/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.move.service.dbimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileCode;
import com.jxdinfo.hussar.formdesign.common.service.SysMidFileCodeService;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.move.service.IFileMoveService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={ConditionDataBaseStorage.class})
public class FileMoveServiceDBImpl
implements IFileMoveService {
    @Resource
    private SysMidFileCodeService sysMidFileCodeService;

    @Override
    public Map<String, Object> moveFiles(Map<String, Object> map) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, String> resultData = new HashMap<String, String>();
        if (ToolUtil.isNotEmpty(map)) {
            int lastindex = String.valueOf(map.get("path")).lastIndexOf("/");
            String fileName = String.valueOf(map.get("path")).substring(lastindex);
            String newTargetPath = map.get("targetPath") + fileName;
            if (String.valueOf(map.get("path")).equals(newTargetPath)) {
                resultMap.put("code", 200);
                resultMap.put("data", fileName);
                resultMap.put("msg", "\u6587\u4ef6\u79fb\u52a8\u6210\u529f");
                return resultMap;
            }
        }
        String moveFileType = String.valueOf(map.get("type"));
        String moveFileId = String.valueOf(map.get("fileId"));
        String parentId = String.valueOf(map.get("parentId"));
        List moveFiles = this.sysMidFileCodeService.list((Wrapper)this.sysMidFileCodeService.lambdaQueryWrapper().eq(SysMidFileCode::getFileId, (Object)moveFileId));
        if (HussarUtils.isNotEmpty((Object)moveFiles)) {
            for (SysMidFileCode moveFile : moveFiles) {
                moveFile.setParentId(parentId);
                List subFiles = this.sysMidFileCodeService.list((Wrapper)this.sysMidFileCodeService.lambdaQueryWrapper().eq(SysMidFileCode::getParentId, (Object)parentId));
                if (HussarUtils.isNotEmpty((Object)subFiles)) {
                    List subFileNames = subFiles.stream().map(SysMidFileCode::getName).distinct().collect(Collectors.toList());
                    while (subFileNames.contains(moveFile.getName())) {
                        moveFile.setName(moveFile.getName() + "1");
                    }
                }
                JSONObject fileData = JSON.parseObject((String)moveFile.getData());
                fileData.put("parentId", (Object)parentId);
                if (HussarUtils.equals((Object)"Workflow", (Object)moveFileType)) {
                    fileData.put("eName", (Object)moveFile.getName());
                } else {
                    fileData.put("name", (Object)moveFile.getName());
                }
                moveFile.setData(JSON.toJSONString((Object)fileData));
                resultData.put(moveFile.getFileId(), moveFile.getName());
            }
            this.sysMidFileCodeService.updateBatchById((Collection)moveFiles);
        }
        resultMap.put("code", 200);
        if (ToolUtil.isNotEmpty(resultData)) {
            resultMap.put("data", resultData);
        }
        resultMap.put("msg", "\u6587\u4ef6\u79fb\u52a8\u6210\u529f");
        return resultMap;
    }
}

