/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.onlineimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionUseSharedStorage;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.WebProSetInfo;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.WebProSetInfoService;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CodeEnum;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="WebProSetInfoServiceOnLineImpl")
@Conditional(value={ConditionUseSharedStorage.class})
public class WebProSetInfoServiceOnLineImpl
implements WebProSetInfoService {
    private final StorageService storageService;
    private final PathStrategyService pathStrategy;

    public WebProSetInfoServiceOnLineImpl(StorageService storageService, PathStrategyService pathStrategy) {
        this.storageService = storageService;
        this.pathStrategy = pathStrategy;
    }

    @Override
    public WebProSetInfo get() throws IOException {
        return this.getWebProSetInfo();
    }

    @Override
    public void save(WebProSetInfo webProSetInfo) throws IOException {
        this.writeWebProSetInfoMapToFile(webProSetInfo);
    }

    private WebProSetInfo getWebProSetInfo() throws IOException {
        StorageResult result = this.storageService.downloadByPath(this.pathStrategy.resourcePathService().projectStoreSettingFile().getRemotePath());
        if (result.isSuccess()) {
            String webProSetInfoJSON = new String((byte[])result.getData(), StandardCharsets.UTF_8);
            return (WebProSetInfo)JSON.parseObject((String)webProSetInfoJSON, (TypeReference)new TypeReference<WebProSetInfo>(){}, (Feature[])new Feature[0]);
        }
        if (result.getCode() == CodeEnum.CODE_NOT_FILE_FOUND.getCode().intValue()) {
            return null;
        }
        throw new IOException(result.getMsg());
    }

    private void writeWebProSetInfoMapToFile(WebProSetInfo webProSetInfo) throws IOException {
        String webProSetInfoMapDTOJSON = JSON.toJSONString((Object)webProSetInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        this.writeWebProSetInfo(webProSetInfoMapDTOJSON);
    }

    private void writeWebProSetInfo(String fileContent) throws IOException {
        String filePath = this.pathStrategy.resourcePathService().projectStoreSettingFile().getRemotePath();
        this.writeStringToFile(fileContent, filePath);
    }

    private void writeStringToFile(String content, String filePath) throws IOException {
        StorageResult result = this.storageService.uploadByPath(filePath, content.getBytes(StandardCharsets.UTF_8), true);
        if (!result.isSuccess()) {
            throw new IOException(result.getMsg());
        }
    }
}

