/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.onlineimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionUseSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.DataCellInfo;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.DataCellInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.onlineimpl.BaseFileServiceOnLineImpl;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CategoryEnum;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="DataCellInfoServiceOnLineImpl")
@Conditional(value={ConditionUseSharedStorage.class})
public class DataCellInfoServiceOnLineImpl
extends BaseFileServiceOnLineImpl<DataCellInfo>
implements DataCellInfoService {
    @Autowired
    public DataCellInfoServiceOnLineImpl(StorageService storageService, FileMappingService fileMappingService) {
        this.storageService = storageService;
        this.fileMappingService = fileMappingService;
    }

    @Override
    public void updateDataCell(DataCellInfo dataCellInfo) throws IOException, LcdpException {
        String newDataStr;
        JSONObject newData = JSONObject.parseObject((String)dataCellInfo.getData());
        List newArray = newData.getJSONObject("table").getJSONArray("fields").toJavaList(JSONObject.class);
        List oldArray = null;
        String path = this.fileMappingService.getDataPath(dataCellInfo.getId());
        StorageResult result = this.storageService.downloadByPath(path);
        if (result.isSuccess()) {
            String oldStr = new String((byte[])result.getData(), StandardCharsets.UTF_8);
            JSONObject oldData = JSONObject.parseObject((String)oldStr);
            oldArray = oldData.getJSONObject("table").getJSONArray("fields").toJavaList(JSONObject.class);
        }
        if (ToolUtil.isNotEmpty(oldArray)) {
            for (JSONObject oldJsonObject : oldArray) {
                String oldFieldName = oldJsonObject.getString("name");
                for (JSONObject newJsonObject : newArray) {
                    String newFieldName = newJsonObject.getString("name");
                    if (!oldFieldName.equals(newFieldName)) continue;
                    for (Map.Entry stringObjectEntry : newJsonObject.entrySet()) {
                        String entry = (String)stringObjectEntry.getKey();
                        if (!ToolUtil.isNotEmpty((Object)oldJsonObject.get((Object)entry)) || "dataType".equals(entry) || "isPrimary".equals(entry) || "comment".equals(entry) || "sourceDatModelId".equals(entry) || "sourceFieldName".equals(entry)) continue;
                        newJsonObject.put(entry, oldJsonObject.get((Object)entry));
                    }
                }
            }
        }
        if (ToolUtil.isEmpty((Object)(newDataStr = JSON.toJSONString((Object)newData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})))) {
            this.storageService.uploadByUuid(CategoryEnum.JSON, dataCellInfo.getId(), path, "".getBytes(), false);
        } else {
            this.storageService.uploadByUuid(CategoryEnum.JSON, dataCellInfo.getId(), path, newDataStr.getBytes(StandardCharsets.UTF_8), false);
        }
    }
}

