/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.onlineimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.MobilePageInfo;
import com.jxdinfo.hussar.formdesign.common.model.WorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.BaseFileService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.util.FileUtil;
import com.jxdinfo.hussar.formdesign.properties.LcdpVersionProperties;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CategoryEnum;
import com.jxdinfo.hussar.workflow.godaxe.model.GodAxeModelService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.core.env.Environment;

public class BaseFileServiceOnLineImpl<T extends BaseFile>
implements BaseFileService<T> {
    @Resource
    protected FileMappingService fileMappingService;
    @Resource
    protected Environment environment;
    @Resource
    protected StorageService storageService;
    @Resource
    protected GodAxeModelService godAxeModelService;
    @Resource
    protected LcdpVersionProperties lcdpVersionProperties;
    @Resource
    private PathStrategyService pathStrategy;

    protected BaseFileServiceOnLineImpl() {
    }

    @Override
    public String create(BaseFile baseFile) throws LcdpException {
        String path;
        String rootPath = ToolUtil.pathFomatterByOS((String)this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getRemotePath());
        String parentPath = ToolUtil.pathFomatterByOS((String)this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getRemotePath());
        if (!ToolUtil.isEmpty((Object)baseFile.getParentId())) {
            parentPath = this.getDataPath(baseFile.getParentId());
        }
        if (Boolean.TRUE.equals(this.storageService.existsByPath(path = "Frame".equals(baseFile.getType()) ? rootPath + "frame" + baseFile.getName() + ".fwd" : parentPath + File.separator + baseFile.getName() + FileUtil.transFileSuffix((String)baseFile.getType())).getData())) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, path);
        }
        if (Boolean.TRUE.equals(this.storageService.existsByPath(path + ".meta").getData())) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, path + ".meta");
        }
        String version = this.lcdpVersionProperties.getLcdpVersion();
        baseFile.setVersion(version);
        this.write(path, baseFile);
        return version;
    }

    private void updateConfig(T baseFile) throws LcdpException {
        String path = (String)this.storageService.getFilePathByUuid(CategoryEnum.JSON, baseFile.getId()).getData();
        if (Boolean.TRUE.equals(this.storageService.existsByPath(path).getData())) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, baseFile.getId());
        }
        if (Boolean.TRUE.equals(this.storageService.existsByPath(path + ".meta").getData())) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, baseFile.getId());
        }
        this.storageService.uploadByUuid(CategoryEnum.JSON, baseFile.getId(), path, baseFile.getData().getBytes(StandardCharsets.UTF_8), false);
    }

    private FormDesignResponse<Void> packageDist(String id, String projectPath, String mobileProjectPath) throws IOException, LcdpException {
        String line;
        FormDesignResponse response = new FormDesignResponse();
        StringBuilder sb = new StringBuilder();
        String framePath = this.getDataPath(id);
        if (ToolUtil.isEmpty((Object)framePath)) {
            response.setErrorMsg("\u6ca1\u6709\u914d\u7f6e\u6846\u67b6\u9875\uff01");
            response.setErrorCode(500);
            return response;
        }
        String currPath = projectPath + "\\cmd\\package.bat";
        File file = new File(currPath);
        ArrayList<String> cmdS = new ArrayList<String>();
        cmdS.add("cd " + mobileProjectPath);
        cmdS.add("npm run build");
        FileUtils.writeLines((File)file, (String)"utf-8", cmdS);
        Process child = Runtime.getRuntime().exec(currPath);
        InputStream inputStream = child.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        while ((line = bufferedReader.readLine()) != null) {
            sb.append(line).append("\n");
        }
        inputStream.close();
        if (!FileUtils.exists((File)new File(mobileProjectPath + "\\node_modules"))) {
            response.setErrorMsg("\u6253\u5305\u5931\u8d25\uff0c\u8bf7\u5148\u4e0b\u8f7d\u4f9d\u8d56\uff01");
            response.setErrorCode(500);
            return response;
        }
        return response;
    }

    @Override
    public void delete(String id) throws LcdpException {
        int deleteCode = 402;
        if (ToolUtil.isEmpty((Object)id)) {
            throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, id);
        }
        String path = this.getDataPath(id);
        if (Boolean.FALSE.equals(this.storageService.deleteByPath(path + ".meta", false).getData())) {
            throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, path + ".meta");
        }
        StorageResult deleteResource = this.storageService.deleteByPath(path, false);
        if (Boolean.FALSE.equals(deleteResource.getData()) && deleteResource.getCode() != 402) {
            throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, path);
        }
    }

    @Override
    public void updateFile(T baseFile) throws LcdpException {
        this.updateFileData(baseFile);
    }

    @Override
    public JSONObject updateFileNew(T baseFile) throws IOException, LcdpException {
        return null;
    }

    @Override
    public void updateFileData(T baseFile) throws LcdpException {
        this.updateFileMeta(baseFile);
    }

    @Override
    public void createMultiple(List<T> baseFiles) throws LcdpException, IOException {
        String rootPath = ToolUtil.pathFomatterByOS((String)this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getRemotePath());
        String parentPath = ToolUtil.pathFomatterByOS((String)this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getRemotePath());
        for (BaseFile baseFile : baseFiles) {
            String path;
            if (!ToolUtil.isEmpty((Object)baseFile.getParentId())) {
                parentPath = this.getDataPath(baseFile.getParentId());
            }
            if (Boolean.TRUE.equals(this.storageService.existsByPath(path = "Frame".equals(baseFile.getType()) ? rootPath + "frame" + baseFile.getName() + ".fwd" : parentPath + File.separator + baseFile.getName() + FileUtil.transFileSuffix((String)baseFile.getType())).getData())) {
                throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, path);
            }
            if (Boolean.TRUE.equals(this.storageService.existsByPath(path + ".meta").getData())) {
                throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, path + ".meta");
            }
            this.write(path, baseFile);
        }
    }

    @Override
    public void addOrUpdateFileData(T baseFile) throws IOException, LcdpException {
        String path;
        String rootPath = ToolUtil.pathFomatterByOS((String)this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getRemotePath());
        String parentPath = ToolUtil.pathFomatterByOS((String)this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getRemotePath());
        if (!ToolUtil.isEmpty((Object)baseFile.getParentId())) {
            parentPath = this.getDataPath(baseFile.getParentId());
        }
        if (Boolean.TRUE.equals(this.storageService.existsByPath(path = "Frame".equals(baseFile.getType()) ? rootPath + "frame" + baseFile.getName() + ".fwd" : parentPath + File.separator + baseFile.getName() + FileUtil.transFileSuffix((String)baseFile.getType())).getData())) {
            this.updateFileData(baseFile);
        }
        if (Boolean.TRUE.equals(this.storageService.existsByPath(path + ".meta").getData())) {
            this.updateFileMeta(baseFile);
        }
        if (!Boolean.TRUE.equals(this.storageService.existsByPath(path).getData()) || !Boolean.TRUE.equals(this.storageService.existsByPath(path + ".meta").getData())) {
            this.write(path, (BaseFile)baseFile);
        }
    }

    @Override
    public void updateFileCommonModelData(T baseFile) throws IOException, LcdpException {
    }

    @Override
    public void updateFileMeta(T baseFile) throws LcdpException {
        String parentPath;
        String path = this.getDataPath(baseFile.getId());
        String oldFileName = path.replace(parentPath = this.getDataPath(baseFile.getParentId()), "").replace("\\", "").replace("/", "");
        if (oldFileName.indexOf(".") > 0) {
            oldFileName = oldFileName.substring(0, oldFileName.indexOf("."));
        }
        boolean needRename = this.justRename((BaseFile)baseFile, oldFileName);
        if (baseFile instanceof WorkflowInfo) {
            boolean bl = needRename = !((WorkflowInfo)((Object)baseFile)).geteName().equals(oldFileName);
            if (needRename) {
                this.godAxeModelService.updateWorkflowProcessKey(((WorkflowInfo)((Object)baseFile)).geteName(), oldFileName);
            }
        }
        this.write(path, (BaseFile)baseFile);
        if (needRename) {
            if (baseFile instanceof MobilePageInfo) {
                if (Boolean.TRUE.equals(this.storageService.existsByPath(parentPath + File.separator + baseFile.getName() + ".mpd" + ".meta").getData())) {
                    throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, baseFile.getId());
                }
                this.storageService.rename(path, parentPath + File.separator + baseFile.getName() + ".mpd", false);
                this.storageService.rename(path + ".meta", parentPath + File.separator + baseFile.getName() + ".mpd" + ".meta", false);
            } else if (baseFile instanceof PageInfo) {
                if (Boolean.TRUE.equals(this.storageService.existsByPath(parentPath + File.separator + baseFile.getName() + ".mpd" + ".meta").getData())) {
                    throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, baseFile.getId());
                }
                this.storageService.rename(path, parentPath + File.separator + baseFile.getName() + ".wpd", false);
                this.storageService.rename(path + ".meta", parentPath + File.separator + baseFile.getName() + ".wpd" + ".meta", false);
            } else if (baseFile instanceof WorkflowInfo) {
                if (Boolean.TRUE.equals(this.storageService.existsByPath(parentPath + File.separator + ((WorkflowInfo)((Object)baseFile)).geteName() + ".meta").getData())) {
                    throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, baseFile.getId());
                }
                this.storageService.rename(path, parentPath + File.separator + ((WorkflowInfo)((Object)baseFile)).geteName(), false);
                this.storageService.rename(path + ".meta", parentPath + File.separator + ((WorkflowInfo)((Object)baseFile)).geteName() + ".meta", false);
            } else {
                if (Boolean.TRUE.equals(this.storageService.existsByPath(parentPath + File.separator + baseFile.getName() + ".meta").getData())) {
                    throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, baseFile.getId());
                }
                this.storageService.rename(path, parentPath + File.separator + baseFile.getName(), false);
                this.storageService.rename(path + ".meta", parentPath + File.separator + baseFile.getName() + ".meta", false);
            }
        }
    }

    @Override
    public void update(BaseFile baseFile) throws LcdpException {
        String path = this.getDataPath(baseFile.getId());
        String parentPath = this.getDataPath(baseFile.getParentId());
        String oldFileName = path.replace(parentPath, "").replace("\\", "").replace("/", "");
        boolean needRename = this.justRename(baseFile, oldFileName);
        this.write(path, baseFile);
        if (needRename) {
            if (baseFile instanceof MobilePageInfo) {
                this.storageService.rename(path, parentPath + File.separator + baseFile.getName() + ".mpd", false);
                this.storageService.rename(path + ".meta", parentPath + File.separator + baseFile.getName() + ".mpd" + ".meta", false);
            } else if (baseFile instanceof PageInfo) {
                this.storageService.rename(path, parentPath + File.separator + baseFile.getName() + ".wpd", false);
                this.storageService.rename(path + ".meta", parentPath + File.separator + baseFile.getName() + ".wpd" + ".meta", false);
            } else {
                this.storageService.rename(path, parentPath + File.separator + baseFile.getName(), false);
                this.storageService.rename(path + ".meta", parentPath + File.separator + baseFile.getName() + ".meta", false);
            }
        }
    }

    @Override
    public T get(String id) throws LcdpException {
        String path = this.getDataPath(id);
        return this.readFileToObject(path);
    }

    @Override
    public JSONObject getCrossApp(String appId, String fileId) throws LcdpException, IOException {
        return null;
    }

    @Override
    public void move(String id, String parentId, String newName, String newDesc) throws LcdpException {
        String oldJsonPath = this.getDataPath(id);
        String oldMetaPath = this.getMetaPath(id);
        String newParentPath = this.getDataPath(parentId);
        String oldJsonName = this.removeMeta(this.getFileName(id));
        StorageResult storageResult = this.storageService.downloadByUuid(CategoryEnum.META, id);
        if (!storageResult.isSuccess()) {
            throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, id);
        }
        JSONObject metaFileContent = JSON.parseObject((String)new String((byte[])storageResult.getData(), StandardCharsets.UTF_8));
        metaFileContent.put("parentId", (Object)parentId);
        if (newName != null) {
            metaFileContent.put("name", (Object)newName);
        }
        if (newDesc != null) {
            metaFileContent.put("desc", (Object)newDesc);
        }
        try {
            this.storageService.uploadByUuid(CategoryEnum.META, id, oldMetaPath, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)metaFileContent).getBytes(StandardCharsets.UTF_8), false);
        }
        catch (JsonProcessingException e) {
            throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, oldMetaPath);
        }
        String type = (String)metaFileContent.get((Object)"type");
        String suffix = "";
        if (ToolUtil.isNotEmpty((Object)type)) {
            if ("WebPage".equals(type)) {
                suffix = ".wpd";
            } else if ("MobilePage".equals(type)) {
                suffix = ".mpd";
            } else if ("UniPage".equals(type)) {
                suffix = ".upd";
            } else if ("DataModel".equals(type)) {
                suffix = ".dbd";
            }
        }
        if (newName != null && !"".equals(newName)) {
            String newPath = newParentPath + File.separator + newName + suffix;
            this.storageService.rename(oldJsonPath, newPath, false);
            boolean moveResource = (Boolean)this.storageService.rename(oldMetaPath, newPath + ".meta", false).getData();
            if (!moveResource) {
                throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, oldMetaPath);
            }
        } else {
            String newPath = newParentPath + File.separator + oldJsonName;
            this.storageService.rename(oldJsonPath, newPath, false);
            boolean moveResource = (Boolean)this.storageService.rename(oldMetaPath, newPath + ".meta", false).getData();
            if (!moveResource) {
                throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, oldMetaPath);
            }
        }
    }

    @Override
    public void copy(String id, String parentId, String newId, String newName, String newDesc) throws LcdpException {
        byte[] jsonFileContent;
        String newPath;
        String oldMetaPath = this.getMetaPath(id);
        String newParentPath = this.getDataPath(parentId);
        String oldJsonName = this.removeMeta(this.getFileName(id));
        if (newName != null && !"".equals(newName)) {
            byte[] metaFileContent;
            newPath = newParentPath + File.separator + newName;
            jsonFileContent = (byte[])this.storageService.downloadByUuid(CategoryEnum.JSON, id).getData();
            if (jsonFileContent != null) {
                this.storageService.uploadByUuid(CategoryEnum.JSON, newId, newPath, jsonFileContent, false);
            }
            if ((metaFileContent = (byte[])this.storageService.downloadByUuid(CategoryEnum.META, id).getData()) == null) {
                throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, newPath);
            }
            boolean copyResource = (Boolean)this.storageService.uploadByUuid(CategoryEnum.META, newId, newPath + ".meta", metaFileContent, false).getData();
            if (!copyResource) {
                throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, oldMetaPath);
            }
        } else {
            byte[] metaFileContent;
            newPath = newParentPath + File.separator + oldJsonName;
            jsonFileContent = (byte[])this.storageService.downloadByUuid(CategoryEnum.JSON, id).getData();
            if (jsonFileContent != null) {
                this.storageService.uploadByUuid(CategoryEnum.JSON, newId, newPath, jsonFileContent, false);
            }
            if ((metaFileContent = (byte[])this.storageService.downloadByUuid(CategoryEnum.META, id).getData()) == null) {
                throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, newPath);
            }
            boolean copyResource = (Boolean)this.storageService.uploadByUuid(CategoryEnum.META, newId, newPath + ".meta", metaFileContent, false).getData();
            if (!copyResource) {
                throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, oldMetaPath);
            }
        }
        JSONObject metaFileContent = JSON.parseObject((String)new String((byte[])this.storageService.downloadByUuid(CategoryEnum.META, newId).getData(), StandardCharsets.UTF_8));
        metaFileContent.put("parentId", (Object)parentId);
        if (newName != null) {
            metaFileContent.put("name", (Object)newName);
        }
        if (newDesc != null) {
            metaFileContent.put("desc", (Object)newDesc);
        }
        metaFileContent.put("id", (Object)newId);
        metaFileContent.put("parentId", (Object)parentId);
        try {
            this.storageService.uploadByUuid(CategoryEnum.META, newId, newPath + ".meta", new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)metaFileContent).getBytes(StandardCharsets.UTF_8), false);
        }
        catch (JsonProcessingException e) {
            throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, newPath + ".meta");
        }
    }

    @Override
    public JSONObject copyNew(String id, String parentId, String newId, String newName, String newDesc) throws LcdpException, IOException {
        return null;
    }

    @Override
    public String getJsPath(String id) throws LcdpException, IOException {
        return null;
    }

    @Override
    public JSONObject getExtend(String id) throws IOException, LcdpException {
        return null;
    }

    protected void write(String path, BaseFile baseFile) throws LcdpException {
        try {
            if (ToolUtil.isNotEmpty((Object)baseFile.getData())) {
                this.storageService.uploadByUuid(CategoryEnum.JSON, baseFile.getId(), path, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(JSON.parse((String)baseFile.getData())).getBytes(StandardCharsets.UTF_8), false);
            }
            baseFile.setData(null);
            this.storageService.uploadByUuid(CategoryEnum.META, baseFile.getId(), path + ".meta", new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)baseFile).getBytes(StandardCharsets.UTF_8), false);
        }
        catch (JsonProcessingException e) {
            throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, path);
        }
    }

    protected T readFileToObject(String path) throws LcdpException {
        byte[] jsonFileByte = (byte[])this.storageService.downloadByPath(path).getData();
        byte[] metaFileByte = (byte[])this.storageService.downloadByPath(this.addMeta(path)).getData();
        if (metaFileByte == null) {
            throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, this.addMeta(path));
        }
        String metaFileInfo = new String(metaFileByte, StandardCharsets.UTF_8);
        BaseFile t = (BaseFile)JSON.parseObject((String)metaFileInfo, (Type)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0], (Feature[])new Feature[0]);
        if (jsonFileByte != null) {
            String jsonFileInfo = new String(jsonFileByte, StandardCharsets.UTF_8);
            t.setData(jsonFileInfo);
        }
        return (T)t;
    }

    protected String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    protected String addMeta(String path) {
        String real = path.replace("/", File.separator).replace("\\", File.separator);
        return real + ".meta";
    }

    protected String removeMeta(String path) {
        return path.substring(0, path.lastIndexOf(".meta"));
    }

    protected String getFileName(String id) throws LcdpException {
        String path = this.getMetaPath(id);
        return path.substring(path.lastIndexOf(92) + 1).substring(path.lastIndexOf(47) + 1);
    }

    protected String getMetaPath(String id) throws LcdpException {
        if (ToolUtil.isEmpty((Object)id)) {
            return ToolUtil.pathFomatterByOS((String)this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getRemotePath());
        }
        String path = this.fileMappingService.getMetaPath(id);
        if (ToolUtil.isEmpty((Object)path)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)path);
    }

    protected boolean justRename(BaseFile newBaseFile, String oldFileName) {
        return !newBaseFile.getName().equals(oldFileName);
    }

    protected String getDataPath(String id) throws LcdpException {
        return this.getMetaPath(id).replace(".meta", "");
    }
}

