/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.WebProSetInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.WebProSetInfoService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="WebProSetInfoServiceImpl")
@Conditional(value={ConditionNotSharedStorage.class, ConditionNotDataBaseStorage.class})
public class WebProSetInfoServiceImpl
implements WebProSetInfoService {
    private final FormDesignProperties speedCodeProperties;
    private final PathStrategyService pathStrategy;

    public WebProSetInfoServiceImpl(FormDesignProperties speedCodeProperties, PathStrategyService pathStrategy) {
        this.speedCodeProperties = speedCodeProperties;
        this.pathStrategy = pathStrategy;
    }

    @Override
    public WebProSetInfo get() throws IOException {
        return this.getWebProSetInfo();
    }

    @Override
    public void save(WebProSetInfo webProSetInfo) throws IOException {
        this.writeWebProSetInfoMapToFile(webProSetInfo);
    }

    private WebProSetInfo getWebProSetInfo() throws IOException {
        File webProSetFile = new File(this.pathStrategy.resourcePathService().getWebProjectSettingPath());
        if (!webProSetFile.exists()) {
            return null;
        }
        String webProSetInfoJSON = FileUtils.readFileToString((File)webProSetFile, (Charset)Charset.forName("UTF-8"));
        return (WebProSetInfo)JSON.parseObject((String)webProSetInfoJSON, (TypeReference)new TypeReference<WebProSetInfo>(){}, (Feature[])new Feature[0]);
    }

    private void writeWebProSetInfoMapToFile(WebProSetInfo webProSetInfo) throws IOException {
        String webProSetInfoMapDTOJSON = JSON.toJSONString((Object)webProSetInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        this.writeWebProSetInfo(webProSetInfoMapDTOJSON);
    }

    private void writeWebProSetInfo(String fileContent) {
        String filePath = this.pathStrategy.resourcePathService().getWebProjectSettingPath();
        this.writeWebProSetStringToFile(fileContent, filePath);
        VfgModeTool.pushToRemote((String)"\u63d0\u4ea4\u4ee3\u7801\uff1a.project-store/setting", Collections.singletonList(filePath));
    }

    private String writeStringToFile(String content, String filePath) {
        filePath = filePath.replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
        try {
            com.jxdinfo.hussar.formdesign.common.util.FileUtils.writeStringToFile((File)new File(filePath), (String)content, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return filePath;
    }

    private String writeWebProSetStringToFile(String content, String filePath) {
        filePath = filePath.replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
        try {
            FileUtils.writeStringToFile((File)new File(filePath), (String)content, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return filePath;
    }
}

