/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.formdesign.common.annotation.ExceptionCatcher;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.constant.CommonModelMetaInfo;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.FileTreeService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.util.ParamPaserUtil;
import com.jxdinfo.hussar.formdesign.file.move.util.ConstantUtil;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="FileTreeServiceImpl")
@Conditional(value={ConditionNotSharedStorage.class, ConditionNotDataBaseStorage.class})
public class FileTreeServiceImpl
implements FileTreeService {
    @Resource
    ISysApplicationBoService sysApplicationService;
    private static final String COMMON_MODEL = "common_model";
    private static final String MODEL_MODULE = "/common_model";
    private final FileMappingService fileMappingService;
    private final PathStrategyService pathStrategy;

    @Autowired
    public FileTreeServiceImpl(FileMappingService fileMappingService, PathStrategyService pathStrategy) {
        this.pathStrategy = pathStrategy;
        this.fileMappingService = fileMappingService;
    }

    @Override
    @ExceptionCatcher
    public FormDesignResponse<List<JSONObject>> getFileTree(String parentId) throws IOException, LcdpException {
        FormDesignResponse response = new FormDesignResponse();
        String path = "";
        if (ToolUtil.isNotEmpty((Object)parentId)) {
            path = this.fileMappingService.getDataPath(parentId);
        }
        String projectStoreCodePath = ToolUtil.pathFomatterByOS((String)FileUtil.posixPath((String[])new String[]{this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath(), path}));
        String commonModelPath = ToolUtil.pathFomatterByOS((String)FileUtil.posixPath((String[])new String[]{this.pathStrategy.resourcePathService().projectStore(new String[0]).getLocalPath(), MODEL_MODULE}));
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        List codes = FileUtils.iteratorTree((String)projectStoreCodePath, (String)parentId, (String)this.filters());
        List commonModels = FileUtils.iteratorTree((String)commonModelPath, (String)COMMON_MODEL, (String)this.filters());
        jsonObjects.addAll(codes);
        jsonObjects.addAll(commonModels);
        jsonObjects.add(CommonModelMetaInfo.getCommonModelMetaInfo());
        response.setData(jsonObjects);
        return response;
    }

    @Override
    public List<Map<String, Object>> getFileTreeCrossApp(String parentId) throws IOException, LcdpException {
        String DATA_KEY = "data";
        String path = "";
        ArrayList<Map<String, Object>> response = new ArrayList<Map<String, Object>>();
        FormDesignResponse<List<JSONObject>> fileTreeResponse = this.getFileTree("#");
        List fileTreeData = (List)fileTreeResponse.getData();
        HashMap<String, Object> fileTreeResultMap = new HashMap<String, Object>();
        fileTreeResultMap.put("data", fileTreeData);
        fileTreeResultMap.put("appId", "");
        fileTreeResultMap.put("appName", "");
        response.add(fileTreeResultMap);
        return response;
    }

    @Override
    public FormDesignResponse<List<JSONObject>> getFileTreeNew(String parentId) throws IOException, LcdpException {
        FormDesignResponse response = new FormDesignResponse();
        String path = "";
        if (ToolUtil.isNotEmpty((Object)parentId)) {
            path = this.fileMappingService.getDataPath(parentId);
        }
        File file = new File(ToolUtil.pathFomatterByOS((String)(this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath() + path)));
        File commonModelFile = new File(ToolUtil.pathFomatterByOS((String)(this.pathStrategy.resourcePathService().projectStore(new String[0]).getLocalPath() + MODEL_MODULE)));
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        if (!FileUtils.exists((File)file) && !FileUtils.exists((File)commonModelFile)) {
            return response;
        }
        ArrayList<String> errorFiles = new ArrayList<String>();
        this.iteratorNew(jsonObjects, file, parentId, errorFiles);
        String errStr = String.valueOf(errorFiles);
        errStr = errStr.substring(1, errStr.length() - 1);
        response.setErrorMsg(errStr);
        System.out.println(errStr);
        jsonObjects.add(CommonModelMetaInfo.getCommonModelMetaInfo());
        response.setData(jsonObjects);
        return response;
    }

    private void iterator(List<JSONObject> jsonObjects, File file, String pId) throws IOException {
        File[] files;
        if (file.isDirectory() && ToolUtil.isNotEmpty((Object)(files = file.listFiles()))) {
            for (File file1 : files) {
                JSONObject jsonObject;
                File mataFile = new File(file1.getAbsolutePath() + ".meta");
                if (!FileUtils.exists((File)mataFile) || (jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)mataFile, (String)"UTF-8"))) == null) continue;
                jsonObject.put("parentId", (Object)pId);
                jsonObjects.add(jsonObject);
                String type = jsonObject.getString("type");
                if (ToolUtil.isNotEmpty((Object)type) && ConstantUtil.anyMatch(type, this.filters().split(","))) {
                    JSONObject dataJsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)file1, (String)"UTF-8"));
                    jsonObject.put("data", (Object)dataJsonObject);
                }
                if (!file1.isDirectory()) continue;
                this.iterator(jsonObjects, file1, jsonObject.getString("id"));
            }
        }
    }

    private void iteratorNew(List<JSONObject> jsonObjects, File file, String pId, List<String> errorFiles) throws IOException {
        File[] files;
        if (file.isDirectory() && ToolUtil.isNotEmpty((Object)(files = FileUtils.listFiles((File)file)))) {
            for (File file1 : files) {
                File mataFile = new File(file1.getAbsolutePath() + ".meta");
                if (!FileUtils.exists((File)mataFile)) continue;
                JSONObject jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)mataFile, (String)"UTF-8"));
                if (jsonObject == null) {
                    errorFiles.add("\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38\uff1a" + file1.getAbsolutePath());
                    continue;
                }
                jsonObject.put("parentId", (Object)pId);
                jsonObjects.add(jsonObject);
                String type = jsonObject.getString("type");
                if (ToolUtil.isNotEmpty((Object)type) && ("DataModel".equals(type) || "FrontScript".equals(type) || "JsScript".equals(type) || "UniJsScript".equals(type) || "MobileJsScript".equals(type) || "CustomPage".equals(type) || "MobileFrontScript".equals(type) || "MobileCustomPage".equals(type) || "UniCustomPage".equals(type) || "UniFrontScript".equals(type)) || "WebPage".equals(type)) {
                    String newFileContent = FileUtils.readFileToString((File)file1, (String)"UTF-8");
                    JSONObject dataJsonObject = JSONObject.parseObject((String)newFileContent);
                    if (!AppContextUtil.isExtension() && FileUtils.isWpdFile((File)file1)) {
                        if (newFileContent.contains("extendKey")) {
                            newFileContent = ParamPaserUtil.replaceExtendKeys(newFileContent);
                        }
                        FileUtils.writeStringToFile((File)file1, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)JSON.parseObject((String)newFileContent)), (String)"UTF-8");
                        dataJsonObject = JSONObject.parseObject((String)newFileContent);
                    }
                    jsonObject.put("data", (Object)dataJsonObject);
                }
                if (!file1.isDirectory()) continue;
                this.iteratorNew(jsonObjects, file1, jsonObject.getString("id"), errorFiles);
            }
        }
    }

    private List<JSONObject> treeSort(List<JSONObject> jsonObjects) {
        final Collator collator = Collator.getInstance();
        jsonObjects.sort(new Comparator<JSONObject>(){
            private static final String ORDER_FILED1 = "parentId";
            private static final String ORDER_FILED2 = "type";
            private static final String ORDER_FILED3 = "desc";

            @Override
            public int compare(JSONObject a, JSONObject b) {
                String pidA = "";
                String pidB = "";
                String typeA = "";
                String typeB = "";
                String nameA = "";
                String nameB = "";
                try {
                    pidA = a.getString(ORDER_FILED1);
                    pidB = b.getString(ORDER_FILED1);
                    typeA = a.getString(ORDER_FILED2);
                    typeB = b.getString(ORDER_FILED2);
                    nameA = typeA.equals("Workflow") ? a.getString("name") : a.getString(ORDER_FILED3);
                    nameB = typeB.equals("Workflow") ? b.getString("name") : b.getString(ORDER_FILED3);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                int flag = FileTreeServiceImpl.this.pidCompare(pidA, pidB);
                if (flag == 0) {
                    flag = FileTreeServiceImpl.this.typeCompare(typeA, typeB);
                    if (flag == 0) {
                        if (ToolUtil.isNotEmpty((Object)nameA) && ToolUtil.isNotEmpty((Object)nameB)) {
                            return collator.compare(nameA, nameB);
                        }
                        return 0;
                    }
                    return flag;
                }
                return flag;
            }
        });
        return jsonObjects;
    }

    private int typeCompare(String typeA, String typeB) {
        int flag;
        switch (typeA) {
            case "Module": {
                if (typeB.equals("Module")) {
                    flag = 0;
                    break;
                }
                flag = -1;
                break;
            }
            case "MicroApp": {
                if (typeB.equals("Module")) {
                    flag = 1;
                    break;
                }
                if (typeB.equals("MicroApp")) {
                    flag = 0;
                    break;
                }
                flag = -1;
                break;
            }
            case "WebPage": {
                if (typeB.equals("Module") || typeB.equals("MicroApp")) {
                    flag = 1;
                    break;
                }
                if (typeB.equals("WebPage")) {
                    flag = 0;
                    break;
                }
                flag = -1;
                break;
            }
            case "MobilePage": {
                if (typeB.equals("Module") || typeB.equals("MicroApp") || typeB.equals("WebPage")) {
                    flag = 1;
                    break;
                }
                if (typeB.equals("MobilePage")) {
                    flag = 0;
                    break;
                }
                flag = -1;
                break;
            }
            case "DataModel": {
                if (typeB.equals("Module") || typeB.equals("MicroApp") || typeB.equals("WebPage") || typeB.equals("MobilePage")) {
                    flag = 1;
                    break;
                }
                if (typeB.equals("DataModel")) {
                    flag = 0;
                    break;
                }
                flag = -1;
                break;
            }
            default: {
                flag = !typeB.equals("Workflow") ? 1 : 0;
            }
        }
        return flag;
    }

    private int pidCompare(String pidA, String pidB) {
        if (pidA.equals("#") && !pidB.equals("#")) {
            return -1;
        }
        if (pidB.equals("#") && !pidA.equals("#")) {
            return 1;
        }
        return pidA.compareTo(pidB);
    }

    @Override
    public List<JSONObject> getAppFileTree(String appId) throws LcdpException, IOException {
        return null;
    }

    @Override
    public List<String> getFileTreeId(String parentId) throws IOException, LcdpException {
        FormDesignResponse<List<JSONObject>> filrTreeResponse = this.getFileTree(parentId);
        List filrTreeList = (List)filrTreeResponse.getData();
        ArrayList<String> fileTreeIdList = new ArrayList<String>();
        for (int i = 0; i < filrTreeList.size(); ++i) {
            if (((JSONObject)filrTreeList.get(i)).get((Object)"type").equals("Module") || ((JSONObject)filrTreeList.get(i)).get((Object)"type").equals("") || ((JSONObject)filrTreeList.get(i)).get((Object)"type").equals("MicroApp")) continue;
            String id = (String)((JSONObject)filrTreeList.get(i)).get((Object)"id");
            fileTreeIdList.add(id);
        }
        return fileTreeIdList;
    }

    @Override
    @ExceptionCatcher
    public FormDesignResponse<JSONArray> getFileTreeByType(String type) throws IOException, LcdpException {
        FormDesignResponse response = new FormDesignResponse();
        File file = new File(ToolUtil.pathFomatterByOS((String)this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath()));
        JSONObject jsonObjects = new JSONObject();
        if (!FileUtils.exists((File)file)) {
            return response;
        }
        ArrayList<String> errorFiles = new ArrayList<String>();
        this.iteratorByType(jsonObjects, file, "#", errorFiles, type);
        String errStr = Objects.toString(errorFiles);
        errStr = errStr.substring(1, errStr.length() - 1);
        response.setErrorMsg(errStr);
        System.out.println(errStr);
        response.setData((Object)jsonObjects.getJSONArray("children"));
        return response;
    }

    private void iteratorByType(JSONObject parentJsonObject, File file, String pId, List<String> errorFiles, String type) throws IOException, LcdpException {
        File[] files;
        if (FileUtils.isDirectory((File)file) && ToolUtil.isNotEmpty((Object)(files = FileUtils.listFiles((File)file)))) {
            for (File currentFile : files) {
                JSONArray childArray;
                File mataFile = new File(currentFile.getAbsolutePath() + ".meta");
                if (!FileUtils.exists((File)mataFile)) continue;
                JSONObject jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)mataFile, (String)"UTF-8"));
                if (jsonObject == null) {
                    errorFiles.add("\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38\uff1a" + currentFile.getAbsolutePath());
                    continue;
                }
                String currentType = jsonObject.getString("type");
                if (!ToolUtil.isNotEmpty((Object)currentType)) continue;
                JSONObject moduleJsonObject = new JSONObject();
                moduleJsonObject.put("id", jsonObject.get((Object)"id"));
                moduleJsonObject.put("parentId", (Object)pId);
                moduleJsonObject.put("name", jsonObject.get((Object)"desc"));
                moduleJsonObject.put("router", (Object)this.fileMappingService.getDataPath(jsonObject.get((Object)"id").toString()));
                moduleJsonObject.put("type", (Object)currentType);
                if ("Module".equals(currentType)) {
                    if (ToolUtil.isEmpty((Object)parentJsonObject.getJSONArray("children"))) {
                        childArray = new JSONArray();
                        parentJsonObject.put("children", (Object)childArray);
                        parentJsonObject.getJSONArray("children").add((Object)moduleJsonObject);
                    } else {
                        parentJsonObject.getJSONArray("children").add((Object)moduleJsonObject);
                    }
                    this.iteratorByType(moduleJsonObject, currentFile, jsonObject.get((Object)"id").toString(), errorFiles, type);
                    continue;
                }
                if (!"MobilePage".equals(currentType)) continue;
                if (ToolUtil.isEmpty((Object)parentJsonObject.getJSONArray("children"))) {
                    childArray = new JSONArray();
                    parentJsonObject.put("children", (Object)childArray);
                    parentJsonObject.getJSONArray("children").add((Object)moduleJsonObject);
                    continue;
                }
                parentJsonObject.getJSONArray("children").add((Object)moduleJsonObject);
            }
        }
    }

    private String filters() {
        List<String> filters = Arrays.asList("DataModel", "FrontScript", "JsScript", "UniJsScript", "MobileJsScript", "VueScript", "UniVueScript", "MobileVueScript", "CssScript", "UniCssScript", "MobileCssScript", "CustomPage", "MobileFrontScript", "MobileCustomPage", "UniCustomPage", "UniFrontScript", "DynamicModel");
        return String.join((CharSequence)",", filters);
    }
}

