/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.database.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.constant.CommonModelMetaInfo;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileCode;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.service.SysMidFileCodeService;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.FileTreeService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={ConditionDataBaseStorage.class})
public class FileTreeDataBaseServiceImpl
implements FileTreeService {
    @Resource
    private SysMidFileCodeService sysMidFileCodeService;
    @Resource
    private ISysApplicationBoService sysApplicationService;

    @Override
    public List<Map<String, Object>> getFileTreeCrossApp(String parentId) throws IOException, LcdpException {
        ArrayList<Map<String, Object>> response = new ArrayList<Map<String, Object>>();
        List sysApplications = this.sysApplicationService.list();
        List resourceList = this.sysMidFileCodeService.getAllFiles();
        if (HussarUtils.isEmpty((Object)resourceList)) {
            return Collections.emptyList();
        }
        Map<String, List<SysMidFileCode>> resourceMap = resourceList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getAppId()).orElse("local")));
        for (Map.Entry<String, List<SysMidFileCode>> stringListMap : resourceMap.entrySet()) {
            String appName = "";
            String appId = "";
            String key = stringListMap.getKey();
            if (!"local".equals(key)) {
                for (SysApplication sysApplication : sysApplications) {
                    if (!sysApplication.getId().toString().equals(key)) continue;
                    appId = key;
                    appName = sysApplication.getAppName();
                }
            }
            ArrayList<JSONObject> results = new ArrayList<JSONObject>();
            this.flatFileTree(parentId, stringListMap.getValue(), results);
            this.flatFileTree("common_model", stringListMap.getValue(), results);
            results.add(CommonModelMetaInfo.getCommonModelMetaInfo());
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("data", results);
            resultMap.put("appId", appId);
            resultMap.put("appName", appName);
            response.add(resultMap);
        }
        return response;
    }

    @Override
    public FormDesignResponse<List<JSONObject>> getFileTree(String parentId) throws IOException, LcdpException {
        FormDesignResponse response = new FormDesignResponse();
        ArrayList<JSONObject> results = new ArrayList<JSONObject>();
        List resourceList = this.sysMidFileCodeService.getAllFiles();
        this.flatFileTree(parentId, resourceList, results);
        this.flatFileTree("common_model", resourceList, results);
        results.add(CommonModelMetaInfo.getCommonModelMetaInfo());
        response.setData(results);
        return response;
    }

    @Override
    public FormDesignResponse<List<JSONObject>> getFileTreeNew(String parentId) throws IOException, LcdpException {
        return this.getFileTree(parentId);
    }

    @Override
    public List<JSONObject> getAppFileTree(String appId) throws LcdpException, IOException {
        return null;
    }

    @Override
    public List<String> getFileTreeId(String parentId) throws IOException, LcdpException {
        FormDesignResponse<List<JSONObject>> filrTreeResponse = this.getFileTree(parentId);
        List filrTreeList = (List)filrTreeResponse.getData();
        ArrayList<String> fileTreeIdList = new ArrayList<String>();
        for (JSONObject jsonObject : filrTreeList) {
            if (jsonObject.get((Object)"type").equals("Module") || jsonObject.get((Object)"type").equals("") || jsonObject.get((Object)"type").equals("MicroApp")) continue;
            String id = (String)jsonObject.get((Object)"id");
            fileTreeIdList.add(id);
        }
        return fileTreeIdList;
    }

    @Override
    public FormDesignResponse<JSONArray> getFileTreeByType(String type) throws LcdpException, IOException {
        return null;
    }

    private String filters() {
        List<String> filters = Arrays.asList("DataModel", "FrontScript", "JsScript", "UniJsScript", "MobileJsScript", "VueScript", "UniVueScript", "MobileVueScript", "CssScript", "UniCssScript", "MobileCssScript", "CustomPage", "MobileFrontScript", "MobileCustomPage", "UniCustomPage", "UniFrontScript", "DynamicModel");
        return String.join((CharSequence)",", filters);
    }

    private void flatFileTree(String parentId, List<SysMidFileCode> resourceList, List<JSONObject> results) {
        List childResourceList = resourceList.stream().filter(sysMidFileCode -> HussarUtils.equals((Object)sysMidFileCode.getParentId(), (Object)parentId)).collect(Collectors.toList());
        for (SysMidFileCode childResource : childResourceList) {
            List grandChildResourceList;
            if (HussarUtils.equals((Object)childResource.getMetaFlag(), (Object)"1")) {
                SysMidFileCode mainResourceInfo;
                JSONObject metaResourceData = JSON.parseObject((String)childResource.getData());
                metaResourceData.put("parentId", (Object)childResource.getParentId());
                String resourceType = childResource.getType();
                if (ToolUtil.isNotEmpty((Object)resourceType) && FileUtils.anyMatch((String)resourceType, (String[])this.filters().split(",")) && HussarUtils.isNotEmpty((Object)(mainResourceInfo = (SysMidFileCode)childResourceList.stream().filter(sysMidFileCode -> HussarUtils.equals((Object)sysMidFileCode.getFileId(), (Object)childResource.getFileId()) && HussarUtils.equals((Object)sysMidFileCode.getMetaFlag(), (Object)"0")).findFirst().orElse(null)))) {
                    metaResourceData.put("data", (Object)JSON.parseObject((String)mainResourceInfo.getData()));
                }
                results.add(metaResourceData);
            }
            if (!HussarUtils.isNotEmpty(grandChildResourceList = resourceList.stream().filter(sysMidFileCode -> HussarUtils.equals((Object)sysMidFileCode.getParentId(), (Object)childResource.getFileId())).collect(Collectors.toList()))) continue;
            this.flatFileTree(childResource.getFileId(), resourceList, results);
        }
    }
}

