/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.exception.ApiException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.collaboration.lock.model.StorageLockPO;
import com.jxdinfo.hussar.formdesign.collaboration.lock.service.IndexStorageLockService;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.OperateFileVO;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.project.scenes.MicroService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.aggregationservice.AggregationPageInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.quote.relation.service.SysQuoteRelationService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speed/pageinfo"})
public class PageInfoController {
    private static final Logger logger = LoggerFactory.getLogger(PageInfoController.class);
    private final PathStrategyService pathStrategy = (PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class);
    @Resource
    private PageInfoService pageInfoService;
    @Autowired
    private IndexStorageLockService indexStorageLockService;
    @Autowired
    private AggregationPageInfoService aggregationPageInfoService;
    @Autowired
    private FormDesignProperties formDesignProperties;
    @Autowired
    private SysQuoteRelationService sysQuoteRelationService;

    @PostMapping(value={"/add"})
    public FormDesignResponse<String> addDataInfo(@RequestBody PageInfo pageInfo) throws IOException, LcdpException {
        String version = this.pageInfoService.create(pageInfo);
        FormDesignResponse pageInfoFormDesignResponse = new FormDesignResponse();
        pageInfoFormDesignResponse.setData((Object)version);
        return pageInfoFormDesignResponse;
    }

    @PostMapping(value={"/addMultiple"})
    public FormDesignResponse<PageInfo> addMultipleDataInfo(@RequestBody List<PageInfo> pageInfos) throws IOException, LcdpException {
        if (ToolUtil.isNotEmpty(pageInfos)) {
            for (PageInfo pageInfo : pageInfos) {
                if (!ToolUtil.isNotEmpty((Object)pageInfo.getData())) continue;
                this.aggregationPageInfoService.disposeQuoteRelation(pageInfo.getId(), pageInfo.getData());
            }
        }
        this.pageInfoService.createMultiple(pageInfos);
        return new FormDesignResponse();
    }

    @PostMapping(value={"/data/meta"})
    public FormDesignResponse<PageInfo> updateAllDataInfo(@RequestBody PageInfo pageInfo) throws IOException, LcdpException {
        return this.aggregationPageInfoService.updateAllDataInfo(pageInfo);
    }

    @PostMapping(value={"/data/metaTemplate"})
    public FormDesignResponse<JSONObject> updateAllDataInfoTemplate(@RequestBody PageInfo pageInfo) throws IOException, LcdpException {
        return this.aggregationPageInfoService.updateAllDataInfoTemplate(pageInfo);
    }

    @PostMapping(value={"/save/pages"})
    public FormDesignResponse<PageInfo> saveMultiPageInfo(@RequestBody List<PageInfo> pageInfos) throws IOException, LcdpException {
        if (ToolUtil.isNotEmpty(pageInfos)) {
            for (PageInfo pageInfo : pageInfos) {
                if (ToolUtil.isNotEmpty((Object)pageInfo.getData())) {
                    this.pageInfoService.updateFile(pageInfo);
                    continue;
                }
                this.pageInfoService.updateFileMeta(pageInfo);
            }
        }
        return new FormDesignResponse();
    }

    @PostMapping(value={"/edit"})
    public FormDesignResponse<PageInfo> updateDataInfo(@RequestBody PageInfo pageInfo) throws IOException, LcdpException {
        return this.aggregationPageInfoService.updateAllDataInfo(pageInfo);
    }

    @PutMapping(value={"/save"})
    public FormDesignResponse<PageInfo> saveDataInfo(@RequestBody PageInfo pageInfo) throws IOException, LcdpException {
        FormDesignResponse sharedStorage;
        if (this.formDesignProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(pageInfo.getId())).getErrorCode() != 200) {
            return sharedStorage;
        }
        if (ToolUtil.isEmpty((Object)pageInfo) || ToolUtil.isEmpty((Object)pageInfo.getName())) {
            logger.error("\u6587\u4ef6\uff08{}\uff09\u7684name\u4f20\u9012\u4e3a\u7a7a\uff0cpageInfo\u5185\u5bb9\u4e3a\uff1a{}", (Object)pageInfo.getId(), (Object)JSONObject.toJSONString((Object)pageInfo));
        }
        this.pageInfoService.updateFileData(pageInfo);
        return new FormDesignResponse();
    }

    @GetMapping
    public FormDesignResponse<PageInfo> getDataInfo(String id) throws IOException, LcdpException {
        FormDesignResponse stringSpeedCodeResponse = new FormDesignResponse();
        stringSpeedCodeResponse.setData(this.pageInfoService.get(id));
        return stringSpeedCodeResponse;
    }

    @PostMapping(value={"/datas"})
    public FormDesignResponse<List<PageInfo>> getDataInfos(@RequestBody List<PageInfo> pageInfoList) throws IOException, LcdpException {
        FormDesignResponse stringSpeedCodeResponse = new FormDesignResponse();
        ArrayList pageInfos = new ArrayList();
        if (ToolUtil.isNotEmpty(pageInfoList)) {
            for (PageInfo pageInfo : pageInfoList) {
                pageInfos.add(this.pageInfoService.get(pageInfo.getId()));
            }
        }
        stringSpeedCodeResponse.setData(pageInfos);
        return stringSpeedCodeResponse;
    }

    @PostMapping(value={"/del"})
    public FormDesignResponse<PageInfo> deleteDataInfo(String id) throws IOException, LcdpException {
        return this.aggregationPageInfoService.deleteDataInfo(id);
    }

    @PostMapping(value={"/copy"})
    public FormDesignResponse<JSONObject> copyDataInfo(@RequestBody OperateFileVO operateFileVO) throws IOException, LcdpException {
        return this.aggregationPageInfoService.copyDataInfo(operateFileVO);
    }

    @PostMapping(value={"/move"})
    public FormDesignResponse<PageInfo> moveDataInfo(@RequestBody OperateFileVO operateFileVO) throws IOException, LcdpException {
        FormDesignResponse sharedStorage;
        if (this.formDesignProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(operateFileVO.getId())).getErrorCode() != 200) {
            return sharedStorage;
        }
        return this.aggregationPageInfoService.moveDataInfo(operateFileVO);
    }

    @GetMapping(value={"/getWebRoutePrefix"})
    public FormDesignResponse<String> getWebRoutePrefix() {
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        try {
            ((MicroService)SpringContextHolder.getBean(MicroService.class)).scene();
            String appRoutePrefix = this.pathStrategy.vuePathService().prefix();
            String serviceID = AppContextUtil.getServiceID();
            if (ToolUtil.isNotEmpty((Object)appRoutePrefix)) {
                speedCodeResponse.setData((Object)appRoutePrefix);
            } else if (ToolUtil.isNotEmpty((Object)serviceID)) {
                speedCodeResponse.setData((Object)serviceID);
            } else {
                speedCodeResponse.setData((Object)"");
            }
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.SUCCESS.getCode());
        }
        catch (ApiException e) {
            speedCodeResponse.setErrorCode(HttpStatus.UNAUTHORIZED.value());
            speedCodeResponse.setErrorMsg(HttpStatus.UNAUTHORIZED.getReasonPhrase() + " \u767b\u5f55\u5931\u6548\u6216\u8d85\u65f6");
        }
        return speedCodeResponse;
    }

    @GetMapping(value={"/getWebUrl"})
    public FormDesignResponse<String> getWebUrl(String pageId) throws LcdpException {
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        String url = this.pageInfoService.getWebUrl(pageId);
        if (url != null) {
            speedCodeResponse.setData((Object)url);
        } else {
            speedCodeResponse.setErrorMsg("\u9875\u9762\u672a\u53d1\u5e03\uff0c\u8d44\u6e90\u4e3a\u7a7a");
            speedCodeResponse.setData((Object)"");
        }
        return speedCodeResponse;
    }

    @GetMapping(value={"/getMobileUrl"})
    public FormDesignResponse<String> getMobileUrl(String id) throws IOException, LcdpException {
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        String url = this.pageInfoService.getMobileUrl(id);
        if (url != null) {
            speedCodeResponse.setData((Object)url);
        } else {
            speedCodeResponse.setErrorMsg("\u9875\u9762\u672a\u53d1\u5e03\uff0c\u8d44\u6e90\u4e3a\u7a7a");
            speedCodeResponse.setData((Object)"");
        }
        return speedCodeResponse;
    }

    private FormDesignResponse isSharedStorage(String id) {
        Long userId;
        StorageResult result;
        SecurityUser user = BaseSecurityUtil.getUser();
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        if (ToolUtil.isEmpty((Object)user)) {
            speedCodeResponse.setErrorCode(400);
            speedCodeResponse.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
            return speedCodeResponse;
        }
        if (this.formDesignProperties.isLockEnabled() && ToolUtil.isNotEmpty((Object)(result = this.indexStorageLockService.getOneLockByResource(id)).getData()) && (!ToolUtil.isNotEmpty((Object)(userId = ((StorageLockPO)result.getData()).getUserId())) || !userId.equals(user.getId()))) {
            speedCodeResponse.setErrorCode(403);
            speedCodeResponse.setErrorMsg(((StorageLockPO)result.getData()).getUserName() + "\u6b63\u5728\u5360\u7528");
            return speedCodeResponse;
        }
        return new FormDesignResponse();
    }

    @GetMapping(value={"/getAllReferencesAndErrors"})
    public FormDesignResponse<Map<String, Object>> getAllReferencesAndErrorsList() throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        Map<String, Object> allReferencesAndErrorsList = this.pageInfoService.getAllReferencesAndErrorsList();
        map.put("newReference", allReferencesAndErrorsList);
        ApiResponse allQuoteList = this.sysQuoteRelationService.getAllQuoteList();
        map.put("oldReference", allQuoteList.getData());
        formDesignResponse.setData(map);
        return formDesignResponse;
    }

    @GetMapping(value={"/getPageState"})
    public FormDesignResponse<List<String>> getPageState(@RequestParam(value="ids", required=false) List<String> ids) throws IOException {
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        formDesignResponse.setData(this.pageInfoService.getPageState(ids));
        return formDesignResponse;
    }
}

