/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.modeltoexcel.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.jxdinfo.hussar.formdesign.engine.api.service.EngineApiService;
import com.jxdinfo.hussar.formdesign.modeltoexcel.model.ExcelData;
import com.jxdinfo.hussar.formdesign.modeltoexcel.model.ExcelDataPreview;
import com.jxdinfo.hussar.formdesign.modeltoexcel.model.ExcelDemo;
import com.jxdinfo.hussar.formdesign.modeltoexcel.service.ExcelReaderPlusService;
import com.jxdinfo.hussar.formdesign.modeltoexcel.utils.ExcelUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/formdesign/excelReader"})
public class ExcelReaderController {
    @Autowired
    ExcelReaderPlusService excelReaderPlus;
    @Autowired
    EngineApiService engineApiService;

    @RequestMapping(value={"/readExcel"})
    @ResponseBody
    public ApiResponse<ExcelData> readExcel(MultipartFile file) throws IOException {
        InputStream is = null;
        String fileName = file.getOriginalFilename();
        try {
            is = file.getInputStream();
        }
        catch (FileNotFoundException e) {
            return ApiResponse.fail((String)"\u6587\u4ef6\u5185\u5bb9\u5f02\u5e38");
        }
        return ApiResponse.success((Object)this.excelReaderPlus.readExcel(is, fileName));
    }

    @GetMapping(value={"/exportTemplate"})
    public void exportRemouldTemplate(HttpServletResponse response) throws ParseException {
        ServletOutputStream outputStream;
        LinkedHashMap<String, String> kvMap = ExcelUtil.getExcelDemoAttribute();
        ArrayList<ExcelDemo> excelDemos = new ArrayList<ExcelDemo>();
        for (int i = 0; i < 9; ++i) {
            ExcelDemo excelDemo = new ExcelDemo();
            int j = i + 1;
            excelDemo.setJobNumber("HUSSAR-000" + j);
            excelDemo.setName("\u5f20\u4e09" + j);
            excelDemo.setAge(25);
            Date date = new SimpleDateFormat("yyyy-MM-dd").parse("1998-01-0" + j);
            excelDemo.setBirthday(date);
            excelDemo.setSex(j % 2 == 1 ? "\u7537" : "\u5973");
            excelDemo.setSelfIntroduction("\u4e2a\u4eba\u4ecb\u7ecdxxx......");
            excelDemos.add(excelDemo);
        }
        String fileName = "demo.xlsx";
        try {
            outputStream = response.getOutputStream();
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
            response.setHeader("Content-Type", "application/force-download;charset=UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ExcelUtil.export(kvMap, excelDemos, (OutputStream)outputStream, null);
    }

    @PostMapping(value={"/dataPreview"})
    public ApiResponse<IPage<List<Map>>> dataPreview(@RequestBody ExcelDataPreview excelDataPreview) {
        return ApiResponse.success(this.excelReaderPlus.dataPreview(excelDataPreview));
    }

    @RequestMapping(value={"/setDatas"})
    public ApiResponse<Map> setDatas(@RequestBody ExcelDataPreview excelDataPreview) {
        String businessId = excelDataPreview.getBusinessId();
        HashMap<String, Object> methodParams = new HashMap<String, Object>();
        List<Map> datas = this.excelReaderPlus.getDatas(excelDataPreview);
        methodParams.put("importList", JSON.toJSONString(datas));
        try {
            ResponseEntity<ApiResponse<Object>> responseEntity = this.engineApiService.invokeByReturnEntity(businessId, null, methodParams);
            int successInt = 0;
            if (responseEntity.getStatusCode().value() == 200 && ((ApiResponse)responseEntity.getBody()).getCode() == 10000) {
                ArrayList arrayList = (ArrayList)((ApiResponse)responseEntity.getBody()).getData();
                successInt = arrayList.size();
            }
            int allInt = datas.size();
            HashMap<String, Integer> resMap = new HashMap<String, Integer>();
            resMap.put("successInt", successInt);
            resMap.put("allInt", allInt);
            resMap.put("failedInt", allInt - successInt);
            return ApiResponse.success(resMap);
        }
        catch (Exception E) {
            return ApiResponse.fail((String)"\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e,\u63d2\u5165\u5931\u8d25");
        }
    }
}

