/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.move.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.move.model.ProjectStoreMoveModel;
import com.jxdinfo.hussar.formdesign.file.move.service.IFileMoveService;
import com.jxdinfo.hussar.formdesign.file.move.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="FileMoveServiceImpl")
@Transactional(rollbackFor={Exception.class})
@Conditional(value={ConditionNotSharedStorage.class})
public class FileMoveServiceImpl
implements IFileMoveService {
    private static final Logger logger = LoggerFactory.getLogger(FileMoveServiceImpl.class);
    @Resource
    private FileMappingService fileMappingService;
    private final FormDesignProperties speedCodeProperties;
    private final PathStrategyService pathStrategy;

    public FileMoveServiceImpl(FormDesignProperties speedCodeProperties, PathStrategyService pathStrategy) {
        this.speedCodeProperties = speedCodeProperties;
        this.pathStrategy = pathStrategy;
    }

    @Override
    public Map<String, Object> moveFiles(Map<String, Object> map) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty(map)) {
            int lastindex = String.valueOf(map.get("path")).lastIndexOf("/");
            String fileName = String.valueOf(map.get("path")).substring(lastindex);
            String newTargetPath = map.get("targetPath") + fileName;
            if (String.valueOf(map.get("path")).equals(newTargetPath)) {
                resultMap.put("code", 200);
                resultMap.put("data", fileName);
                resultMap.put("msg", "\u6587\u4ef6\u79fb\u52a8\u6210\u529f");
                return resultMap;
            }
        }
        String path = this.pathStrategy.resourcePathService().getProjectAndCodePath() + map.get("path");
        String pathMeta = this.pathStrategy.resourcePathService().getProjectAndCodePath() + map.get("pathMeta");
        String type = String.valueOf(map.get("type"));
        ArrayList<File> sourceFileList = new ArrayList<File>();
        File fileMeta = new File(pathMeta);
        sourceFileList.add(fileMeta);
        try {
            boolean copySuccess = this.copyFileOrDirectory(map, sourceFileList);
            if (copySuccess) {
                FileUtil.deleteFolder(fileMeta);
                if (!"Module".equals(type)) {
                    FileUtil.deleteFolder(new File(path));
                }
                this.fileMappingService.fileMappingCacheEvict();
                resultMap.put("code", 200);
                if (ToolUtil.isNotEmpty((Object)map.get("newName"))) {
                    resultMap.put("data", map.get("newName"));
                }
                resultMap.put("msg", "\u6587\u4ef6\u79fb\u52a8\u6210\u529f");
            } else {
                resultMap.put("code", 500);
                resultMap.put("msg", "\u79fb\u52a8\u5931\u8d25");
            }
            return resultMap;
        }
        catch (IOException e) {
            e.printStackTrace();
            resultMap.put("code", 500);
            resultMap.put("msg", "\u79fb\u52a8\u5931\u8d25");
            return resultMap;
        }
    }

    private boolean copyFileOrDirectory(Map<String, Object> map, List<File> sourceFileList) throws FileNotFoundException {
        boolean flag;
        List<ProjectStoreMoveModel> list;
        String path = this.pathStrategy.resourcePathService().getProjectAndCodePath() + map.get("path");
        String targetPath = this.pathStrategy.resourcePathService().getProjectAndCodePath() + map.get("targetPath");
        String parentId = String.valueOf(map.get("parentId"));
        String type = String.valueOf(map.get("type"));
        HashMap<String, String> newNameMap = new HashMap<String, String>(2);
        if ("Module".equals(type)) {
            list = this.getFilesNeedToBeEdited(sourceFileList, targetPath, parentId);
            boolean flag1 = this.copyFileToTargetPath(list);
            ArrayList<File> fileList = new ArrayList<File>();
            FileUtil.getFiles(path, fileList);
            boolean flag2 = this.copyFileToTargetPath(path, targetPath);
            flag = flag1 && flag2;
        } else {
            File file = new File(path);
            sourceFileList.add(file);
            list = this.getFilesNeedToBeEdited(sourceFileList, targetPath, parentId);
            flag = this.copyFileToTargetPath(list);
        }
        for (ProjectStoreMoveModel model : list) {
            if (!ToolUtil.isNotEmpty((Object)model.getFileData()) || !ToolUtil.isNotEmpty((Object)model.getFileData().getString("id")) || !ToolUtil.isNotEmpty((Object)model.getNewName())) continue;
            newNameMap.put(model.getFileData().getString("id"), model.getNewName());
        }
        map.put("newName", newNameMap);
        return flag;
    }

    private boolean copyFileToTargetPath(List<ProjectStoreMoveModel> list) {
        ArrayList<JSONObject> fileDataList = new ArrayList<JSONObject>();
        ArrayList<String> urlList = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(list)) {
            for (ProjectStoreMoveModel psm : list) {
                JSONObject fileData = psm.getFileData();
                String newUrl = psm.getNewUrl();
                fileDataList.add(fileData);
                urlList.add(newUrl);
            }
            try {
                return FileUtil.generateJsonFile(fileDataList, urlList);
            }
            catch (IOException e) {
                logger.error("\u751f\u6210\u6587\u4ef6\u65f6\u51fa\u9519");
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean copyFileToTargetPath(String path, String targetPath) {
        try {
            File file = new File(path);
            String fileName = file.getName();
            String moveToUrl = targetPath + File.separator + fileName;
            File targetFile = new File(moveToUrl);
            if (FileUtils.exists((File)targetFile) && FileUtils.isDirectory((File)targetFile)) {
                List<String> targetFileNameList = this.getFirstLevelFileNameList(targetPath);
                moveToUrl = targetPath + File.separator + FileMoveServiceImpl.getNewFileName(targetFile, targetFileNameList, true);
            }
            FileUtils.moveDirectory((File)new File(path), (File)new File(moveToUrl));
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("\u79fb\u52a8\u6a21\u5757\u5931\u8d25");
            return false;
        }
    }

    private List<ProjectStoreMoveModel> getFilesNeedToBeEdited(List<File> sourceFileList, String targetPath, String parentId) throws FileNotFoundException {
        LinkedList<ProjectStoreMoveModel> list = new LinkedList<ProjectStoreMoveModel>();
        List<String> targetFileNameList = this.getFirstLevelFileNameList(targetPath);
        if (ToolUtil.isNotEmpty(sourceFileList)) {
            for (File file : sourceFileList) {
                this.addProjectStoreModel(file, targetFileNameList, list, targetPath, parentId);
            }
        }
        return list;
    }

    private void addProjectStoreModel(File file, List<String> targetFileNameList, List<ProjectStoreMoveModel> list, String targetPath, String parentId) throws FileNotFoundException {
        String name = file.getName();
        String url = file.getPath();
        String newName = FileMoveServiceImpl.getNewFileName(file, targetFileNameList, false);
        ProjectStoreMoveModel psm = new ProjectStoreMoveModel();
        JSONObject fileData = FileUtil.readOneFile(url);
        if (fileData == null) {
            psm.setFileData(null);
            psm.setUrl(url);
            psm.setNewName(newName.substring(0, newName.indexOf(46)));
            psm.setNewUrl(targetPath + File.separator + newName);
            list.add(psm);
            return;
        }
        String type = fileData.getString("type");
        String thisParentId = fileData.getString("parentId");
        boolean isExistParentId = StringUtils.isNotEmpty((CharSequence)thisParentId);
        if (isExistParentId) {
            fileData.put("parentId", (Object)parentId);
        }
        if (!name.equals(newName)) {
            boolean isWorkflowType;
            int index = newName.indexOf(46);
            String newEnglishName = newName;
            if (index != -1) {
                newEnglishName = newName.substring(0, index);
            }
            if (isWorkflowType = "Workflow".equals(type)) {
                fileData.put("eName", (Object)newEnglishName);
            } else {
                String englishName = fileData.getString("name");
                boolean isNameBaseWebPage = "Base.WebPage".equals(englishName);
                if (StringUtils.isNotEmpty((CharSequence)englishName) && !isNameBaseWebPage) {
                    fileData.put("name", (Object)newEnglishName);
                }
            }
        }
        psm.setFileData(fileData);
        psm.setUrl(url);
        psm.setNewName(newName.substring(0, newName.indexOf(46)));
        psm.setNewUrl(targetPath + File.separator + newName);
        list.add(psm);
    }

    public static String getNewFileName(File file, List<String> targetFileNameList, boolean isDirectory) {
        String fileName;
        String newFileName = fileName = file.getName();
        if (targetFileNameList.contains(fileName)) {
            do {
                if (isDirectory) {
                    newFileName = newFileName + "1";
                    continue;
                }
                int index = newFileName.indexOf(46);
                if (index != -1) {
                    String prefix = newFileName.substring(0, index);
                    String suffix = newFileName.substring(index);
                    newFileName = prefix + "1" + suffix;
                    continue;
                }
                newFileName = newFileName + "1";
            } while (targetFileNameList.contains(newFileName));
        }
        return newFileName;
    }

    private List<String> getFirstLevelFileNameList(String targetPath) {
        LinkedList<String> nameList = new LinkedList<String>();
        HashMap<String, List<File>> levelFileMap = new HashMap<String, List<File>>();
        FileUtil.getLayeredFiles(targetPath, levelFileMap, 0, targetPath);
        String level = "0";
        String catalog = "";
        String key = level + ":" + catalog;
        List targetFileList = (List)levelFileMap.get(key);
        if (ToolUtil.isNotEmpty((Object)targetFileList)) {
            for (File file : targetFileList) {
                String fileName = file.getName();
                nameList.add(fileName);
            }
        }
        return nameList;
    }
}

