/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.onlineimpl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionUseSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.PageTemplateInfo;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageTemplateInfoService;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="PageTemplateInfoServiceOnLineImpl")
@Conditional(value={ConditionUseSharedStorage.class})
public class PageTemplateInfoServiceOnLineImpl
implements PageTemplateInfoService {
    @Resource
    private FileMappingService fileMappingService;
    @Resource
    private StorageService storageService;
    @Resource
    private PathStrategyService pathStrategy;

    @Override
    public void create(PageTemplateInfo pageTemplateInfo) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStorePageTemplate(new String[0]).getRemotePath();
        if (!(ToolUtil.isEmpty((Object)pageTemplateInfo.getPageType()) || ToolUtil.isEmpty((Object)pageTemplateInfo.getCategory()) || ToolUtil.isEmpty((Object)pageTemplateInfo.getName()))) {
            String libName = pageTemplateInfo.getPageType();
            String catePath = libName + File.separator + pageTemplateInfo.getCategory();
            String metaPath = this.relativeToAbsolute(catePath + File.separator + pageTemplateInfo.getName() + ".meta", rootPath);
            Boolean isExists = Boolean.TRUE.equals(this.storageService.existsByPath(metaPath).getData());
            if (isExists.booleanValue()) {
                throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, metaPath);
            }
            try {
                this.storageService.uploadByPath(metaPath, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)pageTemplateInfo).getBytes(StandardCharsets.UTF_8), false);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, metaPath);
            }
        } else {
            throw new LcdpException(LcdpExceptionEnum.UPLOAD_ERROR, "\u6a21\u677f\u4fe1\u606f\u9519\u8bef");
        }
    }

    @Override
    public void updateFileMeta(PageTemplateInfo pageTemplateInfo) throws IOException, LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().projectStorePageTemplate(new String[0]).getRemotePath();
        if (!(ToolUtil.isEmpty((Object)pageTemplateInfo.getPageType()) || ToolUtil.isEmpty((Object)pageTemplateInfo.getCategory()) || ToolUtil.isEmpty((Object)pageTemplateInfo.getName()))) {
            String libName = pageTemplateInfo.getPageType();
            String catePath = libName + File.separator + pageTemplateInfo.getCategory();
            String metaPath = this.relativeToAbsolute(catePath + File.separator + pageTemplateInfo.getName() + ".meta", rootPath);
            try {
                this.storageService.uploadByPath(metaPath, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)pageTemplateInfo).getBytes(StandardCharsets.UTF_8), false);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, metaPath);
            }
        } else {
            throw new LcdpException(LcdpExceptionEnum.UPLOAD_ERROR, "\u6a21\u677f\u4fe1\u606f\u9519\u8bef");
        }
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public void delete(PageTemplateInfo pageTemplateInfo) throws LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().projectStorePageTemplate(new String[0]).getRemotePath();
        String parentPath = pageTemplateInfo.getPageType() + File.separator + pageTemplateInfo.getCategory();
        String mateFilePath = this.relativeToAbsolute(parentPath + File.separator + pageTemplateInfo.getName() + ".meta", rootPath);
        this.storageService.deleteByPath(mateFilePath, false);
        String cover = pageTemplateInfo.getCover();
        this.delCover(cover);
    }

    @Override
    public FormDesignResponse<String> upload(MultipartFile file) throws IOException {
        FormDesignResponse response = new FormDesignResponse();
        String fileSavePath = this.pathStrategy.resourcePathService().projectStorePageTemplateCover(new String[0]).getRemotePath();
        String fileName = file.getOriginalFilename();
        String filePath = fileSavePath + File.separator + fileName;
        byte[] bytes = file.getBytes();
        this.storageService.uploadByPath(filePath, bytes, false);
        response.setData((Object)fileName);
        return response;
    }

    @Override
    public void delCover(String fileName) throws LcdpException {
        if (!"".equals(fileName)) {
            String fileSavePath = this.pathStrategy.resourcePathService().projectStorePageTemplateCover(new String[0]).getRemotePath();
            String filePath = ToolUtil.pathFomatterByOS((String)fileSavePath) + File.separator + fileName;
            this.storageService.deleteByPath(filePath, false);
        }
    }

    @Override
    public ResponseEntity<byte[]> getCover(String fileName) throws IOException {
        MediaType mime;
        String fileSavePath = this.pathStrategy.resourcePathService().projectStorePageTemplateCover(new String[0]).getRemotePath();
        String filePath = fileSavePath + File.separator + fileName;
        String ext = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (ext.equals("jpg") || ext.equals("JPG")) {
            mime = MediaType.IMAGE_JPEG;
        } else if (ext.equals("png") || ext.equals("PNG")) {
            mime = MediaType.IMAGE_PNG;
        } else {
            System.err.println("bad cover extension: " + ext + ", guess jpeg");
            mime = MediaType.IMAGE_JPEG;
        }
        StorageResult storageResult = this.storageService.downloadByPath(filePath);
        if (storageResult.isSuccess()) {
            return ResponseEntity.ok().contentType(mime).body(storageResult.getData());
        }
        return ResponseEntity.notFound().build();
    }

    protected String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }
}

