/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.onlineimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.annotation.ExceptionCatcher;
import com.jxdinfo.hussar.formdesign.common.config.StorageContext;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionUseSharedStorage;
import com.jxdinfo.hussar.formdesign.common.constant.CommonModelMetaInfo;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.FileTreeService;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageEntity;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CategoryEnum;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="FileTreeServiceOnLineImpl")
@Conditional(value={ConditionUseSharedStorage.class})
public class FileTreeServiceOnLineImpl
implements FileTreeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTreeServiceOnLineImpl.class);
    private final FileMappingService fileMappingService;
    private final FormDesignProperties formDesignProperties;
    private static final String COMMON_MODEL = "common_model";
    private final StorageService storageService;
    private final StorageContext storageContext;
    private final PathStrategyService pathStrategy;

    @Autowired
    public FileTreeServiceOnLineImpl(FileMappingService fileMappingService, PathStrategyService pathStrategy, FormDesignProperties formDesignProperties, StorageService storageService, StorageContext storageContext) {
        this.fileMappingService = fileMappingService;
        this.pathStrategy = pathStrategy;
        this.formDesignProperties = formDesignProperties;
        this.storageService = storageService;
        this.storageContext = storageContext;
    }

    @Override
    @ExceptionCatcher
    public FormDesignResponse<List<JSONObject>> getFileTree(String parentId) throws IOException, LcdpException {
        FormDesignResponse response = new FormDesignResponse();
        String path = "";
        if (ToolUtil.isNotEmpty((Object)parentId) && ToolUtil.isEmpty((Object)(path = this.fileMappingService.getDataPath(parentId)))) {
            path = this.fileMappingService.getFilePathById(parentId).replace(".meta", "");
        }
        path = ToolUtil.pathFomatterByOS((String)path);
        List storageEntities = (List)this.storageService.list(path, ".meta", true).getData();
        String commonModelPath = "";
        if (ToolUtil.isNotEmpty((Object)parentId) && ToolUtil.isEmpty((Object)(commonModelPath = ToolUtil.pathFomatterByOS((String)(this.pathStrategy.resourcePathService().projectStore(new String[0]).getRemotePath() + "/common_model"))))) {
            commonModelPath = this.fileMappingService.getFilePathById(parentId).replace(".meta", "");
        }
        commonModelPath = ToolUtil.pathFomatterByOS((String)commonModelPath);
        List commonModelStorageEntities = (List)this.storageService.list(commonModelPath, ".meta", true).getData();
        if (ToolUtil.isEmpty((Object)storageEntities) && ToolUtil.isEmpty((Object)commonModelStorageEntities)) {
            return response;
        }
        ArrayList<String> errorFiles = new ArrayList<String>();
        ArrayList<JSONObject> fileList = new ArrayList<JSONObject>();
        this.iterator(storageEntities, fileList, errorFiles);
        this.iterator(commonModelStorageEntities, fileList, errorFiles);
        String errStr = String.valueOf(errorFiles);
        errStr = errStr.substring(1, errStr.length() - 1);
        response.setErrorMsg(errStr);
        fileList.add(CommonModelMetaInfo.getCommonModelMetaInfo());
        response.setData(this.treeSort(fileList));
        return response;
    }

    @Override
    public FormDesignResponse<List<JSONObject>> getFileTreeNew(String parentId) throws IOException, LcdpException {
        return null;
    }

    private void iterator(List<StorageEntity> storageEntities, List<JSONObject> fileList, List<String> errorFiles) throws IOException {
        for (StorageEntity storageEntity : storageEntities) {
            JSONObject file = JSON.parseObject((String)new String(storageEntity.getContent() != null ? storageEntity.getContent() : "".getBytes(), "UTF-8"));
            if (file == null) {
                errorFiles.add("\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38\uff1a" + storageEntity.getPath());
                continue;
            }
            if (file.get((Object)"type").equals("DataModel")) {
                byte[] dataBytes;
                String id = (String)file.get((Object)"id");
                StorageResult storageResult = this.storageService.downloadByUuid(CategoryEnum.JSON, id);
                if (ToolUtil.isEmpty((Object)storageResult.getData())) {
                    LOGGER.error(id + "\u5bf9\u5e94dbd " + storageResult.getMsg());
                }
                if (ToolUtil.isNotEmpty((Object)(dataBytes = (byte[])storageResult.getData()))) {
                    file.put("data", (Object)JSONObject.parseObject((String)new String(dataBytes, StandardCharsets.UTF_8)));
                }
            }
            fileList.add(file);
        }
    }

    private List<JSONObject> treeSort(List<JSONObject> jsonObjects) {
        final Collator collator = Collator.getInstance();
        jsonObjects.sort(new Comparator<JSONObject>(){
            private static final String ORDER_FILED1 = "parentId";
            private static final String ORDER_FILED2 = "type";
            private static final String ORDER_FILED3 = "desc";

            @Override
            public int compare(JSONObject a, JSONObject b) {
                String pidA = "";
                String pidB = "";
                String typeA = "";
                String typeB = "";
                String nameA = "";
                String nameB = "";
                try {
                    pidA = a.getString(ORDER_FILED1);
                    pidB = b.getString(ORDER_FILED1);
                    typeA = a.getString(ORDER_FILED2);
                    typeB = b.getString(ORDER_FILED2);
                    nameA = typeA.equals("Workflow") ? a.getString("name") : a.getString(ORDER_FILED3);
                    nameB = typeB.equals("Workflow") ? b.getString("name") : b.getString(ORDER_FILED3);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                int flag = FileTreeServiceOnLineImpl.this.pidCompare(pidA, pidB);
                if (flag == 0) {
                    flag = FileTreeServiceOnLineImpl.this.typeCompare(typeA, typeB);
                    if (flag == 0) {
                        if (ToolUtil.isNotEmpty((Object)nameA) && ToolUtil.isNotEmpty((Object)nameB)) {
                            return collator.compare(nameA, nameB);
                        }
                        return 0;
                    }
                    return flag;
                }
                return flag;
            }
        });
        return jsonObjects;
    }

    private int typeCompare(String typeA, String typeB) {
        int flag;
        switch (typeA) {
            case "Module": {
                if (typeB.equals("Module")) {
                    flag = 0;
                    break;
                }
                flag = -1;
                break;
            }
            case "MicroApp": {
                if (typeB.equals("Module")) {
                    flag = 1;
                    break;
                }
                if (typeB.equals("MicroApp")) {
                    flag = 0;
                    break;
                }
                flag = -1;
                break;
            }
            case "WebPage": {
                if (typeB.equals("Module") || typeB.equals("MicroApp")) {
                    flag = 1;
                    break;
                }
                if (typeB.equals("WebPage")) {
                    flag = 0;
                    break;
                }
                flag = -1;
                break;
            }
            case "MobilePage": {
                if (typeB.equals("Module") || typeB.equals("MicroApp") || typeB.equals("WebPage")) {
                    flag = 1;
                    break;
                }
                if (typeB.equals("MobilePage")) {
                    flag = 0;
                    break;
                }
                flag = -1;
                break;
            }
            case "DataModel": {
                if (typeB.equals("Module") || typeB.equals("MicroApp") || typeB.equals("WebPage") || typeB.equals("MobilePage")) {
                    flag = 1;
                    break;
                }
                if (typeB.equals("DataModel")) {
                    flag = 0;
                    break;
                }
                flag = -1;
                break;
            }
            default: {
                flag = !typeB.equals("Workflow") ? 1 : 0;
            }
        }
        return flag;
    }

    private int pidCompare(String pidA, String pidB) {
        if (pidA.equals("#") && !pidB.equals("#")) {
            return -1;
        }
        if (pidB.equals("#") && !pidA.equals("#")) {
            return 1;
        }
        return pidA.compareTo(pidB);
    }

    @Override
    public List<JSONObject> getAppFileTree(String appId) throws LcdpException, IOException {
        String path = "#";
        if (ToolUtil.isEmpty((Object)(path = this.fileMappingService.getDataPath(path)))) {
            path = this.fileMappingService.getFilePathById(path).replace(".meta", "");
        }
        String finalPath = path = ToolUtil.pathFomatterByOS((String)path);
        List storageEntities = (List)((StorageResult)this.storageContext.with(null, appId, null, () -> this.storageService.list(finalPath, ".meta", true))).getData();
        String commonModelPath = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getProjectRootPath(), COMMON_MODEL});
        List commonModelStorageEntities = (List)((StorageResult)this.storageContext.with(null, appId, null, () -> this.storageService.list(commonModelPath, ".meta", true))).getData();
        storageEntities.addAll(commonModelStorageEntities);
        ArrayList errorFiles = new ArrayList();
        ArrayList<JSONObject> fileList = new ArrayList<JSONObject>();
        this.storageContext.with(null, appId, null, () -> {
            try {
                this.iterator(storageEntities, fileList, errorFiles);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return fileList;
    }

    @Override
    public List<String> getFileTreeId(String parentId) throws IOException, LcdpException {
        return null;
    }

    @Override
    public FormDesignResponse<JSONArray> getFileTreeByType(String type) throws LcdpException, IOException {
        return null;
    }
}

