/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.onlineimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionUseSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.MicroAppInfo;
import com.jxdinfo.hussar.formdesign.common.model.MobilePageInfo;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.DataInfo;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.FileBean;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.PubPlatDTO;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.DataInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.MicroAppInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.onlineimpl.BaseFileServiceOnLineImpl;
import com.jxdinfo.hussar.formdesign.file.fileoperate.util.ZipUtil;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CategoryEnum;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service(value="DataInfoServiceOnLineImpl")
@Conditional(value={ConditionUseSharedStorage.class})
public class DataInfoServiceOnLineImpl
extends BaseFileServiceOnLineImpl<MobilePageInfo>
implements DataInfoService {
    @Resource
    private MicroAppInfoService microAppInfoService;
    @Resource
    private PageInfoService pageInfoService;
    @Resource
    private FormDesignProperties speedCodeProperties;
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    @Autowired
    private RestTemplate restTemplate;
    @Resource
    private PathStrategyService pathStrategy;

    @Autowired
    public DataInfoServiceOnLineImpl(FileMappingService fileMappingService, FormDesignProperties speedCodeProperties) {
        this.fileMappingService = fileMappingService;
        this.speedCodeProperties = speedCodeProperties;
    }

    @Override
    public void saveFrame(MobilePageInfo mobilePageInfo) throws LcdpException, IOException {
        DataInfo dataInfo = (DataInfo)JSON.parseObject((String)mobilePageInfo.getData(), DataInfo.class);
        HashMap tabBar = (HashMap)JSON.parseObject((String)dataInfo.getTabBar().toString(), HashMap.class);
        String pubPlatMadPath = this.getDataPath(mobilePageInfo.getId());
        JSONArray oldList = JSONObject.parseArray((String)tabBar.get("list").toString());
        ArrayList<HashMap> newList = new ArrayList<HashMap>();
        for (Object o : oldList) {
            HashMap tabMap = (HashMap)JSON.parseObject((String)o.toString(), HashMap.class);
            if (tabMap.get("pageID") != null && ToolUtil.isNotEmpty((Object)tabMap.get("pageID").toString())) {
                String path = this.fileMappingService.getFormatPath(tabMap.get("pageID").toString());
                tabMap.put("pageID", path);
            }
            newList.add(tabMap);
        }
        tabBar.replace("list", newList);
        if (ToolUtil.isEmpty(tabBar.get("homePage")) && ToolUtil.isNotEmpty(newList)) {
            Map defaultHomePage = (Map)newList.get(0);
            tabBar.replace("homePage", this.pathToLevelIds(String.valueOf(defaultHomePage.get("pageID")).replace("/", "\\")));
        }
        dataInfo.setTabBar(tabBar);
        dataInfo.setUpdateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern(DATE_FORMAT)));
        mobilePageInfo.setData(JSON.toJSONString((Object)dataInfo));
        if (ToolUtil.isNotEmpty((Object)mobilePageInfo.getData())) {
            this.storageService.uploadByUuid(CategoryEnum.JSON, mobilePageInfo.getId(), pubPlatMadPath, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(JSON.parse((String)mobilePageInfo.getData())).getBytes(StandardCharsets.UTF_8), false);
        } else {
            this.storageService.uploadByUuid(CategoryEnum.JSON, mobilePageInfo.getId(), pubPlatMadPath, "".getBytes(), false);
        }
    }

    @Override
    public void publishFrame(Map<String, String> idMap) throws LcdpException, IOException {
        String pubPlatID = idMap.get("id");
        MicroAppInfo microAppInfo = (MicroAppInfo)((Object)this.microAppInfoService.get(pubPlatID));
        String projectPath = this.speedCodeProperties.getWorkspace() + microAppInfo.getProjectPath() + "\\src\\config";
        String tabData = new String((byte[])this.storageService.downloadByUuid(CategoryEnum.JSON, pubPlatID).getData(), StandardCharsets.UTF_8);
        DataInfo dataInfo = (DataInfo)JSON.parseObject((String)tabData, DataInfo.class);
        HashMap tabBar = (HashMap)JSON.parseObject((String)dataInfo.getTabBar().toString(), HashMap.class);
        List tabBarList = JSONObject.parseArray((String)tabBar.get("homePage").toString(), String.class);
        tabBar.replace("homePage", this.fileMappingService.getFormatPath((String)tabBarList.get(tabBarList.size() - 1)));
        String absolutePath = this.relativeToAbsolute(File.separator + "page.config.json", projectPath);
        File file = new File(absolutePath);
        try {
            if (ToolUtil.isEmpty((Object)tabBar)) {
                FileUtils.writeStringToFile((File)file, (String)"", (String)"UTF-8", (boolean)false);
            } else {
                FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)tabBar), (String)"UTF-8", (boolean)false);
            }
        }
        catch (IOException e) {
            throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, file.getAbsolutePath());
        }
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public MobilePageInfo updateFrameJson(String id) throws LcdpException, IOException, ParseException {
        MicroAppInfo microAppInfo = (MicroAppInfo)((Object)this.microAppInfoService.get(id));
        String pubPlatJsonPath = this.speedCodeProperties.getWorkspace() + microAppInfo.getProjectPath() + "\\src\\config\\page.config.json";
        String projectPath = this.pathStrategy.resourcePathService().getProjectAndCodePath();
        File file = new File(pubPlatJsonPath);
        MobilePageInfo mobilePageInfo = (MobilePageInfo)((Object)this.get(id));
        DataInfo dataInfo = (DataInfo)JSON.parseObject((String)mobilePageInfo.getData(), DataInfo.class);
        if (dataInfo == null) {
            mobilePageInfo.setData(JSONObject.toJSONString((Object)new DataInfo()));
            return mobilePageInfo;
        }
        if (FileUtils.exists((File)file)) {
            String tabBar = "";
            try {
                if (!FileUtils.isDirectory((File)file)) {
                    tabBar = FileUtils.readFileToString((File)file, (String)"UTF-8");
                }
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, pubPlatJsonPath);
            }
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            Date updateTime = format.parse(dataInfo.getUpdateTime());
            if (updateTime.getTime() > file.lastModified()) {
                return mobilePageInfo;
            }
            JSONObject tabBarObj = JSONObject.parseObject((String)tabBar);
            String homePage = tabBarObj.get((Object)"homePage").toString().replace("/", "\\");
            List<String> levelIds = this.pathToLevelIds(homePage);
            tabBarObj.put("homePage", levelIds);
            dataInfo.setTabBar(JSONObject.parse((String)tabBarObj.toString()));
            mobilePageInfo.setData(JSON.toJSONString((Object)dataInfo));
            FileUtils.writeStringToFile((File)new File(this.relativeToAbsolute(this.getDataPath(mobilePageInfo.getId()), projectPath)), (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)dataInfo), (String)"UTF-8", (boolean)false);
        }
        return mobilePageInfo;
    }

    private List<String> pathToLevelIds(String relativePath) throws LcdpException {
        ArrayList<String> levelIds = new ArrayList<String>();
        List idS = Arrays.stream(relativePath.split("\\\\")).collect(Collectors.toList());
        idS.remove(0);
        ArrayList<String> eachLevelPathS = new ArrayList<String>();
        StringBuilder moduleId = new StringBuilder();
        for (String levelId : idS) {
            moduleId.append("\\").append(levelId);
            eachLevelPathS.add(moduleId.toString());
        }
        for (String eachLevelPath : eachLevelPathS) {
            this.fileMappingService.fileMappingCache().forEach((fileId, fileName) -> {
                if (fileName.substring(0, fileName.indexOf(".")).contentEquals(eachLevelPath)) {
                    levelIds.add((String)fileId);
                }
            });
        }
        return levelIds;
    }

    @Override
    public FormDesignResponse<Void> packageToJQX(Map<String, String> pubMap) throws Exception {
        MicroAppInfo microAppInfo = (MicroAppInfo)((Object)this.microAppInfoService.get(pubMap.get("id")));
        FormDesignResponse response = new FormDesignResponse();
        String mobileProjectPath = this.speedCodeProperties.getWorkspace() + microAppInfo.getProjectPath();
        File[] dist = FileUtils.listFiles((File)new File(mobileProjectPath + "\\dist"));
        if (ToolUtil.isEmpty((Object)dist)) {
            response.setErrorMsg("\u6253\u5305\u5931\u8d25\uff01");
            response.setErrorCode(500);
            return response;
        }
        File emptyFile = new File(mobileProjectPath + "\\package");
        String emptyLocalPath = emptyFile.getAbsolutePath();
        for (File inDist : dist) {
            FileUtils.copyFile((File)inDist, (File)new File(emptyLocalPath + "\\www"), (boolean)true);
            FileUtils.copyFile((File)inDist, (File)new File(emptyLocalPath + "\\www1"), (boolean)true);
            FileUtils.copyFile((File)inDist, (File)new File(emptyLocalPath + "\\www2"), (boolean)true);
        }
        ZipUtil.zip(emptyLocalPath + "\\www", emptyLocalPath + "\\www.zip");
        ZipUtil.zip(emptyLocalPath + "\\www1", emptyLocalPath + "\\www1.zip");
        ZipUtil.zip(emptyLocalPath + "\\www2", emptyLocalPath + "\\www2.zip");
        HashMap<String, Object> androidFileMap = new HashMap<String, Object>();
        androidFileMap.put("accountId", "143F5BDC-52CF-49BE-B553-F6494561C454");
        androidFileMap.put("secretKey", "8d1aff622e27dace2b7ac7a736862950");
        File androidZip = new File(emptyLocalPath + "\\www.zip");
        androidFileMap.put("file", androidZip);
        String res = (String)this.restTemplate.postForObject(Objects.requireNonNull(this.environment.getProperty("fileUrl")), androidFileMap, String.class, new Object[0]);
        HashMap<String, Object> iosFileMap = new HashMap<String, Object>();
        iosFileMap.put("accountId", "143F5BDC-52CF-49BE-B553-F6494561C454");
        iosFileMap.put("secretKey", "8d1aff622e27dace2b7ac7a736862950");
        File iosZip = new File(emptyLocalPath + "\\www1.zip");
        iosFileMap.put("file", iosZip);
        String res1 = (String)this.restTemplate.postForObject(Objects.requireNonNull(this.environment.getProperty("fileUrl")), iosFileMap, String.class, new Object[0]);
        HashMap<String, Object> pcFileMap = new HashMap<String, Object>();
        pcFileMap.put("accountId", "143F5BDC-52CF-49BE-B553-F6494561C454");
        pcFileMap.put("secretKey", "8d1aff622e27dace2b7ac7a736862950");
        File pcZip = new File(emptyLocalPath + "\\www2.zip");
        pcFileMap.put("file", pcZip);
        String res2 = (String)this.restTemplate.postForObject(Objects.requireNonNull(this.environment.getProperty("fileUrl")), pcFileMap, String.class, new Object[0]);
        ArrayList<FileBean> fileBeans = new ArrayList<FileBean>();
        FileBean androidFileBean = new FileBean();
        androidFileBean.setFileID(JSONObject.parseObject((String)res).getString("data"));
        androidFileBean.setFileName("www.zip");
        androidFileBean.setFileSize(FileUtils.sizeOf((File)androidZip));
        androidFileBean.setType(0);
        FileBean iosFileBean = new FileBean();
        iosFileBean.setFileID(JSONObject.parseObject((String)res1).getString("data"));
        iosFileBean.setFileName("www1.zip");
        iosFileBean.setFileSize(FileUtils.sizeOf((File)iosZip));
        iosFileBean.setType(1);
        FileBean pcFileBean = new FileBean();
        pcFileBean.setFileID(JSONObject.parseObject((String)res2).getString("data"));
        pcFileBean.setFileName("www2.zip");
        pcFileBean.setFileSize(FileUtils.sizeOf((File)pcZip));
        pcFileBean.setType(2);
        fileBeans.add(androidFileBean);
        fileBeans.add(iosFileBean);
        fileBeans.add(pcFileBean);
        PubPlatDTO pubPlatDTO = new PubPlatDTO();
        pubPlatDTO.setName(microAppInfo.getDesc());
        pubPlatDTO.setObjID(microAppInfo.getAppID());
        pubPlatDTO.setSecretKey(microAppInfo.getSecret());
        pubPlatDTO.setPubType("3");
        pubPlatDTO.setAndroidChange("1");
        pubPlatDTO.setIosChange("1");
        pubPlatDTO.setPcChange("1");
        pubPlatDTO.setFileBeanList(fileBeans);
        return this.invokePubPlat(pubPlatDTO);
    }

    @Override
    public FormDesignResponse<Void> putPathToJQX(Map<String, String> pubMap) throws IOException, LcdpException {
        FormDesignResponse response = new FormDesignResponse();
        MicroAppInfo microAppInfo = (MicroAppInfo)((Object)this.microAppInfoService.get(pubMap.get("id")));
        if (response.getErrorCode() == 500) {
            return response;
        }
        PubPlatDTO pubPlatDTO = new PubPlatDTO();
        pubPlatDTO.setObjID(microAppInfo.getAppID());
        pubPlatDTO.setName(microAppInfo.getDesc());
        pubPlatDTO.setSecretKey(microAppInfo.getSecret());
        pubPlatDTO.setPubType("4");
        pubPlatDTO.setPath(this.environment.getProperty("VUE_STARTPATH"));
        return this.invokePubPlat(pubPlatDTO);
    }

    private FormDesignResponse<Void> invokePubPlat(PubPlatDTO pubPlatDTO) {
        FormDesignResponse response = new FormDesignResponse();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", "superadmin");
        params.put("password", "111111");
        params.put("client_id", "pc");
        params.put("client_secret", "pc");
        String token = ((JSONObject)Objects.requireNonNull(this.restTemplate.postForObject(String.valueOf(this.environment.getProperty("JQX_TOKEN_URL")), params, JSONObject.class, new Object[0]))).get((Object)"access_token").toString();
        JSONObject mobileUser = new JSONObject();
        mobileUser.put("code", (Object)"superadmin");
        mobileUser.put("password", (Object)DigestUtils.md5Digest((byte[])"111111".getBytes()));
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", token);
        HttpEntity loginEntity = new HttpEntity((Object)mobileUser, (MultiValueMap)headers);
        String loginRes = (String)this.restTemplate.postForObject(String.valueOf(this.environment.getProperty("JQX_LOGIN_URL")), (Object)loginEntity, String.class, new Object[0]);
        if (JSONObject.parseObject((String)loginRes).get((Object)"success").equals(false)) {
            response.setErrorMsg("\u90e8\u7f72\u5931\u8d25\uff01");
            response.setErrorCode(500);
            return response;
        }
        HttpEntity publishEntity = new HttpEntity((Object)pubPlatDTO, (MultiValueMap)headers);
        String publishRes = (String)this.restTemplate.postForObject(String.valueOf(this.environment.getProperty("publishApi")), (Object)publishEntity, String.class, new Object[0]);
        if ("false".equals(JSONObject.parseObject((String)publishRes).get((Object)"data"))) {
            response.setErrorMsg("\u90e8\u7f72\u5931\u8d25\uff01");
            response.setErrorCode(500);
            return response;
        }
        return response;
    }

    @Override
    public void setHomePage(String id) throws Exception {
        String microAppID = ((PageInfo)this.pageInfoService.get(id)).getMicroApp();
        MicroAppInfo microAppInfo = (MicroAppInfo)((Object)this.microAppInfoService.get(microAppID));
        String pageConfigPath = this.speedCodeProperties.getWorkspace() + microAppInfo.getProjectPath() + "\\src\\config\\page.config.json";
        String route = this.getMicroPagePath(id);
        File pageFile = new File(pageConfigPath);
        String jsonStr = FileUtils.readFileToString((File)pageFile, (String)"utf-8");
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        jsonObject.remove((Object)"homePage");
        jsonObject.put("homePage", (Object)route.replaceAll("\\\\", "/"));
        FileUtils.writeStringToFile((File)pageFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"UTF-8", (boolean)false);
    }

    private String getMicroPagePath(String id) throws LcdpException {
        String madPath = this.getDataPath(id);
        madPath = madPath.replace("\\", "/");
        String noProjectStoreCodeMadPath = madPath.replace(this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getRemotePath(), "");
        return noProjectStoreCodeMadPath.substring(0, noProjectStoreCodeMadPath.lastIndexOf(".mpd"));
    }
}

