/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.collaboration.lock.model.StorageLockPO;
import com.jxdinfo.hussar.formdesign.collaboration.lock.service.IndexStorageLockService;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.OperateFileVO;
import com.jxdinfo.hussar.formdesign.common.model.WorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.aggregationservice.AggregationWorkflowService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.SaveInfoDto;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.WorkflowDumpDto;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.WorkflowService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.vo.ProcessDefinitionVo;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/speed/workflowinfo"})
public class WorkflowInfoController {
    private WorkflowService workflowService;
    private final IndexStorageLockService indexStorageLockService;
    private final FormDesignProperties formDesignProperties;
    @Autowired
    private AggregationWorkflowService aggregationWorkflowService;

    @Autowired
    public WorkflowInfoController(WorkflowService workflowService, IndexStorageLockService indexStorageLockService, FormDesignProperties formDesignProperties) {
        this.workflowService = workflowService;
        this.indexStorageLockService = indexStorageLockService;
        this.formDesignProperties = formDesignProperties;
    }

    @PostMapping(value={"/add"})
    public FormDesignResponse<WorkflowInfo> addDataInfo(@RequestBody WorkflowInfo workflowInfo) throws IOException, LcdpException {
        ArrayList<String> processKeys = new ArrayList<String>();
        processKeys.add(workflowInfo.getIdentity());
        FormDesignResponse<Map> formDesignResponse = this.workflowService.checkProcessKey(processKeys);
        if (formDesignResponse.getErrorCode() == 10001) {
            return formDesignResponse;
        }
        this.workflowService.createWorkflow(workflowInfo);
        return new FormDesignResponse();
    }

    @PostMapping(value={"/data/meta"})
    public FormDesignResponse<WorkflowInfo> updateAllDataInfo(@RequestBody WorkflowInfo workflowInfo) throws IOException, LcdpException {
        return this.aggregationWorkflowService.updateAllDataInfo(workflowInfo);
    }

    @PutMapping(value={"/save"})
    public FormDesignResponse<PageInfo> saveDataInfo(@RequestBody WorkflowInfo workflowInfo) throws IOException, LcdpException {
        FormDesignResponse sharedStorage;
        if (this.formDesignProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(String.valueOf(workflowInfo.getModelId()))).getErrorCode() != 200) {
            return sharedStorage;
        }
        this.workflowService.updateFileData(workflowInfo);
        return new FormDesignResponse();
    }

    @PostMapping(value={"/move"})
    public FormDesignResponse<PageInfo> moveDataInfo(@RequestBody OperateFileVO operateFileVO) throws IOException, LcdpException {
        FormDesignResponse sharedStorage;
        if (this.formDesignProperties.getScenes().isSharedStorage() && this.formDesignProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(operateFileVO.getId())).getErrorCode() != 200) {
            return sharedStorage;
        }
        this.aggregationWorkflowService.moveWorkFlow(operateFileVO.getId(), operateFileVO.getParentId(), operateFileVO.getNewName(), operateFileVO.getNewDesc(), operateFileVO.getCategory());
        return new FormDesignResponse();
    }

    @PostMapping(value={"/copy"})
    public FormDesignResponse copyDataInfo(@RequestBody List<OperateFileVO> operateFileVOs) throws IOException, LcdpException {
        return this.aggregationWorkflowService.copyDataInfo(operateFileVOs);
    }

    @PutMapping
    public FormDesignResponse<WorkflowInfo> updateDataInfo(@RequestBody WorkflowInfo workflowInfo) throws IOException, LcdpException {
        FormDesignResponse sharedStorage;
        if (this.formDesignProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(String.valueOf(workflowInfo.getModelId()))).getErrorCode() != 200) {
            return sharedStorage;
        }
        this.workflowService.updateFileMeta(workflowInfo);
        return new FormDesignResponse();
    }

    @GetMapping
    public FormDesignResponse<WorkflowInfo> getDataInfo(String id) throws IOException, LcdpException {
        FormDesignResponse stringSpeedCodeResponse = new FormDesignResponse();
        stringSpeedCodeResponse.setData(this.workflowService.get(id));
        return stringSpeedCodeResponse;
    }

    @PostMapping(value={"/del"})
    public FormDesignResponse<WorkflowInfo> deleteDataInfo(@RequestParam String id, @RequestParam String identity, @RequestParam(required=false) String organId, @RequestParam(required=false) boolean forced, @RequestParam(required=false) String ids) throws IOException, LcdpException {
        ArrayList<String> deptIds = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)ids)) {
            deptIds = Arrays.asList(ids.split(","));
        }
        return this.aggregationWorkflowService.deleteDataInfo(id, identity, organId, forced, deptIds);
    }

    private FormDesignResponse isSharedStorage(String id) {
        Long userId;
        StorageResult result;
        SecurityUser user = BaseSecurityUtil.getUser();
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        if (ToolUtil.isEmpty((Object)user)) {
            speedCodeResponse.setErrorCode(400);
            speedCodeResponse.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
            return speedCodeResponse;
        }
        if (this.formDesignProperties.isLockEnabled() && ToolUtil.isNotEmpty((Object)(result = this.indexStorageLockService.getOneLockByResource(id)).getData()) && (!ToolUtil.isNotEmpty((Object)(userId = ((StorageLockPO)result.getData()).getUserId())) || !userId.equals(user.getId()))) {
            speedCodeResponse.setErrorCode(403);
            speedCodeResponse.setErrorMsg(((StorageLockPO)result.getData()).getUserName() + "\u6b63\u5728\u5360\u7528");
            return speedCodeResponse;
        }
        return new FormDesignResponse();
    }

    @GetMapping(value={"/queryFlowMeta"})
    public ApiResponse<WorkFlow> queryFlowMeta(String processKey, String processVersion) throws IOException, LcdpException {
        WorkFlow workFlow = this.workflowService.queryFlowMeta(processKey, processVersion);
        return ApiResponse.success((Object)workFlow);
    }

    @GetMapping(value={"/queryFlowVersion"})
    public ApiResponse<JSONArray> queryFlowVersion(String processKey) throws IOException, LcdpException {
        List<ProcessDefinitionVo> list = this.workflowService.queryFlowVersion(processKey);
        JSONArray jsonArray = JSONArray.parseArray((String)JSON.toJSONString(list));
        return ApiResponse.success((Object)jsonArray);
    }

    @PostMapping(value={"/saveMetaAndData"})
    public ApiResponse<?> saveMetaAndData(@RequestBody SaveInfoDto saveInfoDto) throws IOException, LcdpException {
        return this.workflowService.checkAndSaveWorkFlowDataAndMeta(saveInfoDto);
    }

    @PostMapping(value={"/setMainVersion"})
    public ApiResponse<String> setMainVersion(@RequestParam(value="processKey") String processKey, @RequestParam(value="processVersion") String processVersion) throws IOException, LcdpException {
        return this.workflowService.setMainVersion(processKey, processVersion);
    }

    @GetMapping(value={"/queryNextVersion"})
    public ApiResponse<String> queryNextVersion(String processKey) {
        return this.workflowService.queryNextVersion(processKey);
    }

    @GetMapping(value={"/checkProcessKey"})
    public FormDesignResponse<Map> checkProcessKey(List<String> processKey) {
        return this.workflowService.checkProcessKey(processKey);
    }

    @GetMapping(value={"/exportProcess"})
    public void exportProcess(@RequestParam(value="processKey") String processKey, @RequestParam(value="modelName") String modelName, @RequestParam(value="name") String name, @RequestParam(value="fileId") String fileId, @RequestParam(value="version") Integer version, @RequestParam(value="moduleId") String moduleId, HttpServletResponse response) throws Exception {
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        WorkflowDumpDto workflowDumpDto = new WorkflowDumpDto();
        workflowDumpDto.setModelName(modelName);
        workflowDumpDto.setName(name);
        workflowDumpDto.setProcessKey(processKey);
        workflowDumpDto.setModuleId(moduleId);
        workflowDumpDto.setFileId(fileId);
        workflowDumpDto.setTenantCode(tenantCode);
        workflowDumpDto.setVersion(version);
        this.workflowService.exportProcess(workflowDumpDto, response);
    }

    @PostMapping(value={"/importProcess"})
    public ApiResponse<Object> importProcess(@RequestBody MultipartFile file, String fileId, String processKey) throws IOException, LcdpException, ClassNotFoundException {
        return this.workflowService.importProcess(file, fileId, processKey);
    }
}

