/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.controller;

import com.jxdinfo.hussar.formdesign.common.annotation.ExceptionCatcher;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.MicroAppInfo;
import com.jxdinfo.hussar.formdesign.common.model.OperateFileVO;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.MicroAppInfoService;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speed/microappinfo"})
public class MicroAppInfoController {
    private final MicroAppInfoService microAppInfoService;
    @Resource
    private FileMappingService fileMappingService;
    private final FormDesignProperties speedCodeProperties;

    @Autowired
    public MicroAppInfoController(MicroAppInfoService microAppInfoService, FormDesignProperties speedCodeProperties) {
        this.microAppInfoService = microAppInfoService;
        this.speedCodeProperties = speedCodeProperties;
    }

    @PostMapping(value={"/add"})
    public FormDesignResponse<MicroAppInfo> addDataInfo(@RequestBody MicroAppInfo microAppInfo) throws IOException, LcdpException {
        microAppInfo.setProjectPath(FileUtil.posixPath((String[])new String[]{this.fileMappingService.getDataPath(microAppInfo.getParentId()), microAppInfo.getName()}));
        this.microAppInfoService.create(microAppInfo);
        return new FormDesignResponse();
    }

    @PostMapping(value={"/folderIsExist"})
    public FormDesignResponse<Boolean> folderIsExist(@RequestBody MicroAppInfo microAppInfo) throws LcdpException {
        Boolean isExist = this.microAppInfoService.folderIsExist(FileUtil.posixPath((String[])new String[]{this.speedCodeProperties.getWorkspace(), this.fileMappingService.getDataPath(microAppInfo.getParentId()), microAppInfo.getName()}));
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        speedCodeResponse.setData((Object)isExist);
        return speedCodeResponse;
    }

    @PostMapping(value={"/createProject"})
    @ExceptionCatcher
    public FormDesignResponse<MicroAppInfo> createProject(@RequestBody MicroAppInfo microAppInfo) throws IOException, LcdpException {
        String projectPath = FileUtil.posixPath((String[])new String[]{this.speedCodeProperties.getWorkspace(), this.fileMappingService.getDataPath(microAppInfo.getParentId()), microAppInfo.getName()});
        microAppInfo.setProjectPath(projectPath);
        this.microAppInfoService.createProject(projectPath);
        this.microAppInfoService.updateAppPort(microAppInfo);
        this.microAppInfoService.updateServerPort(projectPath);
        return new FormDesignResponse();
    }

    @PutMapping(value={"/data/meta"})
    public FormDesignResponse<MicroAppInfo> updateAllDataInfo(@RequestBody MicroAppInfo microAppInfo) throws IOException, LcdpException {
        if (ToolUtil.isNotEmpty((Object)microAppInfo.getData())) {
            this.microAppInfoService.updateFile(microAppInfo);
        } else {
            this.microAppInfoService.updateFileMeta(microAppInfo);
        }
        this.microAppInfoService.updateAppPort(microAppInfo);
        return new FormDesignResponse();
    }

    @PostMapping(value={"/edit"})
    public FormDesignResponse<MicroAppInfo> updateDataInfo(@RequestBody MicroAppInfo microAppInfo) throws IOException, LcdpException {
        this.microAppInfoService.updateFileMeta(microAppInfo);
        this.microAppInfoService.updateAppPort(microAppInfo);
        return new FormDesignResponse();
    }

    @PutMapping(value={"/save"})
    public FormDesignResponse<MicroAppInfo> saveDataInfo(@RequestBody MicroAppInfo microAppInfo) throws IOException, LcdpException {
        this.microAppInfoService.updateFileData(microAppInfo);
        return new FormDesignResponse();
    }

    @GetMapping(value={"/getFolder"})
    public FormDesignResponse<List<String>> getFolder(String path) throws LcdpException {
        List<String> data = this.microAppInfoService.getFolder(path);
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        speedCodeResponse.setData(data);
        return speedCodeResponse;
    }

    @GetMapping(value={"/getProjectPath"})
    public FormDesignResponse<String> getProjectPath() throws IOException {
        String data = this.microAppInfoService.getProjectPath();
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        speedCodeResponse.setData((Object)data);
        return speedCodeResponse;
    }

    @GetMapping(value={"/getMicroInfo"})
    public FormDesignResponse<MicroAppInfo> getMicroInfo(String id) throws IOException, LcdpException {
        FormDesignResponse stringSpeedCodeResponse = new FormDesignResponse();
        stringSpeedCodeResponse.setData(this.microAppInfoService.get(id));
        return stringSpeedCodeResponse;
    }

    @PostMapping(value={"/del"})
    public FormDesignResponse<MicroAppInfo> deleteDataInfo(String id) throws IOException, LcdpException {
        this.microAppInfoService.delete(id);
        return new FormDesignResponse();
    }

    @PostMapping(value={"/copy"})
    public FormDesignResponse<MicroAppInfo> copyDataInfo(@RequestBody OperateFileVO operateFileVO) throws IOException, LcdpException {
        this.microAppInfoService.copy(operateFileVO.getId(), operateFileVO.getParentId(), operateFileVO.getNewId(), operateFileVO.getNewName(), operateFileVO.getNewDesc());
        return new FormDesignResponse();
    }

    @PutMapping(value={"/move"})
    public FormDesignResponse<MicroAppInfo> moveDataInfo(@RequestBody OperateFileVO operateFileVO) throws IOException, LcdpException {
        this.microAppInfoService.move(operateFileVO.getId(), operateFileVO.getParentId(), operateFileVO.getNewName(), operateFileVO.getNewDesc());
        return new FormDesignResponse();
    }

    @GetMapping(value={"/getMaxPort"})
    public FormDesignResponse<Integer> getMaxPort() throws LcdpException {
        List<MicroAppInfo> microAppInfoList = this.microAppInfoService.getMicroAppInfo();
        return this.microAppInfoService.getMaxPort(microAppInfoList);
    }
}

