/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.extend.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.common.constant.ClientKindEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.FrontClientConverter;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.extend.ExtendClientConvertor;
import com.jxdinfo.hussar.formdesign.extend.model.vue.ExtendCustomVueInfo;
import com.jxdinfo.hussar.formdesign.extend.model.vue.ExtendCustomVuePathVO;
import com.jxdinfo.hussar.formdesign.extend.model.vue.ExtendCustomVueVO;
import com.jxdinfo.hussar.formdesign.extend.service.ExtendCustomVueService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExtendCustomVueUtil {
    public static String getCustomVuePathById(String id, String pageType) throws LcdpException {
        ExtendCustomVueInfo fileInfo;
        String path = VfgModeTool.isRemote() ? "#" + ((String)FrontClientConverter.getPathResolver((String)ClientKindEnum.CLIENT_PATH.kind(pageType)).paths().get("EXTEND_VUE_PATH")).replaceAll("\\\\", "/") : "@" + ((String)FrontClientConverter.getPathResolver((String)ClientKindEnum.CLIENT_PATH.kind(pageType)).paths().get("EXTEND_VUE_PATH")).substring(4).replaceAll("\\\\", "/");
        ExtendCustomVueService customVueService = ExtendClientConvertor.getExtendVue("com.jxdinfo." + pageType + ".extend.vue");
        try {
            fileInfo = (ExtendCustomVueInfo)((Object)customVueService.get(id));
        }
        catch (LcdpException | IOException e) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        if (fileInfo != null) {
            path = path + fileInfo.getFilePath();
        }
        return path;
    }

    public static Map<String, String> getRegisteredVuedPath(List<String> metaPath) throws LcdpException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            for (String path : metaPath) {
                String content = FileUtils.readFileToString((File)new File(path), (String)"UTF-8");
                ExtendCustomVueInfo fileInfo = (ExtendCustomVueInfo)((Object)JSON.parseObject((String)content, ExtendCustomVueInfo.class));
                map.put(fileInfo.getFilePath().replaceAll("\\\\", "").replaceAll("/", ""), null);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, metaPath.toString());
        }
        return map;
    }

    public static void createBlankDirectory(List<ExtendCustomVuePathVO> pathList) {
        for (int i = 0; i < pathList.size(); ++i) {
            ExtendCustomVuePathVO pathVO = pathList.get(i);
            if ("0".equals(pathVO.getParentPath()) || "#".equals(pathVO.getParentPath())) continue;
            boolean flag = false;
            for (ExtendCustomVuePathVO pathVOTwo : pathList) {
                if (!pathVO.getParentPath().equals(pathVOTwo.getPath())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            ExtendCustomVuePathVO BlankVO = new ExtendCustomVuePathVO();
            BlankVO.setPath(pathVO.getParentPath());
            BlankVO.setLabel(pathVO.getParentPath().substring(pathVO.getParentPath().lastIndexOf(File.separator) + 1));
            if (pathVO.getParentPath().lastIndexOf(File.separator) < 1) {
                BlankVO.setParentPath("#");
            } else {
                BlankVO.setParentPath(pathVO.getParentPath().substring(0, pathVO.getParentPath().lastIndexOf(File.separator)));
            }
            BlankVO.setListFile(new ArrayList<ExtendCustomVueVO>());
            pathList.add(BlankVO);
            ExtendCustomVueUtil.createBlankDirectory(pathList);
        }
    }

    public static void addBlankRootDirectory(List<ExtendCustomVuePathVO> pathVOList) {
        if (pathVOList.size() > 0) {
            boolean blankFile = true;
            for (ExtendCustomVuePathVO pathVO : pathVOList) {
                if (!"0".equals(pathVO.getParentPath())) continue;
                blankFile = false;
                break;
            }
            if (blankFile) {
                ExtendCustomVuePathVO pathVO = new ExtendCustomVuePathVO();
                pathVO.setParentPath("0");
                pathVO.setListFile(new ArrayList<ExtendCustomVueVO>());
                pathVO.setLabel("#");
                pathVO.setPath("#");
                pathVO.setChildren(new ArrayList<ExtendCustomVuePathVO>());
                pathVOList.add(pathVO);
            }
        }
    }

    public static List<ExtendCustomVuePathVO> recursiveFilePath(String id, List<ExtendCustomVuePathVO> pathList) {
        ArrayList<ExtendCustomVuePathVO> childList = new ArrayList<ExtendCustomVuePathVO>();
        for (ExtendCustomVuePathVO nav : pathList) {
            if (!nav.getParentPath().equals(id)) continue;
            childList.add(nav);
        }
        for (ExtendCustomVuePathVO nav : childList) {
            nav.setChildren(ExtendCustomVueUtil.recursiveFilePath(nav.getPath(), pathList));
        }
        if (childList.size() == 0) {
            return new ArrayList<ExtendCustomVuePathVO>();
        }
        return childList;
    }

    public static ExtendCustomVueVO getVueFileInformation(String filePath) throws LcdpException {
        ExtendCustomVueVO FileVO = new ExtendCustomVueVO();
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(new File(filePath).lastModified());
            FileVO.setUpdateTime(cal.getTime().toLocaleString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, filePath);
        }
        return FileVO;
    }
}

