/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.extend.controller;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.CrossReferErrorInfo;
import com.jxdinfo.hussar.formdesign.common.model.OperateFileVO;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendScriptInfo;
import com.jxdinfo.hussar.formdesign.extend.service.ExtendScriptInfoService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.Api;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4e8c\u6b21\u5f00\u53d1-\u624b\u5199js"})
@RequestMapping(value={"/formdesign/extend/scriptinfo"})
public class ExtendWScriptInfoController {
    @Qualifier(value="ExtendWJsInfoServiceImpl")
    @Autowired
    private ExtendScriptInfoService extendScriptInfoService;

    @PostMapping(value={"/add"})
    public ApiResponse<ExtendScriptInfo> addDataInfo(@RequestBody ExtendScriptInfo extendScriptInfo) throws IOException, LcdpException {
        return this.extendScriptInfoService.add(extendScriptInfo);
    }

    @PostMapping(value={"/edit"})
    public ApiResponse<ExtendScriptInfo> updateAllDataInfo(@RequestBody ExtendScriptInfo extendScriptInfo) throws IOException, LcdpException {
        return this.extendScriptInfoService.edit(extendScriptInfo);
    }

    @PostMapping(value={"/saveCrossReferErrors"})
    public ApiResponse<ExtendScriptInfo> saveCrossReferErrors(@RequestBody CrossReferErrorInfo crossReferErrors) throws IOException, LcdpException {
        return this.extendScriptInfoService.saveCrossReferErrors(crossReferErrors.getCrossReferErrors(), crossReferErrors.getId());
    }

    @GetMapping
    public ApiResponse<ExtendScriptInfo> getDataInfo(String id) throws IOException, LcdpException {
        return ApiResponse.success(this.extendScriptInfoService.get(id));
    }

    @PostMapping(value={"/del"})
    public ApiResponse<Boolean> delete(String id) throws IOException, LcdpException {
        this.extendScriptInfoService.delete(id);
        return ApiResponse.success((Object)true);
    }

    @PostMapping(value={"/copy"})
    public ApiResponse<Boolean> copyDataInfo(@RequestBody OperateFileVO operateFileVO) throws IOException, LcdpException {
        this.extendScriptInfoService.copy(operateFileVO.getId(), operateFileVO.getParentId(), operateFileVO.getNewId(), operateFileVO.getNewName(), operateFileVO.getNewDesc());
        return ApiResponse.success((Object)true);
    }

    @PostMapping(value={"/move"})
    public ApiResponse<Boolean> moveDataInfo(@RequestBody OperateFileVO operateFileVO) throws IOException, LcdpException {
        this.extendScriptInfoService.move(operateFileVO.getId(), operateFileVO.getParentId(), operateFileVO.getNewName(), operateFileVO.getNewDesc());
        return ApiResponse.success((Object)true);
    }
}

