/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.component.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.core.util.LicenseInfo;
import com.jxdinfo.hussar.core.util.SecurityUtil;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.component.constant.CheckInfoEnum;
import com.jxdinfo.hussar.formdesign.component.constant.ComponentField;
import com.jxdinfo.hussar.formdesign.component.constant.ComponentType;
import com.jxdinfo.hussar.formdesign.component.model.CheckInfo;
import com.jxdinfo.hussar.formdesign.component.model.CheckResult;
import com.jxdinfo.hussar.formdesign.component.model.CompatibleVersions;
import com.jxdinfo.hussar.formdesign.component.model.ComponentDependence;
import com.jxdinfo.hussar.formdesign.component.model.ComponentExportInfo;
import com.jxdinfo.hussar.formdesign.component.model.ComponentInfo;
import com.jxdinfo.hussar.formdesign.component.model.CustomComponentInfo;
import com.jxdinfo.hussar.formdesign.component.service.ComponentService;
import com.jxdinfo.hussar.formdesign.component.service.CustomComponentService;
import com.jxdinfo.hussar.formdesign.component.util.ComponentCacheUtil;
import com.jxdinfo.hussar.formdesign.component.util.ComponentCheckInfoUtil;
import com.jxdinfo.hussar.formdesign.devtools.model.ComponentDto;
import com.jxdinfo.hussar.formdesign.file.fileoperate.util.ZipUtil;
import com.jxdinfo.hussar.formdesign.properties.LcdpVersionProperties;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.AutoIntegrationConfiguration;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.operator.PluginOperator;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.operator.module.PluginInfo;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ComponentServiceImpl
implements ComponentService {
    @Autowired
    private FormDesignProperties formDesignProperties;
    @Autowired
    private LcdpVersionProperties lcdpVersionProperties;
    @Autowired(required=false)
    private AutoIntegrationConfiguration autoIntegrationConfiguration;
    @Autowired(required=false)
    @Lazy
    private PluginOperator pluginOperator;
    @Autowired
    private CustomComponentService customComponentService;
    @Autowired
    private PathStrategyService pathStrategy;
    private static final Logger logger = LoggerFactory.getLogger(ComponentServiceImpl.class);

    @Override
    public ApiResponse<CheckResult<ComponentInfo>> check(MultipartFile file, String id) throws Exception {
        if (!this.autoIntegrationConfiguration.enable()) {
            CheckResult checkResult = new CheckResult();
            checkResult.setResult(-1);
            CheckInfo checkInfo = new CheckInfo();
            checkResult.addCheckInfos(checkInfo);
            checkInfo.addInfos("\u672a\u542f\u52a8\u4e0d\u91cd\u542f\u63d2\u4ef6, \u8be6\u60c5\u53ef\u770b\u5e2e\u52a9\u4e2d\u5fc3-\u5f00\u53d1\u8005\u6307\u5357-\u6280\u672f\u7ec4\u4ef6-\u4e0d\u91cd\u542f\u63d2\u4ef6\uff0c\u53ef\u901a\u8fc7\u5c06\u914d\u7f6e\u6587\u4ef6application.yml\u4e2dplugin-enable\u6539\u4e3atrue, \u542f\u52a8\u4e0d\u91cd\u542f\u63d2\u4ef6", -2);
            checkInfo.setResultAndMsg(-2, "\u4e0d\u91cd\u542f\u63d2\u4ef6\u672a\u542f\u52a8\uff0c\u8bf7\u53c2\u8003\u5e2e\u52a9\u4e2d\u5fc3\u542f\u52a8\u4e0d\u91cd\u542f\u63d2\u4ef6");
            return ApiResponse.fail((int)ResultCode.FAILURE.getCode(), checkResult, (String)"\u6821\u9a8c\u5931\u8d25");
        }
        if (file.isEmpty()) {
            return ApiResponse.fail((String)"\u538b\u7f29\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        String type = file.getContentType();
        if ("application/x-zip-compressed".equals(type) || "application/zip".equals(type)) {
            return this.zipCheck(file, id);
        }
        return ApiResponse.fail((String)"\u5f53\u524d\u53ea\u652f\u6301zip\u538b\u7f29\u5305");
    }

    @Override
    public ApiResponse<Map<String, Object>> inducts(ComponentInfo componentInfo) throws Exception {
        Map<String, ComponentInfo> awaitComponentInfos = this.getAwaitComponentInfos();
        ComponentInfo awaitComponent = awaitComponentInfos.get(componentInfo.getId());
        if (HussarUtils.isEmpty((Object)awaitComponent)) {
            return ApiResponse.fail((String)"\u672a\u77e5\u7ec4\u4ef6");
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (ComponentType.EXTENSION.getValue().equals(componentInfo.getType())) {
            ComponentInfo oldComponentInfo = null;
            List<ComponentInfo> componentInfos = this.getComponentInfos(componentInfo.getType());
            for (ComponentInfo component : componentInfos) {
                if (!component.getCode().equals(componentInfo.getCode())) continue;
                oldComponentInfo = component;
                dataMap.put("delComponentInfo", oldComponentInfo);
            }
            if (HussarUtils.isNotEmpty(oldComponentInfo)) {
                this.pluginOperator.uninstall(oldComponentInfo.getPluginId(), false);
            }
            ApiResponse<Boolean> installFlag = this.installPlugin(componentInfo);
            if (ResultCode.SUCCESS.getCode() != installFlag.getCode()) {
                if (HussarUtils.isNotEmpty((Object)oldComponentInfo)) {
                    String jarPath = FileUtil.systemPath((String[])new String[]{oldComponentInfo.getComponentIOPath(this.pathStrategy.resourcePathService().getComponentIOPath()), oldComponentInfo.getBackendFileName()});
                    this.pluginOperator.install(Paths.get(jarPath, new String[0]));
                }
                return ApiResponse.fail((String)installFlag.getMsg());
            }
            String elementFile = this.getElementFile(componentInfo);
            dataMap.put("elementFile", elementFile);
            if (HussarUtils.isNotEmpty((Object)componentInfo.getFrontFileName())) {
                String frontFile = this.getFrontFile(componentInfo);
                dataMap.put("frontFile", frontFile);
            }
            dataMap.put("type", componentInfo.getType());
            if (HussarUtils.isNotEmpty((Object)oldComponentInfo)) {
                this.delComponentInfoByCode(oldComponentInfo.getCode());
                File thisFile = new File(oldComponentInfo.getComponentIOPath(this.pathStrategy.resourcePathService().getComponentIOPath()));
                org.apache.commons.io.FileUtils.deleteQuietly((File)thisFile);
            }
        }
        if (ComponentType.CUSTOM.getValue().equals(componentInfo.getType())) {
            CustomComponentInfo customComponentInfo = this.customComponentService.getCustomJson(componentInfo);
            if (HussarUtils.isEmpty((Object)customComponentInfo)) {
                return ApiResponse.fail((String)"\u5bfc\u5165\u5931\u8d25");
            }
            customComponentInfo.setCompPanelCategory(componentInfo.getCompPanelCategory());
            customComponentInfo.setCategory(componentInfo.getCategory());
            String path1 = componentInfo.getComponentIOPath(this.pathStrategy.resourcePathService().getComponentIOPath());
            String path2 = FileUtil.systemPath((String[])new String[]{path1, componentInfo.getCustomFileName()});
            File customFile = new File(path2);
            org.apache.commons.io.FileUtils.writeStringToFile((File)customFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)customComponentInfo), (String)"UTF-8", (boolean)false);
            dataMap.put("customFile", customComponentInfo);
            dataMap.put("type", componentInfo.getType());
        }
        this.addComponent(componentInfo);
        this.delAwaitComponentInfo(componentInfo.getId());
        return ApiResponse.success(dataMap);
    }

    public List<ComponentInfo> getAllTenantComponentInfos(String type) throws IOException {
        List<ComponentInfo> componentInfos = new ArrayList<ComponentInfo>();
        String path1 = this.pathStrategy.resourcePathService().getComponentIOPath();
        File file1 = new File(path1);
        if (!file1.exists()) {
            return componentInfos;
        }
        String path2 = FileUtil.systemPath((String[])new String[]{path1, type + "ComponentInfos.json"});
        File file2 = new File(path2);
        if (!file2.exists()) {
            return componentInfos;
        }
        String jsonStr = org.apache.commons.io.FileUtils.readFileToString((File)file2, (String)"UTF-8");
        componentInfos = JSONArray.parseArray((String)jsonStr, ComponentInfo.class);
        return componentInfos;
    }

    @Override
    public void export(HttpServletResponse response, ComponentExportInfo componentExportInfo) throws Exception {
        List<String> fileNames;
        ComponentInfo componentInfo = null;
        HashMap outFileNames = new HashMap();
        if (HussarUtils.isNotBlank((CharSequence)componentExportInfo.getCode())) {
            componentInfo = this.getComponentByCode(componentExportInfo.getCode());
            fileNames = this.getExtendFileName(componentInfo);
        } else if (HussarUtils.isNotBlank((CharSequence)componentExportInfo.getId())) {
            componentInfo = this.getComponentById(componentExportInfo.getId());
            fileNames = this.getCustomFileName(componentInfo);
        } else {
            return;
        }
        String rootPath = componentInfo.getComponentIOPath(this.pathStrategy.resourcePathService().getComponentIOPath());
        ComponentDto componentDto = new ComponentDto();
        componentDto.setId(componentInfo.getId());
        componentDto.setBackendFileName(componentInfo.getBackendFileName());
        componentDto.setFileNames(fileNames);
        componentDto.setRootPath(rootPath);
        componentDto.setOutFileNames(outFileNames);
        componentDto = FileUtils.export((ComponentDto)componentDto);
        response.setContentType("application/octet-stream");
        response.setHeader("content-disposition", "attachment; fileName=" + componentExportInfo.getZipName());
        response.setCharacterEncoding("UTF-8");
        ServletOutputStream out = response.getOutputStream();
        ZipUtil.zips(componentDto.getFileNames(), componentDto.getOutFileNames(), (OutputStream)out);
    }

    @Override
    public ApiResponse<List<Map<String, Object>>> getAllFrontFile(String pageType) throws IOException {
        ArrayList frontFiles = new ArrayList();
        List<ComponentInfo> componentInfos = this.getComponentCache();
        for (ComponentInfo componentInfo : componentInfos) {
            if (!ComponentType.EXTENSION.getValue().equals(componentInfo.getType()) || !HussarUtils.isNotEmpty((Object)componentInfo.getFrontFileName()) || !HussarUtils.isEmpty((Object)pageType) && !pageType.equals(componentInfo.getPageType())) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            String frontFile = this.getFrontFile(componentInfo);
            map.put("componentInfo", componentInfo);
            map.put("frontFile", frontFile);
            frontFiles.add(map);
        }
        return ApiResponse.success(frontFiles);
    }

    @Override
    public ApiResponse<List<Map<String, Object>>> getAllElementFile() throws IOException {
        ArrayList elementFiles = new ArrayList();
        List<ComponentInfo> componentInfos = this.getComponentCache();
        for (ComponentInfo componentInfo : componentInfos) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String elementFile = this.getElementFile(componentInfo);
            map.put("elementFile", elementFile);
            map.put("componentInfo", componentInfo);
            elementFiles.add(map);
        }
        return ApiResponse.success(elementFiles);
    }

    @Override
    public synchronized boolean delAwaitComponent(String id) throws IOException {
        Map<String, ComponentInfo> awaitComponentInfos = this.getAwaitComponentInfos();
        ComponentInfo componentInfo = awaitComponentInfos.get(id);
        if (HussarUtils.isEmpty((Object)componentInfo)) {
            return false;
        }
        this.delComponetFile(componentInfo);
        this.delAwaitComponentInfo(id);
        return true;
    }

    @Override
    public ApiResponse<String> getFrontFileByCode(String code) throws IOException {
        if (HussarUtils.isBlank((CharSequence)code)) {
            return ApiResponse.fail((String)"\u7ec4\u4ef6\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<ComponentInfo> componentInfos = this.getPreviewComponentCache();
        for (ComponentInfo componentInfo : componentInfos) {
            if (!code.equals(componentInfo.getCode())) continue;
            String frontFile = this.getPreviewFrontFile(componentInfo);
            if (HussarUtils.isBlank((CharSequence)frontFile)) {
                return ApiResponse.fail((String)"\u5c01\u88c5js\u83b7\u53d6\u5931\u8d25");
            }
            return ApiResponse.success((int)ResultCode.SUCCESS.getCode(), (Object)frontFile, (String)"");
        }
        return ApiResponse.fail((String)("\u7ec4\u4ef6" + code + "\u4e0d\u5b58\u5728"));
    }

    public ApiResponse<CheckResult<ComponentInfo>> zipCheck(MultipartFile file, String id) throws Exception {
        CheckResult<ComponentInfo> checkResult = new CheckResult<ComponentInfo>();
        CheckInfo completeCheck = new CheckInfo(CheckInfoEnum.COMPLETE.success());
        checkResult.addCheckInfos(completeCheck);
        ComponentInfo componentInfo = this.getComponentInfo(file);
        if (HussarUtils.isEmpty((Object)componentInfo)) {
            ComponentCheckInfoUtil.complete(completeCheck, "componentInfo.json(\u7ec4\u4ef6\u4fe1\u606f)", -3);
            checkResult.setResult(-1);
            return ApiResponse.fail((int)ResultCode.FAILURE.getCode(), checkResult, (String)"\u6821\u9a8c\u5931\u8d25");
        }
        componentInfo.setId(id);
        List<String> fileNames = this.checkFile(file, componentInfo, completeCheck);
        if (-2 == completeCheck.getResult()) {
            checkResult.setResult(-1);
            return ApiResponse.fail((int)ResultCode.FAILURE.getCode(), checkResult, (String)"\u6821\u9a8c\u5931\u8d25");
        }
        if (-1 == completeCheck.getResult()) {
            checkResult.setResult(-1);
        }
        this.checkPageType(componentInfo.getPageType(), checkResult);
        this.checkInfo(componentInfo, checkResult);
        if (1 > checkResult.getResult()) {
            if (0 == checkResult.getResult()) {
                this.writeAwaitComponent(componentInfo, fileNames, file);
            }
            checkResult.setData(componentInfo);
            return ApiResponse.fail((int)ResultCode.FAILURE.getCode(), checkResult, (String)"\u6821\u9a8c\u5931\u8d25");
        }
        this.writeAwaitComponent(componentInfo, fileNames, file);
        checkResult.setData(componentInfo);
        return ApiResponse.success(checkResult);
    }

    public void checkPageType(String pageType, CheckResult<ComponentInfo> checkResult) {
        CheckInfo pageTypeCheck = new CheckInfo();
        checkResult.addCheckInfos(pageTypeCheck);
        if (HussarUtils.isBlank((CharSequence)pageType)) {
            ComponentCheckInfoUtil.pageType(pageTypeCheck, pageType, -1);
            checkResult.setResult(-1);
            return;
        }
        if ("WebPage".equals(pageType)) {
            ComponentCheckInfoUtil.pageType(pageTypeCheck, "web\u9875\u9762", 1);
            return;
        }
        if ("MobilePage".equals(pageType)) {
            ComponentCheckInfoUtil.pageType(pageTypeCheck, "\u79fb\u52a8\u9875\u9762", 1);
            return;
        }
        if ("UniPage".equals(pageType)) {
            ComponentCheckInfoUtil.pageType(pageTypeCheck, "\u79fb\u52a8\u9875\u9762", 1);
            return;
        }
        ComponentCheckInfoUtil.pageType(pageTypeCheck, pageType, -2);
        checkResult.setResult(-1);
    }

    public void writeAwaitComponent(ComponentInfo componentInfo, List<String> fileNames, MultipartFile file) throws Exception {
        this.writeFile(componentInfo, fileNames, file);
        if (ComponentType.EXTENSION.getValue().equals(componentInfo.getType())) {
            componentInfo.setBackendFileName(componentInfo.getId() + componentInfo.getBackendFileName());
        }
        if (ComponentType.CUSTOM.getValue().equals(componentInfo.getType())) {
            CustomComponentInfo customComponentInfo = this.customComponentService.getCustomJson(componentInfo);
            customComponentInfo.setName(componentInfo.getId());
            String path1 = componentInfo.getComponentIOPath(this.pathStrategy.resourcePathService().getComponentIOPath());
            String path2 = FileUtil.systemPath((String[])new String[]{path1, componentInfo.getCustomFileName()});
            File customFile = new File(path2);
            org.apache.commons.io.FileUtils.writeStringToFile((File)customFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)customComponentInfo), (String)"UTF-8", (boolean)false);
        }
        this.addAwaitComponentInfos(componentInfo);
    }

    public List<String> checkFile(MultipartFile file, ComponentInfo componentInfo, CheckInfo completeCheck) {
        Map<String, String> fileNameMap = this.getFileNames(componentInfo, completeCheck);
        ArrayList<String> fileNames = new ArrayList<String>();
        if (HussarUtils.isEmpty(fileNameMap)) {
            return null;
        }
        for (Map.Entry<String, String> fileName : fileNameMap.entrySet()) {
            boolean flag = false;
            try (ZipInputStream zis = new ZipInputStream(file.getInputStream(), ZipUtil.getFileCharset(file.getInputStream()));){
                ZipEntry zipEntry;
                while ((zipEntry = zis.getNextEntry()) != null) {
                    String zipFileName = zipEntry.getName();
                    if (!fileName.getValue().equals(zipFileName)) continue;
                    flag = true;
                    fileNames.add(fileName.getValue());
                    break;
                }
            }
            catch (IOException e) {
                logger.error("\u7ec4\u4ef6\u76f8\u5173\u6587\u4ef6\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            }
            if (flag) continue;
            ComponentCheckInfoUtil.complete(completeCheck, fileName.getKey() + ":" + fileName.getValue(), -2);
        }
        if (-2 >= completeCheck.getResult()) {
            return null;
        }
        return fileNames;
    }

    @Override
    public void writeFile(ComponentInfo componentInfo, List<String> fileNames, MultipartFile file) throws Exception {
        String rootPath = componentInfo.getComponentIOPath(this.pathStrategy.resourcePathService().getComponentIOPath());
        FileUtils.inducts((MultipartFile)file, (String)componentInfo.getId(), (String)componentInfo.getBackendFileName(), (String)rootPath, fileNames);
    }

    public Map<String, String> getFileNames(ComponentInfo componentInfo, CheckInfo completeCheck) {
        String type = componentInfo.getType();
        HashMap<String, String> fileNames = new HashMap<String, String>();
        fileNames.put("componentInfo.json(\u7ec4\u4ef6\u4fe1\u606f)", "componentInfo.json");
        if (ComponentType.CUSTOM.getValue().equals(type)) {
            if (HussarUtils.isEmpty((Object)componentInfo.getCustomFileName())) {
                ComponentCheckInfoUtil.complete(completeCheck, ComponentField.CUSTOMFILENAME.getLabel(), -1);
            } else {
                fileNames.put(ComponentField.CUSTOMFILENAME.getLabel(), componentInfo.getCustomFileName());
            }
            if (HussarUtils.isNotEmpty((Object)componentInfo.getCoverFileName())) {
                fileNames.put(ComponentField.COVERFILENAME.getLabel(), componentInfo.getCoverFileName());
            }
            return fileNames;
        }
        if (ComponentType.EXTENSION.getValue().equals(type)) {
            if (HussarUtils.isEmpty((Object)componentInfo.getBackendFileName())) {
                ComponentCheckInfoUtil.complete(completeCheck, ComponentField.BACKENDFILENAME.getLabel(), -1);
            } else {
                fileNames.put(ComponentField.BACKENDFILENAME.getLabel(), componentInfo.getBackendFileName());
            }
            if (HussarUtils.isEmpty((Object)componentInfo.getElementFileName())) {
                ComponentCheckInfoUtil.complete(completeCheck, ComponentField.ELEMENTFILENAME.getLabel(), -1);
            } else {
                fileNames.put(ComponentField.ELEMENTFILENAME.getLabel(), componentInfo.getElementFileName());
            }
            if (HussarUtils.isNotEmpty((Object)componentInfo.getFrontFileName())) {
                fileNames.put(ComponentField.FRONTFILENAME.getLabel(), componentInfo.getFrontFileName());
            }
            return fileNames;
        }
        ComponentCheckInfoUtil.type(completeCheck, type, false);
        return null;
    }

    public void checkInfo(ComponentInfo componentInfo, CheckResult<ComponentInfo> checkResult) throws IOException {
        if (ComponentType.CUSTOM.getValue().equals(componentInfo.getType())) {
            this.checkCustomInfo(componentInfo, checkResult);
        } else if (ComponentType.EXTENSION.getValue().equals(componentInfo.getType())) {
            this.checkExtensionInfo(componentInfo, checkResult);
        }
    }

    public ApiResponse<Boolean> installPlugin(ComponentInfo componentInfo) {
        try {
            PluginInfo pluginInfo;
            String jarPath = FileUtil.systemPath((String[])new String[]{componentInfo.getComponentIOPath(this.pathStrategy.resourcePathService().getComponentIOPath()), componentInfo.getBackendFileName()});
            if (VfgModeTool.isRemote()) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(FileUtils.install((String)String.valueOf(Paths.get(jarPath, new String[0]))));
                MockMultipartFile file = new MockMultipartFile(componentInfo.getBackendFileName(), componentInfo.getBackendFileName(), "application/x-zip-compressed", (InputStream)inputStream);
                pluginInfo = this.pluginOperator.uploadPluginAndStart((MultipartFile)file);
            } else {
                pluginInfo = this.pluginOperator.install(Paths.get(jarPath, new String[0]));
            }
            if (HussarUtils.isEmpty((Object)pluginInfo) || HussarUtils.isEmpty((Object)pluginInfo.getPluginDescriptor())) {
                return ApiResponse.fail((String)"\u5bfc\u5165\u5931\u8d25");
            }
            String pluginId = pluginInfo.getPluginDescriptor().getPluginId();
            componentInfo.setPluginId(pluginId);
            logger.info("\u6ce8\u518c" + pluginId + "\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u5bfc\u5165\u5931\u8d25");
        }
        return ApiResponse.success((Object)true);
    }

    public String getFrontFile(ComponentInfo componentInfo) throws IOException {
        String frontFile = "";
        if (HussarUtils.isNotEmpty((Object)componentInfo.getFrontFileName())) {
            String path = VfgModeTool.isRemote() ? componentInfo.getComponentIOPath(this.pathStrategy.resourcePathService().getComponentIOPath()) : componentInfo.getRootPath(this.pathStrategy.resourcePathService().getProjectAndComponentsPath());
            String frontJsPath = FileUtil.systemPath((String[])new String[]{path, componentInfo.getFrontFileName()});
            frontFile = FileUtils.getJsString((String)frontFile, (String)frontJsPath);
        }
        return frontFile;
    }

    public String getPreviewFrontFile(ComponentInfo componentInfo) throws IOException {
        String frontFile = "";
        if (HussarUtils.isNotEmpty((Object)componentInfo.getFrontFileName())) {
            String path = "";
            path = VfgModeTool.isRemote() ? componentInfo.getComponentIOPath(FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getComponentIOPath(), "component"})) : componentInfo.getComponentIOPath(this.pathStrategy.resourcePathService().getComponentIOPath());
            String frontJsPath = FileUtil.systemPath((String[])new String[]{path, componentInfo.getFrontFileName()});
            frontFile = FileUtils.getJsString((String)frontFile, (String)frontJsPath);
        }
        return frontFile;
    }

    public String getElementFile(ComponentInfo componentInfo) throws IOException {
        String path = componentInfo.getComponentIOPath(this.pathStrategy.resourcePathService().getComponentIOPath());
        String elementJsPath = FileUtil.systemPath((String[])new String[]{path, componentInfo.getElementFileName()});
        String elementFile = "";
        elementFile = FileUtils.getJsString((String)elementFile, (String)elementJsPath);
        return elementFile;
    }

    public List<String> getCustomFileName(ComponentInfo componentInfo) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        fileNameList.add("componentInfo.json");
        fileNameList.add(componentInfo.getCustomFileName());
        if (HussarUtils.isNotEmpty((Object)componentInfo.getCoverFileName())) {
            fileNameList.add(componentInfo.getCoverFileName());
        }
        return fileNameList;
    }

    public List<String> getExtendFileName(ComponentInfo componentInfo) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        fileNameList.add("componentInfo.json");
        if (HussarUtils.isNotEmpty((Object)componentInfo.getFrontFileName())) {
            fileNameList.add(componentInfo.getFrontFileName());
        }
        fileNameList.add(componentInfo.getBackendFileName());
        fileNameList.add(componentInfo.getElementFileName());
        return fileNameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentInfo getComponentInfo(MultipartFile file) throws IOException {
        ZipInputStream zis = new ZipInputStream(file.getInputStream(), ZipUtil.getFileCharset(file.getInputStream()));
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                String line;
                String fileName = zipEntry.getName();
                if (!"componentInfo.json".equals(fileName)) continue;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(zis));
                StringBuilder sb = new StringBuilder("");
                while ((line = bufferedReader.readLine()) != null) {
                    sb.append(line);
                }
                ComponentInfo componentInfo = (ComponentInfo)JSONObject.parseObject((String)sb.toString(), ComponentInfo.class);
                return componentInfo;
            }
        }
        catch (JSONException | IOException e) {
            logger.error("\u7ec4\u4ef6\u4fe1\u606f\u83b7\u53d6\u5931\u8d25", e);
        }
        finally {
            if (HussarUtils.isNotEmpty((Object)zis)) {
                zis.close();
            }
        }
        return null;
    }

    public void checkCustomInfo(ComponentInfo componentInfo, CheckResult<ComponentInfo> checkResult) throws IOException {
        CheckInfo lcdpCheck = new CheckInfo(CheckInfoEnum.LCDPVERSION.success());
        checkResult.addCheckInfos(lcdpCheck);
        CompatibleVersions lcdpVersions = componentInfo.getLcdpVersions();
        if (HussarUtils.isNotEmpty((Object)lcdpVersions)) {
            String lcdpVersion = this.lcdpVersionProperties.getLcdpVersion();
            if (!lcdpVersions.check(lcdpVersion)) {
                ComponentCheckInfoUtil.lcdpVersion(lcdpCheck, lcdpVersion, lcdpVersions, true);
                checkResult.setResult(-1);
            }
        } else {
            ComponentCheckInfoUtil.lcdpVersion(lcdpCheck, null, null, false);
            checkResult.setResult(-1);
        }
        CheckInfo dependenciesCheck = new CheckInfo(CheckInfoEnum.DEPENDENCIES.success());
        checkResult.addCheckInfos(dependenciesCheck);
        List<ComponentDependence> componentDependences = componentInfo.getDependencies();
        if (HussarUtils.isEmpty(componentDependences)) {
            return;
        }
        HashMap<String, String> componentVersions = new HashMap<String, String>();
        List<ComponentInfo> componentInfos = this.getComponentInfos(ComponentType.EXTENSION.getValue());
        for (ComponentInfo component : componentInfos) {
            componentVersions.put(component.getCode(), component.getVersion());
        }
        for (ComponentDependence componentDependence : componentInfo.getDependencies()) {
            if (HussarUtils.isEmpty((Object)componentDependence.getVersion())) continue;
            String localVersion = (String)componentVersions.get(componentDependence.getCode());
            if (HussarUtils.isEmpty((Object)localVersion)) {
                ComponentCheckInfoUtil.dependencies(dependenciesCheck, componentDependence.getName(), -2);
                checkResult.setResult(-1);
                continue;
            }
            if (localVersion.equals(componentDependence.getVersion())) continue;
            boolean flag = false;
            CompatibleVersions versions = componentDependence.getCompatibleVersions();
            if (HussarUtils.isNotEmpty((Object)versions)) {
                flag = versions.check(localVersion);
            }
            if (flag) continue;
            String name = componentDependence.getName();
            String msg = ComponentCheckInfoUtil.version(ComponentField.DEPENDENCIES.getLabel() + "\u4e2d\u7ec4\u4ef6" + name, "\u5df2\u5b58\u5728\u7684" + name + "\u7ec4\u4ef6\u7248\u672c\u53f7", "\u5f53\u524d\u5bfc\u5165\u7ec4\u4ef6\u5e94\u7528\u7684" + name + "\u7ec4\u4ef6\u7248\u672c\u53f7\u4e3a\uff1a" + componentDependence.getVersion() + "\uff0c\u517c\u5bb9", localVersion, versions);
            ComponentCheckInfoUtil.dependencies(dependenciesCheck, msg, 0);
            checkResult.setResult(0);
        }
    }

    public void checkExtensionInfo(ComponentInfo componentInfo, CheckResult<ComponentInfo> checkResult) throws IOException {
        CheckInfo lcdpCheck = new CheckInfo(CheckInfoEnum.LCDPVERSION.success());
        checkResult.addCheckInfos(lcdpCheck);
        CompatibleVersions lcdpVersions = componentInfo.getLcdpVersions();
        if (HussarUtils.isNotEmpty((Object)lcdpVersions)) {
            String lcdpVersion = this.lcdpVersionProperties.getLcdpVersion();
            if (!lcdpVersions.check(lcdpVersion)) {
                ComponentCheckInfoUtil.lcdpVersion(lcdpCheck, lcdpVersion, lcdpVersions, false);
                checkResult.setResult(-1);
            }
        } else {
            ComponentCheckInfoUtil.lcdpVersion(lcdpCheck, null, null, false);
            checkResult.setResult(-1);
        }
        CheckInfo codeCheck = new CheckInfo(CheckInfoEnum.CODEADD.success());
        checkResult.addCheckInfos(codeCheck);
        String code = componentInfo.getCode();
        if (HussarUtils.isBlank((CharSequence)code)) {
            ComponentCheckInfoUtil.code(codeCheck, ComponentField.CODE.getLabel(), -1);
            checkResult.setResult(-1);
            return;
        }
        String version = componentInfo.getVersion();
        if (HussarUtils.isEmpty((Object)version)) {
            ComponentCheckInfoUtil.code(codeCheck, ComponentField.VERSION.getLabel(), -1);
            checkResult.setResult(-1);
            return;
        }
        String localComponent = ClazzFactory.get((String)componentInfo.getCode());
        if (HussarUtils.isNotEmpty((Object)localComponent)) {
            String localVersion = null;
            List<ComponentInfo> componentInfos = this.getComponentInfos(componentInfo.getType());
            for (ComponentInfo localComponentInfo : componentInfos) {
                if (!localComponentInfo.getCode().equals(componentInfo.getCode())) continue;
                localVersion = localComponentInfo.getVersion();
                break;
            }
            if (HussarUtils.isNotEmpty(localVersion)) {
                boolean checkFlag = false;
                if (localVersion.equals(componentInfo.getVersion())) {
                    ComponentCheckInfoUtil.code(codeCheck, "", 1);
                    return;
                }
                CompatibleVersions compatibleVersions = componentInfo.getCompatibleVersions();
                if (HussarUtils.isNotEmpty((Object)compatibleVersions)) {
                    checkFlag = compatibleVersions.check(localVersion);
                }
                if (checkFlag) {
                    ComponentCheckInfoUtil.code(codeCheck, "", 1);
                } else {
                    String msg = ComponentCheckInfoUtil.version(ComponentField.COMPATIBLEVERSIONS.getLabel(), "\u5df2\u5b58\u5728\u7684\u7ec4\u4ef6\u7248\u672c\u53f7", "\u8be5\u7ec4\u4ef6\u7248\u672c\u53f7\u4e3a\uff1a" + componentInfo.getVersion() + "\uff0c\u517c\u5bb9", localVersion, compatibleVersions);
                    ComponentCheckInfoUtil.code(codeCheck, msg, 0);
                    checkResult.setResult(0);
                }
            } else {
                ComponentCheckInfoUtil.code(codeCheck, "", -2);
                checkResult.setResult(-1);
            }
        }
    }

    @Override
    public synchronized void addComponent(ComponentInfo componentInfo) throws IOException {
        List<ComponentInfo> componentInfos = this.getComponentInfos(componentInfo.getType());
        componentInfos.add(componentInfo);
        this.writeComponentInfos(componentInfos, componentInfo.getType());
        logger.info("\u5199\u5165\u7ec4\u4ef6" + componentInfo.getId());
    }

    public synchronized void delComponentInfoByCode(String code) throws IOException {
        String id = null;
        List<ComponentInfo> componentInfos = this.getComponentInfos(ComponentType.EXTENSION.getValue());
        Iterator<ComponentInfo> iterator = componentInfos.iterator();
        while (iterator.hasNext()) {
            ComponentInfo componentInfo = iterator.next();
            if (!code.equals(componentInfo.getCode())) continue;
            iterator.remove();
            id = componentInfo.getId();
            break;
        }
        if (HussarUtils.isBlank(id)) {
            return;
        }
        this.writeComponentInfos(componentInfos, ComponentType.EXTENSION.getValue());
        logger.info("\u5220\u9664\u7ec4\u4ef6" + id);
    }

    public synchronized void addAwaitComponentInfos(ComponentInfo componentInfo) throws IOException {
        Map<String, ComponentInfo> componentInfos = this.getAwaitComponentInfos();
        componentInfos.put(componentInfo.getId(), componentInfo);
        this.writeAwaitComponentInfos(componentInfos);
        logger.info("\u5199\u5165\u5f85\u5904\u7406" + componentInfo.getId());
    }

    public synchronized void delAwaitComponentInfo(String id) throws IOException {
        Map<String, ComponentInfo> awaitComponentInfos = this.getAwaitComponentInfos();
        awaitComponentInfos.remove(id);
        this.writeAwaitComponentInfos(awaitComponentInfos);
        logger.info("\u5220\u9664\u5f85\u5904\u7406\u4fe1\u606f" + id);
    }

    @Override
    public synchronized void writeComponentInfos(List<ComponentInfo> componentInfos, String type) throws IOException {
        if (VfgModeTool.isRemote()) {
            if (ComponentType.EXTENSION.getValue().equals(type)) {
                this.writeExtensionComponentInfos(componentInfos, type);
            } else {
                this.writeCustomComponentInfos(componentInfos, type);
            }
        } else {
            String path1 = this.pathStrategy.resourcePathService().getProjectAndComponentsPath();
            File file1 = new File(path1);
            if (!FileUtils.exists((File)file1)) {
                FileUtils.forceMkdir((File)file1);
            }
            String path2 = FileUtil.systemPath((String[])new String[]{path1, type + "ComponentInfos.json"});
            File file = new File(path2);
            FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(componentInfos), (String)"UTF-8", (boolean)false);
        }
        if (ComponentType.EXTENSION.getValue().equals(type)) {
            this.setComponentCache();
        }
    }

    public synchronized void writeExtensionComponentInfos(List<ComponentInfo> componentInfos, String type) throws IOException {
        String path1 = this.pathStrategy.resourcePathService().getComponentIOPath();
        File file1 = new File(path1);
        if (!file1.exists()) {
            org.apache.commons.io.FileUtils.forceMkdir((File)file1);
        }
        String path2 = FileUtil.systemPath((String[])new String[]{path1, type + "ComponentInfos.json"});
        File file = new File(path2);
        org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(componentInfos), (String)"UTF-8", (boolean)false);
    }

    public synchronized void writeCustomComponentInfos(List<ComponentInfo> componentInfos, String type) throws IOException {
        String path1 = this.pathStrategy.resourcePathService().getComponentIOPath();
        File file1 = new File(path1);
        if (!FileUtils.exists((File)file1)) {
            FileUtils.forceMkdir((File)file1);
        }
        String path2 = FileUtil.systemPath((String[])new String[]{path1, type + "ComponentInfos.json"});
        File file = new File(path2);
        org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(componentInfos), (String)"UTF-8", (boolean)false);
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u4fe1\u606f\uff1a%s", file.getName()), Collections.singletonList(file.getAbsolutePath()));
    }

    @Override
    public List<ComponentInfo> getComponentInfos(String type) throws IOException {
        if (VfgModeTool.isRemote()) {
            if (ComponentType.EXTENSION.getValue().equals(type)) {
                return this.getExtensionComponentInfos(type);
            }
            return this.getOtherComponentInfos(type);
        }
        List<ComponentInfo> componentInfos = new ArrayList<ComponentInfo>();
        String path1 = this.pathStrategy.resourcePathService().getProjectAndComponentsPath();
        File file1 = new File(path1);
        if (!file1.exists()) {
            return componentInfos;
        }
        String path2 = FileUtil.systemPath((String[])new String[]{path1, type + "ComponentInfos.json"});
        File file2 = new File(path2);
        if (!file2.exists()) {
            return componentInfos;
        }
        String jsonStr = FileUtils.readFileToString((File)file2, (String)"UTF-8");
        componentInfos = JSONArray.parseArray((String)jsonStr, ComponentInfo.class);
        return componentInfos;
    }

    public List<ComponentInfo> getExtensionComponentInfos(String type) throws IOException {
        List<ComponentInfo> componentInfos = new ArrayList<ComponentInfo>();
        String path1 = this.pathStrategy.resourcePathService().getComponentIOPath();
        File file1 = new File(path1);
        if (!file1.exists()) {
            return componentInfos;
        }
        String path2 = FileUtil.systemPath((String[])new String[]{path1, type + "ComponentInfos.json"});
        File file2 = new File(path2);
        if (!file2.exists()) {
            return componentInfos;
        }
        String jsonStr = org.apache.commons.io.FileUtils.readFileToString((File)file2, (String)"UTF-8");
        componentInfos = JSONArray.parseArray((String)jsonStr, ComponentInfo.class);
        return componentInfos;
    }

    public List<ComponentInfo> getOtherComponentInfos(String type) throws IOException {
        List<ComponentInfo> componentInfos = new ArrayList<ComponentInfo>();
        String path1 = this.pathStrategy.resourcePathService().getComponentIOPath();
        File file1 = new File(path1);
        if (!file1.exists()) {
            return componentInfos;
        }
        String path2 = FileUtil.systemPath((String[])new String[]{path1, type + "ComponentInfos.json"});
        File file2 = new File(path2);
        if (!file2.exists()) {
            return componentInfos;
        }
        String jsonStr = org.apache.commons.io.FileUtils.readFileToString((File)file2, (String)"UTF-8");
        componentInfos = JSONArray.parseArray((String)jsonStr, ComponentInfo.class);
        return componentInfos;
    }

    public List<ComponentInfo> getPreviewComponentInfos(String type) throws IOException {
        if (ComponentType.EXTENSION.getValue().equals(type)) {
            return this.getPreviewExtensionComponentInfos(type);
        }
        return this.getPreviewOtherComponentInfos(type);
    }

    public List<ComponentInfo> getPreviewExtensionComponentInfos(String type) throws IOException {
        List<ComponentInfo> componentInfos = new ArrayList<ComponentInfo>();
        String path = "";
        path = VfgModeTool.isRemote() ? FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getComponentIOPath(), "component"}) : this.pathStrategy.resourcePathService().getComponentIOPath();
        File file1 = new File(path);
        if (!file1.exists()) {
            return componentInfos;
        }
        String path2 = FileUtil.systemPath((String[])new String[]{path, type + "ComponentInfos.json"});
        File file2 = new File(path2);
        if (!file2.exists()) {
            return componentInfos;
        }
        String jsonStr = org.apache.commons.io.FileUtils.readFileToString((File)file2, (String)"UTF-8");
        componentInfos = JSONArray.parseArray((String)jsonStr, ComponentInfo.class);
        return componentInfos;
    }

    public List<ComponentInfo> getPreviewOtherComponentInfos(String type) throws IOException {
        List<ComponentInfo> componentInfos = new ArrayList<ComponentInfo>();
        String path = this.pathStrategy.resourcePathService().getProjectAndComponentsPath();
        File file1 = new File(path);
        if (!FileUtils.exists((File)file1)) {
            return componentInfos;
        }
        String path2 = FileUtil.systemPath((String[])new String[]{path, type + "ComponentInfos.json"});
        File file2 = new File(path2);
        if (!FileUtils.exists((File)file2)) {
            return componentInfos;
        }
        String jsonStr = FileUtils.readFileToString((File)file2, (String)"UTF-8");
        componentInfos = JSONArray.parseArray((String)jsonStr, ComponentInfo.class);
        return componentInfos;
    }

    private synchronized void writeAwaitComponentInfos(Map<String, ComponentInfo> awaitComponentInfos) throws IOException {
        String rootPath = this.pathStrategy.resourcePathService().getComponentIOPath();
        File rootFile = new File(rootPath);
        if (!rootFile.exists()) {
            org.apache.commons.io.FileUtils.forceMkdir((File)rootFile);
        }
        String path = FileUtil.systemPath((String[])new String[]{rootPath, "awaitComponentInfos.json"});
        File file = new File(path);
        org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(awaitComponentInfos), (String)"UTF-8", (boolean)false);
    }

    @Override
    public Map<String, ComponentInfo> getAwaitComponentInfos() throws IOException {
        Map<String, ComponentInfo> awaitComponentInfos = new HashMap<String, ComponentInfo>();
        String path2 = FileUtil.systemPath((String[])new String[]{this.pathStrategy.resourcePathService().getComponentIOPath(), "awaitComponentInfos.json"});
        File file2 = new File(path2);
        if (!file2.exists()) {
            return awaitComponentInfos;
        }
        String jsonStr = org.apache.commons.io.FileUtils.readFileToString((File)file2, (String)"UTF-8");
        try {
            awaitComponentInfos = (Map)JSONArray.parseObject((String)jsonStr, (TypeReference)new TypeReference<Map<String, ComponentInfo>>(){}, (Feature[])new Feature[0]);
        }
        catch (JSONException e) {
            logger.error("\u83b7\u53d6\u5f85\u5904\u7406\u7ec4\u4ef6\u5931\u8d25", (Throwable)e);
        }
        return awaitComponentInfos;
    }

    @Override
    public ComponentInfo getComponentById(String id) throws IOException {
        List<ComponentInfo> componentInfos = this.getComponentInfos(ComponentType.EXTENSION.getValue());
        for (ComponentInfo componentInfo : componentInfos) {
            if (!id.equals(componentInfo.getId())) continue;
            return componentInfo;
        }
        componentInfos = this.getComponentInfos(ComponentType.CUSTOM.getValue());
        for (ComponentInfo componentInfo : componentInfos) {
            if (!id.equals(componentInfo.getId())) continue;
            return componentInfo;
        }
        return null;
    }

    public ComponentInfo getComponentByCode(String code) throws IOException {
        List<ComponentInfo> componentInfos = this.getComponentInfos(ComponentType.EXTENSION.getValue());
        for (ComponentInfo componentInfo : componentInfos) {
            if (!code.equals(componentInfo.getCode())) continue;
            return componentInfo;
        }
        return null;
    }

    @Override
    public void delComponetFile(ComponentInfo componentInfo) throws IOException {
        if (!VfgModeTool.isRemote()) {
            String rootPath = componentInfo.getRootPath(this.pathStrategy.resourcePathService().getProjectAndComponentsPath());
            File thisFile = new File(rootPath);
            FileUtils.deleteQuietly((File)thisFile);
        } else if (ComponentType.CUSTOM.getValue().equals(componentInfo.getType())) {
            String rootPath = componentInfo.getRootPath(this.pathStrategy.resourcePathService().getProjectAndComponentsPath());
            File thisFile = new File(rootPath);
            FileUtils.deleteQuietly((File)thisFile);
            VfgModeTool.pushToRemote((String)String.format("\u5220\u9664\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u6587\u4ef6\uff1a%s", thisFile.getName()), Collections.singletonList(thisFile.getAbsolutePath()));
        } else {
            String rootPath = componentInfo.getComponentIOPath(this.pathStrategy.resourcePathService().getComponentIOPath());
            File thisFile = new File(rootPath);
            org.apache.commons.io.FileUtils.deleteQuietly((File)thisFile);
        }
    }

    public List<ComponentInfo> getComponentCache() throws IOException {
        List componentInfos = new ArrayList();
        componentInfos = SecurityUtil.isDev((String)"formdesign") != false ? (List)ComponentCacheUtil.get("componentCache", "all") : (List)HussarCacheUtil.get((String)"componentCache", (Object)"all");
        if (HussarUtils.isEmpty(componentInfos)) {
            return this.setComponentCache();
        }
        return componentInfos;
    }

    public List<ComponentInfo> getPreviewComponentCache() throws IOException {
        List componentInfos = new ArrayList();
        componentInfos = SecurityUtil.isDev((String)"formdesign") != false ? (List)ComponentCacheUtil.get("componentCache", "all") : (List)HussarCacheUtil.get((String)"componentCache", (Object)"all");
        if (HussarUtils.isEmpty(componentInfos)) {
            return this.setPreviewComponentCache();
        }
        return componentInfos;
    }

    public List<ComponentInfo> setComponentCache() throws IOException {
        List<ComponentInfo> componentInfos = this.getComponentInfos(ComponentType.EXTENSION.getValue());
        if (LicenseInfo.getLicenseType() % 3 == 0) {
            ComponentCacheUtil.put("componentCache", "all", componentInfos);
        } else {
            HussarCacheUtil.put((String)"componentCache", (Object)"all", componentInfos);
        }
        return componentInfos;
    }

    public List<ComponentInfo> setPreviewComponentCache() throws IOException {
        List<ComponentInfo> componentInfos = this.getPreviewComponentInfos(ComponentType.EXTENSION.getValue());
        if (LicenseInfo.getLicenseType() % 3 == 0) {
            ComponentCacheUtil.put("componentCache", "all", componentInfos);
        } else {
            HussarCacheUtil.put((String)"componentCache", (Object)"all", componentInfos);
        }
        return componentInfos;
    }
}

