/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.component.controller;

import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.component.model.CheckResult;
import com.jxdinfo.hussar.formdesign.component.model.ComponentExportInfo;
import com.jxdinfo.hussar.formdesign.component.model.ComponentInfo;
import com.jxdinfo.hussar.formdesign.component.service.ComponentService;
import com.jxdinfo.hussar.formdesign.component.service.FormDesignRemoteComponentService;
import com.jxdinfo.hussar.formdesign.external.require.engine.utils.LrEngineUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"importComponent/component"})
public class ComponentController {
    @Autowired
    private ComponentService componentService;
    @Autowired(required=false)
    private FormDesignRemoteComponentService formDesignRemoteComponentService;

    @PostMapping(value={"/check"})
    public ApiResponse<CheckResult<ComponentInfo>> check(@RequestBody MultipartFile file) throws Exception {
        String id = LrEngineUtil.nextId() + "";
        if (ToolUtil.isNotEmpty((Object)AppContextUtil.getUnionPrefix()) && !Objects.equals(AppContextUtil.getUnionPrefix(), "hussar-web")) {
            this.formDesignRemoteComponentService.check(file, id);
        }
        return this.componentService.check(file, id);
    }

    @PostMapping(value={"/inducts"})
    public ApiResponse<Map<String, Object>> inducts(@RequestBody ComponentInfo componentInfo) throws Exception {
        if (ToolUtil.isNotEmpty((Object)AppContextUtil.getUnionPrefix()) && !Objects.equals(AppContextUtil.getUnionPrefix(), "hussar-web")) {
            this.formDesignRemoteComponentService.inducts(componentInfo);
        }
        return this.componentService.inducts(componentInfo);
    }

    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, @RequestBody ComponentExportInfo componentExportInfo) throws Exception {
        this.componentService.export(response, componentExportInfo);
    }

    @GetMapping(value={"/getAllFrontFile"})
    public ApiResponse<List<Map<String, Object>>> getAllFrontFile(String pageType) throws IOException {
        return this.componentService.getAllFrontFile(pageType);
    }

    @GetMapping(value={"/getFrontFile"})
    public ApiResponse<String> getFrontFileByCode(String code) throws IOException {
        return this.componentService.getFrontFileByCode(code);
    }

    @PostMapping(value={"/getAllElementFile"})
    public ApiResponse<List<Map<String, Object>>> getAllElementFile() throws IOException {
        return this.componentService.getAllElementFile();
    }

    @PostMapping(value={"/getAll"})
    public ApiResponse<List<ComponentInfo>> getAllComponentInfo(@RequestBody String type) throws IOException {
        List<ComponentInfo> componentInfos = this.componentService.getComponentInfos(type);
        return ApiResponse.success(componentInfos);
    }

    @PostMapping(value={"/cancel"})
    public ApiResponse<Boolean> delAwaitComponent(@RequestBody String id) throws IOException {
        return this.componentService.delAwaitComponent(id) ? ApiResponse.success() : ApiResponse.fail((String)"");
    }
}

