/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.onlineimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.applicationmix.service.IHussarBaseAppMixBoService;
import com.jxdinfo.hussar.applicationmix.vo.MixAppInfoVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionUseSharedStorage;
import com.jxdinfo.hussar.formdesign.common.constant.ExportResourceConstant;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.AdjustWorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.model.WorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.ModelCopyDto;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.SaveInfoDto;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.WorkflowDumpDto;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.WorkflowService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.onlineimpl.BaseFileServiceOnLineImpl;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CategoryEnum;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.file.ZipUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.vo.ProcessDefinitionVo;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.godaxe.model.GodAxeModelService;
import com.jxdinfo.hussar.workflow.upgrade.StandardExtendPropertiesApiService;
import com.jxdinfo.hussar.workflow.upgrade.StandardFormAuthApiService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="WorkflowServiceOnLineImpl")
@Conditional(value={ConditionUseSharedStorage.class})
public class WorkflowServiceOnLineImpl
extends BaseFileServiceOnLineImpl<WorkflowInfo>
implements WorkflowService {
    @Resource
    private GodAxeModelService godAxeModelService;
    @Resource
    private PathStrategyService pathStrategy;
    @Resource
    private StandardFormAuthApiService formAuthApiService;
    @Resource
    private StandardExtendPropertiesApiService extendPropertiesApiService;
    @Resource
    private HussarConfig hussarConfig;
    public static String SYS_ACT_EXTENDS = "sysActExtends.json";
    @Autowired(required=false)
    private IHussarBaseAppMixBoService hussarBaseAppMixBoService;

    @Override
    public void deleteBpmFile(String identity, String organId, boolean forced) {
        ApiResponse apiResponse = this.godAxeModelService.deleteProcess(identity, organId, forced);
        if (!apiResponse.isSuccess()) {
            throw new HussarException(Integer.valueOf(apiResponse.getCode()), apiResponse.getMsg());
        }
    }

    @Override
    public void createWorkflow(WorkflowInfo workflowInfo) throws LcdpException {
        String filePath;
        String parentPath = "";
        if (!com.jxdinfo.hussar.formdesign.common.util.ToolUtil.isEmpty((Object)workflowInfo.getParentId()) && !"#".equals(workflowInfo.getParentId())) {
            parentPath = this.getDataPath(workflowInfo.getParentId());
        }
        if (Boolean.TRUE.equals(this.storageService.existsByPath(filePath = this.relativeToAbsolute(workflowInfo.geteName() + FileUtil.transFileSuffix((String)workflowInfo.getType()), parentPath)).getData())) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, filePath);
        }
        String metaFilePath = filePath + ".meta";
        if (Boolean.TRUE.equals(this.storageService.existsByPath(metaFilePath).getData())) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, metaFilePath);
        }
        ArrayList<WorkFlow> workFlowList = new ArrayList<WorkFlow>();
        workFlowList.add(this.dealData(workflowInfo));
        this.godAxeModelService.saveFileOnly(workFlowList);
        this.write(filePath, workflowInfo);
    }

    @Override
    public void updateWorkFlowFile(WorkflowInfo workflowInfo) throws IOException, LcdpException {
        JSONObject object = JSON.parseObject((String)workflowInfo.getData());
        object.getJSONObject("props").put("name", (Object)workflowInfo.geteName());
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getRemotePath();
        String filePath = this.getDataPath(workflowInfo.getId());
        String metaFilePath = this.addMeta(filePath);
        if (!Boolean.TRUE.equals(this.storageService.existsByPath(filePath).getData())) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, workflowInfo.getId());
        }
        if (!Boolean.TRUE.equals(this.storageService.existsByPath(metaFilePath).getData())) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, workflowInfo.getId());
        }
        this.godAxeModelService.saveWorkflow(this.dealData(workflowInfo), BaseSecurityUtil.getUser().getStringTenantId(), false, false);
        boolean needRename = this.checkRename(workflowInfo);
        this.write(filePath, workflowInfo);
        if (needRename) {
            this.renameTwoWorkflowFile(workflowInfo, filePath, metaFilePath, rootPath);
        }
    }

    @Override
    public FormDesignResponse<Object> adjustProcess(AdjustWorkflowInfo workflowInfo) throws IOException, LcdpException {
        workflowInfo.setVersion(this.get(workflowInfo.getId()) != null ? ((WorkflowInfo)((Object)this.get(workflowInfo.getId()))).getVersion() : null);
        WorkFlow oldWorkFlow = this.godAxeModelService.getLastFileByProcessKey(workflowInfo.getIdentity(), BaseSecurityUtil.getUser().getStringTenantId());
        if (!workflowInfo.getOverride()) {
            // empty if block
        }
        WorkFlow workFlow = this.dealData(workflowInfo);
        JSONObject object = JSON.parseObject((String)workflowInfo.getData());
        object.getJSONObject("props").put("name", (Object)workflowInfo.geteName());
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getRemotePath();
        String filePath = this.getDataPath(workflowInfo.getId());
        String metaFilePath = this.addMeta(filePath);
        if (!Boolean.TRUE.equals(this.storageService.existsByPath(filePath).getData())) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, workflowInfo.getId());
        }
        if (!Boolean.TRUE.equals(this.storageService.existsByPath(metaFilePath).getData())) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, workflowInfo.getId());
        }
        boolean needRename = this.checkRename(workflowInfo);
        String data = workflowInfo.getData();
        workflowInfo.setVersion(oldWorkFlow.getVersion());
        this.write(filePath, workflowInfo);
        workflowInfo.setData(data);
        if (needRename) {
            this.renameTwoWorkflowFile(workflowInfo, filePath, metaFilePath, rootPath);
        }
        ApiResponse obj = this.godAxeModelService.updateProcess(this.dealData(workflowInfo), BaseSecurityUtil.getUser().getStringTenantId());
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        if (!obj.isSuccess()) {
            speedCodeResponse.setErrorMsg("\u8986\u76d6\u53d1\u5e03\u9519\u8bef\uff1a" + obj.getMsg());
            speedCodeResponse.setErrorCode(14160 == obj.getCode() ? obj.getCode() : 500);
            return speedCodeResponse;
        }
        if (obj.getData() instanceof Map && "14160".equals(((Map)obj.getData()).get("code"))) {
            speedCodeResponse.setErrorMsg("\u8986\u76d6\u53d1\u5e03\u9519\u8bef\uff1a" + ((Map)obj.getData()).get("msg"));
            speedCodeResponse.setErrorCode(14160);
            return speedCodeResponse;
        }
        return new FormDesignResponse();
    }

    @Override
    public void moveWorkFlow(String id, String parentId, String newName, String newDesc, String category) throws LcdpException, IOException {
        String oldJsonPath = this.getDataPath(id);
        String oldMetaPath = this.getMetaPath(id);
        String newParentPath = this.getDataPath(parentId);
        String oldJsonName = this.removeMeta(this.getFileName(id));
        boolean moveResource = true;
        String newPath = newParentPath + File.separator + oldJsonName;
        JSONObject metaFileContentJson = JSON.parseObject((String)new String((byte[])this.storageService.downloadByUuid(CategoryEnum.META, id).getData(), StandardCharsets.UTF_8));
        String eName = metaFileContentJson.getString("eName");
        if (eName != null && !"".equals(eName)) {
            newPath = newParentPath + File.separator + eName;
        }
        moveResource = (Boolean)this.storageService.rename(oldJsonPath, newPath, false).getData();
        moveResource = (Boolean)this.storageService.rename(oldMetaPath, newPath + ".meta", false).getData();
        if (!moveResource) {
            throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, oldMetaPath);
        }
        metaFileContentJson.put("parentId", (Object)parentId);
        if (newName != null && !"".equals(newName)) {
            metaFileContentJson.put("name", (Object)newName);
        }
        if (eName != null && !"".equals(eName)) {
            metaFileContentJson.put("eName", (Object)eName);
        }
        metaFileContentJson.put("category", (Object)category);
        try {
            this.storageService.uploadByUuid(CategoryEnum.META, id, newPath + ".meta", new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)metaFileContentJson).getBytes(StandardCharsets.UTF_8), false);
        }
        catch (JsonProcessingException e) {
            throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, newPath + ".meta");
        }
    }

    @Override
    public List<String> copyWorkFlow(List<ModelCopyDto> list) throws LcdpException, IOException {
        ArrayList<String> processKeys = new ArrayList<String>();
        ArrayList<WorkFlow> workFlowList = new ArrayList<WorkFlow>();
        for (ModelCopyDto modelCopyDto : list) {
            String oldProcessKey;
            byte[] jsonFileContent;
            String id = modelCopyDto.getId();
            String parentId = modelCopyDto.getParentId();
            String newId = modelCopyDto.getNewId();
            String newName = modelCopyDto.getNewName();
            String category = modelCopyDto.getCategory();
            String newDesc = modelCopyDto.getNewDesc();
            String oldMetaPath = this.getMetaPath(modelCopyDto.getId());
            String newParentPath = this.getDataPath(parentId);
            String oldJsonName = this.removeMeta(this.getFileName(modelCopyDto.getId()));
            boolean copyResource = true;
            String newPath = newParentPath + File.separator + oldJsonName;
            if (newDesc != null && !"".equals(newDesc)) {
                newPath = newParentPath + File.separator + newDesc;
            }
            if ((jsonFileContent = (byte[])this.storageService.downloadByUuid(CategoryEnum.JSON, id).getData()) == null) {
                throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, newPath);
            }
            copyResource = (Boolean)this.storageService.uploadByUuid(CategoryEnum.JSON, newId, newPath, jsonFileContent, false).getData();
            byte[] metaFileContent = (byte[])this.storageService.downloadByUuid(CategoryEnum.META, id).getData();
            if (metaFileContent == null) {
                throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, newPath);
            }
            boolean copyMeta = (Boolean)this.storageService.uploadByUuid(CategoryEnum.META, newId, newPath + ".meta", metaFileContent, false).getData();
            copyResource = copyResource && copyMeta;
            if (!copyResource) {
                throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, oldMetaPath);
            }
            JSONObject metaFileContentJson = JSON.parseObject((String)new String((byte[])this.storageService.downloadByUuid(CategoryEnum.META, newId).getData(), StandardCharsets.UTF_8));
            String processKey = oldProcessKey = metaFileContentJson.getString("identity");
            metaFileContentJson.put("parentId", (Object)parentId);
            metaFileContentJson.put("id", (Object)newId);
            if (newName != null && !"".equals(newName)) {
                metaFileContentJson.put("name", (Object)newName);
            }
            if (newDesc != null && !"".equals(newDesc)) {
                metaFileContentJson.put("eName", (Object)newDesc);
                metaFileContentJson.put("identity", (Object)newDesc);
                processKey = newDesc;
            }
            if (category != null && !"".equals(category)) {
                metaFileContentJson.put("category", (Object)category);
            }
            metaFileContentJson.put("version", (Object)"0");
            if (!oldProcessKey.equals(processKey)) {
                this.godAxeModelService.updateWorkflowProcessKey(processKey, oldProcessKey);
            }
            JSONObject wfdFileContentJson = JSON.parseObject((String)new String((byte[])this.storageService.downloadByUuid(CategoryEnum.JSON, newId).getData(), StandardCharsets.UTF_8));
            JSONObject props = (JSONObject)wfdFileContentJson.get((Object)"props");
            if (newDesc != null && !"".equals(newDesc)) {
                props.put("identity", (Object)newDesc);
            }
            WorkflowInfo workflowInfo = (WorkflowInfo)((Object)this.readFileToObject(oldMetaPath));
            WorkFlow workFlow = this.dealData(workflowInfo);
            workFlow.setIdentity(processKey);
            workFlowList.add(workFlow);
            try {
                this.storageService.uploadByUuid(CategoryEnum.META, newId, newPath + ".meta", new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)metaFileContentJson).getBytes(StandardCharsets.UTF_8), false);
                this.storageService.uploadByUuid(CategoryEnum.JSON, newId, newPath, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)wfdFileContentJson).getBytes(StandardCharsets.UTF_8), false);
            }
            catch (JsonProcessingException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, newPath + ".meta");
            }
            processKeys.add(metaFileContentJson.getString("identity"));
        }
        this.godAxeModelService.saveFileOnly(workFlowList);
        return processKeys;
    }

    @Override
    public List<String> publishWorkflowOnOrgan(List<ModelCopyDto> list) throws LcdpException, IOException {
        ArrayList<String> processKeys = new ArrayList<String>();
        ArrayList<WorkFlow> workFlowList = new ArrayList<WorkFlow>();
        for (ModelCopyDto modelCopyDto : list) {
            String oldProcessKey;
            byte[] jsonFileContent;
            String id = modelCopyDto.getId();
            String parentId = modelCopyDto.getParentId();
            String newId = modelCopyDto.getNewId();
            String newName = modelCopyDto.getNewName();
            String category = modelCopyDto.getCategory();
            String newDesc = modelCopyDto.getNewDesc();
            String eName = modelCopyDto.geteName();
            String oldMetaPath = this.getMetaPath(modelCopyDto.getId());
            String newParentPath = this.getDataPath(parentId);
            String oldJsonName = this.removeMeta(this.getFileName(modelCopyDto.getId()));
            boolean copyResource = true;
            String newPath = newParentPath + File.separator + oldJsonName;
            if (newDesc != null && !"".equals(newDesc)) {
                newPath = newParentPath + File.separator + newDesc;
            }
            if ((jsonFileContent = (byte[])this.storageService.downloadByUuid(CategoryEnum.JSON, id).getData()) == null) {
                throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, newPath);
            }
            copyResource = (Boolean)this.storageService.uploadByUuid(CategoryEnum.JSON, newId, newPath, jsonFileContent, false).getData();
            byte[] metaFileContent = (byte[])this.storageService.downloadByUuid(CategoryEnum.META, id).getData();
            if (metaFileContent == null) {
                throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, newPath);
            }
            boolean copyMeta = (Boolean)this.storageService.uploadByUuid(CategoryEnum.META, newId, newPath + ".meta", metaFileContent, false).getData();
            copyResource = copyResource && copyMeta;
            if (!copyResource) {
                throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, oldMetaPath);
            }
            JSONObject metaFileContentJson = JSON.parseObject((String)new String((byte[])this.storageService.downloadByUuid(CategoryEnum.META, newId).getData(), StandardCharsets.UTF_8));
            String processKey = oldProcessKey = metaFileContentJson.getString("identity");
            metaFileContentJson.put("parentId", (Object)parentId);
            metaFileContentJson.put("id", (Object)newId);
            if (newName != null && !"".equals(newName)) {
                metaFileContentJson.put("name", (Object)newName);
            }
            if (newDesc != null && !"".equals(newDesc)) {
                metaFileContentJson.put("identity", (Object)newDesc);
                processKey = newDesc;
            }
            if (eName != null && !"".equals(eName)) {
                metaFileContentJson.put("eName", (Object)eName);
            }
            if (category != null && !"".equals(category)) {
                metaFileContentJson.put("category", (Object)category);
            }
            metaFileContentJson.put("version", (Object)"0");
            if (!oldProcessKey.equals(processKey)) {
                throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, newPath + ".meta");
            }
            JSONObject wfdFileContentJson = JSON.parseObject((String)new String((byte[])this.storageService.downloadByUuid(CategoryEnum.JSON, newId).getData(), StandardCharsets.UTF_8));
            JSONObject props = (JSONObject)wfdFileContentJson.get((Object)"props");
            if (newDesc != null && !"".equals(newDesc)) {
                props.put("identity", (Object)newDesc);
            }
            WorkflowInfo workflowInfo = (WorkflowInfo)((Object)this.readFileToObject(oldMetaPath));
            WorkFlow workFlow = this.dealData(workflowInfo);
            workFlow.setIdentity(processKey);
            workFlowList.add(workFlow);
            try {
                this.storageService.uploadByUuid(CategoryEnum.META, newId, newPath + ".meta", new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)metaFileContentJson).getBytes(StandardCharsets.UTF_8), false);
                this.storageService.uploadByUuid(CategoryEnum.JSON, newId, newPath, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)wfdFileContentJson).getBytes(StandardCharsets.UTF_8), false);
            }
            catch (JsonProcessingException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, newPath + ".meta");
            }
            processKeys.add(metaFileContentJson.getString("identity"));
        }
        return processKeys;
    }

    @Override
    public WorkFlow queryFlowMeta(String processKey, String version) throws IOException, LcdpException {
        Integer ver = null;
        if (HussarUtils.isNotEmpty((Object)version)) {
            ver = Integer.valueOf(version);
        }
        return this.godAxeModelService.getFileByProcessKeyAndVersion(processKey, ver);
    }

    @Override
    public List<ProcessDefinitionVo> queryFlowVersion(String processKey) throws IOException, LcdpException {
        return this.godAxeModelService.queryFlowVersion(processKey);
    }

    @Override
    public ApiResponse<?> checkAndSaveWorkFlowDataAndMeta(SaveInfoDto saveInfoDto) throws IOException, LcdpException {
        WorkflowInfo workFlowInfo = saveInfoDto.getWorkflowInfo();
        WorkFlow workFlow = this.dealData(workFlowInfo);
        String saveType = saveInfoDto.getSaveType();
        return this.godAxeModelService.saveWorkflowMetaAndData(workFlow, saveType);
    }

    @Override
    public ApiResponse<String> setMainVersion(String processKey, String processVersion) throws IOException, LcdpException {
        this.godAxeModelService.setMainVersion(processKey, processVersion, null);
        return new ApiResponse();
    }

    @Override
    public ApiResponse<String> queryNextVersion(String processKey) {
        return this.godAxeModelService.queryNextVersion(processKey);
    }

    private boolean checkRename(WorkflowInfo workflowInfo) throws LcdpException, IOException {
        String parentPath;
        String path;
        String oldFileName;
        boolean needRename = false;
        String newFileName = workflowInfo.geteName();
        if (!newFileName.equals(oldFileName = (path = this.getDataPath(workflowInfo.getId())).replace(parentPath = this.getDataPath(workflowInfo.getParentId()), "").replace("\\", "").replace("/", ""))) {
            needRename = true;
        }
        return needRename;
    }

    private void renameTwoWorkflowFile(WorkflowInfo workflowInfo, String filePath, String metaFilePath, String rootPath) throws LcdpException, IOException {
        String newFilePath;
        String parentPath = "";
        if (!com.jxdinfo.hussar.formdesign.common.util.ToolUtil.isEmpty((Object)workflowInfo.getParentId()) && !"#".equals(workflowInfo.getParentId())) {
            parentPath = this.getDataPath(workflowInfo.getParentId());
        }
        if (Boolean.TRUE.equals(this.storageService.existsByPath(newFilePath = FileUtil.posixPath((String[])new String[]{parentPath, workflowInfo.geteName() + FileUtil.transFileSuffix((String)workflowInfo.getType())})).getData())) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, newFilePath);
        }
        String newMetaFilePath = newFilePath + ".meta";
        if (Boolean.TRUE.equals(this.storageService.existsByPath(newMetaFilePath).getData())) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, newMetaFilePath);
        }
        this.storageService.rename(filePath, newFilePath, false);
        this.storageService.rename(metaFilePath, newMetaFilePath, false);
    }

    private WorkFlow dealData(WorkflowInfo workflowService) {
        WorkFlow workFlow = new WorkFlow();
        workFlow.setId(workflowService.getId());
        workFlow.setData(workflowService.getData());
        workFlow.setDesc(workflowService.getDesc());
        workFlow.setName(workflowService.getName());
        workFlow.setType(workflowService.getType());
        workFlow.setModelId(workflowService.getModelId());
        workFlow.setIdentity(workflowService.getIdentity());
        workFlow.setProcDefId(workflowService.getProcDefId());
        workFlow.setVersion(workflowService.getVersion());
        workFlow.setCategory(AppContextUtil.getServiceName());
        workFlow.setAppId(workflowService.getAppId());
        workFlow.setAppName(workflowService.getAppName());
        workFlow.setWorkflowStyle(workflowService.getWorkflowStyle());
        workFlow.setProcessTag(workflowService.getProcessTag());
        workFlow.setProcessTagName(workflowService.getProcessTagName());
        if (workflowService instanceof AdjustWorkflowInfo) {
            workFlow.setForcePublish(((AdjustWorkflowInfo)workflowService).getForcePublish());
        }
        if (HussarUtils.isNotEmpty((Object)workflowService.getAppId()) && this.hussarBaseAppMixBoService != null) {
            if (AppContextUtil.isExtension()) {
                workflowService.setAppId(AppContextUtil.getAppId());
                workFlow.setAppId(workflowService.getAppId());
            }
            MixAppInfoVo mixAppInfoVo = this.hussarBaseAppMixBoService.getMixAppInfo(Long.valueOf(workflowService.getAppId()));
            if (AppContextUtil.isExtension() && HussarUtils.isNotEmpty((Object)mixAppInfoVo.getAppEnglishName()) && mixAppInfoVo.getAppEnglishName().endsWith("_extension")) {
                workFlow.setAppCode(mixAppInfoVo.getAppEnglishName().substring(0, mixAppInfoVo.getAppEnglishName().lastIndexOf("_")));
            } else {
                workFlow.setAppCode(mixAppInfoVo.getAppEnglishName());
            }
        }
        return workFlow;
    }

    @Override
    public FormDesignResponse<Map> checkProcessKey(List<String> processKeys) {
        List workFlow = this.godAxeModelService.getFilesByProcessKeys(processKeys);
        HashMap<String, String> map = new HashMap<String, String>();
        if (HussarUtils.isNotEmpty((Object)workFlow)) {
            for (WorkFlow flow : workFlow) {
                if (!processKeys.contains(flow.getIdentity())) continue;
                map.put(flow.getIdentity(), "\u6d41\u7a0b\u6807\u8bc6\u5df2\u5b58\u5728");
            }
            return FormDesignResponse.fail(map, (String)"");
        }
        return new FormDesignResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportProcess(WorkflowDumpDto workflowDumpDto, HttpServletResponse response) throws Exception {
        File file = null;
        String fileId = workflowDumpDto.getFileId();
        String tenantCode = workflowDumpDto.getTenantCode();
        String name = workflowDumpDto.getName();
        String exportPath = this.getExportPath(fileId);
        String environmentPath = "offline";
        HashMap<String, String> metaMap = new HashMap<String, String>();
        metaMap.put("processKey", workflowDumpDto.getProcessKey());
        String zipPath = exportPath + File.separator + environmentPath + File.separator + tenantCode + "_" + name + "_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMddHHmmss") + ExportResourceConstant._HUSSAR;
        ArrayList<File> files = new ArrayList<File>();
        File zip = new File(zipPath);
        File zipParent = zip.getParentFile();
        if (!zipParent.exists()) {
            zipParent.mkdirs();
        }
        try {
            byte[] meta;
            file = Files.createTempDirectory("processExport" + fileId, new FileAttribute[0]).toFile();
            String processKey = workflowDumpDto.getProcessKey();
            Integer version = workflowDumpDto.getVersion();
            File workflow = new File(file.getAbsolutePath() + File.separator + ExportResourceConstant.WORKFLOW);
            try {
                FileUtils.forceMkdir((File)workflow);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            List actFormAuthList = new ArrayList();
            List extendProperties = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)processKey) && HussarUtils.isNotEmpty((Object)version)) {
                BpmResponseResult extendPropertiesListResult;
                JSONArray extendPropertiesResult;
                BpmResponseResult actFormAuthListResult = this.formAuthApiService.actFormAuthExportData(processKey, version);
                JSONArray actFormAuthResult = actFormAuthListResult.getResult();
                if (actFormAuthResult.size() > 0) {
                    actFormAuthList = JSON.parseArray((String)actFormAuthResult.getJSONArray(0).toJSONString(), SysActFormAuth.class);
                }
                if ((extendPropertiesResult = (extendPropertiesListResult = this.extendPropertiesApiService.actExtendPropertiesExportData(processKey, version)).getResult()).size() > 0) {
                    extendProperties = JSON.parseArray((String)extendPropertiesResult.getJSONArray(0).toJSONString(), SysActExtendProperties.class);
                }
            } else {
                throw new Exception("\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            }
            if (HussarUtils.isNotEmpty(actFormAuthList)) {
                meta = SerializeUtils.serialize(actFormAuthList);
                String formAuth = workflow + File.separator + ExportResourceConstant.SYS_ACT_FORMAUTHS;
                File formAuthFile = new File(formAuth);
                FileUtils.writeByteArrayToFile((File)formAuthFile, (byte[])meta);
                files.add(formAuthFile);
            }
            if (HussarUtils.isNotEmpty(extendProperties)) {
                meta = SerializeUtils.serialize(extendProperties);
                String actExtend = workflow + File.separator + SYS_ACT_EXTENDS;
                File actExtendFile = new File(actExtend);
                FileUtils.writeByteArrayToFile((File)actExtendFile, (byte[])meta);
                files.add(actExtendFile);
            }
            String wfd = this.readLocalWfd(fileId);
            byte[] myByte = wfd.getBytes("UTF-8");
            String wfdPath = file.getAbsolutePath() + File.separator + ExportResourceConstant.PROJECT_STORE + File.separator + workflowDumpDto.getName();
            File wfdPathFile = new File(wfdPath);
            FileUtils.writeByteArrayToFile((File)wfdPathFile, (byte[])myByte);
            files.add(wfdPathFile);
            String meta2 = this.readLocalMeta(fileId);
            byte[] metaByte = meta2.getBytes("UTF-8");
            String metaPath = file.getAbsolutePath() + File.separator + ExportResourceConstant.PROJECT_STORE + File.separator + workflowDumpDto.getName() + ".meta";
            File metaPathFile = new File(metaPath);
            FileUtils.writeByteArrayToFile((File)metaPathFile, (byte[])metaByte);
            files.add(metaPathFile);
            String p = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath() + File.separator + workflowDumpDto.getModelName();
            byte[] pathByte = p.getBytes("UTF-8");
            String Filepath = workflow + File.separator + "path";
            File FilepathFile = new File(Filepath);
            FileUtils.writeByteArrayToFile((File)FilepathFile, (byte[])pathByte);
            files.add(FilepathFile);
            byte[] metaJson = SerializeUtils.serialize(metaMap);
            String metaJsonPath = workflow + File.separator + ExportResourceConstant.META_JSON;
            File metaJsonPathFile = new File(metaJsonPath);
            FileUtils.writeByteArrayToFile((File)metaJsonPathFile, (byte[])metaJson);
            files.add(metaJsonPathFile);
            String newFileName = URLEncoder.encode(tenantCode + "_" + name + "_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMddHHmmss") + ExportResourceConstant._HUSSAR, "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + newFileName);
            response.setContentType("application/octet-stream");
            response.setCharacterEncoding("UTF-8");
            FileOutputStream fous = new FileOutputStream(zip);
            ZipOutputStream zipOut = new ZipOutputStream(fous);
            WorkflowServiceOnLineImpl.zipFile(files, zipOut);
            zipOut.close();
            fous.close();
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(zipPath));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ((OutputStream)toClient).write(buffer);
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (file != null && file.exists()) {
                try {
                    org.apache.commons.io.FileUtils.forceDelete((File)file);
                    org.apache.commons.io.FileUtils.forceDelete((File)zip);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void zipFile(List files, ZipOutputStream outputStream) {
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            File file = (File)files.get(i);
            WorkflowServiceOnLineImpl.zipFile(file, outputStream);
        }
    }

    public static void zipFile(File inputFile, ZipOutputStream ouputStream) {
        block7: {
            try {
                if (!inputFile.exists()) break block7;
                if (inputFile.isFile()) {
                    int nNumber;
                    FileInputStream IN = new FileInputStream(inputFile);
                    BufferedInputStream bins = new BufferedInputStream(IN, 512);
                    ZipEntry entry = new ZipEntry(inputFile.getName());
                    ouputStream.putNextEntry(entry);
                    byte[] buffer = new byte[512];
                    while ((nNumber = bins.read(buffer)) != -1) {
                        ouputStream.write(buffer, 0, nNumber);
                    }
                    bins.close();
                    IN.close();
                    break block7;
                }
                try {
                    File[] files = inputFile.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        WorkflowServiceOnLineImpl.zipFile(files[i], ouputStream);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ApiResponse<Object> importProcess(MultipartFile file, String fileId, String processKey) {
        HashMap<String, Object> returnMap;
        block5: {
            File temp = null;
            returnMap = new HashMap<String, Object>();
            try {
                InputStream inputStream = file.getInputStream();
                temp = Files.createTempDirectory("processImport" + fileId, new FileAttribute[0]).toFile();
                File tempFile = new File(temp.getAbsolutePath() + File.separator + fileId + ".zip");
                org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
                ZipUtil.unzip((String)tempFile.getAbsolutePath(), (String)(temp.getAbsolutePath() + File.separator));
                this.importProcessToOffline(fileId, temp, returnMap, processKey);
            }
            catch (Exception e) {
                returnMap.put("status", false);
                returnMap.put("msg", e.toString());
                if (!ToolUtil.isNotEmpty((Object)temp) || !temp.exists()) break block5;
                try {
                    org.apache.commons.io.FileUtils.forceDelete((File)temp);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (!((Boolean)returnMap.get("status")).booleanValue()) {
            return ApiResponse.fail((String)returnMap.get("msg").toString());
        }
        return ApiResponse.success((String)"\u5bfc\u5165\u6210\u529f");
    }

    @Override
    public ApiResponse<?> checkForStandardWorkflow(WorkflowInfo workflowInfo) {
        WorkFlow workFlow = this.dealData(workflowInfo);
        return this.godAxeModelService.checkForStandardWorkflow(workFlow);
    }

    private void importProcessToOffline(String fileId, File temp, Map<String, Object> returnMap, String processKey) throws Exception {
        File axe = new File(temp.getAbsolutePath() + File.separator + ExportResourceConstant.PROJECT_STORE);
        this.importWorkFlow(temp, fileId, processKey);
        returnMap.put("status", true);
    }

    private void importWorkFlow(File temp, String fileId, String processKey) throws IOException, LcdpException, ClassNotFoundException {
        String exportProcessKey;
        File workflow = new File(temp.getAbsolutePath());
        File projectStore = new File(temp.getAbsolutePath());
        File projectStoreFile = org.apache.commons.io.FileUtils.getFile((File)projectStore, (String[])new String[0]);
        File[] files = projectStoreFile.listFiles();
        try {
            for (int i = 0; i < files.length; ++i) {
                File[] oldProjectStore;
                byte[] projectStoreBytes = org.apache.commons.io.FileUtils.readFileToByteArray((File)files[i]);
                File pathFile = org.apache.commons.io.FileUtils.getFile((File)workflow, (String[])new String[]{"path"});
                byte[] pathByte = org.apache.commons.io.FileUtils.readFileToByteArray((File)pathFile);
                String path = new String(pathByte);
                File file = new File(path);
                if (!file.exists()) {
                    file.mkdirs();
                }
                if ((oldProjectStore = file.listFiles()) == null || oldProjectStore.length <= 0) continue;
                for (int j = 0; j < oldProjectStore.length; ++j) {
                    if (!oldProjectStore[j].getName().equals(files[i].getName())) continue;
                    boolean flag = oldProjectStore[j].delete();
                    if (flag) {
                        FileOutputStream fos = new FileOutputStream(oldProjectStore[j]);
                        fos.write(projectStoreBytes, 0, projectStoreBytes.length);
                        fos.flush();
                        fos.close();
                        continue;
                    }
                    throw new IllegalArgumentException("\u5220\u9664\u5931\u8d25");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File formAuth = org.apache.commons.io.FileUtils.getFile((File)workflow, (String[])new String[]{ExportResourceConstant.SYS_ACT_FORMAUTHS});
        File actExtends = org.apache.commons.io.FileUtils.getFile((File)workflow, (String[])new String[]{SYS_ACT_EXTENDS});
        File metaFile = new File(temp + File.separator + ExportResourceConstant.META_JSON);
        if (!metaFile.exists()) {
            throw new IllegalArgumentException("\u5bfc\u5165\u5305\u9519\u8bef\uff0c\u4e0d\u5b58\u5728meta.json\u6587\u4ef6");
        }
        byte[] meta = new byte[]{};
        try {
            meta = org.apache.commons.io.FileUtils.readFileToByteArray((File)metaFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Map metaMap = (Map)SerializeUtils.deserialize((byte[])meta);
        if (metaMap == null) {
            throw new IllegalArgumentException("meta.json\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
        }
        String string = exportProcessKey = metaMap.get("processKey") == null ? "" : metaMap.get("processKey").toString();
        if (!exportProcessKey.equals(processKey)) {
            throw new IllegalArgumentException("\u5bfc\u5165\u7684\u4e0d\u662f\u4e00\u4e2a\u6d41\u7a0b");
        }
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(processKey);
        try {
            if (formAuth.exists()) {
                byte[] bytes = org.apache.commons.io.FileUtils.readFileToByteArray((File)formAuth);
                List actFormAuthList = (List)SerializeUtils.deserialize((byte[])bytes);
                this.formAuthApiService.actFormAuthBatchImport(actFormAuthList);
                org.apache.commons.io.FileUtils.forceDelete((File)formAuth);
            }
            if (actExtends.exists()) {
                byte[] bytes = org.apache.commons.io.FileUtils.readFileToByteArray((File)actExtends);
                List actExtendPropertiesList = (List)SerializeUtils.deserialize((byte[])bytes);
                this.extendPropertiesApiService.actExtendPropertiesImport(actExtendPropertiesList);
                org.apache.commons.io.FileUtils.forceDelete((File)actExtends);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getExportPath(String id) {
        String uploadPath = FileUtil.posixPath((String[])new String[]{this.hussarConfig.getFileUploadPath(), "processExport", id});
        File loadPath = new File(uploadPath);
        if (!loadPath.exists()) {
            loadPath.mkdirs();
        }
        return uploadPath;
    }

    private String readLocalWfd(String fileId) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String path = this.getDataPath(fileId);
        File file = new File(this.relativeToAbsolute(path, rootPath));
        if (!FileUtils.exists((File)file)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, fileId);
        }
        try {
            String xml = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            return xml;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String readLocalMeta(String fileId) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String path = this.getDataPath(fileId);
        File file = new File(this.relativeToAbsolute(path, rootPath));
        File metaFile = new File(this.addMeta(file.getAbsolutePath()));
        if (!FileUtils.exists((File)file)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, fileId);
        }
        if (!FileUtils.exists((File)metaFile)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, fileId);
        }
        try {
            String xml = org.apache.commons.io.FileUtils.readFileToString((File)metaFile, (Charset)StandardCharsets.UTF_8);
            return xml;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

