/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.applicationmix.service.IHussarBaseAppMixBoService;
import com.jxdinfo.hussar.applicationmix.vo.MixAppInfoVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.constant.ExportResourceConstant;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.AdjustWorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.model.WorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.ModelCopyDto;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.SaveInfoDto;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.WorkflowDumpDto;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.WorkflowService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl.BaseFileServiceImpl;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.file.ZipUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.vo.ProcessDefinitionVo;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.godaxe.model.GodAxeModelService;
import com.jxdinfo.hussar.workflow.upgrade.StandardExtendPropertiesApiService;
import com.jxdinfo.hussar.workflow.upgrade.StandardFormAuthApiService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="WorkflowServiceImpl")
@Conditional(value={ConditionNotSharedStorage.class})
public class WorkflowServiceImpl
extends BaseFileServiceImpl<WorkflowInfo>
implements WorkflowService {
    private final GodAxeModelService godAxeModelService;
    private final PathStrategyService pathStrategy;
    private final StandardFormAuthApiService formAuthApiService;
    private final StandardExtendPropertiesApiService extendPropertiesApiService;
    private final HussarConfig hussarConfig;
    public static String SYS_ACT_EXTENDS = "sysActExtends.json";
    @Autowired(required=false)
    private IHussarBaseAppMixBoService hussarBaseAppMixBoService;

    @Autowired
    public WorkflowServiceImpl(FileMappingService fileMappingService, GodAxeModelService godAxeModelService, PathStrategyService pathStrategy, StandardFormAuthApiService formAuthApiService, StandardExtendPropertiesApiService extendPropertiesApiService, HussarConfig hussarConfig) {
        this.fileMappingService = fileMappingService;
        this.godAxeModelService = godAxeModelService;
        this.pathStrategy = pathStrategy;
        this.formAuthApiService = formAuthApiService;
        this.extendPropertiesApiService = extendPropertiesApiService;
        this.hussarConfig = hussarConfig;
    }

    @Override
    public void deleteBpmFile(String identity, String organId, boolean forced) {
        ApiResponse apiResponse = this.godAxeModelService.deleteProcess(identity, organId, forced);
        if (!apiResponse.isSuccess()) {
            throw new HussarException(Integer.valueOf(apiResponse.getCode()), apiResponse.getMsg());
        }
    }

    @Override
    public void createWorkflow(WorkflowInfo workflowInfo) throws LcdpException, IOException {
        File file;
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String parentPath = "";
        if (!com.jxdinfo.hussar.formdesign.common.util.ToolUtil.isEmpty((Object)workflowInfo.getParentId()) && !"#".equals(workflowInfo.getParentId())) {
            parentPath = this.getDataPath(workflowInfo.getParentId());
        }
        if (FileUtils.exists((File)(file = new File(this.relativeToAbsolute(parentPath + File.separator + workflowInfo.geteName() + FileUtil.transFileSuffix((String)workflowInfo.getType()), rootPath))))) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, file.getAbsolutePath());
        }
        File metaFile = new File(file.getAbsolutePath() + ".meta");
        if (FileUtils.exists((File)metaFile)) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, metaFile.getAbsolutePath());
        }
        ArrayList<WorkFlow> workFlowList = new ArrayList<WorkFlow>();
        workFlowList.add(this.dealData(workflowInfo));
        ApiResponse apiResponse = this.godAxeModelService.saveFileOnly(workFlowList);
        if (!apiResponse.isSuccess()) {
            throw new LcdpException(LcdpExceptionEnum.ERROR, apiResponse.getMsg());
        }
        this.fileMappingService.fileMappingCacheEvict();
        this.write(file, workflowInfo);
    }

    @Override
    public void updateWorkFlowFile(WorkflowInfo workflowInfo) throws IOException, LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        JSONObject object = JSON.parseObject((String)workflowInfo.getData());
        object.getJSONObject("props").put("name", (Object)workflowInfo.geteName());
        String path = this.getDataPath(workflowInfo.getId());
        File file = new File(this.relativeToAbsolute(path, rootPath));
        File metaFile = new File(this.addMeta(file.getAbsolutePath()));
        if (!FileUtils.exists((File)file)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, workflowInfo.getId());
        }
        if (!FileUtils.exists((File)metaFile)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, workflowInfo.getId());
        }
        workflowInfo.setVersion(this.get(workflowInfo.getId()) != null ? ((WorkflowInfo)((Object)this.get(workflowInfo.getId()))).getVersion() : null);
        this.godAxeModelService.saveWorkflow(this.dealData(workflowInfo), BaseSecurityUtil.getUser().getStringTenantId(), false, false);
        boolean needRename = this.checkRename(workflowInfo, metaFile);
        this.writeSingleFile(file, JSONObject.parseObject((String)workflowInfo.getData()));
        workflowInfo.setData(null);
        this.writeSingleFile(metaFile, (JSONObject)JSONObject.toJSON((Object)((Object)workflowInfo)));
        if (needRename) {
            this.renameTwoWorkflowFile(workflowInfo, file, metaFile, rootPath);
        }
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public FormDesignResponse<Object> adjustProcess(AdjustWorkflowInfo workflowInfo) throws IOException, LcdpException {
        workflowInfo.setVersion(this.get(workflowInfo.getId()) != null ? ((WorkflowInfo)((Object)this.get(workflowInfo.getId()))).getVersion() : null);
        WorkFlow oldWorkFlow = this.godAxeModelService.getFileByProcessKeyAndProcessIdAndOrganId(workflowInfo.getIdentity(), workflowInfo.getProcessTag());
        if (!workflowInfo.getOverride()) {
            // empty if block
        }
        JSONObject object = JSON.parseObject((String)workflowInfo.getData());
        object.getJSONObject("props").put("name", (Object)workflowInfo.geteName());
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String path = this.getDataPath(workflowInfo.getId());
        File file = new File(this.relativeToAbsolute(path, rootPath));
        File metaFile = new File(this.addMeta(file.getAbsolutePath()));
        if (!FileUtils.exists((File)file)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, workflowInfo.getId());
        }
        if (!FileUtils.exists((File)metaFile)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, workflowInfo.getId());
        }
        boolean needRename = this.checkRename(workflowInfo, metaFile);
        workflowInfo.setVersion(oldWorkFlow.getVersion());
        String str = workflowInfo.getData();
        this.writeSingleFile(file, JSONObject.parseObject((String)workflowInfo.getData()));
        workflowInfo.setData(null);
        this.writeSingleFile(metaFile, (JSONObject)JSONObject.toJSON((Object)((Object)workflowInfo)));
        workflowInfo.setData(str);
        if (needRename) {
            this.renameTwoWorkflowFile(workflowInfo, file, metaFile, rootPath);
        }
        this.fileMappingService.fileMappingCacheEvict();
        try {
            ApiResponse obj = this.godAxeModelService.updateProcess(this.dealData(workflowInfo), BaseSecurityUtil.getUser().getStringTenantId());
            FormDesignResponse speedCodeResponse = new FormDesignResponse();
            if (!obj.isSuccess()) {
                speedCodeResponse.setErrorMsg("\u8986\u76d6\u53d1\u5e03\u9519\u8bef\uff1a" + obj.getMsg());
                speedCodeResponse.setErrorCode(14160 == obj.getCode() ? obj.getCode() : 500);
                return speedCodeResponse;
            }
            if (obj.getData() instanceof Map && "14160".equals(((Map)obj.getData()).get("code"))) {
                speedCodeResponse.setErrorMsg("\u8986\u76d6\u53d1\u5e03\u9519\u8bef\uff1a" + ((Map)obj.getData()).get("msg"));
                speedCodeResponse.setErrorCode(14160);
                return speedCodeResponse;
            }
        }
        catch (Exception e) {
            FormDesignResponse speedCodeResponse = new FormDesignResponse();
            speedCodeResponse.setErrorMsg("\u8986\u76d6\u53d1\u5e03\u9519\u8bef\uff1a" + e.getMessage());
            speedCodeResponse.setErrorCode(500);
            return speedCodeResponse;
        }
        return new FormDesignResponse();
    }

    @Override
    public void moveWorkFlow(String id, String parentId, String newName, String newDesc, String category) throws LcdpException, IOException {
        File newMetaFile;
        JSONObject jsonObject;
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String path = this.getDataPath(id);
        String parentPath = this.getDataPath(parentId);
        File from = new File(this.relativeToAbsolute(path, rootPath));
        File metaFrom = new File(from.getAbsolutePath() + ".meta");
        File to = new File(this.relativeToAbsolute(parentPath, rootPath));
        if (!FileUtils.isFile((File)from)) {
            throw new LcdpException(LcdpExceptionEnum.NO_FILE, from.getAbsolutePath());
        }
        if (!FileUtils.isDirectory((File)to)) {
            throw new LcdpException(LcdpExceptionEnum.NO_DIRECTORY, to.getAbsolutePath());
        }
        try {
            jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)metaFrom, (String)"UTF-8"));
        }
        catch (IOException e) {
            throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, from.getAbsolutePath());
        }
        String eName = jsonObject.getString("eName");
        if (eName != null && !"".equals(eName)) {
            to = new File(this.relativeToAbsolute(parentPath + "/" + eName, rootPath));
            File metaTo = new File(to.getAbsolutePath() + ".meta");
            if (!FileUtils.exists((File)to) && !FileUtils.exists((File)metaTo)) {
                try {
                    FileUtils.moveFile((File)from, (File)to);
                    FileUtils.moveFile((File)metaFrom, (File)metaTo);
                }
                catch (IOException e) {
                    throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, from.getAbsolutePath());
                }
            } else {
                throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, from.getAbsolutePath());
            }
            newMetaFile = metaTo;
        } else {
            try {
                FileUtils.moveFileToDirectory((File)from, (File)to, (boolean)false);
                FileUtils.moveFileToDirectory((File)metaFrom, (File)to, (boolean)false);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, from.getAbsolutePath());
            }
            newMetaFile = new File(to + File.separator + metaFrom.getName());
        }
        try {
            jsonObject.put("parentId", (Object)parentId);
            if (newName != null && !"".equals(newName)) {
                jsonObject.put("name", (Object)newName);
            }
            if (eName != null && !"".equals(eName)) {
                jsonObject.put("eName", (Object)eName);
            }
            jsonObject.put("category", (Object)category);
            FileUtils.writeStringToFile((File)newMetaFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"UTF-8");
        }
        catch (IOException e) {
            throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, from.getAbsolutePath());
        }
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public List<String> copyWorkFlow(List<ModelCopyDto> list) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        ArrayList<WorkFlow> workFlowList = new ArrayList<WorkFlow>();
        ArrayList<String> processKeys = new ArrayList<String>();
        for (ModelCopyDto modelCopyDto : list) {
            File newWfdFile;
            File newMetaFile;
            String processKey;
            String id = modelCopyDto.getId();
            String parentId = modelCopyDto.getParentId();
            String newId = modelCopyDto.getNewId();
            String newName = modelCopyDto.getNewName();
            String category = modelCopyDto.getCategory();
            String newDesc = modelCopyDto.getNewDesc();
            String path = this.getDataPath(id);
            String parentPath = this.getDataPath(parentId);
            File from = new File(this.relativeToAbsolute(path, rootPath));
            File metaFrom = new File(from.getAbsolutePath() + ".meta");
            File to = new File(this.relativeToAbsolute(parentPath, rootPath));
            String oldProcessKey = JSONObject.parseObject((String)FileUtils.readFileToString((File)metaFrom, (String)"UTF-8")).getString("identity");
            if (!oldProcessKey.equals(processKey = newDesc)) {
                this.godAxeModelService.updateWorkflowProcessKey(processKey, oldProcessKey);
            }
            WorkflowInfo workflowInfo = (WorkflowInfo)((Object)this.readFileToObject(this.relativeToAbsolute(path, rootPath)));
            WorkFlow workFlow = this.dealData(workflowInfo);
            workFlow.setIdentity(processKey);
            workFlow.setName(newName);
            workFlowList.add(workFlow);
            if (!FileUtils.isFile((File)from)) {
                throw new LcdpException(LcdpExceptionEnum.NO_FILE, from.getAbsolutePath());
            }
            if (!FileUtils.isDirectory((File)to)) {
                throw new LcdpException(LcdpExceptionEnum.NO_DIRECTORY, to.getAbsolutePath());
            }
            if (newDesc != null && !"".equals(newDesc)) {
                to = new File(this.relativeToAbsolute(parentPath + File.separator + newDesc, rootPath));
                File metaTo = new File(to.getAbsolutePath() + ".meta");
                if (!FileUtils.exists((File)to) && !FileUtils.exists((File)metaTo)) {
                    try {
                        FileUtils.copyFile((File)from, (File)to, (boolean)false);
                        FileUtils.copyFile((File)metaFrom, (File)metaTo, (boolean)false);
                    }
                    catch (IOException e) {
                        throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, from.getAbsolutePath());
                    }
                } else {
                    throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, from.getAbsolutePath());
                }
                newMetaFile = metaTo;
                newWfdFile = to;
            } else {
                try {
                    FileUtils.copyFileToDirectory((File)from, (File)to, (boolean)false);
                    FileUtils.copyFileToDirectory((File)metaFrom, (File)to, (boolean)false);
                }
                catch (IOException e) {
                    throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, from.getAbsolutePath());
                }
                newMetaFile = new File(to + File.separator + metaFrom.getName());
                newWfdFile = new File(to + File.separator + from.getName());
            }
            try {
                JSONObject jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)newMetaFile, (String)"UTF-8"));
                jsonObject.put("parentId", (Object)parentId);
                jsonObject.put("id", (Object)newId);
                if (newName != null && !"".equals(newName)) {
                    jsonObject.put("name", (Object)newName);
                }
                if (newDesc != null && !"".equals(newDesc)) {
                    jsonObject.put("eName", (Object)newDesc);
                    jsonObject.put("identity", (Object)newDesc);
                }
                if (category != null && !"".equals(category)) {
                    jsonObject.put("category", (Object)category);
                }
                jsonObject.put("version", (Object)"0");
                FileUtils.writeStringToFile((File)newMetaFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"UTF-8");
                String content = FileUtils.readFileToString((File)newWfdFile, (String)"UTF-8");
                content = content.replaceAll(id, newId);
                JSONObject wfdJsonObject = JSONObject.parseObject((String)content);
                JSONObject props = (JSONObject)wfdJsonObject.get((Object)"props");
                if (newDesc != null && !"".equals(newDesc)) {
                    props.put("identity", (Object)newDesc);
                }
                FileUtils.writeStringToFile((File)newWfdFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)wfdJsonObject), (String)"UTF-8");
                this.fileMappingService.fileMappingCacheEvict();
                processKeys.add(jsonObject.getString("identity"));
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, from.getAbsolutePath());
            }
        }
        this.godAxeModelService.saveFileOnly(workFlowList);
        return processKeys;
    }

    @Override
    public List<String> publishWorkflowOnOrgan(List<ModelCopyDto> list) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        ArrayList<WorkFlow> workFlowList = new ArrayList<WorkFlow>();
        ArrayList<String> processKeys = new ArrayList<String>();
        for (ModelCopyDto modelCopyDto : list) {
            File newWfdFile;
            File newMetaFile;
            String processKey;
            String id = modelCopyDto.getId();
            String parentId = modelCopyDto.getParentId();
            String newId = modelCopyDto.getNewId();
            String newName = modelCopyDto.getNewName();
            String category = modelCopyDto.getCategory();
            String newDesc = modelCopyDto.getNewDesc();
            String eName = modelCopyDto.geteName();
            if (HussarUtils.isEmpty((Object)eName)) {
                eName = newDesc;
            }
            String path = this.getDataPath(id);
            String parentPath = this.getDataPath(parentId);
            File from = new File(this.relativeToAbsolute(path, rootPath));
            File metaFrom = new File(from.getAbsolutePath() + ".meta");
            File to = new File(this.relativeToAbsolute(parentPath, rootPath));
            String oldProcessKey = JSONObject.parseObject((String)FileUtils.readFileToString((File)metaFrom, (String)"UTF-8")).getString("identity");
            if (!oldProcessKey.equals(processKey = newDesc)) {
                throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, metaFrom.getAbsolutePath());
            }
            WorkflowInfo workflowInfo = (WorkflowInfo)((Object)this.readFileToObject(this.relativeToAbsolute(path, rootPath)));
            WorkFlow workFlow = this.dealData(workflowInfo);
            workFlow.setIdentity(processKey);
            workFlow.setName(newName);
            workFlowList.add(workFlow);
            if (!from.isFile()) {
                throw new LcdpException(LcdpExceptionEnum.NO_FILE, from.getAbsolutePath());
            }
            if (!to.isDirectory()) {
                throw new LcdpException(LcdpExceptionEnum.NO_DIRECTORY, to.getAbsolutePath());
            }
            if (eName != null && !"".equals(eName)) {
                to = new File(this.relativeToAbsolute(parentPath + File.separator + eName, rootPath));
                File metaTo = new File(to.getAbsolutePath() + ".meta");
                if (!to.exists() && !metaTo.exists()) {
                    try {
                        FileUtils.copyFile((File)from, (File)to, (boolean)false);
                        FileUtils.copyFile((File)metaFrom, (File)metaTo, (boolean)false);
                    }
                    catch (IOException e) {
                        throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, from.getAbsolutePath());
                    }
                } else {
                    throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, from.getAbsolutePath());
                }
                newMetaFile = metaTo;
                newWfdFile = to;
            } else {
                try {
                    FileUtils.copyFileToDirectory((File)from, (File)to, (boolean)false);
                    FileUtils.copyFileToDirectory((File)metaFrom, (File)to, (boolean)false);
                }
                catch (IOException e) {
                    throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, from.getAbsolutePath());
                }
                newMetaFile = new File(to + File.separator + metaFrom.getName());
                newWfdFile = new File(to + File.separator + from.getName());
            }
            try {
                JSONObject jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)newMetaFile, (String)"UTF-8"));
                jsonObject.put("parentId", (Object)parentId);
                jsonObject.put("id", (Object)newId);
                if (newName != null && !"".equals(newName)) {
                    jsonObject.put("name", (Object)newName);
                }
                if (newDesc != null && !"".equals(newDesc)) {
                    jsonObject.put("identity", (Object)newDesc);
                }
                if (HussarUtils.isNotEmpty((Object)eName)) {
                    jsonObject.put("eName", (Object)eName);
                }
                if (category != null && !"".equals(category)) {
                    jsonObject.put("category", (Object)category);
                }
                jsonObject.put("version", (Object)"0");
                FileUtils.writeStringToFile((File)newMetaFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"UTF-8");
                JSONObject wfdJsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)newWfdFile, (String)"UTF-8"));
                JSONObject props = (JSONObject)wfdJsonObject.get((Object)"props");
                if (newDesc != null && !"".equals(newDesc)) {
                    props.put("identity", (Object)newDesc);
                }
                FileUtils.writeStringToFile((File)newWfdFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)wfdJsonObject), (String)"UTF-8");
                this.fileMappingService.fileMappingCacheEvict();
                processKeys.add(jsonObject.getString("identity"));
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, from.getAbsolutePath());
            }
        }
        return processKeys;
    }

    @Override
    public WorkFlow queryFlowMeta(String processKey, String version) throws IOException, LcdpException {
        Integer ver = null;
        if (HussarUtils.isNotEmpty((Object)version)) {
            ver = Integer.valueOf(version);
        }
        return this.godAxeModelService.getFileByProcessKeyAndVersion(processKey, ver);
    }

    @Override
    public List<ProcessDefinitionVo> queryFlowVersion(String processKey) throws IOException, LcdpException {
        return this.godAxeModelService.queryFlowVersion(processKey);
    }

    private boolean checkRename(WorkflowInfo newBaseFile, File oldFile) throws LcdpException {
        boolean needRename = true;
        try {
            WorkflowInfo baseFile = (WorkflowInfo)((Object)JSONObject.parseObject((String)FileUtils.readFileToString((File)oldFile, (String)"UTF-8"), WorkflowInfo.class));
            if (newBaseFile.geteName().equals(baseFile.geteName())) {
                needRename = false;
            }
        }
        catch (IOException e) {
            throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, oldFile.getAbsolutePath());
        }
        return needRename;
    }

    private void renameTwoWorkflowFile(WorkflowInfo workflowInfo, File file, File metaFile, String rootPath) throws LcdpException, IOException {
        File newFile;
        String parentPath = "";
        if (!com.jxdinfo.hussar.formdesign.common.util.ToolUtil.isEmpty((Object)workflowInfo.getParentId()) && !"#".equals(workflowInfo.getParentId())) {
            parentPath = this.getDataPath(workflowInfo.getParentId());
        }
        if (FileUtils.exists((File)(newFile = new File(rootPath + parentPath + File.separator + workflowInfo.geteName() + FileUtil.transFileSuffix((String)workflowInfo.getType()))))) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, newFile.getAbsolutePath());
        }
        File newMetaFile = new File(newFile.getAbsolutePath() + ".meta");
        if (FileUtils.exists((File)newMetaFile)) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, newMetaFile.getAbsolutePath());
        }
        this.fixName(file, newFile);
        this.fixName(metaFile, newMetaFile);
    }

    private WorkFlow dealData(WorkflowInfo workflowService) {
        WorkFlow workFlow = new WorkFlow();
        workFlow.setId(workflowService.getId());
        workFlow.setData(workflowService.getData());
        workFlow.setDesc(workflowService.getDesc());
        workFlow.setName(workflowService.getName());
        workFlow.setType(workflowService.getType());
        workFlow.setModelId(workflowService.getModelId());
        workFlow.setIdentity(workflowService.getIdentity());
        workFlow.setProcDefId(workflowService.getProcDefId());
        workFlow.setVersion(workflowService.getVersion());
        workFlow.setAppId(workflowService.getAppId());
        workFlow.setAppName(workflowService.getAppName());
        workFlow.setCategory(AppContextUtil.getServiceName());
        workFlow.setWorkflowStyle(workflowService.getWorkflowStyle());
        workFlow.setProcessTag(workflowService.getProcessTag());
        workFlow.setProcessTagName(workflowService.getProcessTagName());
        if (workflowService instanceof AdjustWorkflowInfo) {
            workFlow.setForcePublish(((AdjustWorkflowInfo)workflowService).getForcePublish());
        }
        if (HussarUtils.isNotEmpty((Object)workflowService.getAppId()) && this.hussarBaseAppMixBoService != null) {
            if (AppContextUtil.isExtension()) {
                workflowService.setAppId(AppContextUtil.getAppId());
                workFlow.setAppId(workflowService.getAppId());
            }
            MixAppInfoVo mixAppInfoVo = this.hussarBaseAppMixBoService.getMixAppInfo(Long.valueOf(workflowService.getAppId()));
            if (AppContextUtil.isExtension() && HussarUtils.isNotEmpty((Object)mixAppInfoVo.getAppEnglishName()) && mixAppInfoVo.getAppEnglishName().endsWith("_extension")) {
                workFlow.setAppCode(mixAppInfoVo.getAppEnglishName().substring(0, mixAppInfoVo.getAppEnglishName().lastIndexOf("_")));
            } else {
                workFlow.setAppCode(mixAppInfoVo.getAppEnglishName());
            }
        }
        return workFlow;
    }

    @Override
    public ApiResponse<?> checkAndSaveWorkFlowDataAndMeta(SaveInfoDto saveInfoDto) throws IOException, LcdpException {
        WorkflowInfo workflowInfo = saveInfoDto.getWorkflowInfo();
        String saveType = saveInfoDto.getSaveType();
        WorkFlow workFlow = this.dealData(workflowInfo);
        ApiResponse apiResponse = this.godAxeModelService.saveWorkflowMetaAndData(workFlow, saveType);
        return apiResponse;
    }

    @Override
    public ApiResponse<String> setMainVersion(String processKey, String processVersion) throws IOException, LcdpException {
        return this.godAxeModelService.setMainVersion(processKey, processVersion, null);
    }

    @Override
    public ApiResponse<String> queryNextVersion(String processKey) {
        return this.godAxeModelService.queryNextVersion(processKey);
    }

    @Override
    public FormDesignResponse<Map> checkProcessKey(List<String> processKeys) {
        List workFlow = this.godAxeModelService.getFilesByProcessKeys(processKeys);
        HashMap<String, String> map = new HashMap<String, String>();
        if (HussarUtils.isNotEmpty((Object)workFlow)) {
            for (WorkFlow flow : workFlow) {
                if (!processKeys.contains(flow.getIdentity())) continue;
                map.put(flow.getIdentity(), "\u6d41\u7a0b\u6807\u8bc6\u5df2\u5b58\u5728");
            }
            return FormDesignResponse.fail(map, (String)"");
        }
        return new FormDesignResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportProcess(WorkflowDumpDto workflowDumpDto, HttpServletResponse response) throws Exception {
        File file = null;
        String fileId = workflowDumpDto.getFileId();
        String tenantCode = workflowDumpDto.getTenantCode();
        String name = workflowDumpDto.getName();
        String exportPath = this.getExportPath(fileId);
        String environmentPath = "offline";
        HashMap<String, String> metaMap = new HashMap<String, String>();
        metaMap.put("processKey", workflowDumpDto.getProcessKey());
        String zipPath = exportPath + File.separator + environmentPath + File.separator + tenantCode + "_" + name + "_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMddHHmmss") + ExportResourceConstant._HUSSAR;
        ArrayList<File> files = new ArrayList<File>();
        File zip = new File(zipPath);
        File zipParent = zip.getParentFile();
        if (!zipParent.exists()) {
            zipParent.mkdirs();
        }
        try {
            byte[] meta;
            file = Files.createTempDirectory("processExport" + fileId, new FileAttribute[0]).toFile();
            String processKey = workflowDumpDto.getProcessKey();
            Integer version = workflowDumpDto.getVersion();
            File workflow = new File(file.getAbsolutePath() + File.separator + ExportResourceConstant.WORKFLOW);
            try {
                FileUtils.forceMkdir((File)workflow);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            List actFormAuthList = new ArrayList();
            List extendProperties = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)processKey) && HussarUtils.isNotEmpty((Object)version)) {
                BpmResponseResult extendPropertiesListResult;
                JSONArray extendPropertiesResult;
                BpmResponseResult actFormAuthListResult = this.formAuthApiService.actFormAuthExportData(processKey, version);
                JSONArray actFormAuthResult = actFormAuthListResult.getResult();
                if (actFormAuthResult.size() > 0) {
                    actFormAuthList = JSON.parseArray((String)actFormAuthResult.getJSONArray(0).toJSONString(), SysActFormAuth.class);
                }
                if ((extendPropertiesResult = (extendPropertiesListResult = this.extendPropertiesApiService.actExtendPropertiesExportData(processKey, version)).getResult()).size() > 0) {
                    extendProperties = JSON.parseArray((String)extendPropertiesResult.getJSONArray(0).toJSONString(), SysActExtendProperties.class);
                }
            } else {
                throw new Exception("\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            }
            if (HussarUtils.isNotEmpty(actFormAuthList)) {
                meta = SerializeUtils.serialize(actFormAuthList);
                String formAuth = workflow + File.separator + ExportResourceConstant.SYS_ACT_FORMAUTHS;
                File formAuthFile = new File(formAuth);
                FileUtils.writeByteArrayToFile((File)formAuthFile, (byte[])meta);
                files.add(formAuthFile);
            }
            if (HussarUtils.isNotEmpty(extendProperties)) {
                meta = SerializeUtils.serialize(extendProperties);
                String actExtend = workflow + File.separator + SYS_ACT_EXTENDS;
                File actExtendFile = new File(actExtend);
                FileUtils.writeByteArrayToFile((File)actExtendFile, (byte[])meta);
                files.add(actExtendFile);
            }
            String wfd = this.readLocalWfd(fileId);
            byte[] myByte = wfd.getBytes("UTF-8");
            String wfdPath = file.getAbsolutePath() + File.separator + ExportResourceConstant.PROJECT_STORE + File.separator + workflowDumpDto.getName();
            File wfdPathFile = new File(wfdPath);
            FileUtils.writeByteArrayToFile((File)wfdPathFile, (byte[])myByte);
            files.add(wfdPathFile);
            String meta2 = this.readLocalMeta(fileId);
            byte[] metaByte = meta2.getBytes("UTF-8");
            String metaPath = file.getAbsolutePath() + File.separator + ExportResourceConstant.PROJECT_STORE + File.separator + workflowDumpDto.getName() + ".meta";
            File metaPathFile = new File(metaPath);
            FileUtils.writeByteArrayToFile((File)metaPathFile, (byte[])metaByte);
            files.add(metaPathFile);
            String p = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath() + File.separator + workflowDumpDto.getModelName();
            byte[] pathByte = p.getBytes("UTF-8");
            String Filepath = workflow + File.separator + "path";
            File FilepathFile = new File(Filepath);
            FileUtils.writeByteArrayToFile((File)FilepathFile, (byte[])pathByte);
            files.add(FilepathFile);
            byte[] metaJson = SerializeUtils.serialize(metaMap);
            String metaJsonPath = workflow + File.separator + ExportResourceConstant.META_JSON;
            File metaJsonPathFile = new File(metaJsonPath);
            FileUtils.writeByteArrayToFile((File)metaJsonPathFile, (byte[])metaJson);
            files.add(metaJsonPathFile);
            String newFileName = URLEncoder.encode(tenantCode + "_" + name + "_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMddHHmmss") + ExportResourceConstant._HUSSAR, "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + newFileName);
            response.setContentType("application/octet-stream");
            response.setCharacterEncoding("UTF-8");
            FileOutputStream fous = new FileOutputStream(zip);
            ZipOutputStream zipOut = new ZipOutputStream(fous);
            WorkflowServiceImpl.zipFile(files, zipOut);
            zipOut.close();
            fous.close();
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(zipPath));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ((OutputStream)toClient).write(buffer);
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (file != null && file.exists()) {
                try {
                    org.apache.commons.io.FileUtils.forceDelete((File)file);
                    org.apache.commons.io.FileUtils.forceDelete((File)zip);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void zipFile(List files, ZipOutputStream outputStream) {
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            File file = (File)files.get(i);
            WorkflowServiceImpl.zipFile(file, outputStream);
        }
    }

    public static void zipFile(File inputFile, ZipOutputStream ouputStream) {
        block7: {
            try {
                if (!inputFile.exists()) break block7;
                if (inputFile.isFile()) {
                    int nNumber;
                    FileInputStream IN = new FileInputStream(inputFile);
                    BufferedInputStream bins = new BufferedInputStream(IN, 512);
                    ZipEntry entry = new ZipEntry(inputFile.getName());
                    ouputStream.putNextEntry(entry);
                    byte[] buffer = new byte[512];
                    while ((nNumber = bins.read(buffer)) != -1) {
                        ouputStream.write(buffer, 0, nNumber);
                    }
                    bins.close();
                    IN.close();
                    break block7;
                }
                try {
                    File[] files = inputFile.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        WorkflowServiceImpl.zipFile(files[i], ouputStream);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ApiResponse<Object> importProcess(MultipartFile file, String fileId, String processKey) {
        HashMap<String, Object> returnMap;
        block5: {
            File temp = null;
            returnMap = new HashMap<String, Object>();
            try {
                InputStream inputStream = file.getInputStream();
                temp = Files.createTempDirectory("processImport" + fileId, new FileAttribute[0]).toFile();
                File tempFile = new File(temp.getAbsolutePath() + File.separator + fileId + ".zip");
                org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
                ZipUtil.unzip((String)tempFile.getAbsolutePath(), (String)(temp.getAbsolutePath() + File.separator));
                this.importProcessToOffline(fileId, temp, returnMap, processKey);
            }
            catch (Exception e) {
                returnMap.put("status", false);
                returnMap.put("msg", e.toString());
                if (!ToolUtil.isNotEmpty((Object)temp) || !temp.exists()) break block5;
                try {
                    org.apache.commons.io.FileUtils.forceDelete((File)temp);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (!((Boolean)returnMap.get("status")).booleanValue()) {
            return ApiResponse.fail((String)returnMap.get("msg").toString());
        }
        return ApiResponse.success((String)"\u5bfc\u5165\u6210\u529f");
    }

    @Override
    public ApiResponse<?> checkForStandardWorkflow(WorkflowInfo workflowInfo) {
        WorkFlow workFlow = this.dealData(workflowInfo);
        return this.godAxeModelService.checkForStandardWorkflow(workFlow);
    }

    private void importProcessToOffline(String fileId, File temp, Map<String, Object> returnMap, String processKey) throws Exception {
        File axe = new File(temp.getAbsolutePath() + File.separator + ExportResourceConstant.PROJECT_STORE);
        this.importWorkFlow(temp, fileId, processKey);
        returnMap.put("status", true);
    }

    private void importWorkFlow(File temp, String fileId, String processKey) throws IOException, LcdpException, ClassNotFoundException {
        String exportProcessKey;
        File workflow = new File(temp.getAbsolutePath());
        File projectStore = new File(temp.getAbsolutePath());
        File projectStoreFile = org.apache.commons.io.FileUtils.getFile((File)projectStore, (String[])new String[0]);
        File[] files = projectStoreFile.listFiles();
        try {
            for (int i = 0; i < files.length; ++i) {
                File[] oldProjectStore;
                byte[] projectStoreBytes = org.apache.commons.io.FileUtils.readFileToByteArray((File)files[i]);
                File pathFile = org.apache.commons.io.FileUtils.getFile((File)workflow, (String[])new String[]{"path"});
                byte[] pathByte = org.apache.commons.io.FileUtils.readFileToByteArray((File)pathFile);
                String path = new String(pathByte);
                File file = new File(path);
                if (!file.exists()) {
                    file.mkdirs();
                }
                if ((oldProjectStore = file.listFiles()) == null || oldProjectStore.length <= 0) continue;
                for (int j = 0; j < oldProjectStore.length; ++j) {
                    if (!oldProjectStore[j].getName().equals(files[i].getName())) continue;
                    boolean flag = oldProjectStore[j].delete();
                    if (flag) {
                        FileOutputStream fos = new FileOutputStream(oldProjectStore[j]);
                        fos.write(projectStoreBytes, 0, projectStoreBytes.length);
                        fos.flush();
                        fos.close();
                        continue;
                    }
                    throw new IllegalArgumentException("\u5220\u9664\u5931\u8d25");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File formAuth = org.apache.commons.io.FileUtils.getFile((File)workflow, (String[])new String[]{ExportResourceConstant.SYS_ACT_FORMAUTHS});
        File actExtends = org.apache.commons.io.FileUtils.getFile((File)workflow, (String[])new String[]{SYS_ACT_EXTENDS});
        File metaFile = new File(temp + File.separator + ExportResourceConstant.META_JSON);
        if (!metaFile.exists()) {
            throw new IllegalArgumentException("\u5bfc\u5165\u5305\u9519\u8bef\uff0c\u4e0d\u5b58\u5728meta.json\u6587\u4ef6");
        }
        byte[] meta = new byte[]{};
        try {
            meta = org.apache.commons.io.FileUtils.readFileToByteArray((File)metaFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Map metaMap = (Map)SerializeUtils.deserialize((byte[])meta);
        if (metaMap == null) {
            throw new IllegalArgumentException("meta.json\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
        }
        String string = exportProcessKey = metaMap.get("processKey") == null ? "" : metaMap.get("processKey").toString();
        if (!exportProcessKey.equals(processKey)) {
            throw new IllegalArgumentException("\u5bfc\u5165\u7684\u4e0d\u662f\u4e00\u4e2a\u6d41\u7a0b");
        }
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(processKey);
        try {
            if (formAuth.exists()) {
                byte[] bytes = org.apache.commons.io.FileUtils.readFileToByteArray((File)formAuth);
                List actFormAuthList = (List)SerializeUtils.deserialize((byte[])bytes);
                this.formAuthApiService.actFormAuthBatchImport(actFormAuthList);
                org.apache.commons.io.FileUtils.forceDelete((File)formAuth);
            }
            if (actExtends.exists()) {
                byte[] bytes = org.apache.commons.io.FileUtils.readFileToByteArray((File)actExtends);
                List actExtendPropertiesList = (List)SerializeUtils.deserialize((byte[])bytes);
                this.extendPropertiesApiService.actExtendPropertiesImport(actExtendPropertiesList);
                org.apache.commons.io.FileUtils.forceDelete((File)actExtends);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getExportPath(String id) {
        String uploadPath = FileUtil.posixPath((String[])new String[]{this.hussarConfig.getFileUploadPath(), "processExport", id});
        File loadPath = new File(uploadPath);
        if (!loadPath.exists()) {
            loadPath.mkdirs();
        }
        return uploadPath;
    }

    private String readLocalWfd(String fileId) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String path = this.getDataPath(fileId);
        File file = new File(this.relativeToAbsolute(path, rootPath));
        if (!FileUtils.exists((File)file)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, fileId);
        }
        try {
            String xml = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            return xml;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String readLocalMeta(String fileId) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String path = this.getDataPath(fileId);
        File file = new File(this.relativeToAbsolute(path, rootPath));
        File metaFile = new File(this.addMeta(file.getAbsolutePath()));
        if (!FileUtils.exists((File)file)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, fileId);
        }
        if (!FileUtils.exists((File)metaFile)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, fileId);
        }
        try {
            String xml = org.apache.commons.io.FileUtils.readFileToString((File)metaFile, (Charset)StandardCharsets.UTF_8);
            return xml;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

