/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl;

import com.jxdinfo.hussar.formdesign.common.constant.ClientKindEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.FrontClientConverter;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.MicroAppInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.ResourcesService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ResourcesServiceImpl
implements ResourcesService {
    @Autowired
    private FormDesignProperties speedCodeProperties;
    @Resource
    private PageInfoService pageInfoService;
    @Resource
    private MicroAppInfoService microAppInfoService;
    @Resource
    private FileMappingService fileMappingService;
    @Resource
    private FormDesignProperties formDesignProperties;
    @Resource
    private PathStrategyService pathStrategy;

    @Override
    public List<Map<String, String>> getImgResources() {
        ArrayList<Map<String, String>> imgList = new ArrayList<Map<String, String>>();
        File file = new File(FileUtil.posixPath((String[])new String[]{this.speedCodeProperties.getProjectPath(), "src", "main", "webapp", "static", "img"}));
        File[] files = FileUtils.listFiles((File)file);
        this.getImages(files, imgList);
        return imgList;
    }

    private void getImages(File[] files, List<Map<String, String>> imgList) {
        if (null != files && files.length > 0) {
            for (File f : files) {
                if (FileUtils.isFile((File)f)) {
                    HashMap<String, String> imgMap = new HashMap<String, String>();
                    imgMap.put("name", f.getName());
                    imgMap.put("path", f.getAbsolutePath().replace(FileUtil.posixPath((String[])new String[]{this.speedCodeProperties.getProjectPath(), "src", "main", "webapp", "static"}), "/static").replace("\\", "/"));
                    imgList.add(imgMap);
                    continue;
                }
                File[] fileList = FileUtils.listFiles((File)f);
                this.getImages(fileList, imgList);
            }
        }
    }

    @Override
    public Map<String, Object> getImgResources(String id) throws Exception {
        HashMap<String, Object> resourceMap = new HashMap<String, Object>();
        if (VfgModeTool.isRemote()) {
            resourceMap.put("pathChar", "~@pkg");
        } else if (AppContextUtil.isExtension() || AppContextUtil.isNormal()) {
            resourceMap.put("pathChar", "mf");
        } else {
            resourceMap.put("pathChar", "~@");
        }
        BaseFile baseFile = this.fileMappingService.getPageInfoById(id);
        String frontProjectPath = (String)FrontClientConverter.getPathResolver((String)ClientKindEnum.CLIENT_PATH.kind(baseFile.getType())).paths().get("FRONT_PROJECT_PATH");
        String imgPath = ToolUtil.pathFomatterByOS((String)FileUtil.posixPath((String[])new String[]{frontProjectPath, "src", "assets", "img"}));
        String splitPath = ToolUtil.pathFomatterByOS((String)FileUtil.posixPath((String[])new String[]{frontProjectPath, "src"}));
        resourceMap.put("imgList", this.getAllImages(imgPath, splitPath));
        return resourceMap;
    }

    @Override
    public Map<String, Object> getBimImgResources(String id, String frontImgPath) throws Exception {
        HashMap<String, Object> resourceMap = new HashMap<String, Object>();
        StringBuilder pathChar = new StringBuilder();
        for (int i = 0; i < StringUtils.countMatches((CharSequence)this.fileMappingService.getFilePathById(id), (CharSequence)"\\"); ++i) {
            pathChar.append("../");
        }
        resourceMap.put("pathChar", pathChar.toString().substring(0, pathChar.toString().length() - 1));
        BaseFile baseFile = this.fileMappingService.getPageInfoById(id);
        frontImgPath = ToolUtil.isEmpty((Object)frontImgPath) ? "\\src\\assets\\img" : frontImgPath.replace("/", "\\");
        String frontProjectPath = (String)FrontClientConverter.getPathResolver((String)ClientKindEnum.CLIENT_PATH.kind(baseFile.getType())).paths().get("FRONT_PROJECT_PATH");
        frontProjectPath = this.pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[0]);
        String imgPath = ToolUtil.pathFomatterByOS((String)(frontProjectPath + frontImgPath));
        String splitPath = ToolUtil.pathFomatterByOS((String)FileUtil.posixPath((String[])new String[]{frontProjectPath, "src"}));
        resourceMap.put("imgList", this.getAllImages(imgPath, splitPath));
        return resourceMap;
    }

    @Override
    public void getFile(String id, String path, HttpServletResponse response) throws IOException, LcdpException {
        if (path.indexOf("mf") > 0) {
            path = path.substring(path.indexOf("mf") + 2);
        }
        BaseFile baseFile = this.fileMappingService.getPageInfoById(id);
        String frontProjectPath = (String)FrontClientConverter.getPathResolver((String)ClientKindEnum.CLIENT_PATH.kind(baseFile.getType())).paths().get("FRONT_PROJECT_PATH");
        path = ToolUtil.pathFomatterByOS((String)FileUtil.posixPath((String[])new String[]{frontProjectPath, "src", VfgModeTool.isRemote() ? path.substring(path.indexOf("/")) : path}));
        FileUtils.getFile((String)path, (HttpServletResponse)response);
    }

    @Override
    public boolean saveImage(MultipartFile[] files, String type) throws IOException {
        String imgPath = "";
        String frontProjectPath = (String)FrontClientConverter.getPathResolver((String)ClientKindEnum.CLIENT_PATH.kind(type)).paths().get("FRONT_PROJECT_PATH");
        imgPath = ToolUtil.pathFomatterByOS((String)FileUtil.posixPath((String[])new String[]{frontProjectPath, "src", "assets", "img"}));
        FileUtils.uploadImages((String)imgPath, (MultipartFile[])files);
        VfgModeTool.pushToRemote((String)String.format("\u4e0a\u4f20\u56fe\u7247", new Object[0]), Collections.singletonList(imgPath));
        return true;
    }

    private List<Map<String, Object>> getAllImages(String imgPath, String splitPath) throws Exception {
        return FileUtils.getAllImages((String)imgPath, (String)splitPath);
    }
}

