/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.PageTemplateInfo;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageTemplateInfoService;
import com.jxdinfo.hussar.quote.relation.service.SysQuoteRelationService;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="PageTemplateInfoServiceImpl")
@Conditional(value={ConditionNotSharedStorage.class})
public class PageTemplateInfoServiceImpl
implements PageTemplateInfoService {
    @Resource
    private FileMappingService fileMappingService;
    @Resource
    private SysQuoteRelationService sysQuoteRelationService;
    @Resource
    private PathStrategyService pathStrategy;

    @Override
    public void create(PageTemplateInfo pageTemplateInfo) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStorePageTemplate(new String[0]).getLocalPath();
        String libName = pageTemplateInfo.getPageType();
        String parentPath = libName + File.separator + pageTemplateInfo.getCategory();
        File mateFile = new File(this.relativeToAbsolute(parentPath + File.separator + pageTemplateInfo.getName() + ".meta", rootPath));
        if (FileUtils.exists((File)mateFile)) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, mateFile.getAbsolutePath());
        }
        FileUtils.writeStringToFile((File)mateFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)pageTemplateInfo), (String)"UTF-8", (boolean)false);
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u6a21\u677f\u4e2d\u95f4\u6587\u4ef6\uff1a%s", mateFile.getName()), Collections.singletonList(mateFile.getAbsolutePath()));
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public void updateFileMeta(PageTemplateInfo pageTemplateInfo) throws IOException, LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().projectStorePageTemplate(new String[0]).getLocalPath();
        String libName = pageTemplateInfo.getPageType();
        String parentPath = libName + File.separator + pageTemplateInfo.getCategory();
        File mateFile = new File(this.relativeToAbsolute(parentPath + File.separator + pageTemplateInfo.getName() + ".meta", rootPath));
        if (!FileUtils.exists((File)mateFile)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, pageTemplateInfo.getName());
        }
        FileUtils.writeStringToFile((File)mateFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)pageTemplateInfo), (String)"UTF-8");
        VfgModeTool.pushToRemote((String)String.format("\u4fee\u6539\u65f6\u63d0\u4ea4\u4e2d\u95f4\u6587\u4ef6 .projectStore", new Object[0]), Collections.singletonList(rootPath));
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public void delete(PageTemplateInfo pageTemplateInfo) throws LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().projectStorePageTemplate(new String[0]).getLocalPath();
        String parentPath = pageTemplateInfo.getPageType() + File.separator + pageTemplateInfo.getCategory();
        File mateFile = new File(this.relativeToAbsolute(parentPath + File.separator + pageTemplateInfo.getName() + ".meta", rootPath));
        try {
            FileUtils.forceDelete((File)mateFile);
        }
        catch (IOException e) {
            throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, mateFile.getAbsolutePath());
        }
        VfgModeTool.pushToRemote((String)String.format("\u5220\u9664\u6587\u4ef6\uff1a%s", mateFile.getName()), Collections.singletonList(mateFile.getAbsolutePath()));
        String cover = pageTemplateInfo.getCover();
        if (!"".equals(cover)) {
            this.delCover(cover);
        }
        this.sysQuoteRelationService.deleteQuoteRelationByReferResid(pageTemplateInfo.getName());
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public FormDesignResponse<String> upload(MultipartFile file) throws LcdpException {
        String fileSavePath = this.pathStrategy.resourcePathService().getProjectAndPageTemplateCoverPath();
        FormDesignResponse response = FileUtils.upload((MultipartFile)file, (String)fileSavePath);
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u6a21\u677f\u5c01\u9762\u56fe\u7247\uff1a%s", file.getOriginalFilename()), Collections.singletonList(fileSavePath));
        return response;
    }

    @Override
    public void delCover(String fileName) throws LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().getProjectAndPageTemplateCoverPath();
        File file = new File(ToolUtil.pathFomatterByOS((String)rootPath) + File.separator + fileName);
        if (FileUtils.exists((File)file)) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, file.getAbsolutePath());
            }
            VfgModeTool.pushToRemote((String)String.format("\u5220\u9664\u5c01\u9762\uff1a%s", file.getName()), Collections.singletonList(file.getAbsolutePath()));
            this.fileMappingService.fileMappingCacheEvict();
        }
    }

    @Override
    public ResponseEntity<byte[]> getCover(String fileName) throws IOException, LcdpException {
        String fileSavePath = this.pathStrategy.resourcePathService().getProjectAndPageTemplateCoverPath();
        File file = new File(fileSavePath + File.separator + fileName);
        String ext = fileName.substring(fileName.lastIndexOf(".") + 1);
        MediaType mime = ext.equals("jpg") || ext.equals("JPG") ? MediaType.IMAGE_JPEG : (ext.equals("png") || ext.equals("PNG") ? MediaType.IMAGE_PNG : MediaType.IMAGE_JPEG);
        if (FileUtils.exists((File)file) && !FileUtils.isDirectory((File)file)) {
            byte[] bytes = FileUtils.readFileToByteArray((File)file);
            return ResponseEntity.ok().contentType(mime).body((Object)bytes);
        }
        return null;
    }

    protected String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }
}

