/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.component.service.impl;

import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.component.constant.ComponentType;
import com.jxdinfo.hussar.formdesign.component.model.ComponentInfo;
import com.jxdinfo.hussar.formdesign.component.service.ComponentService;
import com.jxdinfo.hussar.formdesign.component.service.ExtensionComponentService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.operator.PluginOperator;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ExtensionComponentServiceImpl
implements ExtensionComponentService {
    @Autowired(required=false)
    @Lazy
    private PluginOperator pluginOperator;
    @Autowired
    private ComponentService componentService;

    @Override
    public boolean delExtensionComponent(String code) throws Exception {
        ComponentInfo componentInfo = this.getComponentInfo(code);
        if (HussarUtils.isEmpty((Object)componentInfo)) {
            return false;
        }
        this.pluginOperator.uninstall(componentInfo.getPluginId(), false);
        this.componentService.delComponetFile(componentInfo);
        this.delComponentInfoByCode(code);
        ClazzFactory.remove((String)componentInfo.getCode());
        return true;
    }

    public String delComponentInfoByCode(String code) throws IOException {
        String id = null;
        List<ComponentInfo> componentInfos = this.componentService.getComponentInfos(ComponentType.EXTENSION.getValue());
        Iterator<ComponentInfo> iterator = componentInfos.iterator();
        while (iterator.hasNext()) {
            ComponentInfo componentInfo = iterator.next();
            if (!code.equals(componentInfo.getCode())) continue;
            iterator.remove();
            id = componentInfo.getId();
            break;
        }
        if (id == null) {
            return null;
        }
        this.componentService.writeComponentInfos(componentInfos, ComponentType.EXTENSION.getValue());
        return id;
    }

    public ComponentInfo getComponentInfo(String code) throws IOException {
        List<ComponentInfo> componentInfos = this.componentService.getComponentInfos(ComponentType.EXTENSION.getValue());
        for (ComponentInfo componentInfo : componentInfos) {
            if (!code.equals(componentInfo.getCode())) continue;
            return componentInfo;
        }
        return null;
    }
}

