/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.component.service.impl;

import com.jxdinfo.hussar.formdesign.component.constant.ComponentType;
import com.jxdinfo.hussar.formdesign.component.model.ComponentCategoryInfo;
import com.jxdinfo.hussar.formdesign.component.model.ComponentGroupInfo;
import com.jxdinfo.hussar.formdesign.component.model.ComponentInfo;
import com.jxdinfo.hussar.formdesign.component.service.ComponentCategoryService;
import com.jxdinfo.hussar.formdesign.component.service.ComponentGroupService;
import com.jxdinfo.hussar.formdesign.component.service.ComponentService;
import com.jxdinfo.hussar.formdesign.component.service.CustomComponentService;
import com.jxdinfo.hussar.formdesign.component.service.ExtensionComponentService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ComponentGroupServiceImpl
implements ComponentGroupService {
    @Autowired
    private ComponentService componentService;
    @Autowired
    private ExtensionComponentService extensionComponentService;
    @Autowired
    private CustomComponentService customComponentService;
    @Autowired
    private ComponentCategoryService componentCategoryService;

    @Override
    public boolean delGroup(ComponentGroupInfo componentGroupInfo) throws Exception {
        List<ComponentInfo> componentInfos = this.componentService.getComponentInfos(ComponentType.EXTENSION.getValue());
        for (ComponentInfo componentInfo : componentInfos) {
            if (!componentInfo.getCategory().equals(componentGroupInfo.getName())) continue;
            this.extensionComponentService.delExtensionComponent(componentInfo.getCode());
        }
        componentInfos = this.componentService.getComponentInfos(ComponentType.CUSTOM.getValue());
        for (ComponentInfo componentInfo : componentInfos) {
            if (!componentInfo.getCategory().equals(componentGroupInfo.getName())) continue;
            this.customComponentService.delCustomComponent(componentInfo.getId());
        }
        ComponentCategoryInfo componentCategoryInfo = null;
        List<ComponentCategoryInfo> componentCategoryInfos = this.componentCategoryService.getAllComponentCategoryInfo(componentGroupInfo.getLibName());
        for (ComponentCategoryInfo categoryInfo : componentCategoryInfos) {
            if (!categoryInfo.getName().equals(componentGroupInfo.getCompPanelCategory())) continue;
            componentCategoryInfo = categoryInfo;
            break;
        }
        if (HussarUtils.isEmpty(componentCategoryInfo)) {
            return false;
        }
        componentCategoryInfo.getChildren().removeIf(groupInfo -> groupInfo.getName().equals(componentGroupInfo.getName()));
        this.componentCategoryService.addCategory(componentCategoryInfo);
        return true;
    }
}

