/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.printTemplate.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.formdesign.printTemplate.service.PrintTemplateService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.template.print.dto.PublishTemplateDto;
import com.jxdinfo.hussar.template.print.model.SysTemplatePrintInfo;
import com.jxdinfo.hussar.template.print.service.ISysTemplatePrintInfoService;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PrintTemplateServiceImpl
implements PrintTemplateService {
    private static final Logger logger = LoggerFactory.getLogger(PrintTemplateServiceImpl.class);
    @Autowired
    PageInfoService pageInfoService;
    @Autowired
    PathStrategyService pathStrategyService;
    @Autowired(required=false)
    ISysTemplatePrintInfoService iSysTemplatePrintInfoService;

    @Override
    public void publishPrintTemplate(PublishCtx<CodeResult> publishCtx, String id) {
        Map printTemplate;
        ArrayList<Map> projectTemplatePrintInfos = new ArrayList<Map>();
        if (HussarUtils.isNotEmpty((Object)publishCtx.getParams()) && ToolUtil.isNotEmpty((Object)(printTemplate = (Map)publishCtx.getParams().get("printTemplate")))) {
            for (Object key : printTemplate.keySet()) {
                Map map = (Map)printTemplate.get(key);
                map.put("templateId", key);
                map.put("pageId", id);
                projectTemplatePrintInfos.add(map);
            }
        }
        List sysTemplatePrintInfoList = this.iSysTemplatePrintInfoService.getTemplateListByPageId(id);
        ArrayList<JSONObject> sysTemplatePrintInfos = new ArrayList<JSONObject>();
        if (ToolUtil.isNotEmpty((Object)sysTemplatePrintInfoList)) {
            for (SysTemplatePrintInfo sysTemplatePrintInfo : sysTemplatePrintInfoList) {
                sysTemplatePrintInfos.add((JSONObject)JSONObject.toJSON((Object)sysTemplatePrintInfo));
            }
        }
        String rootPath = this.pathStrategyService.resourcePathService().projectStorePrintTemplate(new String[0]).getLocalPath();
        HashMap<String, Map> tempMapA = new HashMap<String, Map>();
        HashMap<String, Map> tempMapB = new HashMap<String, Map>();
        HashMap<String, Map> tempMapC = new HashMap<String, Map>();
        for (Map map : projectTemplatePrintInfos) {
            tempMapA.put(String.valueOf(map.get("templateId")), map);
        }
        for (Map map : sysTemplatePrintInfos) {
            tempMapB.put(String.valueOf(map.get("templateId")), map);
        }
        ArrayList<Long> removed = new ArrayList<Long>();
        for (Map obj : tempMapB.values()) {
            if (tempMapA.containsKey(String.valueOf(obj.get("templateId")))) continue;
            removed.add(Long.valueOf(String.valueOf(obj.get("templateId"))));
            tempMapC.put(String.valueOf(obj.get("templateId")), obj);
        }
        ArrayList<Map> arrayList = new ArrayList<Map>();
        PublishTemplateDto publishTemplateDto = new PublishTemplateDto();
        HashMap<String, byte[]> templateDatas = new HashMap<String, byte[]>();
        for (Map obj : tempMapA.values()) {
            if (tempMapC.containsKey(String.valueOf(obj.get("templateId")))) continue;
            File file = new File(FileUtil.posixPath((String[])new String[]{rootPath, String.valueOf(obj.get("templatePath"))}));
            try (FileInputStream fis = new FileInputStream(file);
                 ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);){
                int n;
                byte[] b = new byte[1024];
                while ((n = fis.read(b)) != -1) {
                    bos.write(b, 0, n);
                }
                byte[] data = bos.toByteArray();
                templateDatas.put(FileUtil.posixPath((String[])new String[]{rootPath, String.valueOf(obj.get("templatePath"))}), data);
                obj.put("data", data);
                obj.put("absolute", FileUtil.posixPath((String[])new String[]{rootPath, String.valueOf(obj.get("templatePath"))}));
                obj.put("fileName", file.getName());
            }
            catch (IOException e) {
                logger.error("\u6a21\u677f\u6587\u4ef6\u8f6c\u5b57\u8282\u5931\u8d25{}", (Object)e.getMessage());
            }
            obj.put("relative", obj.get("templatePath"));
            arrayList.add(obj);
        }
        publishTemplateDto.setTemplateDatas(templateDatas);
        HashMap<String, ArrayList<Object>> params = new HashMap<String, ArrayList<Object>>();
        params.put("removed", removed);
        params.put("added", arrayList);
        publishTemplateDto.setParams(params);
        this.iSysTemplatePrintInfoService.processTemplates(publishTemplateDto);
    }

    @Override
    public Map<String, Object> uploadPrintTemplate(MultipartFile file) throws IOException {
        String fileName = file.getOriginalFilename();
        HashMap<String, Object> map = new HashMap<String, Object>();
        InputStream is = file.getInputStream();
        map.put("size", file.getSize());
        map.put("fileName", fileName);
        String templateId = String.valueOf(IdWorker.getId((Object)new SysTemplatePrintInfo()));
        String rootPath = this.pathStrategyService.resourcePathService().projectStorePrintTemplate(new String[0]).getLocalPath();
        String templatePath = FileUtil.posixPath((String[])new String[]{templateId, fileName});
        return this.saveFile(is, rootPath, templatePath, map);
    }

    @Override
    public void printTemplateDownload(HttpServletResponse response, String templatePath, String fileName) throws IOException {
        InputStream inputStream;
        if (ToolUtil.isEmpty((Object)templatePath)) {
            templatePath = "/printTemplate/defaultTemplate.docx";
            fileName = "defaultTemplate.docx";
            inputStream = this.getClass().getResourceAsStream(templatePath);
        } else {
            File file = new File(FileUtil.posixPath((String[])new String[]{this.pathStrategyService.resourcePathService().projectStorePrintTemplate(new String[0]).getLocalPath(), templatePath}));
            if (!file.exists()) {
                System.out.println("\u6587\u4ef6\u4e0d\u5b58\u5728: " + file.getPath());
                return;
            }
            inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        if (inputStream != null) {
            int bytesRead;
            response.setContentType("multipart/form-data");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
            byte[] buffer = new byte[1024];
            BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
                outputStream.flush();
            }
            inputStream.close();
            outputStream.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> saveFile(InputStream inputStream, String rootPath, String templatePath, Map<String, Object> map) {
        String uploadDir = FileUtil.posixPath((String[])new String[]{rootPath, templatePath});
        File uploadDirFile = new File(uploadDir);
        if (!uploadDirFile.getParentFile().exists()) {
            uploadDirFile.getParentFile().mkdirs();
        }
        try (FileOutputStream outputStream = new FileOutputStream(FileUtil.posixPath((String[])new String[]{rootPath, templatePath}));){
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            inputStream.close();
            outputStream.close();
            map.put("templatePath", templatePath);
            Map<String, Object> map2 = map;
            return map2;
        }
        catch (IOException e) {
            logger.error("\u4fdd\u5b58\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
            return new HashMap<String, Object>();
        }
    }
}

