/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.util;

import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.DigestUtils;
import org.springframework.util.ResourceUtils;

public class ZipUtil {
    private static final Logger logger = LoggerFactory.getLogger(ZipUtil.class);

    public static void zip(String sourceFileName, String zipFileName) throws Exception {
        logger.info("\u5f00\u59cb\u538b\u7f29...");
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFileName));
        File sourceFile = new File(sourceFileName);
        ZipUtil.compress(out, sourceFile, "");
        out.close();
        logger.info("\u538b\u7f29\u5b8c\u6210\uff01");
    }

    public static void zipForLocal(String sourceFileName, String zipFileName) throws Exception {
        logger.info("\u5f00\u59cb\u538b\u7f29...");
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFileName));
        File sourceFile = new File(sourceFileName);
        ZipUtil.compressForLocal(out, sourceFile, "");
        out.close();
        logger.info("\u538b\u7f29\u5b8c\u6210\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressForLocal(ZipOutputStream out, File sourceFile, String base) throws IOException {
        block17: {
            block16: {
                if (!sourceFile.isDirectory()) break block16;
                File[] flist = sourceFile.listFiles();
                if (flist == null) break block17;
                if (flist.length == 0) {
                    logger.info(base + "/");
                    out.putNextEntry(new ZipEntry(base + "/"));
                } else {
                    for (File file : flist) {
                        ZipUtil.compressForLocal(out, file, base + "/" + file.getName());
                    }
                }
                break block17;
            }
            out.putNextEntry(new ZipEntry(base));
            FileInputStream fos = new FileInputStream(sourceFile);
            BufferedInputStream bis = new BufferedInputStream(fos);
            try {
                int len;
                byte[] buf = new byte[1024];
                logger.info(base);
                while ((len = bis.read(buf, 0, 1024)) != -1) {
                    out.write(buf, 0, len);
                }
            }
            catch (IOException e) {
                logger.error("\u538b\u7f29\u5931\u8d25", (Throwable)e);
            }
            finally {
                try {
                    if (HussarUtils.isNotEmpty((Object)bis)) {
                        bis.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(ZipOutputStream out, File sourceFile, String base) throws IOException {
        block17: {
            block16: {
                if (!FileUtils.isDirectory((File)sourceFile)) break block16;
                File[] flist = FileUtils.listFiles((File)sourceFile);
                if (flist == null) break block17;
                if (flist.length == 0) {
                    logger.info(base + "/");
                    out.putNextEntry(new ZipEntry(base + "/"));
                } else {
                    for (File file : flist) {
                        ZipUtil.compress(out, file, base + "/" + file.getName());
                    }
                }
                break block17;
            }
            out.putNextEntry(new ZipEntry(base));
            FileInputStream fos = new FileInputStream(sourceFile);
            BufferedInputStream bis = new BufferedInputStream(fos);
            try {
                int len;
                byte[] buf = new byte[1024];
                logger.info(base);
                while ((len = bis.read(buf, 0, 1024)) != -1) {
                    out.write(buf, 0, len);
                }
            }
            catch (IOException e) {
                logger.error("\u538b\u7f29\u5931\u8d25", (Throwable)e);
            }
            finally {
                try {
                    if (HussarUtils.isNotEmpty((Object)bis)) {
                        bis.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(ZipOutputStream out, InputStream is, String fileName) throws IOException {
        out.putNextEntry(new ZipEntry(fileName));
        BufferedInputStream bis = new BufferedInputStream(is);
        byte[] buf = new byte[1024];
        try {
            int len;
            while ((len = bis.read(buf, 0, 1024)) != -1) {
                out.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            logger.error(fileName + "\u538b\u7f29\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (HussarUtils.isNotEmpty((Object)bis)) {
                bis.close();
            }
            if (HussarUtils.isNotEmpty((Object)is)) {
                is.close();
            }
        }
    }

    public static String getMd5(String path) {
        String md5 = null;
        try (FileInputStream inputStream = new FileInputStream(ResourceUtils.getFile((String)path));){
            md5 = DigestUtils.md5DigestAsHex((InputStream)inputStream);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return md5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zips(List<String> sourceFileNames, Map<String, String> outFileNames, OutputStream outputStream) {
        logger.info("\u538b\u7f29\u5f00\u59cb...");
        ZipOutputStream out = new ZipOutputStream(outputStream);
        try {
            for (String sourceFileName : sourceFileNames) {
                File sourceFile = new File(sourceFileName);
                ZipUtil.compress(out, sourceFile, outFileNames.get(sourceFileName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (HussarUtils.isNotEmpty((Object)out)) {
                    out.flush();
                }
                if (HussarUtils.isNotEmpty((Object)out)) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        logger.info("\u538b\u7f29\u5b8c\u6210!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zips(Map<String, InputStream> inputStreamMap, OutputStream outputStream) throws IOException {
        ZipOutputStream out = new ZipOutputStream(outputStream);
        try {
            for (String fileName : inputStreamMap.keySet()) {
                ZipUtil.compress(out, inputStreamMap.get(fileName), fileName);
            }
            out.flush();
        }
        catch (IOException e) {
            logger.error("\u538b\u7f29\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (HussarUtils.isNotEmpty((Object)out)) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Charset getFileCharset(InputStream is) {
        ZipInputStream zis = new ZipInputStream(is, Charset.forName("UTF-8"));
        boolean flag = false;
        try {
            while (zis.getNextEntry() != null) {
            }
        }
        catch (IOException | IllegalArgumentException e) {
            flag = true;
        }
        finally {
            try {
                if (HussarUtils.isNotEmpty((Object)is)) {
                    is.close();
                }
                if (HussarUtils.isNotEmpty((Object)zis)) {
                    zis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Charset charset = flag ? Charset.forName("GBK") : Charset.forName("UTF-8");
        return charset;
    }
}

