/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageTemplateFileTreeService;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="PageTemplateFileTreeServiceImpl")
@Conditional(value={ConditionNotSharedStorage.class})
public class PageTemplateFileTreeServiceImpl
implements PageTemplateFileTreeService {
    private final FormDesignProperties formDesignProperties;
    private final PathStrategyService pathStrategy;

    @Autowired
    public PageTemplateFileTreeServiceImpl(FormDesignProperties formDesignProperties, PathStrategyService pathStrategy) {
        this.formDesignProperties = formDesignProperties;
        this.pathStrategy = pathStrategy;
    }

    @Override
    public FormDesignResponse<List<JSONObject>> getFileTree(String libName) throws IOException {
        FormDesignResponse response = new FormDesignResponse();
        File file = new File(ToolUtil.pathFomatterByOS((String)(this.pathStrategy.resourcePathService().projectStorePageTemplate(new String[0]).getLocalPath() + File.separator + libName)));
        List<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        if (!FileUtils.exists((File)file)) {
            return response;
        }
        ArrayList<String> errorFiles = new ArrayList<String>();
        this.iterator(jsonObjects, file, errorFiles);
        String errStr = String.valueOf(errorFiles);
        errStr = errStr.substring(1, errStr.length() - 1);
        response.setErrorMsg(errStr);
        System.out.println(errStr);
        jsonObjects = this.treeSort(jsonObjects);
        response.setData(jsonObjects);
        return response;
    }

    private void iterator(List<JSONObject> jsonObjects, File file, List<String> errorFiles) throws IOException {
        File[] files;
        if (FileUtils.isDirectory((File)file) && ToolUtil.isNotEmpty((Object)(files = FileUtils.listFiles((File)file)))) {
            for (File file1 : files) {
                if (FileUtils.isDirectory((File)file1)) {
                    File mataFile = new File(file1.getAbsolutePath() + ".meta");
                    this.iterator(jsonObjects, file1, errorFiles);
                    continue;
                }
                JSONObject jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)file1, (String)"UTF-8"));
                if (jsonObject == null) {
                    errorFiles.add("\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38\uff1a" + file1.getAbsolutePath());
                    continue;
                }
                if (jsonObject.get((Object)"data") != null) {
                    jsonObject.put("data", (Object)jsonObject.get((Object)"data").toString());
                }
                jsonObjects.add(jsonObject);
                String type = jsonObject.getString("type");
                if (!ToolUtil.isNotEmpty((Object)type) || !"DataModel".equals(type)) continue;
                JSONObject dataJsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)file1, (String)"UTF-8"));
                jsonObject.put("data", (Object)dataJsonObject);
            }
        }
    }

    private List<JSONObject> treeSort(List<JSONObject> jsonObjects) {
        final Collator collator = Collator.getInstance();
        jsonObjects.sort(new Comparator<JSONObject>(){
            private static final String ORDER_FIELD = "label";

            @Override
            public int compare(JSONObject a, JSONObject b) {
                String labelA = "";
                String labelB = "";
                try {
                    if ("category".equals(a.getString("fileType"))) {
                        labelA = a.getString(ORDER_FIELD);
                    }
                    if ("category".equals(b.getString("fileType"))) {
                        labelB = b.getString(ORDER_FIELD);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                return collator.compare(labelA, labelB);
            }
        });
        for (JSONObject jsonObject : jsonObjects) {
            if (!"category".equals(jsonObject.getString("fileType")) || !"defaultCategory".equals(jsonObject.getString("name"))) continue;
            jsonObjects.remove(jsonObject);
            jsonObjects.add(0, jsonObject);
            break;
        }
        return jsonObjects;
    }
}

