/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.ComponentGroupConfig;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.ComponentGroupConfigService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl.BaseFileServiceImpl;
import java.io.File;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ComponentGroupConfigServiceImpl
extends BaseFileServiceImpl<ComponentGroupConfig>
implements ComponentGroupConfigService {
    private static final String configSuffix = ".ccf";
    private static String configStore = "";

    @Autowired
    public ComponentGroupConfigServiceImpl(FormDesignProperties speedCodeProperties) {
        String projectPath = this.getPathStr(speedCodeProperties.getProjectPath());
        String projectStoreDir = this.getPathStr(speedCodeProperties.getProjectRootPath());
        configStore = projectPath + projectStoreDir + File.separator;
    }

    @Override
    public String create(ComponentGroupConfig baseFile) throws LcdpException {
        String absolutePath = configStore + baseFile.getName() + configSuffix;
        String version = this.lcdpVersionProperties.getLcdpVersion();
        baseFile.setVersion(version);
        this.write(new File(absolutePath), baseFile);
        return version;
    }

    @Override
    public void updateFile(ComponentGroupConfig baseFile) throws LcdpException {
        this.create(baseFile);
    }

    @Override
    public ComponentGroupConfig get(String id) throws LcdpException {
        String absolutePath = configStore + id + configSuffix;
        File file = new File(absolutePath);
        if (!FileUtils.exists((File)file)) {
            return null;
        }
        return (ComponentGroupConfig)((Object)this.readFileToObject(absolutePath));
    }

    @Override
    public void delete(String id) throws IOException {
        String absolutePath = configStore + id + configSuffix;
        FileUtils.forceDelete((File)new File(absolutePath));
    }

    private String getPathStr(String str) {
        if (str.endsWith(File.separator)) {
            str = str.substring(0, str.length() - 1);
        }
        if (!str.startsWith(File.separator)) {
            str = File.separator + str;
        }
        return str;
    }
}

