/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.constant.FileConstant;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.WorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.model.refer.PageRefer;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.BaseFileService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.util.ParamPaserUtil;
import com.jxdinfo.hussar.formdesign.properties.LcdpVersionProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.godaxe.model.GodAxeModelService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.core.env.Environment;

public class BaseFileServiceImpl<T extends BaseFile>
implements BaseFileService<T> {
    protected PathStrategyService pathStrategy = (PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class);
    protected FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    protected FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    protected Environment environment = (Environment)SpringContextHolder.getBean(Environment.class);
    protected GodAxeModelService godAxeModelService = (GodAxeModelService)SpringContextHolder.getBean(GodAxeModelService.class);
    protected LcdpVersionProperties lcdpVersionProperties = (LcdpVersionProperties)SpringContextHolder.getBean(LcdpVersionProperties.class);
    public static final String WPD_EXTENDSCHEMA_KEY = "extendSchema";
    public static final String DBD_EXTENDSCHEMA_KEY = "extendSchema";

    protected BaseFileServiceImpl() {
    }

    @Override
    public String create(T baseFile) throws LcdpException, IOException {
        File file;
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String parentPath = "";
        if (!ToolUtil.isEmpty((Object)baseFile.getParentId()) && !"#".equals(baseFile.getParentId())) {
            parentPath = this.getDataPath(baseFile.getParentId());
        }
        if (FileUtils.exists((File)(file = new File(this.relativeToAbsolute(parentPath + File.separator + baseFile.getName() + FileUtil.transFileSuffix((String)baseFile.getType()), rootPath)))) && file.getPath().equals(file.getCanonicalPath())) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, file.getAbsolutePath());
        }
        File metaFile = new File(file.getAbsolutePath() + ".meta");
        if (FileUtils.exists((File)metaFile) && metaFile.getPath().equals(metaFile.getCanonicalPath())) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, metaFile.getAbsolutePath());
        }
        this.fileMappingService.fileMappingCacheEvict();
        String version = this.lcdpVersionProperties.getLcdpVersion();
        baseFile.setVersion(version);
        this.write(file, (BaseFile)baseFile);
        return version;
    }

    @Override
    public void createMultiple(List<T> baseFiles) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        for (BaseFile baseFile : baseFiles) {
            File file;
            String parentPath = "";
            if (!ToolUtil.isEmpty((Object)baseFile.getParentId()) && !"#".equals(baseFile.getParentId())) {
                parentPath = this.getDataPath(baseFile.getParentId());
            }
            if (FileUtils.exists((File)(file = new File(this.relativeToAbsolute(parentPath + File.separator + baseFile.getName() + FileUtil.transFileSuffix((String)baseFile.getType()), rootPath)))) && file.getPath().equals(file.getCanonicalPath())) {
                throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, file.getAbsolutePath());
            }
            File metaFile = new File(file.getAbsolutePath() + ".meta");
            if (FileUtils.exists((File)metaFile) && metaFile.getPath().equals(metaFile.getCanonicalPath())) {
                throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, metaFile.getAbsolutePath());
            }
            this.write(file, baseFile);
        }
        this.fileMappingService.fileMappingCacheEvict();
    }

    private void updateConfig(T baseFile) throws IOException, LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String path = this.getDataPath(baseFile.getId());
        File file = new File(this.relativeToAbsolute(path, rootPath));
        File metaFile = new File(this.addMeta(file.getAbsolutePath()));
        if (!FileUtils.exists((File)file)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, baseFile.getId());
        }
        if (!FileUtils.exists((File)metaFile)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, baseFile.getId());
        }
        this.writeSingleFile(file, JSONObject.parseObject((String)baseFile.getData()));
        this.fileMappingService.fileMappingCacheEvict();
    }

    private FormDesignResponse<Void> packageDist(String id, String projectPath, String mobileProjectPath) throws IOException, LcdpException {
        String line;
        FormDesignResponse response = new FormDesignResponse();
        StringBuilder sb = new StringBuilder();
        String framePath = this.getDataPath(id);
        if (ToolUtil.isEmpty((Object)framePath)) {
            response.setErrorMsg("\u6ca1\u6709\u914d\u7f6e\u6846\u67b6\u9875\uff01");
            response.setErrorCode(500);
            return response;
        }
        String currPath = projectPath + "\\cmd\\package.bat";
        File file = new File(currPath);
        ArrayList<String> cmdS = new ArrayList<String>();
        cmdS.add("cd " + mobileProjectPath);
        cmdS.add("npm run build");
        FileUtils.writeLines((File)file, (String)"utf-8", cmdS);
        Process child = Runtime.getRuntime().exec(currPath);
        InputStream inputStream = child.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        while ((line = bufferedReader.readLine()) != null) {
            sb.append(line).append("\n");
        }
        inputStream.close();
        if (!FileUtils.exists((File)new File(mobileProjectPath + "\\node_modules"))) {
            response.setErrorMsg("\u6253\u5305\u5931\u8d25\uff0c\u8bf7\u5148\u4e0b\u8f7d\u4f9d\u8d56\uff01");
            response.setErrorCode(500);
            return response;
        }
        return response;
    }

    @Override
    public void delete(String id) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        if (ToolUtil.isEmpty((Object)id)) {
            throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, id);
        }
        String path = this.getDataPath(id);
        try {
            File file = new File(this.relativeToAbsolute(path, rootPath));
            FileUtils.forceDelete((File)file);
            FileUtils.forceDelete((File)new File(this.addMeta(file.getAbsolutePath())));
            if (AppContextUtil.isExtension()) {
                File fileExtend;
                File extFile = new File(this.addExt(file.getAbsolutePath()));
                if (FileUtils.exists((File)extFile)) {
                    FileUtils.forceDelete((File)extFile);
                }
                if ((fileExtend = new File(this.addExtendPage(file.getAbsolutePath()))).exists()) {
                    FileUtils.forceDelete((File)fileExtend);
                }
            }
            VfgModeTool.pushToRemote((String)String.format("\u5220\u9664\u65f6\u63d0\u4ea4\u4e2d\u95f4\u6587\u4ef6 .projectStore", new Object[0]), Collections.singletonList(rootPath));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, path);
        }
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public void updateFile(T baseFile) throws IOException, LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String path = this.getDataPath(baseFile.getId());
        File file = new File(this.relativeToAbsolute(path, rootPath));
        File metaFile = new File(this.addMeta(file.getAbsolutePath()));
        if (!FileUtils.exists((File)file)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, baseFile.getId());
        }
        if (!FileUtils.exists((File)metaFile)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, baseFile.getId());
        }
        boolean needRename = this.justRename((BaseFile)baseFile, metaFile);
        JSONObject jsonObjectData = JSONObject.parseObject((String)baseFile.getData());
        if (AppContextUtil.isExtension() && jsonObjectData.containsKey((Object)"extendSchema")) {
            JSONObject extendJsonObject = (JSONObject)jsonObjectData.get((Object)"extendSchema");
            jsonObjectData.put("extendSchema", null);
            this.updateExtendFile(extendJsonObject, baseFile, rootPath);
        }
        this.writeSingleFile(file, jsonObjectData);
        baseFile.setData(null);
        this.writeSingleFile(metaFile, (JSONObject)JSONObject.toJSON(baseFile));
        if (needRename) {
            this.renameTwoFile((BaseFile)baseFile, file, metaFile, rootPath);
            this.renameExtendFileByPath(baseFile, rootPath);
        }
        this.fileMappingService.fileMappingCacheEvict();
    }

    private void updateExtendFile(JSONObject extendJsonObject, T baseFile, String rootPath) throws IOException, LcdpException {
        String extendPath = this.getDataExtendPath(baseFile.getId());
        File extendFile = new File(this.relativeToAbsolute(extendPath, rootPath));
        if (!extendFile.exists()) {
            FileUtils.createNewFile((File)extendFile);
        }
        this.writeSingleFile(extendFile, extendJsonObject);
    }

    @Override
    public JSONObject updateFileNew(T baseFile) throws IOException, LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String path = this.getDataPath(baseFile.getId());
        File file = new File(this.relativeToAbsolute(path, rootPath));
        if (!FileUtils.exists((File)file)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, baseFile.getId());
        }
        String data = baseFile.getData();
        JSONObject jsonObject = JSONObject.parseObject((String)data);
        Object referencesObj = jsonObject.get((Object)"references");
        if (ToolUtil.isNotEmpty((Object)referencesObj)) {
            JSONArray referArray = JSON.parseArray((String)JSON.toJSONString((Object)referencesObj));
            PageRefer pageRefer = (PageRefer)JSON.parseObject((String)JSON.toJSONString((Object)referArray.get(0)), PageRefer.class);
            String referPath = pageRefer.getReferPath();
            String name = referPath.split("\\.")[0];
            data.replaceAll(name, baseFile.getId());
            jsonObject = JSON.parseObject((String)data);
        }
        this.writeSingleFile(file, jsonObject);
        this.fileMappingService.fileMappingCacheEvict();
        return jsonObject;
    }

    @Override
    public void updateFileData(T baseFile) throws IOException, LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String path = this.getDataPath(baseFile.getId());
        File file = new File(this.relativeToAbsolute(path, rootPath));
        File metaFile = new File(this.addMeta(file.getAbsolutePath()));
        if (!FileUtils.exists((File)file)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, baseFile.getId());
        }
        boolean needRename = this.justRename((BaseFile)baseFile, metaFile);
        if (AppContextUtil.isExtension() && "DataModel".equals(baseFile.getType())) {
            JSONObject data = JSONObject.parseObject((String)baseFile.getData());
            if (HussarUtils.isNotEmpty((Object)data) && Boolean.TRUE.equals(data.get((Object)"extension"))) {
                this.writeSingleFile(file, data);
            } else {
                Object extData;
                Object object = extData = HussarUtils.isNotEmpty((Object)data) ? data.get((Object)"extendSchema") : null;
                if (HussarUtils.isNotEmpty((Object)extData)) {
                    file = new File(file + ".ext");
                    this.writeExtFile(file, JSONObject.parseObject((String)extData.toString()));
                }
            }
        } else {
            this.writeSingleFile(file, JSONObject.parseObject((String)baseFile.getData()));
        }
        baseFile.setData(null);
        this.writeSingleFile(metaFile, (JSONObject)JSONObject.toJSON(baseFile));
        if (needRename) {
            this.renameTwoFile((BaseFile)baseFile, file, metaFile, rootPath);
        }
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public void addOrUpdateFileData(T baseFile) throws IOException, LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String parentPath = "";
        if (!ToolUtil.isEmpty((Object)baseFile.getParentId()) && !"#".equals(baseFile.getParentId())) {
            parentPath = this.getDataPath(baseFile.getParentId());
        }
        File file = "Frame".equals(baseFile.getType()) ? new File(this.relativeToAbsolute("frame" + File.separator + baseFile.getName() + ".fwd", rootPath)) : new File(this.relativeToAbsolute(parentPath + File.separator + baseFile.getName() + FileUtil.transFileSuffix((String)baseFile.getType()), rootPath));
        File metaFile = new File(file.getAbsolutePath() + ".meta");
        if (FileUtils.exists((File)file) && file.getPath().equals(file.getCanonicalPath())) {
            this.updateFileData(baseFile);
        }
        if (FileUtils.exists((File)metaFile) && metaFile.getPath().equals(metaFile.getCanonicalPath())) {
            this.updateFileMeta(baseFile);
        }
        if (!FileUtils.exists((File)file) || !FileUtils.exists((File)metaFile)) {
            this.fileMappingService.fileMappingCacheEvict();
            this.write(file, (BaseFile)baseFile);
        }
    }

    @Override
    public void updateFileCommonModelData(T baseFile) throws LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().projectStore(new String[0]).getLocalPath() + "/common_model";
        File file = new File(rootPath + "/" + baseFile.getId() + ".dbd");
        File metaFile = new File(file + ".meta");
        if (!FileUtils.exists((File)file)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, baseFile.getId());
        }
        boolean needRename = this.justRename((BaseFile)baseFile, metaFile);
        this.writeSingleFile(file, JSONObject.parseObject((String)baseFile.getData()));
        baseFile.setData(null);
        this.writeSingleFile(metaFile, (JSONObject)JSONObject.toJSON(baseFile));
    }

    @Override
    public void updateFileMeta(T baseFile) throws IOException, LcdpException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String path = this.getMetaPath(baseFile.getId());
        String dataPath = this.getDataPath(baseFile.getId());
        File metaFile = new File(this.relativeToAbsolute(path, rootPath));
        if (!FileUtils.exists((File)metaFile)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, baseFile.getId());
        }
        baseFile.setData(null);
        boolean needRename = this.justRename((BaseFile)baseFile, metaFile);
        this.writeSingleFile(metaFile, (JSONObject)JSONObject.toJSON(baseFile));
        if (needRename) {
            this.renameTwoFile((BaseFile)baseFile, new File(this.relativeToAbsolute(dataPath, rootPath)), metaFile, rootPath);
            this.renameExtendFileByPath(baseFile, rootPath);
        }
        this.fileMappingService.fileMappingCacheEvict();
    }

    private void renameExtendFileByPath(T baseFile, String rootPath) throws LcdpException, IOException {
        String extendPath = this.getDataExtendPath(baseFile.getId());
        File extendFile = new File(this.relativeToAbsolute(extendPath, rootPath));
        if (extendFile.exists()) {
            this.renameExtendFile((BaseFile)baseFile, extendFile, rootPath);
        }
    }

    @Override
    public void update(BaseFile baseFile) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String path = this.getDataPath(baseFile.getId());
        File file = new File(this.relativeToAbsolute(path, rootPath));
        File metaFile = new File(file.getAbsolutePath() + ".meta");
        boolean needRename = this.justRename(baseFile, metaFile);
        this.write(file, baseFile);
        if (needRename) {
            this.renameTwoFile(baseFile, file, metaFile, rootPath);
        }
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public T get(String id) throws LcdpException, IOException {
        String rootPath = "dict".equals(id) ? this.pathStrategy.resourcePathService().projectStore(new String[0]).getLocalPath() : this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String path = this.getDataPath(id);
        return this.readFileToObject(ToolUtil.pathFomatterByOS((String)(rootPath + File.separator + path)));
    }

    @Override
    public JSONObject getCrossApp(String appId, String fileId) throws LcdpException, IOException {
        String FORM_URL = "formURL";
        String rootPath = this.buildRootPath(appId, fileId);
        if (HussarUtils.isEmpty((Object)appId)) {
            JSONObject jsonObject = (JSONObject)JSONObject.toJSON(this.get(fileId));
            jsonObject.put("formURL", (Object)this.fileMappingService.getFormatPath(fileId));
            return jsonObject;
        }
        String dataPath = this.fileMappingService.getDataPath(fileId);
        T fileContent = this.readFileToObject(ToolUtil.pathFomatterByOS((String)(rootPath + File.separator + dataPath)));
        JSONObject jsonObject = (JSONObject)JSONObject.toJSON(fileContent);
        String formatPath = this.formatFilePath(dataPath);
        jsonObject.put("formURL", (Object)formatPath);
        return jsonObject;
    }

    @Override
    public void move(String id, String parentId, String newName, String newDesc) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String path = this.getDataPath(id);
        String parentPath = this.getDataPath(parentId);
        File from = new File(this.relativeToAbsolute(path, rootPath));
        File metaFrom = new File(from.getAbsolutePath() + ".meta");
        File to = new File(this.relativeToAbsolute(parentPath, rootPath));
        if (!FileUtils.isFile((File)from)) {
            throw new LcdpException(LcdpExceptionEnum.NO_FILE, from.getAbsolutePath());
        }
        if (!FileUtils.isDirectory((File)to)) {
            throw new LcdpException(LcdpExceptionEnum.NO_DIRECTORY, to.getAbsolutePath());
        }
        JSONObject metaFileContent = JSONObject.parseObject((String)FileUtils.readFileToString((File)metaFrom, (String)"UTF-8"));
        String type = (String)metaFileContent.get((Object)"type");
        String suffix = FileConstant.transFileSuffix((String)type);
        File newMetaFile = null;
        if (newName != null && !"".equals(newName)) {
            to = new File(this.relativeToAbsolute(parentPath + File.separator + newName + suffix, rootPath));
            File metaTo = new File(to.getAbsolutePath() + ".meta");
            if (!FileUtils.exists((File)to) && !FileUtils.exists((File)metaTo)) {
                try {
                    FileUtils.moveFile((File)from, (File)to);
                    FileUtils.moveFile((File)metaFrom, (File)metaTo);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, from.getAbsolutePath());
                }
            }
            newMetaFile = metaTo;
        } else {
            try {
                FileUtils.moveFileToDirectory((File)from, (File)to, (boolean)false);
                FileUtils.moveFileToDirectory((File)metaFrom, (File)to, (boolean)false);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, from.getAbsolutePath());
            }
            newMetaFile = new File(to + File.separator + metaFrom.getName());
        }
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)newMetaFile, (String)"UTF-8"));
            jsonObject.put("parentId", (Object)parentId);
            if (newName != null) {
                jsonObject.put("name", (Object)newName);
            }
            if (newDesc != null) {
                jsonObject.put("desc", (Object)newDesc);
            }
            FileUtils.writeStringToFile((File)newMetaFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, from.getAbsolutePath());
        }
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u4e2d\u95f4\u6587\u4ef6 .projectStore", new Object[0]), Collections.singletonList(rootPath));
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public void copy(String id, String parentId, String newId, String newName, String newDesc) throws LcdpException, IOException {
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String path = this.getDataPath(id);
        String parentPath = this.getDataPath(parentId);
        File from = new File(this.relativeToAbsolute(path, rootPath));
        File metaFrom = new File(from.getAbsolutePath() + ".meta");
        File to = new File(this.relativeToAbsolute(parentPath, rootPath));
        if (!FileUtils.isFile((File)from)) {
            throw new LcdpException(LcdpExceptionEnum.NO_FILE, from.getAbsolutePath());
        }
        if (!FileUtils.isDirectory((File)to)) {
            throw new LcdpException(LcdpExceptionEnum.NO_DIRECTORY, to.getAbsolutePath());
        }
        JSONObject metaFileContent = JSONObject.parseObject((String)FileUtils.readFileToString((File)metaFrom, (String)"UTF-8"));
        String type = (String)metaFileContent.get((Object)"type");
        String suffix = FileConstant.transFileSuffix((String)type);
        File newMetaFile = null;
        if (newName != null && newName != "") {
            to = new File(this.relativeToAbsolute(parentPath + "/" + newName + suffix, rootPath));
            File metaTo = new File(to.getAbsolutePath() + ".meta");
            if (!FileUtils.exists((File)to) && !FileUtils.exists((File)metaTo)) {
                try {
                    FileUtils.copyFile((File)from, (File)to, (boolean)false);
                    FileUtils.copyFile((File)metaFrom, (File)metaTo, (boolean)false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, from.getAbsolutePath());
                }
            }
            newMetaFile = metaTo;
        } else {
            try {
                FileUtils.copyFileToDirectory((File)from, (File)to, (boolean)false);
                FileUtils.copyFileToDirectory((File)metaFrom, (File)to, (boolean)false);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, from.getAbsolutePath());
            }
            newMetaFile = new File(to + File.separator + metaFrom.getName());
        }
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)newMetaFile, (String)"UTF-8"));
            jsonObject.put("parentId", (Object)parentId);
            jsonObject.put("id", (Object)newId);
            jsonObject.put("isMenuSet", (Object)false);
            if (newName != null && newName != "") {
                jsonObject.put("name", (Object)newName);
            }
            if (newDesc != null && newDesc != "") {
                jsonObject.put("desc", (Object)newDesc);
            }
            FileUtils.writeStringToFile((File)newMetaFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, from.getAbsolutePath());
        }
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u4e2d\u95f4\u6587\u4ef6 .projectStore", new Object[0]), Collections.singletonList(rootPath));
        this.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public JSONObject copyNew(String id, String parentId, String newId, String newName, String newDesc) throws LcdpException, IOException {
        JSONObject obj;
        File newWpdFile;
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String path = this.getDataPath(id);
        String parentPath = this.getDataPath(parentId);
        File from = new File(this.relativeToAbsolute(path, rootPath));
        File metaFrom = new File(from.getAbsolutePath() + ".meta");
        File to = new File(this.relativeToAbsolute(parentPath, rootPath));
        if (!from.isFile()) {
            throw new LcdpException(LcdpExceptionEnum.NO_FILE, from.getAbsolutePath());
        }
        if (!to.isDirectory()) {
            throw new LcdpException(LcdpExceptionEnum.NO_DIRECTORY, to.getAbsolutePath());
        }
        JSONObject metaFileContent = JSONObject.parseObject((String)FileUtils.readFileToString((File)metaFrom, (String)"UTF-8"));
        String type = (String)metaFileContent.get((Object)"type");
        String suffix = FileConstant.transFileSuffix((String)type);
        File newMetaFile = null;
        if (newName != null && newName != "") {
            to = new File(this.relativeToAbsolute(parentPath + "/" + newName + suffix, rootPath));
            File metaTo = new File(to.getAbsolutePath() + ".meta");
            if (!to.exists() && !metaTo.exists()) {
                try {
                    FileUtils.copyFile((File)from, (File)to, (boolean)false);
                    FileUtils.copyFile((File)metaFrom, (File)metaTo, (boolean)false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, from.getAbsolutePath());
                }
            }
            newMetaFile = metaTo;
            newWpdFile = to;
        } else {
            try {
                FileUtils.copyFileToDirectory((File)from, (File)to, (boolean)false);
                FileUtils.copyFileToDirectory((File)metaFrom, (File)to, (boolean)false);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, from.getAbsolutePath());
            }
            newMetaFile = new File(to + File.separator + metaFrom.getName());
            newWpdFile = new File(to + File.separator + from.getName());
        }
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)newMetaFile, (String)"UTF-8"));
            jsonObject.put("parentId", (Object)parentId);
            jsonObject.put("id", (Object)newId);
            jsonObject.put("isMenuSet", (Object)false);
            if (newName != null && newName != "") {
                jsonObject.put("name", (Object)newName);
            }
            if (newDesc != null && newDesc != "") {
                jsonObject.put("desc", (Object)newDesc);
            }
            FileUtils.writeStringToFile((File)newMetaFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"UTF-8");
            String newFileContent = FileUtils.readFileToString((File)newWpdFile, (String)"UTF-8");
            newFileContent = newFileContent.replaceAll(id, newId);
            if (!AppContextUtil.isExtension() && newFileContent.contains("extendKey")) {
                newFileContent = ParamPaserUtil.replaceExtendKeys(newFileContent);
            }
            FileUtils.writeStringToFile((File)newWpdFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)JSON.parseObject((String)newFileContent)), (String)"UTF-8");
            obj = JSON.parseObject((String)newFileContent);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, from.getAbsolutePath());
        }
        this.fileMappingService.fileMappingCacheEvict();
        return obj;
    }

    @Override
    public String getJsPath(String id) throws LcdpException {
        return this.fileMappingService.getFormatPath(id);
    }

    @Override
    public JSONObject getExtend(String id) throws IOException, LcdpException {
        String rootPath = "dict".equals(id) ? this.pathStrategy.resourcePathService().projectStore(new String[0]).getLocalPath() : this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        String path = this.getDataExtendPath(id);
        String absolutePath = ToolUtil.pathFomatterByOS((String)(rootPath + File.separator + path));
        File fileOfExtend = new File(absolutePath);
        JSONObject extendObject = null;
        if (fileOfExtend.exists()) {
            String dataExtend = FileUtils.readFileToString((File)fileOfExtend, (String)"UTF-8");
            extendObject = JSONObject.parseObject((String)dataExtend);
        }
        return extendObject;
    }

    void writeSingleFile(File file, JSONObject jsonObject) throws LcdpException {
        try {
            if (!FileUtils.exists((File)file)) {
                throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, file.getAbsolutePath());
            }
            if (ToolUtil.isEmpty((Object)jsonObject)) {
                FileUtils.writeStringToFile((File)file, (String)"", (String)"UTF-8", (boolean)false);
            } else {
                FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"UTF-8");
            }
            VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u4ee3\u7801\uff1a%s", file.getName()), Collections.singletonList(file.getAbsolutePath()));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, file.getAbsolutePath());
        }
    }

    protected void write(File file, BaseFile baseFile) throws LcdpException {
        try {
            File fileOfMeta = new File(this.addMeta(file.getAbsolutePath()));
            Object jsonObject = JSONObject.parse((String)baseFile.getData());
            if (ToolUtil.isEmpty((Object)jsonObject)) {
                FileUtils.writeStringToFile((File)file, (String)"", (String)"UTF-8", (boolean)false);
            } else {
                FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject), (String)"UTF-8");
            }
            baseFile.setData(null);
            FileUtils.writeStringToFile((File)fileOfMeta, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(JSONObject.toJSON((Object)baseFile)), (String)"UTF-8");
            VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u4ee3\u7801\uff1a%s,%s", file.getName(), fileOfMeta.getName()), Arrays.asList(file.getAbsolutePath(), fileOfMeta.getAbsolutePath()));
        }
        catch (IOException e) {
            throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, file.getAbsolutePath());
        }
    }

    protected T readFileToObject(String absolutePath) throws LcdpException {
        try {
            File file = new File(absolutePath);
            File fileOfMeta = new File(this.addMeta(absolutePath));
            String info = FileUtils.readFileToString((File)fileOfMeta, (String)"UTF-8");
            BaseFile t = (BaseFile)JSON.parseObject((String)info, (Type)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0], (Feature[])new Feature[0]);
            if (!FileUtils.isDirectory((File)file)) {
                String data = FileUtils.readFileToString((File)file, (String)"UTF-8");
                data = this.mergeExtendInfo(absolutePath, data);
                t.setData(data);
            }
            return (T)t;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, absolutePath);
        }
    }

    private String mergeExtendInfo(String absolutePath, String data) throws IOException {
        File fileOfModelExtend;
        File fileOfExtend = new File(this.addExtendPage(absolutePath));
        if (fileOfExtend.exists() && AppContextUtil.isExtension()) {
            JSONObject dataJson = JSONObject.parseObject((String)data);
            String dataExtend = FileUtils.readFileToString((File)fileOfExtend, (String)"UTF-8");
            dataJson.put("extendSchema", (Object)JSONObject.parseObject((String)dataExtend));
            data = JSONObject.toJSONString((Object)dataJson);
        }
        if ((fileOfModelExtend = new File(this.addExt(absolutePath))).exists() && AppContextUtil.isExtension()) {
            JSONObject dataJson = JSONObject.parseObject((String)data);
            String dataExtend = FileUtils.readFileToString((File)fileOfModelExtend, (String)"UTF-8");
            dataJson.put("extendSchema", (Object)JSONObject.parseObject((String)dataExtend));
            data = JSONObject.toJSONString((Object)dataJson);
        }
        return data;
    }

    protected boolean fixName(File oldFile, File newFile) {
        return FileUtils.fixName((File)oldFile, (File)newFile);
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    String addMeta(String absolutePath) {
        String real = absolutePath.replace("/", File.separator).replace("\\", File.separator);
        return real + ".meta";
    }

    String addExtendPage(String absolutePath) {
        String real = absolutePath.replace("/", File.separator).replace("\\", File.separator);
        return real + ".extend";
    }

    String addExt(String absolutePath) {
        String real = absolutePath.replace("/", File.separator).replace("\\", File.separator);
        return real + ".ext";
    }

    private String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        String parentPath = (String)this.fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath);
    }

    boolean justRename(BaseFile newBaseFile, File oldFile) throws LcdpException {
        boolean needRename = true;
        try {
            BaseFile baseFile = (BaseFile)JSONObject.parseObject((String)FileUtils.readFileToString((File)oldFile, (String)"UTF-8"), BaseFile.class);
            if (newBaseFile.getName().equals(baseFile.getName())) {
                needRename = false;
            }
            if (newBaseFile instanceof WorkflowInfo) {
                baseFile = (BaseFile)JSONObject.parseObject((String)FileUtils.readFileToString((File)oldFile, (String)"UTF-8"), WorkflowInfo.class);
                needRename = !((WorkflowInfo)newBaseFile).geteName().equals(((WorkflowInfo)baseFile).geteName());
                if (needRename) {
                    this.godAxeModelService.updateWorkflowProcessKey(((WorkflowInfo)newBaseFile).geteName(), ((WorkflowInfo)baseFile).geteName());
                }
                newBaseFile.setVersion(baseFile.getVersion());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, oldFile.getAbsolutePath());
        }
        return needRename;
    }

    void renameTwoFile(BaseFile baseFile, File file, File metaFile, String rootPath) throws LcdpException, IOException {
        File newFile;
        String parentPath = "";
        if (!ToolUtil.isEmpty((Object)baseFile.getParentId()) && !"#".equals(baseFile.getParentId())) {
            parentPath = this.getDataPath(baseFile.getParentId());
        }
        String name = baseFile.getName();
        if (baseFile instanceof WorkflowInfo) {
            name = ((WorkflowInfo)baseFile).geteName();
        }
        if (FileUtils.exists((File)(newFile = new File(rootPath + parentPath + File.separator + name + FileUtil.transFileSuffix((String)baseFile.getType()))))) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, newFile.getAbsolutePath());
        }
        File newMetaFile = new File(newFile.getAbsolutePath() + ".meta");
        if (FileUtils.exists((File)newMetaFile)) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, newMetaFile.getAbsolutePath());
        }
        this.fixName(file, newFile);
        this.fixName(metaFile, newMetaFile);
    }

    void renameExtendFile(BaseFile baseFile, File file, String rootPath) throws LcdpException, IOException {
        File newFile;
        String parentPath = "";
        if (!ToolUtil.isEmpty((Object)baseFile.getParentId()) && !"#".equals(baseFile.getParentId())) {
            parentPath = this.getDataPath(baseFile.getParentId());
        }
        String name = baseFile.getName();
        if (baseFile instanceof WorkflowInfo) {
            name = ((WorkflowInfo)baseFile).geteName();
        }
        if (FileUtils.exists((File)(newFile = new File(rootPath + parentPath + File.separator + name + ".wpd" + ".extend")))) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, newFile.getAbsolutePath());
        }
        this.fixName(file, newFile);
    }

    String getDataPath(String id) throws LcdpException, IOException {
        return this.getMetaPath(id).replace(".meta", "");
    }

    String getDataExtendPath(String id) throws LcdpException, IOException {
        return this.getMetaPath(id).replace(".meta", ".extend");
    }

    private String buildRootPath(String appId, String fileId) {
        String rootPath = "dict".equals(fileId) ? this.pathStrategy.resourcePathService().projectStore(new String[0]).getLocalPath() : this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        return rootPath;
    }

    private String formatFilePath(String dataPath) {
        String formatPath = dataPath.replace(File.separator, "/");
        int location = formatPath.lastIndexOf("/");
        if (location != -1) {
            String name = formatPath.substring(location);
            int suffix = name.lastIndexOf(".");
            if (suffix != -1) {
                name = name.substring(0, suffix);
            }
            formatPath = formatPath.substring(0, location) + name;
        }
        return formatPath;
    }

    private void writeExtFile(File file, JSONObject jsonObject) throws LcdpException {
        try {
            if (ToolUtil.isEmpty((Object)jsonObject)) {
                FileUtils.writeStringToFile((File)file, (String)"", (String)"UTF-8", (boolean)false);
            } else {
                FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"UTF-8");
            }
            VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u4ee3\u7801\uff1a%s", file.getName()), Collections.singletonList(file.getAbsolutePath()));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, file.getAbsolutePath());
        }
    }
}

