/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.extend.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.common.model.script.ExtendWScript;
import com.jxdinfo.hussar.formdesign.common.parser.DefaultScriptParser;
import com.jxdinfo.hussar.formdesign.common.parser.ScriptParser;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.extend.factory.ScriptParseFactory;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendScriptInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class ScriptParsingUtil {
    private static final Logger logger = LoggerFactory.getLogger(ScriptParsingUtil.class);

    public static ScriptParser getParser(String type) {
        ScriptParser scriptParser = (ScriptParser)SpringUtil.getBean(DefaultScriptParser.class);
        if (type.equals("CssScript") || type.equals("UniCssScript") || type.equals("MobileCssScript")) {
            return scriptParser;
        }
        String parser = ScriptParseFactory.get(type);
        if (ObjectUtils.isEmpty((Object)parser)) {
            logger.error("\u811a\u672c\u89e3\u6790\u5668\u672a\u6ce8\u518c: {}", (Object)parser);
            return scriptParser;
        }
        try {
            scriptParser = (ScriptParser)SpringUtil.getBean((String)parser, ScriptParser.class);
        }
        catch (Exception e) {
            logger.error("\u811a\u672c\u89e3\u6790\u5668\u672a\u6ce8\u518c\uff1a{}", (Object)parser);
        }
        return scriptParser;
    }

    public static void transform(ExtendScriptInfo extendScriptInfo) {
        ExtendWScript extendWScript = ScriptParsingUtil.getParser(extendScriptInfo.getType()).parseScript(extendScriptInfo.getData());
        if (ToolUtil.isEmpty((Object)extendWScript)) {
            extendWScript = new ExtendWScript();
        }
        extendWScript.setName(extendScriptInfo.getName());
        extendWScript.setDesc(extendScriptInfo.getDesc());
        extendWScript.setId(extendScriptInfo.getId());
        extendWScript.setType(extendScriptInfo.getType());
        extendWScript.setNote(extendScriptInfo.getNote());
        if (extendScriptInfo.getData() == null) {
            if (ToolUtil.isEmpty((Object)extendScriptInfo.getEditorNote())) {
                extendWScript.setEditorNote(extendScriptInfo.getEditorNote());
            }
        } else {
            extendWScript.setEditorNote(extendScriptInfo.getData());
        }
        extendScriptInfo.setData(JSON.toJSONString((Object)extendWScript));
    }
}

