/*
 * Decompiled with CFR 0.152.
 */
package common.util;

import common.constant.EngineColumnType;
import java.sql.JDBCType;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class EngineColumnTypeUtil {
    private static final List<EngineColumnType> engineColumnTypes = new ArrayList<EngineColumnType>();

    public static Optional<EngineColumnType> getEngineColumnType(String dataType) {
        return engineColumnTypes.stream().filter(x -> x.getDataType().equalsIgnoreCase(dataType)).findFirst();
    }

    static {
        engineColumnTypes.add(new EngineColumnType(JDBCType.INTEGER, Integer.class.getName(), "int"));
        engineColumnTypes.add(new EngineColumnType(JDBCType.VARCHAR, String.class.getName(), "string"));
        engineColumnTypes.add(new EngineColumnType(JDBCType.VARCHAR, String.class.getName(), "arrayPrimary"));
        engineColumnTypes.add(new EngineColumnType(JDBCType.VARCHAR, String.class.getName(), "treeObject"));
        engineColumnTypes.add(new EngineColumnType(JDBCType.DOUBLE, Double.class.getName(), "double"));
        engineColumnTypes.add(new EngineColumnType(JDBCType.TIMESTAMP, LocalDateTime.class.getName(), "date"));
        engineColumnTypes.add(new EngineColumnType(JDBCType.TINYINT, Boolean.class.getName(), "boolean"));
        engineColumnTypes.add(new EngineColumnType(JDBCType.BIGINT, Long.class.getName(), "long"));
    }
}

