/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.util;

import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.mongo.MongoTemplateCache;
import com.jxdinfo.hussar.formdesign.common.util.mongo.MongoTemplateUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class MongoCommon {
    private static String database;

    public String getDatabase() {
        return database;
    }

    @Value(value="${spring.data.mongodb.database}")
    public void setDatabase(String database) {
        MongoCommon.database = database;
    }

    public static MongoTemplate getMongoTemplate() {
        MongoTemplate template = MongoTemplateCache.get((String)database);
        if (template == null) {
            template = MongoTemplateUtil.createDb((String)database);
        }
        return template;
    }

    public static String getMongoId(String formId) {
        return String.format("%s:%s", AppContextUtil.getAppId(), formId);
    }
}

