/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.db;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.no.code.business.service.SysMiddleFileStorageService;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormIndexMeta;
import com.jxdinfo.hussar.formdesign.no.code.model.SysMiddleFileStorage;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnDB;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CategoryEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={NoCodeConditionOnDB.class})
public class CanvasSchemaDBImpl
implements CanvasSchemaService {
    @Resource
    private SysMiddleFileStorageService sysMiddleFileStorageService;
    @Resource
    private ISysApplicationExternalService applicationService;
    @Resource
    private StorageService storage;

    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(FormCanvasSchema schema, String appId) throws JsonProcessingException {
        Wrapper wrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FORM_ID", (Object)Long.parseLong(schema.getId()))).eq((Object)"FILE_TYPE", (Object)"1")).eq((Object)"DEL_FLAG", (Object)"0");
        SysMiddleFileStorage sysMiddleFileStorage = (SysMiddleFileStorage)((Object)this.sysMiddleFileStorageService.getOne(wrapper));
        if (sysMiddleFileStorage != null) {
            sysMiddleFileStorage.setMiddleFileInfo(JSON.toJSONString((Object)((Object)schema)));
            this.sysMiddleFileStorageService.updateById((Object)sysMiddleFileStorage);
        } else {
            sysMiddleFileStorage = new SysMiddleFileStorage();
            sysMiddleFileStorage.setAppId(Long.parseLong(appId));
            sysMiddleFileStorage.setFormId(Long.parseLong(schema.getId()));
            sysMiddleFileStorage.setFileType("1");
            sysMiddleFileStorage.setMiddleFileInfo(JSON.toJSONString((Object)((Object)schema)));
            sysMiddleFileStorage.setDelFlag("0");
            this.sysMiddleFileStorageService.save((Object)sysMiddleFileStorage);
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(FormCanvasSchema schema) throws JsonProcessingException {
        SysForm form = this.applicationService.getFormDetailById(Long.valueOf(Long.parseLong(schema.getId())));
        if (HussarUtils.isNotEmpty((Object)form)) {
            AppContextUtil.setAppId((String)form.getAppId().toString());
            schema.setAppId(form.getAppId().toString());
        }
        return this.saveOrUpdate(schema, AppContextUtil.getAppId());
    }

    @Override
    public FormDesignResponse<FormCanvasSchema> get(String formId) {
        Wrapper wrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FORM_ID", (Object)Long.parseLong(formId))).eq((Object)"FILE_TYPE", (Object)"1")).eq((Object)"DEL_FLAG", (Object)"0");
        SysMiddleFileStorage sysMiddleFileStorage = (SysMiddleFileStorage)((Object)this.sysMiddleFileStorageService.getOne(wrapper));
        if (HussarUtils.isNotEmpty((Object)((Object)sysMiddleFileStorage))) {
            FormCanvasSchema formCanvasSchema = (FormCanvasSchema)((Object)JSON.parseObject((String)sysMiddleFileStorage.getMiddleFileInfo(), FormCanvasSchema.class));
            return FormDesignResponse.success((Object)((Object)formCanvasSchema), (String)"");
        }
        return FormDesignResponse.success(null);
    }

    @Override
    public FormDesignResponse<FormCanvasSchema> get(SysForm form) {
        return this.get(Long.toString(form.getId()));
    }

    @Override
    public FormDesignResponse<FormCanvasSchema> get(String formId, SysForm sysForm) {
        Wrapper wrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FORM_ID", (Object)Long.parseLong(formId))).eq((Object)"FILE_TYPE", (Object)"1")).eq((Object)"DEL_FLAG", (Object)"0");
        SysMiddleFileStorage sysMiddleFileStorage = (SysMiddleFileStorage)((Object)this.sysMiddleFileStorageService.getOne(wrapper));
        if (HussarUtils.isNotEmpty((Object)((Object)sysMiddleFileStorage))) {
            FormCanvasSchema formCanvasSchema = (FormCanvasSchema)((Object)JSON.parseObject((String)sysMiddleFileStorage.getMiddleFileInfo(), FormCanvasSchema.class));
            return FormDesignResponse.success((Object)((Object)formCanvasSchema), (String)"");
        }
        return FormDesignResponse.success(null);
    }

    @Override
    public FormIndexMeta getMeta(String formId) {
        ToolUtil.getLogger(this.getClass()).info("formId=========>: {}", (Object)formId);
        SysForm form = this.applicationService.getFormDetailById(Long.valueOf(Long.parseLong(formId)));
        if (HussarUtils.isNotEmpty((Object)form)) {
            AppContextUtil.setAppId((String)String.valueOf(form.getAppId()));
        }
        ToolUtil.getLogger(this.getClass()).info("AppContextUtil.getAppId=========>: {},formId=====:{}", (Object)AppContextUtil.getAppId(), (Object)formId);
        StorageResult metaRes = this.storage.downloadByUuid(CategoryEnum.META, formId);
        if (!metaRes.isSuccess()) {
            ToolUtil.getLogger(this.getClass()).info("metaRes\u4e3a\u7a7a===============>");
            return new FormIndexMeta();
        }
        if (HussarUtils.isEmpty((Object)metaRes.getData())) {
            ToolUtil.getLogger(this.getClass()).info("metaResData\u4e3a\u7a7a===============>");
            return new FormIndexMeta();
        }
        return (FormIndexMeta)JSON.parseObject((byte[])((byte[])metaRes.getData()), FormIndexMeta.class, (Feature[])new Feature[0]);
    }

    public FormIndexMeta getMeta(String formId, String appId) {
        ToolUtil.getLogger(this.getClass()).info("formId=========>: {}", (Object)formId);
        ToolUtil.getLogger(this.getClass()).info("AppContextUtil.getAppId=========>: {},formId=====:{}", (Object)AppContextUtil.getAppId(), (Object)formId);
        AppContextUtil.setAppId((String)String.valueOf(appId));
        StorageResult metaRes = this.storage.downloadByUuid(CategoryEnum.META, formId);
        if (!metaRes.isSuccess()) {
            ToolUtil.getLogger(this.getClass()).info("metaRes\u4e3a\u7a7a===============>");
            return new FormIndexMeta();
        }
        if (HussarUtils.isEmpty((Object)metaRes.getData())) {
            ToolUtil.getLogger(this.getClass()).info("metaResData\u4e3a\u7a7a===============>");
            return new FormIndexMeta();
        }
        return (FormIndexMeta)JSON.parseObject((byte[])((byte[])metaRes.getData()), FormIndexMeta.class, (Feature[])new Feature[0]);
    }

    @Override
    public FormDesignResponse<Boolean> updateMeta(FormIndexMeta meta) throws JsonProcessingException {
        StorageResult metaRes = this.storage.uploadByUuid(CategoryEnum.META, meta.getId(), meta.getPath(), new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)meta).getBytes(StandardCharsets.UTF_8), true);
        if (!((Boolean)metaRes.getData()).booleanValue()) {
            return FormDesignResponse.fail((Object)false, (String)"\u66f4\u65b0\u8868\u5355meta\u5931\u8d25");
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<Boolean> delete(String formId) {
        Wrapper wrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FORM_ID", (Object)Long.parseLong(formId))).eq((Object)"FILE_TYPE", (Object)"1")).eq((Object)"DEL_FLAG", (Object)"0");
        SysMiddleFileStorage sysMiddleFileStorage = (SysMiddleFileStorage)((Object)this.sysMiddleFileStorageService.getOne(wrapper));
        sysMiddleFileStorage.setDelFlag("1");
        this.sysMiddleFileStorageService.updateById((Object)sysMiddleFileStorage);
        return FormDesignResponse.success((Object)true);
    }
}

