/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService;
import com.jxdinfo.hussar.code.plus.vo.SysCodeRuleVo;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.engine.api.service.EngineApiService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.SerialNumberService;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.serialNumber.SerialNumberCountVO;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

@Service
public class SerialNumberServiceImpl
implements SerialNumberService {
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private EngineApiService engineApiService;
    @Resource
    private ISysCodeRuleService iSysCodeRuleService;
    @Resource
    private ModelRelateService modelRelateService;

    public String getBusinessId(String requestMethod, String appId, String formId, String invokeMethod) {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        String url = FileUtil.posixPath((String[])new String[]{appId, formId, invokeMethod});
        return String.format("%s /%s", requestMethod, url);
    }

    @Override
    public FormDesignResponse<Object> selectCount(String formId, String parentId) {
        String appId = AppContextUtil.getAppId();
        HashMap params = new HashMap();
        String modelId = null;
        modelId = HussarUtils.isNull((Object)parentId) || HussarUtils.isEmpty((Object)parentId) ? formId : parentId;
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, modelId, "SelectCount");
        Object data = ((ApiResponse)this.engineApiService.invokeByReturnEntity(businessId, null, params).getBody()).getData();
        if (data instanceof PageVo) {
            return FormDesignResponse.success(((PageVo)data).getData().get(0));
        }
        return FormDesignResponse.success((Object)data);
    }

    @Override
    public FormDesignResponse<Integer> batchUpdateSerialNum(String formId, String parentId) {
        String modelId = null;
        modelId = HussarUtils.isNull((Object)parentId) || HussarUtils.isEmpty((Object)parentId) ? formId : parentId;
        return FormDesignResponse.success((Object)this.modelRelateService.batchUpdateSerialNum(modelId));
    }

    @Override
    public FormDesignResponse<String> reset(String formId, String parentId) {
        FormCanvasSchema formSchema = (FormCanvasSchema)((Object)this.canvasSchemaService.get(formId).getData());
        String ruleCode = null;
        ruleCode = HussarUtils.isNull((Object)parentId) || HussarUtils.isEmpty((Object)parentId) ? formSchema.getName() : parentId;
        String data = (String)this.iSysCodeRuleService.resetSerialNumber(ruleCode).getData();
        return FormDesignResponse.success((Object)data);
    }

    @Override
    public FormDesignResponse<SerialNumberCountVO> getCurrentCount(String formId, String parentId) {
        FormCanvasSchema formSchema = (FormCanvasSchema)((Object)this.canvasSchemaService.get(formId).getData());
        SerialNumberCountVO serialNumberCountVO = new SerialNumberCountVO();
        List<Widget> widgets = formSchema.widgetsContainChildren();
        widgets = WidgetTool.flatAllWidget(widgets);
        Optional<Widget> first = widgets.stream().filter(s -> HussarUtils.equals((Object)s.getType(), (Object)WidgetType.JXDNSerialNumber.getType()) && HussarUtils.equals((Object)s.getParentKey(), (Object)parentId)).findFirst();
        String ruleCode = "";
        if (first.isPresent()) {
            Widget serialNum = first.get();
            JSONObject props = serialNum.getProps();
            if (HussarUtils.equals((Object)"existing", (Object)props.getString("defaultRule"))) {
                String ruleCodeId = props.getString("defaultRuleExisting");
                ISysCodeRuleService iSysCodeRuleService = (ISysCodeRuleService)SpringUtil.getBean(ISysCodeRuleService.class);
                ApiResponse pageApiResponse = iSysCodeRuleService.getCodeRule(Long.valueOf(ruleCodeId));
                SysCodeRuleVo record = (SysCodeRuleVo)pageApiResponse.getData();
                if (HussarUtils.isEmpty((Object)record)) {
                    return FormDesignResponse.fail((int)10011, null, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6d41\u2f54\u53f7\u2f63\u6210\u89c4\u5219\uff0c\u8bf7\u786e\u8ba4\u89c4\u5219\u914d\u7f6e\u662f\u5426\u6b63\u786e");
                }
                ruleCode = record.getCodeRuleCode();
            } else {
                ruleCode = HussarUtils.isNotEmpty((Object)serialNum.getParentKey()) ? serialNum.getParentKey() : formSchema.getName();
            }
        }
        Long serialNumberCode = this.iSysCodeRuleService.getSerialNumberCodeValue(ruleCode);
        serialNumberCountVO.setCurrent(serialNumberCode);
        return FormDesignResponse.success((Object)serialNumberCountVO);
    }
}

