/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeFormatUtil {
    public static String[] timeToTimeTange(String field, AtomicBoolean isRealFieldF, String format, String data) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime givenTime = LocalDateTime.parse(data, formatter);
        LocalDateTime startTime = null;
        LocalDateTime endTime = null;
        switch (format) {
            case "yyyy": {
                startTime = givenTime.with(TemporalAdjusters.firstDayOfYear()).with(LocalTime.MIN);
                endTime = givenTime.with(TemporalAdjusters.lastDayOfYear()).with(LocalTime.MAX);
                break;
            }
            case "yyyy-MM": {
                startTime = givenTime.with(TemporalAdjusters.firstDayOfMonth()).with(LocalTime.MIN);
                endTime = givenTime.with(TemporalAdjusters.lastDayOfMonth()).with(LocalTime.MAX);
                break;
            }
            case "yyyy-MM-dd": {
                startTime = givenTime.with(LocalTime.MIN);
                endTime = givenTime.with(LocalTime.MAX);
                break;
            }
            case "yyyy-MM-dd HH:mm": {
                startTime = givenTime.withSecond(0).withNano(0);
                endTime = givenTime.withSecond(59).withNano(999999999);
                break;
            }
            case "yyyy-MM-dd HH:mm:ss": {
                startTime = endTime = givenTime;
                break;
            }
            default: {
                return null;
            }
        }
        String start = startTime.format(formatter);
        String end = endTime.format(formatter);
        if (HussarUtils.equals((Object)field, (Object)"START_TIME") && !isRealFieldF.get()) {
            end = end + ".999";
        }
        return new String[]{start, end};
    }

    public static String formatEndTime(String format, String data) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime givenTime = LocalDateTime.parse(data, formatter);
        LocalDateTime endTime = null;
        switch (format) {
            case "yyyy": {
                endTime = givenTime.with(TemporalAdjusters.lastDayOfYear()).with(LocalTime.MAX);
                break;
            }
            case "yyyy-MM": {
                endTime = givenTime.with(TemporalAdjusters.lastDayOfMonth()).with(LocalTime.MAX);
                break;
            }
            case "yyyy-MM-dd": {
                endTime = givenTime.with(LocalTime.MAX);
                break;
            }
            case "yyyy-MM-dd HH:mm": {
                endTime = givenTime.withSecond(59).withNano(999999999);
                break;
            }
            case "yyyy-MM-dd HH:mm:ss": {
                endTime = givenTime;
                break;
            }
            default: {
                return null;
            }
        }
        return endTime.format(formatter);
    }

    public static String formatStartTime(String format, String data) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime givenTime = LocalDateTime.parse(data, formatter);
        LocalDateTime startTime = null;
        switch (format) {
            case "yyyy": {
                startTime = givenTime.with(TemporalAdjusters.firstDayOfYear()).with(LocalTime.MIN);
                break;
            }
            case "yyyy-MM": {
                startTime = givenTime.with(TemporalAdjusters.firstDayOfMonth()).with(LocalTime.MIN);
                break;
            }
            case "yyyy-MM-dd": {
                startTime = givenTime.with(LocalTime.MIN);
                break;
            }
            case "yyyy-MM-dd HH:mm": {
                startTime = givenTime.withSecond(0).withNano(0);
                break;
            }
            case "yyyy-MM-dd HH:mm:ss": {
                startTime = givenTime;
                break;
            }
            default: {
                return null;
            }
        }
        return startTime.format(formatter);
    }

    public static String completeDateFormat(String dateString) {
        Pattern pattern = Pattern.compile("^(\\d{4})(-(\\d{2})(-(\\d{2})( (\\d{2})(:(\\d{2})(:(\\d{2}))?)?)?)?)?$");
        Matcher matcher = pattern.matcher(dateString);
        if (matcher.matches()) {
            StringBuffer sb = new StringBuffer();
            sb.append(matcher.group(1));
            sb.append("-");
            sb.append(matcher.group(3) != null ? matcher.group(3) : "01");
            sb.append("-");
            sb.append(matcher.group(5) != null ? matcher.group(5) : "01");
            sb.append(" ");
            sb.append(matcher.group(7) != null ? matcher.group(7) : "00");
            sb.append(":");
            sb.append(matcher.group(9) != null ? matcher.group(9) : "00");
            sb.append(":");
            sb.append(matcher.group(11) != null ? matcher.group(11) : "00");
            return sb.toString();
        }
        return null;
    }

    public static String now() {
        LocalDateTime localDateTime = LocalDateTime.now();
        String format = "yyyy-MM-dd HH:mm:ss";
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return localDateTime.format(formatter);
    }
}

