/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.mongo;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.staff.StaffScope;
import com.jxdinfo.hussar.formdesign.no.code.cured.StaffScopeScemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.staff.StaffScopeHistory;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnMongo;
import com.jxdinfo.hussar.formdesign.no.code.util.MongoCommon;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.mongodb.BasicDBObject;
import java.util.List;
import org.bson.Document;
import org.springframework.context.annotation.Conditional;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={NoCodeConditionOnMongo.class})
public class StaffScopeMongoImpl
implements StaffScopeScemaService {
    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(StaffScope staffScope) {
        MongoTemplate template = MongoCommon.getMongoTemplate();
        BasicDBObject dbObject = new BasicDBObject();
        staffScope.setAppId(AppContextUtil.getAppId());
        template.getConverter().write((Object)staffScope, (Object)dbObject);
        Update update = Update.fromDocument((Document)Document.parse((String)JSON.toJSONString((Object)staffScope)), (String[])new String[0]);
        template.upsert(Query.query((CriteriaDefinition)Criteria.where((String)"formId").is((Object)staffScope.getFormId()).and("widgetName").is((Object)staffScope.getWidgetName()).and("appId").is((Object)AppContextUtil.getAppId())), (UpdateDefinition)update, StaffScope.class);
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<Boolean> saveOrUpdateBatch(List<StaffScope> staffScopes) {
        if (HussarUtils.isEmpty(staffScopes)) {
            return FormDesignResponse.fail((Object)false, (String)"\u63d0\u4ea4\u6570\u636e\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        for (StaffScope staffScope : staffScopes) {
            this.saveOrUpdate(staffScope);
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<StaffScope> getByName(String formId, String widgetName) {
        MongoTemplate template = MongoCommon.getMongoTemplate();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"formId").is((Object)formId).and("widgetName").is((Object)widgetName).and("appId").is((Object)AppContextUtil.getAppId()));
        return FormDesignResponse.success((Object)template.findOne(query, StaffScope.class));
    }

    @Override
    public FormDesignResponse<List<StaffScope>> list(String formId) {
        MongoTemplate template = MongoCommon.getMongoTemplate();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"formId").is((Object)formId).and("appId").is((Object)AppContextUtil.getAppId()));
        return FormDesignResponse.success((Object)template.find(query, StaffScope.class));
    }

    @Override
    public FormDesignResponse<Boolean> delete(String formId, String widgetName) throws JsonProcessingException {
        Query query;
        MongoTemplate mongoTemplate = MongoCommon.getMongoTemplate();
        StaffScope one = (StaffScope)mongoTemplate.findOne(query = Query.query((CriteriaDefinition)Criteria.where((String)"formId").is((Object)formId).and("widgetName").is((Object)widgetName).and("appId").is((Object)AppContextUtil.getAppId())), StaffScope.class);
        if (HussarUtils.isEmpty((Object)one)) {
            return FormDesignResponse.success((Object)true);
        }
        mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)one.getId())), StaffScope.class);
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<String> saveOrUpdateHistory(StaffScopeHistory staffScopeHistory) throws JsonProcessingException {
        MongoTemplate template = MongoCommon.getMongoTemplate();
        BasicDBObject dbObject = new BasicDBObject();
        staffScopeHistory.setAppId(AppContextUtil.getAppId());
        template.getConverter().write((Object)staffScopeHistory, (Object)dbObject);
        Update update = Update.fromDocument((Document)Document.parse((String)JSON.toJSONString((Object)staffScopeHistory)), (String[])new String[0]);
        template.upsert(Query.query((CriteriaDefinition)Criteria.where((String)"formId").is((Object)staffScopeHistory.getFormId()).and("widgetName").is((Object)staffScopeHistory.getWidgetName()).and("appId").is((Object)AppContextUtil.getAppId())), (UpdateDefinition)update, StaffScopeHistory.class);
        return FormDesignResponse.success((Object)staffScopeHistory.getStepKey());
    }

    @Override
    public FormDesignResponse<List<StaffScopeHistory>> listHistory(String formId) {
        MongoTemplate template = MongoCommon.getMongoTemplate();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"formId").is((Object)formId).and("appId").is((Object)AppContextUtil.getAppId()));
        return FormDesignResponse.success((Object)template.find(query, StaffScopeHistory.class));
    }

    @Override
    public FormDesignResponse<StaffScopeHistory> getHistoryByName(String formId, String widgetName, String stepKey) {
        MongoTemplate template = MongoCommon.getMongoTemplate();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"formId").is((Object)formId).and("widgetName").is((Object)widgetName).and("_id").is((Object)stepKey).and("appId").is((Object)AppContextUtil.getAppId()));
        return FormDesignResponse.success((Object)template.findOne(query, StaffScopeHistory.class));
    }

    @Override
    public FormDesignResponse<Boolean> deleteScopeHistory(String formId) throws JsonProcessingException {
        Query query;
        MongoTemplate mongoTemplate = MongoCommon.getMongoTemplate();
        List staffScopeHistoryList = mongoTemplate.find(query = Query.query((CriteriaDefinition)Criteria.where((String)"formId").is((Object)formId).and("appId").is((Object)AppContextUtil.getAppId())), StaffScopeHistory.class);
        if (HussarUtils.isEmpty((Object)staffScopeHistoryList)) {
            return FormDesignResponse.success((Object)true);
        }
        for (StaffScopeHistory staffScopeHistory : staffScopeHistoryList) {
            mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)staffScopeHistory.getStepKey())), StaffScopeHistory.class);
        }
        return FormDesignResponse.success((Object)true);
    }
}

