/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.db;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.no.code.business.service.SysMiddleFileStorageService;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.SysMiddleFileStorage;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnDB;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import javax.annotation.Resource;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="no.code.setting")
@Conditional(value={NoCodeConditionOnDB.class})
@ComponentScan(basePackages={"com.jxdinfo.hussar.formdesign.no.code.cured"})
public class SettingDBImpl
implements SettingSchemaService<FormSettingSchema> {
    @Resource
    private SysMiddleFileStorageService sysMiddleFileStorageService;

    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(FormSettingSchema schema, String formId) throws JsonProcessingException {
        schema.setAppId(AppContextUtil.getAppId());
        Wrapper wrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FORM_ID", (Object)Long.parseLong(formId))).eq((Object)"FILE_TYPE", (Object)"2")).eq((Object)"DEL_FLAG", (Object)"0");
        SysMiddleFileStorage sysMiddleFileStorage = (SysMiddleFileStorage)((Object)this.sysMiddleFileStorageService.getOne(wrapper));
        if (sysMiddleFileStorage != null) {
            sysMiddleFileStorage.setMiddleFileInfo(JSON.toJSONString((Object)((Object)schema)));
            this.sysMiddleFileStorageService.updateById((Object)sysMiddleFileStorage);
        } else {
            sysMiddleFileStorage = new SysMiddleFileStorage();
            sysMiddleFileStorage.setAppId(Long.parseLong(schema.getAppId()));
            sysMiddleFileStorage.setFormId(Long.parseLong(formId));
            sysMiddleFileStorage.setFileType("2");
            sysMiddleFileStorage.setMiddleFileInfo(JSON.toJSONString((Object)((Object)schema)));
            sysMiddleFileStorage.setDelFlag("0");
            this.sysMiddleFileStorageService.save((Object)sysMiddleFileStorage);
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<FormSettingSchema> get(String formId) {
        FormSettingSchema formSettingSchema = new FormSettingSchema();
        Wrapper wrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FORM_ID", (Object)Long.parseLong(formId))).eq((Object)"FILE_TYPE", (Object)"2")).eq((Object)"DEL_FLAG", (Object)"0");
        SysMiddleFileStorage sysMiddleFileStorage = (SysMiddleFileStorage)((Object)this.sysMiddleFileStorageService.getOne(wrapper));
        if (!HussarUtils.isNotEmpty((Object)((Object)sysMiddleFileStorage))) {
            return FormDesignResponse.success(null);
        }
        formSettingSchema = (FormSettingSchema)((Object)JSON.parseObject((String)sysMiddleFileStorage.getMiddleFileInfo(), FormSettingSchema.class));
        return FormDesignResponse.success((Object)((Object)formSettingSchema), (String)"");
    }

    @Override
    public FormDesignResponse<Boolean> delete(String formId) {
        Wrapper wrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FORM_ID", (Object)Long.parseLong(formId))).eq((Object)"FILE_TYPE", (Object)"2")).eq((Object)"DEL_FLAG", (Object)"0");
        SysMiddleFileStorage sysMiddleFileStorage = (SysMiddleFileStorage)((Object)this.sysMiddleFileStorageService.getOne(wrapper));
        sysMiddleFileStorage.setDelFlag("1");
        this.sysMiddleFileStorageService.updateById((Object)sysMiddleFileStorage);
        return FormDesignResponse.success((Object)true);
    }
}

