/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.extapi.model.SysFormExtApi;
import com.jxdinfo.hussar.formdesign.application.extapi.service.ISysFormExtApiService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormGroupVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysSiftGroupList;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkSingleInnerService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkSingleService;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.annotation.DataOperateLog;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.model.WorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.api.service.EngineApiService;
import com.jxdinfo.hussar.formdesign.extension.api.dto.form.FlowFormSubmitHookDto;
import com.jxdinfo.hussar.formdesign.extension.api.dto.form.FormDataDeleteHookDto;
import com.jxdinfo.hussar.formdesign.extension.api.dto.form.FormSaveHookDto;
import com.jxdinfo.hussar.formdesign.extension.api.dto.form.HookOrderDto;
import com.jxdinfo.hussar.formdesign.extension.api.dto.form.HookParamDto;
import com.jxdinfo.hussar.formdesign.extension.api.dto.form.HookQueryConditionDto;
import com.jxdinfo.hussar.formdesign.extension.api.dto.form.TableQueryHookDto;
import com.jxdinfo.hussar.formdesign.extension.api.service.IFormOperateHookService;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.BaseForm;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.DataFilterType;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControl;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControlSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FormDetailVO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FormVerifyVO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.WidgetField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.FormCanvasSchemaDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.WidgetDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.staff.StaffScope;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.FieldControlUnitSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.HideRuleSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.SubmitSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.FormViewSchemaDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.ShowField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.SaveInfoDto;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.WorkflowService;
import com.jxdinfo.hussar.formdesign.no.code.business.enums.FormQuerySortEnum;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CustomViewOrderService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CustomViewService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.InvokeService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.SettingService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.StaffScopeService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.business.util.FormCanvasUtil;
import com.jxdinfo.hussar.formdesign.no.code.business.util.HookUtil;
import com.jxdinfo.hussar.formdesign.no.code.constant.EngineOperationType;
import com.jxdinfo.hussar.formdesign.no.code.constant.FilterType;
import com.jxdinfo.hussar.formdesign.no.code.constant.ViewIdEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.FormCleaner;
import com.jxdinfo.hussar.formdesign.no.code.cured.ReferenceService;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.StaffScopeScemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.factory.PageBuilderFactory;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.ResourceReference;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.formdesign.no.code.util.TimeFormatUtil;
import com.jxdinfo.hussar.mail.core.collection.CollUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.IResultCode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.choreo.api.service.ApiNamingService;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.api.service.ModelSaveService;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class FormOperateExposedImpl
implements FormOperateExposedService {
    private static final String FORM_EXT = "_formExt";
    private static final String TABLE_QUERY_CACHE = "_tableQueryCache";
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private ViewSchemaService viewSchemaService;
    @Resource
    private ViewService viewService;
    @Resource
    private SettingService settingService;
    @Resource
    private FormOperateService formOperate;
    @Resource
    private FormCleaner formCleaner;
    @Resource
    private EngineApiService engineApiService;
    @Resource
    private InvokeService invokeService;
    @Resource
    private ISysApplicationExternalService externalService;
    @Resource
    private StaffScopeService staffScopeService;
    @Resource
    private ReferenceService referenceService;
    @Resource
    private CanvasService canvasService;
    @Resource
    private FilePublishService filePublishService;
    @Resource
    private StaffScopeScemaService staffScopeScemaService;
    @Autowired
    private ApiNamingService apiNamingService;
    @Resource
    private ISysFormLinkSingleService sysFormLinkSingleService;
    @Resource
    private ISysFormLinkSingleInnerService sysFormLinkSingleInnerService;
    @Resource
    private ISysApplicationExternalService applicationService;
    @Resource
    private CustomViewOrderService customViewOrderService;
    @Resource
    private CustomViewService customViewService;
    @Resource
    private WorkflowService workflowService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysFormExtApiService sysFormExtApiService;
    @Autowired(required=false)
    private IFormOperateHookService formOperateHookService;
    @Resource
    private ModelSaveService modelSaveService;
    @Resource
    private HookUtil hookUtil;
    private static final Logger LOGGER = LoggerFactory.getLogger(FormOperateExposedImpl.class);
    private static final String BASE_FORM = "0";
    private static final String FLOW_FORM = "1";
    private static final String TABLE_QUERY_FROM = "_tableQuery_from";
    private static final List FLOW_FORM_PECULIARLY_COLUMN = Arrays.asList("PROCESS_STATE", "PROCESS_NODE", "START_TIME", "FINISH_TIME", "CREATE_TIME", "END_TIME");
    @Resource
    private FormOperateService formOperateService;

    @HussarTransactional
    public ApiResponse<Boolean> create(BaseForm baseForm, String appId) throws Exception {
        return this.create(baseForm, appId, null, true);
    }

    @HussarTransactional
    public ApiResponse<Boolean> create(BaseForm baseForm, String appId, String widgetStr, boolean createTable) throws Exception {
        String formId = baseForm.getId();
        AppContextUtil.setAppId((String)appId);
        FormCanvasSchema canvas = this.initCanvas(baseForm);
        if (HussarUtils.isNotBlank((CharSequence)widgetStr)) {
            List widgets = JSON.parseArray((String)widgetStr, Widget.class);
            canvas.setWidgets(widgets);
        }
        FormViewSchema view = this.initView(canvas);
        FormSettingSchema setting = this.initSetting(formId, canvas);
        this.canvasSchemaService.saveOrUpdate(canvas, appId);
        this.viewSchemaService.saveOrUpdate(view);
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.setting", SettingSchemaService.class);
        settingSchemaService.saveOrUpdate(setting, formId);
        FormSchema formSchema = new FormSchema.Builder().formPage(canvas).view(view).setting(setting).build();
        if (HussarUtils.equals((Object)FLOW_FORM, (Object)baseForm.getFormType())) {
            this.createDefaultProcess(baseForm, appId);
        }
        this.canvasService.updateTableAndSync(EngineOperationType.ADD.getOperationType(), formSchema, null);
        return ApiResponse.success((Object)true);
    }

    @HussarTransactional
    public ApiResponse<Boolean> delete(String formId, String appId) throws Exception {
        AppContextUtil.setAppId((String)appId);
        this.formOperate.delete(formId);
        FormDesignResponse<Boolean> response = this.formCleaner.formClean(formId);
        if (((Boolean)response.getData()).booleanValue()) {
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.fail((String)response.getErrorMsg());
    }

    @HussarTransactional
    public ApiResponse<Boolean> appClean(String appId, List<String> formIds) {
        FormDesignResponse<Boolean> response;
        AppContextUtil.setAppId((String)appId);
        ApiResponse formRes = this.externalService.getFormListByAppId(Long.valueOf(appId));
        if (HussarUtils.isEmpty((Object)formRes.getData())) {
            return ApiResponse.success((Object)true);
        }
        List haveGroupList = ((SysSiftGroupList)formRes.getData()).getHaveGroupList();
        List noGroupList = ((SysSiftGroupList)formRes.getData()).getNoGroupList();
        ArrayList forms = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)haveGroupList)) {
            for (SysFormGroupVo sysFormGroupVo : haveGroupList) {
                List sysFormList = sysFormGroupVo.getSysFormList();
                if (!HussarUtils.isNotEmpty((Object)sysFormList)) continue;
                sysFormList.forEach(sysForm -> forms.add(String.valueOf(sysForm.getId())));
            }
        }
        if (HussarUtils.isNotEmpty((Object)noGroupList)) {
            noGroupList.forEach(sysForm -> forms.add(String.valueOf(sysForm.getId())));
        }
        if (HussarUtils.isNotEmpty(forms)) {
            forms.forEach(id -> {
                try {
                    this.formOperate.delete((String)id);
                }
                catch (Exception e) {
                    LOGGER.error("\u5220\u9664\u89e3\u6790\u5f15\u64ce\u6570\u636e\u5f02\u5e38\uff1a{}", id);
                }
            });
        }
        if (((Boolean)(response = this.formCleaner.appClean()).getData()).booleanValue()) {
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.fail((String)"\u5220\u9664\u5e94\u7528\u8d44\u6e90\u5931\u8d25");
    }

    public ApiResponse<List<DataFilterType>> filters(String widget) {
        ArrayList<DataFilterType> types = new ArrayList<DataFilterType>();
        if (HussarUtils.isEmpty((Object)widget)) {
            for (FilterType value : FilterType.values()) {
                DataFilterType type = new DataFilterType();
                type.setWidget(value.getWidgetType());
                type.setFilterTypes(value.getFilterTypes());
                types.add(type);
            }
            return ApiResponse.success(types);
        }
        DataFilterType type = new DataFilterType();
        type.setWidget(widget);
        type.setFilterTypes(FilterType.getFilters(widget));
        return ApiResponse.success(Collections.singletonList(type));
    }

    public ApiResponse<FieldControlSchema> fieldControllers(String formId, String appId) {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        FormDesignResponse fieldControlResponse = ((SettingSchemaService)SpringUtil.getBean((String)"no.code.fieldControl", SettingSchemaService.class)).get(formId);
        return ApiResponse.success((Object)fieldControlResponse.getData());
    }

    public ApiResponse<List<WidgetField>> widgets(String formId, String appId) {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        FormDesignResponse<List<WidgetField>> formDesignResponse = this.formOperate.widgetsForAuth(formId);
        ApiResponse response = new ApiResponse();
        response.setCode(formDesignResponse.getErrorCode());
        response.setMsg(formDesignResponse.getErrorMsg());
        response.setData(formDesignResponse.getData());
        return response;
    }

    public FormCanvasSchema initCanvas(BaseForm baseForm) {
        FormCanvasSchema canvas = (FormCanvasSchema)((Object)JSON.parseObject((String)JSON.toJSONString((Object)baseForm), FormCanvasSchema.class));
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("formLayout", "fixed");
        props.put("formWidth", 1000);
        props.put("fieldLayout", 0);
        props.put("labelAlign", "left");
        props.put("labelWidth", 84);
        canvas.setProps(props);
        canvas.setIsDetails(BASE_FORM);
        canvas.setPrimaryKey("RECORD_ID");
        SubmitSchema submitSchema = new SubmitSchema();
        submitSchema.setButtonText("\u63d0\u4ea4");
        submitSchema.setButtonIcon("el-icon-plus");
        HashMap<String, Boolean> settings = new HashMap<String, Boolean>();
        settings.put("saveLast", false);
        settings.put("showNext", true);
        submitSchema.setSettings(settings);
        canvas.getProps().put("submitSchema", submitSchema);
        return canvas;
    }

    public FormViewSchema initView(FormCanvasSchema canvas) {
        FormViewSchema view = new FormViewSchema();
        if (BASE_FORM.equals(canvas.getFormType())) {
            view = PageBuilderFactory.getDefaultViewSchema();
        }
        if (FLOW_FORM.equals(canvas.getFormType())) {
            view = PageBuilderFactory.getDefaultFlowViewSchema();
        }
        this.common(canvas, view);
        return view;
    }

    public FormSettingSchema initSetting(String formId, FormCanvasSchema canvas) {
        List<Widget> widgets = canvas.widgets();
        widgets.addAll(canvas.childTables());
        widgets = WidgetTool.settingWidgets(widgets, widget -> !widget.getIsRealField());
        FormSettingSchema setting = PageBuilderFactory.getDefaultSettingSchema();
        setting.setFormId(formId);
        FieldControlSchema fieldControlSchema = HussarUtils.isEmpty((Object)setting.getFieldControl()) ? new FieldControlSchema() : (FieldControlSchema)HussarUtils.copyProperties((Object)setting.getFieldControl(), FieldControlSchema.class);
        ArrayList<FieldControl> add = HussarUtils.isEmpty((Object)fieldControlSchema.getAdd()) ? new ArrayList() : fieldControlSchema.getAdd();
        ArrayList<FieldControl> edit = HussarUtils.isEmpty((Object)fieldControlSchema.getEdit()) ? new ArrayList() : fieldControlSchema.getEdit();
        ArrayList<FieldControl> detail = HussarUtils.isEmpty((Object)fieldControlSchema.getDetail()) ? new ArrayList() : fieldControlSchema.getDetail();
        FormCanvasUtil.getFieldControl(widgets, add);
        FormCanvasUtil.getFieldControl(widgets, edit);
        FormCanvasUtil.getFieldControl(widgets, detail);
        List<String> orders = canvas.widgetsWithChildren().stream().map(Widget::getName).collect(Collectors.toList());
        FormCanvasUtil.sortFieldControl(add, orders);
        FormCanvasUtil.sortFieldControl(edit, orders);
        FormCanvasUtil.sortFieldControl(detail, orders);
        fieldControlSchema.setAdd(add);
        fieldControlSchema.setEdit(edit);
        fieldControlSchema.setDetail(detail);
        setting.setFieldControl(fieldControlSchema);
        return setting;
    }

    private void common(FormCanvasSchema canvas, FormViewSchema view) {
        view.setAppId(AppContextUtil.getAppId());
        view.setFormId(canvas.getId());
        view.setFormName(canvas.getName());
        view.setFormTitle(canvas.getTitle());
        view.setPrimaryKey(canvas.getPrimaryKey());
        view.setFormType(canvas.getFormType());
        view.setFormIcon(canvas.getIcon());
    }

    public String getBusinessId(String requestMethod, String appId, String formId, String invokeMethod) {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        String url = FileUtil.posixPath((String[])new String[]{appId, formId, invokeMethod});
        return String.format("%s /%s", requestMethod, url);
    }

    public ResponseEntity<ApiResponse<Object>> queryBusinessData(String formId, String appId, Map<String, Object> params) {
        if (!((Boolean)WidgetTool.isSourceExist(appId, formId).getData()).booleanValue()) {
            ApiResponse objectApiResponse = new ApiResponse();
            objectApiResponse.setData(null);
            return ResponseEntity.of(Optional.of(objectApiResponse));
        }
        return this.invokeService.queryBusinessData(appId, formId, params);
    }

    public ResponseEntity<ApiResponse<Object>> queryReferTable(String formId, String appId, Map<String, Object> params) throws JsonProcessingException {
        if (!((Boolean)WidgetTool.isSourceExist(appId, formId).getData()).booleanValue()) {
            ApiResponse objectApiResponse = new ApiResponse();
            objectApiResponse.setData(new ArrayList());
            objectApiResponse.setCode(10000);
            return ResponseEntity.of(Optional.of(objectApiResponse));
        }
        FormDesignResponse<List<ResourceReference>> referRes = this.referenceService.get();
        List references = (List)referRes.getData();
        if (HussarUtils.isNotEmpty((Object)references)) {
            HashMap<String, String> referMap = new HashMap<String, String>();
            String refer = String.valueOf(params.get("refer"));
            List<String> refers = Arrays.asList(refer.split(","));
            for (ResourceReference reference : references) {
                List<String> referKey = reference.getReferKey();
                List<String> sourceKey = reference.getSourceKey();
                if (!HussarUtils.isNotEmpty(referKey) || !HussarUtils.isNotEmpty(sourceKey) || referKey.size() <= 2 || sourceKey.size() < 2) continue;
                String sourceAppId = sourceKey.get(0);
                String sourceFormId = sourceKey.get(1);
                if (!sourceAppId.equals(appId) || !sourceFormId.equals(formId)) continue;
                String referAppId = referKey.get(0);
                String referFormId = referKey.get(1);
                String key = this.labelSuffix(referKey.get(2), referKey.get(1));
                String field = sourceKey.get(2);
                FormCanvasSchema canvasSchema = (FormCanvasSchema)((Object)this.canvasService.get(sourceKey.get(1)).getData());
                List<Widget> childTables = canvasSchema.childTables();
                for (Widget childTable : childTables) {
                    Optional<Widget> first = childTable.getChildren().stream().filter(widget -> HussarUtils.equals((Object)widget.getName(), sourceKey.get(2))).findFirst();
                    if (!first.isPresent()) continue;
                    field = childTable.getName() + "." + field;
                }
                referMap.put(field, key);
            }
            String referId = String.valueOf(params.get("referId"));
            ArrayList<Filter> filters = new ArrayList<Filter>();
            Filter filter = new Filter();
            filter.setMatch("AND");
            filters.add(filter);
            ArrayList<Filter> children = new ArrayList<Filter>();
            for (String sourceKey : referMap.keySet()) {
                Filter childFilter = new Filter();
                childFilter.setMatch("OR");
                childFilter.setChildren(FormOperateExposedImpl.referConditionAssemble(sourceKey, referId));
                children.add(childFilter);
            }
            filter.setChildren(children);
            Object superQueryConditionObj = params.get("superQueryConditionDto");
            if (HussarUtils.isEmpty((Object)superQueryConditionObj)) {
                params.put("superQueryConditionDto", new ArrayList());
            }
            List superQueryConditionDto = JSON.parseArray((String)JSON.toJSONString((Object)params.get("superQueryConditionDto")), Filter.class);
            filters.addAll(superQueryConditionDto);
            params.replace("superQueryConditionDto", filters);
        }
        return this.invokeService.queryReferTable(appId, formId, params);
    }

    private static List<Filter> referConditionAssemble(String sourceKey, String referId) {
        ArrayList<Filter> childFilters = new ArrayList<Filter>();
        Filter refId = new Filter();
        refId.setField(String.format("%s_ref_id", sourceKey));
        refId.setRule(OperatorType.EQ.getValue());
        refId.setMatch("AND");
        refId.setVal(referId);
        childFilters.add(refId);
        return childFilters;
    }

    public ResponseEntity<ApiResponse<Object>> tableQuery(String formId, String viewId, Map<String, Object> params, String newAppId) {
        long time0 = System.currentTimeMillis();
        SysForm sysForm = new SysForm();
        Object objectForm = params.get(TABLE_QUERY_FROM);
        sysForm = HussarUtils.isNotEmpty((Object)objectForm) ? (SysForm)objectForm : (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
        this.tableQueryHookParams(formId, sysForm.getTableName(), params, newAppId);
        String cacheKey = String.format("%s:%s", FORM_EXT, formId);
        SysFormExtApi formExtApi = (SysFormExtApi)HussarCacheUtil.get((String)TABLE_QUERY_CACHE, (Object)cacheKey, SysFormExtApi.class);
        if (HussarUtils.isEmpty((Object)formExtApi)) {
            formExtApi = this.sysFormExtApiService.getSysFormExtApi(newAppId, formId, "tableQuery", params);
            if (HussarUtils.isEmpty((Object)formExtApi)) {
                formExtApi = new SysFormExtApi();
            }
            HussarCacheUtil.put((String)TABLE_QUERY_CACHE, (Object)cacheKey, (Object)formExtApi, (long)3600L);
        }
        if (HussarUtils.isNotEmpty((Object)formExtApi.getFormId())) {
            HashMap<String, String> requestParam = new HashMap<String, String>();
            requestParam.put("formId", formId);
            requestParam.put("viewId", viewId);
            requestParam.put("appId", newAppId);
            ResponseEntity responseEntity = this.sysFormExtApiService.invoke(formExtApi, requestParam, params);
            ApiResponse body = (ApiResponse)responseEntity.getBody();
            if (body.getData() instanceof Map) {
                ApiResponse responseEntityBody;
                Map resMap = (Map)body.getData();
                String jsonString = JsonUtil.toJson((Object)resMap);
                PageVo pageVo = (PageVo)JSON.parseObject((String)jsonString, PageVo.class);
                if (HussarUtils.isNotEmpty((Object)pageVo.getData())) {
                    ArrayList pageVoData = (ArrayList)pageVo.getData();
                    List entities = pageVoData.stream().map(jsonObject -> (EngineResultEntity)JSON.parseObject((String)jsonObject.toJSONString(), EngineResultEntity.class)).collect(Collectors.toList());
                    pageVo = new PageVo(entities, pageVo.getCount());
                }
                if (HussarUtils.isNotEmpty((Object)(responseEntityBody = (ApiResponse)responseEntity.getBody()))) {
                    responseEntityBody.setData((Object)pageVo);
                }
            }
            if (body.getData() instanceof PageVo) {
                PageVo pageVo = (PageVo)body.getData();
                pageVo.setExtApi(Boolean.valueOf(true));
                ApiResponse responseEntityBody = (ApiResponse)responseEntity.getBody();
                if (HussarUtils.isNotEmpty((Object)responseEntityBody)) {
                    responseEntityBody.setData((Object)pageVo);
                }
            }
            this.tableQueryHook(formId, sysForm.getTableName(), params, newAppId, (ApiResponse<Object>)((ApiResponse)responseEntity.getBody()));
            return responseEntity;
        }
        if (HussarUtils.isNotEmpty((Object)newAppId)) {
            AppContextUtil.setAppId((String)newAppId);
        }
        HashMap<String, Object> newparams = new HashMap();
        try {
            newparams = this.formatParamsTime(formId, params);
        }
        catch (Exception e) {
            LOGGER.error("\u9ad8\u7ea7\u67e5\u8be2\u65f6\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff1a", (Throwable)e);
            newparams = params;
        }
        params.remove(TABLE_QUERY_FROM);
        long time1 = System.currentTimeMillis();
        LOGGER.info("--------------invokeService.tableQuery\u524d\u8017\u65f6\uff1a{}", (Object)(time1 - time0));
        ResponseEntity<ApiResponse<Object>> apiResponseResponseEntity = this.invokeService.tableQuery(newAppId, formId, viewId, newparams);
        long time2 = System.currentTimeMillis();
        LOGGER.info("--------------invokeService.tableQuery\u8017\u65f6\uff1a{}", (Object)(time2 - time1));
        this.tableQueryHook(formId, sysForm.getTableName(), params, newAppId, (ApiResponse<Object>)((ApiResponse)apiResponseResponseEntity.getBody()));
        long time3 = System.currentTimeMillis();
        LOGGER.info("--------------invokeService.tableQuery\u540e\u8017\u65f6\uff1a{}", (Object)(time3 - time2));
        LOGGER.info("--------------FormOperateExposedImpl.tableQuery\u603b\u8017\u65f6\uff1a{}", (Object)(time3 - time0));
        return apiResponseResponseEntity;
    }

    private void tableQueryHookParams(String formId, String tableName, Map<String, Object> params, String newAppId) {
        TableQueryHookDto tableQueryHookDto = new TableQueryHookDto();
        tableQueryHookDto.setAppId(Long.valueOf(newAppId));
        tableQueryHookDto.setFormId(Long.valueOf(formId));
        HookParamDto hookParamDto = new HookParamDto();
        if (HussarUtils.isNotEmpty((Object)params.get("current"))) {
            hookParamDto.setCurrent(((Integer)params.get("current")).intValue());
        }
        if (HussarUtils.isNotEmpty((Object)params.get("size"))) {
            hookParamDto.setSize(((Integer)params.get("size")).intValue());
        }
        List orders = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)params.get("orders"))) {
            orders = JSON.parseArray((String)JSON.toJSONString((Object)params.get("orders")), HookOrderDto.class);
        }
        hookParamDto.setOrders(orders);
        List hookQueryConditionDtoList = JSON.parseArray((String)JSON.toJSONString((Object)params.get("superQueryConditionDto")), HookQueryConditionDto.class);
        hookParamDto.setHookQueryConditionDtos(hookQueryConditionDtoList);
        tableQueryHookDto.setHookParamDto(hookParamDto);
        if (HussarUtils.isNotEmpty((Object)this.formOperateHookService)) {
            this.formOperateHookService.beforeTableQuery(tableQueryHookDto);
        }
        this.hookUtil.beforeTableQuery(formId, tableName, tableQueryHookDto);
        HookParamDto hookParamDtoResp = tableQueryHookDto.getHookParamDto();
        int current = hookParamDtoResp.getCurrent();
        params.put("current", current);
        int size = hookParamDtoResp.getSize();
        params.put("size", size);
        List ordersResp = hookParamDtoResp.getOrders();
        params.put("orders", ordersResp);
        List hookQueryConditionDtos = hookParamDtoResp.getHookQueryConditionDtos();
        params.put("superQueryConditionDto", hookQueryConditionDtos);
    }

    private void tableQueryHook(String formId, String tableName, Map<String, Object> params, String newAppId, ApiResponse<Object> tableQueryResponse) {
        TableQueryHookDto tableQueryHookDto = new TableQueryHookDto();
        tableQueryHookDto.setAppId(Long.valueOf(newAppId));
        tableQueryHookDto.setFormId(Long.valueOf(formId));
        HookParamDto hookParamDto = new HookParamDto();
        hookParamDto.setCurrent(((Integer)params.get("current")).intValue());
        hookParamDto.setSize(((Integer)params.get("size")).intValue());
        params.get("orders");
        List orders = JSON.parseArray((String)JSON.toJSONString((Object)params.get("orders")), HookOrderDto.class);
        hookParamDto.setOrders(orders);
        List hookQueryConditionDtoList = JSON.parseArray((String)JSON.toJSONString((Object)params.get("superQueryConditionDto")), HookQueryConditionDto.class);
        hookParamDto.setHookQueryConditionDtos(hookQueryConditionDtoList);
        tableQueryHookDto.setHookParamDto(hookParamDto);
        if (HussarUtils.isNotEmpty((Object)this.formOperateHookService)) {
            this.formOperateHookService.tableQueryHook(tableQueryHookDto, tableQueryResponse);
        }
        this.hookUtil.tableQueryHook(formId, tableName, tableQueryHookDto, tableQueryResponse);
    }

    public ResponseEntity<ApiResponse<Object>> tableQueryAll(String appId, String formId) {
        SysFormExtApi formExtApi = this.sysFormExtApiService.getSysFormExtApi(appId, formId, "tableQueryAll", null);
        if (HussarUtils.isNotEmpty((Object)formExtApi)) {
            HashMap<String, String> requestParam = new HashMap<String, String>();
            requestParam.put("appId", appId);
            requestParam.put("formId", formId);
            return this.sysFormExtApiService.invoke(formExtApi, requestParam, null);
        }
        return this.invokeService.tableQueryAll(appId, formId);
    }

    public ResponseEntity<ApiResponse<Object>> tableQueryByCondition(String appId, String formId, Map<String, Object> params) {
        HashMap<String, Object> newparams = new HashMap();
        try {
            newparams = this.formatParamsTime(formId, params);
        }
        catch (Exception e) {
            LOGGER.error("\u9ad8\u7ea7\u67e5\u8be2\u65f6\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff1a", (Throwable)e);
            newparams = params;
        }
        newparams.put("BC8D215A-26F1-9B83-4DE2-7867003DA241", "BC8D215A-26F1-9B83-4DE2-7867003DA241");
        return this.invokeService.tableQueryByCondition(appId, formId, newparams);
    }

    public ResponseEntity<ApiResponse<Object>> tableQueryByConditionWithAuth(String appId, String formId, Map<String, Object> params) {
        HashMap<String, Object> newparams = new HashMap();
        try {
            newparams = this.formatParamsTime(formId, params);
        }
        catch (Exception e) {
            LOGGER.error("\u9ad8\u7ea7\u67e5\u8be2\u65f6\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff1a", (Throwable)e);
            newparams = params;
        }
        return this.invokeService.tableQueryByConditionWithAuth(appId, formId, newparams);
    }

    private Map<String, Object> formatParamsTime(String formId, Map<String, Object> params) {
        SysForm sysForm = new SysForm();
        Object objectForm = params.get(TABLE_QUERY_FROM);
        sysForm = HussarUtils.isNotEmpty((Object)objectForm) ? (SysForm)objectForm : (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
        Map newParam = (Map)JSON.parseObject((String)JSON.toJSONString(params, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        JSONArray filterJsonArray = (JSONArray)newParam.get("superQueryConditionDto");
        String json = JSON.toJSONString((Object)filterJsonArray);
        List filters = JSON.parseArray((String)json, Filter.class);
        if (filters != null && !filters.isEmpty()) {
            FormCanvasSchema canvas = (FormCanvasSchema)((Object)this.canvasSchemaService.get(sysForm).getData());
            List<Widget> widgets = canvas.getWidgets();
            block11: for (Filter filter : filters) {
                String field = filter.getField();
                String rule = filter.getRule();
                AtomicBoolean isRealFieldF = new AtomicBoolean(true);
                if (!"_eq".equals(rule) && !"_ne".equals(rule) && !"_between".equals(rule) && !"_notBetween".equals(rule)) continue;
                ArrayList<String> formats = new ArrayList<String>();
                String[] parts = rule.split("\\.", 2);
                if (parts.length == 2 && !parts[0].isEmpty() && !parts[1].isEmpty()) {
                    formats.addAll(widgets.stream().filter(widget -> (WidgetType.CHILDREN_TABLE.getType().equals(widget.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(widget.getType())) && widget.getName().equals(parts[0])).flatMap(widget -> widget.getChildren().stream()).filter(child -> WidgetType.DATE.getType().equals(child.getType()) && child.getName().equals(parts[1])).map(child -> child.getProps().getString("format")).collect(Collectors.toList()));
                    formats.addAll(widgets.stream().filter(widget -> WidgetType.GROUP.getType().equals(widget.getType())).flatMap(groupWidget -> groupWidget.getChildren().stream()).filter(child -> (WidgetType.CHILDREN_TABLE.getType().equals(child.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(child.getType())) && child.getName().equals(parts[0])).flatMap(widget -> widget.getChildren().stream()).filter(child -> WidgetType.DATE.getType().equals(child.getType()) && child.getName().equals(parts[1])).map(child -> child.getProps().getString("format")).collect(Collectors.toList()));
                    formats.addAll(widgets.stream().filter(widget -> WidgetType.JXDNTabs.getType().equals(widget.getType())).flatMap(groupWidget -> groupWidget.getChildren().stream()).flatMap(childChildren -> childChildren.getChildren().stream()).filter(child -> (WidgetType.CHILDREN_TABLE.getType().equals(child.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(child.getType())) && child.getName().equals(parts[0])).flatMap(widget -> widget.getChildren().stream()).filter(child -> WidgetType.DATE.getType().equals(child.getType()) && child.getName().equals(parts[1])).map(child -> child.getProps().getString("format")).collect(Collectors.toList()));
                } else {
                    if (HussarUtils.isNotEmpty(widgets)) {
                        for (Widget widget2 : widgets) {
                            if (!WidgetType.DATE.getType().equals(widget2.getType()) || !field.equals(widget2.getName())) continue;
                            formats.add(widget2.getProps().getString("format"));
                        }
                    }
                    this.startTimeHandle(field, params, formats, isRealFieldF);
                }
                if (formats.isEmpty()) continue;
                switch (rule) {
                    case "_eq": {
                        Object[] timeRangeBetween = TimeFormatUtil.timeToTimeTange(field, isRealFieldF, (String)formats.get(0), filter.getVal());
                        if (!HussarUtils.isNotEmpty((Object[])timeRangeBetween)) break;
                        filter.setRule("_between");
                        filter.setVal(JSON.toJSONString((Object)timeRangeBetween));
                        break;
                    }
                    case "_ne": {
                        Object[] timeRangeNotBetween = TimeFormatUtil.timeToTimeTange(field, isRealFieldF, (String)formats.get(0), filter.getVal());
                        if (!HussarUtils.isNotEmpty((Object[])timeRangeNotBetween)) break;
                        filter.setRule("_notBetween");
                        filter.setVal(JSON.toJSONString((Object)timeRangeNotBetween));
                        break;
                    }
                    case "_between": 
                    case "_notBetween": {
                        String val = filter.getVal();
                        if (HussarUtils.isEmpty((Object)val)) continue block11;
                        val = val.substring(1, val.length() - 1);
                        String[] strArray = val.split("\",\\s*\"");
                        for (int i = 0; i < strArray.length; ++i) {
                            strArray[i] = strArray[i].replace("\"", "");
                        }
                        String start = strArray[0];
                        String end = strArray[1];
                        if (!HussarUtils.isNotEmpty((Object)start) || !HussarUtils.isNotEmpty((Object)end)) break;
                        String startTime = TimeFormatUtil.formatStartTime((String)formats.get(0), start);
                        String endTime = TimeFormatUtil.formatEndTime((String)formats.get(0), end);
                        strArray[0] = startTime;
                        strArray[1] = endTime;
                        filter.setVal(JSON.toJSONString((Object)strArray));
                    }
                }
                newParam.put("superQueryConditionDto", filters);
            }
        }
        return newParam;
    }

    private void startTimeHandle(String field, Map<String, Object> params, List<String> formats, AtomicBoolean isRealFieldF) {
        try {
            if (HussarUtils.equals((Object)field, (Object)"START_TIME")) {
                LinkedHashMap o2;
                List filterConfig;
                Optional<Object> objectOptional;
                Object config = params.get("filterConfig");
                if (HussarUtils.isEmpty((Object)config)) {
                    isRealFieldF.set(false);
                    formats.add("yyyy-MM-dd HH:mm:ss");
                } else if (config instanceof ArrayList && (objectOptional = (filterConfig = (List)params.get("filterConfig")).stream().filter(o -> {
                    if (o instanceof LinkedHashMap) {
                        LinkedHashMap jsonObject = (LinkedHashMap)o;
                        String fieldS = String.valueOf(jsonObject.get("field"));
                        boolean isRealField = (Boolean)jsonObject.get("isRealField");
                        isRealFieldF.set(isRealField);
                        return HussarUtils.equals((Object)fieldS, (Object)field) && !isRealField;
                    }
                    return false;
                }).findFirst()).isPresent() && objectOptional.get() instanceof LinkedHashMap && (o2 = (LinkedHashMap)objectOptional.get()).get("props") instanceof LinkedHashMap) {
                    LinkedHashMap props = (LinkedHashMap)o2.get("props");
                    String format = String.valueOf(props.get("format"));
                    formats.add(format);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("START_TIME\u65f6\u95f4\u683c\u5f0f\u5904\u7406\u5931\u8d25,\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(params));
            LOGGER.error("START_TIME\u65f6\u95f4\u683c\u5f0f\u5904\u7406\u5931\u8d25", (Throwable)e);
        }
    }

    @DataOperateLog(moduleCode="tableSave", handleName="\u8868\u5355\u6570\u636e\u6279\u91cf\u4fdd\u5b58")
    public void tableSave(String appId, String formId, Map<String, Object> params) {
        Object type = params.get("importType");
        List importList = (List)params.get("importList");
        this.setIdAndTableNameColumnValue(formId, (List<Object>)importList, type);
        SysFormExtApi formExtApi = this.sysFormExtApiService.getSysFormExtApi(appId, formId, "tableSave", params);
        if (HussarUtils.isNotEmpty((Object)formExtApi)) {
            HashMap<String, String> requestParam = new HashMap<String, String>();
            requestParam.put("appId", appId);
            requestParam.put("formId", formId);
            this.sysFormExtApiService.invoke(formExtApi, requestParam, params);
            return;
        }
        this.invokeService.tableSave(appId, formId, params);
    }

    @DataOperateLog(moduleCode="saveBatchMore", handleName="\u8868\u5355\u6570\u636e\u6279\u91cf\u4fdd\u5b58")
    public void saveBatchMore(String appId, String formId, Map<String, Object> params) {
        List importList = (List)params.get("importList");
        this.setIdAndTableNameColumnValue(formId, (List<Object>)importList, null);
        SysFormExtApi formExtApi = this.sysFormExtApiService.getSysFormExtApi(appId, formId, "tableSave", params);
        if (HussarUtils.isNotEmpty((Object)formExtApi)) {
            HashMap<String, String> requestParam = new HashMap<String, String>();
            requestParam.put("appId", appId);
            requestParam.put("formId", formId);
            this.sysFormExtApiService.invoke(formExtApi, requestParam, params);
            return;
        }
        this.invokeService.saveBatchMore(appId, formId, params);
    }

    public ResponseEntity<ApiResponse<Object>> formQuery(String formId, String id, String tabType, String appId, boolean isOutLinkQuery) {
        ResponseEntity<ApiResponse<Object>> responseEntity;
        SysFormExtApi formExtApi;
        if (HussarUtils.isEmpty((Object)appId)) {
            SysForm sysForm = (SysForm)this.sysFormService.getDetailById(Long.valueOf(formId)).getData();
            if (HussarUtils.isEmpty((Object)sysForm)) {
                return ResponseEntity.ok((Object)ApiResponse.fail((IResultCode)LcdpExceptionEnum.FORM_NOT_FOUND));
            }
            appId = String.valueOf(sysForm.getAppId());
        }
        if (HussarUtils.isNotEmpty((Object)(formExtApi = this.sysFormExtApiService.getSysFormExtApi(appId, formId, "formQuery", null)))) {
            HashMap<String, String> requestParam = new HashMap<String, String>();
            requestParam.put("formId", formId);
            requestParam.put("id", id);
            requestParam.put("tabType", tabType);
            requestParam.put("appId", appId);
            return this.sysFormExtApiService.invoke(formExtApi, requestParam, null);
        }
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        HashMap<String, Object> tableQueryParams = new HashMap<String, Object>();
        ArrayList orderItems = Lists.newArrayListWithCapacity((int)1);
        FormDesignResponse<FormCanvasSchema> formDesignResponse = this.canvasSchemaService.get(formId);
        FormCanvasSchema formCanvasSchema = null;
        if (HussarUtils.isNotEmpty(formDesignResponse) && HussarUtils.isNotEmpty((Object)formDesignResponse.getData())) {
            formCanvasSchema = (FormCanvasSchema)((Object)formDesignResponse.getData());
            List<Widget> childTables = formCanvasSchema.childTables();
            List<Widget> widgets = WidgetTool.flatAllTableWidget(childTables);
            this.dealChildTableFieldSorted(widgets, orderItems);
        }
        tableQueryParams.put("orders", orderItems);
        if ((HussarUtils.isEmpty((Object)tabType) || HussarUtils.equals((Object)tabType, (Object)BASE_FORM)) && ((ApiResponse)(responseEntity = this.invokeService.formQuery(appId, formId, id, isOutLinkQuery, tableQueryParams)).getBody()).isSuccess() && HussarUtils.isNotEmpty((Object)((ApiResponse)responseEntity.getBody()).getData())) {
            return responseEntity;
        }
        if ((HussarUtils.isEmpty((Object)tabType) || HussarUtils.equals((Object)tabType, (Object)"2") || HussarUtils.equals((Object)tabType, (Object)FLOW_FORM) || HussarUtils.equals((Object)tabType, (Object)"3")) && HussarUtils.equals((Object)formCanvasSchema.getFormType(), (Object)FLOW_FORM)) {
            ArrayList<Filter> filters = new ArrayList<Filter>(1);
            Filter dataIdFilter = new Filter();
            dataIdFilter.setField("RECORD_ID");
            dataIdFilter.setMatch("AND");
            dataIdFilter.setRule("_Eq");
            dataIdFilter.setVal(id);
            filters.add(dataIdFilter);
            tableQueryParams.put("current", 1);
            tableQueryParams.put("size", 1);
            tableQueryParams.put("aggFlag", false);
            tableQueryParams.put("superQueryConditionDto", filters);
            ResponseEntity<ApiResponse<Object>> tableQuery = HussarUtils.equals((Object)tabType, (Object)FLOW_FORM) ? this.tableQuery(formId, ViewIdEnum.SYS_FLOW_DONE.getId(), tableQueryParams, appId) : (HussarUtils.equals((Object)tabType, (Object)"2") ? this.tableQuery(formId, ViewIdEnum.SYS_FLOW_TASK.getId(), tableQueryParams, appId) : this.tableQuery(formId, ViewIdEnum.SYS_FLOW_DRAFT.getId(), tableQueryParams, appId));
            PageVo data = (PageVo)((ApiResponse)tableQuery.getBody()).getData();
            if (data.getCount() == null || data.getCount() == 0L) {
                if (HussarUtils.equals((Object)tabType, (Object)"2") && (data = (PageVo)((ApiResponse)(tableQuery = this.tableQuery(formId, ViewIdEnum.SYS_FLOW_DONE.getId(), tableQueryParams, appId)).getBody()).getData()).getCount() != null && data.getCount() > 0L) {
                    return ResponseEntity.ok((Object)ApiResponse.success(data.getData().get(0)));
                }
                if (HussarUtils.isNotEmpty((Object)tabType) && HussarUtils.isNotEmpty(tableQuery = this.tableQuery(formId, ViewIdEnum.SYS_ORDINARY_ALL_DATA.getId(), tableQueryParams, appId)) && HussarUtils.isNotEmpty((Object)((ApiResponse)tableQuery.getBody()).getData())) {
                    PageVo dataAll = (PageVo)((ApiResponse)tableQuery.getBody()).getData();
                    if (HussarUtils.isEmpty((Object)dataAll.getData())) {
                        return ResponseEntity.ok((Object)ApiResponse.fail((IResultCode)LcdpExceptionEnum.NO_DATA_PREMISSION));
                    }
                    return ResponseEntity.ok((Object)ApiResponse.success(dataAll.getData().get(0)));
                }
                return ResponseEntity.ok((Object)ApiResponse.fail((IResultCode)LcdpExceptionEnum.NO_DATA_PREMISSION));
            }
            return ResponseEntity.ok((Object)ApiResponse.success(data.getData().get(0)));
        }
        return ResponseEntity.ok((Object)ApiResponse.fail((IResultCode)LcdpExceptionEnum.NO_DATA_PREMISSION));
    }

    private void dealChildTableFieldSorted(List<Widget> widgets, List<OrderItem> orders) {
        for (Widget widget : widgets) {
            String orderType = String.valueOf(widget.getProps().get((Object)FormQuerySortEnum.ORDER_TYPE.getValue()));
            if (HussarUtils.equals((Object)orderType, (Object)FormQuerySortEnum.FIELD_SORT.getValue()) || HussarUtils.isEmpty((Object)orderType)) {
                Object childrenOrders = widget.getProps().get((Object)FormQuerySortEnum.ORDER_BY.getValue());
                List childOrders = JSON.parseArray((String)JSON.toJSONString((Object)childrenOrders), OrderItem.class);
                if (HussarUtils.isEmpty((Object)childOrders)) {
                    OrderItem orderItem = new OrderItem();
                    orderItem.setColumn(widget.getName() + "." + FormQuerySortEnum.CREATE_TIME_DATE.getValue());
                    orders.add(orderItem);
                    continue;
                }
                for (OrderItem order : childOrders) {
                    order.setColumn(widget.getName() + "." + order.getColumn());
                }
                orders.addAll(childOrders);
                continue;
            }
            OrderItem orderItem = new OrderItem();
            orderItem.setColumn(widget.getName() + "." + FormQuerySortEnum.SEQ.getValue());
            orders.add(orderItem);
        }
    }

    public ResponseEntity<ApiResponse<Object>> formQueryFormRefer(String appId, String formId, String id) {
        String headApp = AppContextUtil.getAppId();
        if (HussarUtils.isEmpty((Object)headApp)) {
            AppContextUtil.setAppId((String)appId);
        }
        return this.invokeService.formQueryFormRefer(appId, formId, id);
    }

    public ApiResponse<FormVerifyVO> formVerify(String appId, String formId, String id) {
        ResponseEntity response;
        SysFormExtApi formExtApi = this.sysFormExtApiService.getSysFormExtApi(appId, formId, "formQuery", null);
        if (HussarUtils.isNotEmpty((Object)formExtApi)) {
            HashMap<String, String> requestParam = new HashMap<String, String>();
            requestParam.put("formId", formId);
            requestParam.put("id", id);
            requestParam.put("appId", appId);
            response = this.sysFormExtApiService.invoke(formExtApi, requestParam, null);
        } else {
            response = this.invokeService.formVerify(appId, formId, id);
        }
        FormVerifyVO formVerifyVO = new FormVerifyVO();
        ApiResponse<Boolean> sourceExist = WidgetTool.isSourceExist(appId, formId);
        if (!((Boolean)sourceExist.getData()).booleanValue()) {
            ApiResponse voApiResponse = new ApiResponse();
            voApiResponse.setCode(sourceExist.getCode());
            voApiResponse.setMsg(sourceExist.getMsg());
            return voApiResponse;
        }
        formVerifyVO.setForm(this.getCanvas(formId, appId));
        if (HussarUtils.isEmpty((Object)((ApiResponse)response.getBody()).getData())) {
            ApiResponse voApiResponse = new ApiResponse();
            voApiResponse.setCode(LcdpExceptionEnum.NO_DATA_PREMISSION.getCode());
            voApiResponse.setMsg(LcdpExceptionEnum.NO_DATA_PREMISSION.getMsg());
            return voApiResponse;
        }
        formVerifyVO.setFormData(((ApiResponse)response.getBody()).getData());
        return ApiResponse.success((Object)formVerifyVO);
    }

    @HussarTransactional
    @DataOperateLog(moduleCode="deleteBatch", handleName="\u8868\u5355\u6570\u636e\u6279\u91cf\u5220\u9664")
    public ResponseEntity<ApiResponse<Object>> deleteBatch(String formId, String ids, String newAppId) {
        Boolean flag;
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
        if (HussarUtils.isNotEmpty((Object)newAppId)) {
            AppContextUtil.setAppId((String)newAppId);
        }
        if (!(flag = this.sysFormLinkSingleService.deleteBatch(ids)).booleanValue()) {
            return ResponseEntity.of(Optional.of(ApiResponse.fail((String)"\u5220\u9664\u5916\u94fe\u6570\u636e\u5931\u8d25")));
        }
        Boolean flagInner = this.sysFormLinkSingleInnerService.deleteBatch(ids);
        if (!flagInner.booleanValue()) {
            return ResponseEntity.of(Optional.of(ApiResponse.fail((String)"\u5220\u9664\u5e94\u7528\u5185\u5916\u94fe\u6570\u636e\u5931\u8d25")));
        }
        ResponseEntity<ApiResponse<Object>> responseEntity = this.invokeService.deleteBatch(newAppId, formId, ids);
        this.formDataDeleteBatchHook(newAppId, formId, sysForm.getTableName(), ids);
        return responseEntity;
    }

    private void formDataDeleteBatchHook(String newAppId, String formId, String tableName, String ids) {
        FormDataDeleteHookDto formDataDeleteHookDto = new FormDataDeleteHookDto();
        formDataDeleteHookDto.setAppId(Long.valueOf(newAppId));
        formDataDeleteHookDto.setFormId(Long.valueOf(formId));
        formDataDeleteHookDto.setIds(ids);
        this.hookUtil.formDataDeleteBatchHook(formId, tableName, formDataDeleteHookDto);
    }

    @DataOperateLog(moduleCode="formSave", handleName="\u8868\u5355\u6570\u636e\u4fdd\u5b58", saveDataOperateLog="#saveDataOperateLog")
    public ResponseEntity<ApiResponse<Object>> formSave(String formId, Map<String, Object> params, String newAppId, Boolean saveDataOperateLog) {
        this.setIdAndTableNameColumnValue(formId, params);
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
        this.formSaveHookParams(formId, sysForm.getTableName(), newAppId, params);
        SysFormExtApi formExtApi = this.sysFormExtApiService.getSysFormExtApi(newAppId, formId, "formSave", params);
        if (HussarUtils.isNotEmpty((Object)formExtApi)) {
            HashMap<String, String> requestParam = new HashMap<String, String>();
            requestParam.put("appId", newAppId);
            requestParam.put("formId", formId);
            ResponseEntity responseEntity = this.sysFormExtApiService.invoke(formExtApi, requestParam, params);
            this.formSaveHook(formId, sysForm.getTableName(), newAppId, params, (ApiResponse<Object>)((ApiResponse)responseEntity.getBody()));
            return responseEntity;
        }
        if (HussarUtils.isNotEmpty((Object)newAppId)) {
            AppContextUtil.setAppId((String)newAppId);
        }
        ResponseEntity<ApiResponse<Object>> responseEntity = this.invokeService.formSave(newAppId, formId, params);
        this.formSaveHook(formId, sysForm.getTableName(), newAppId, params, (ApiResponse<Object>)((ApiResponse)responseEntity.getBody()));
        return responseEntity;
    }

    private void formSaveHookParams(String formId, String tableName, String newAppId, Map<String, Object> params) {
        FormSaveHookDto formSaveHookDto = new FormSaveHookDto();
        formSaveHookDto.setFormId(Long.valueOf(formId));
        formSaveHookDto.setAppId(Long.valueOf(newAppId));
        formSaveHookDto.setParams(params);
        if (HussarUtils.isNotEmpty((Object)this.formOperateHookService)) {
            this.formOperateHookService.beforeFormSave(formSaveHookDto);
        }
        this.hookUtil.beforeFormSave(formId, tableName, formSaveHookDto);
    }

    private void formSaveHook(String formId, String tableName, String newAppId, Map<String, Object> params, ApiResponse<Object> formSaveResponse) {
        FormSaveHookDto formSaveHookDto = new FormSaveHookDto();
        formSaveHookDto.setFormId(Long.valueOf(formId));
        formSaveHookDto.setAppId(Long.valueOf(newAppId));
        formSaveHookDto.setParams(params);
        if (HussarUtils.isNotEmpty((Object)this.formOperateHookService)) {
            this.formOperateHookService.formSaveHook(formSaveHookDto, formSaveResponse);
        }
        this.hookUtil.formSaveHook(formId, tableName, formSaveHookDto, formSaveResponse);
    }

    @DataOperateLog(moduleCode="formIncrementSave", handleName="\u8868\u5355\u6570\u636e\u589e\u91cf\u4fdd\u5b58")
    public ResponseEntity<ApiResponse<Object>> formIncrementSave(String formId, Map<String, Object> params, String newAppId) {
        SysFormExtApi formExtApi;
        if (HussarUtils.isNotEmpty((Object)newAppId)) {
            AppContextUtil.setAppId((String)newAppId);
        }
        SysForm form = this.applicationService.getFormDetailById(Long.valueOf(Long.parseLong(formId)));
        HashMap saveAndUpdateMap = (HashMap)params.get("saveAndUpdate");
        if (HussarUtils.isNotEmpty((Object)saveAndUpdateMap)) {
            List dataMapList = (List)saveAndUpdateMap.get(form.getTableName());
            this.setIdAndTableNameColumnValue(formId, (List<Object>)dataMapList, null);
        }
        if (HussarUtils.isNotEmpty((Object)(formExtApi = this.sysFormExtApiService.getSysFormExtApi(newAppId, formId, "tableSave", params)))) {
            HashMap<String, String> requestParam = new HashMap<String, String>();
            requestParam.put("appId", newAppId);
            requestParam.put("formId", formId);
            Map saveAndUpdate = (Map)params.get("saveAndUpdate");
            HashMap newParam = new HashMap();
            if (HussarUtils.isNotEmpty((Object)saveAndUpdate)) {
                SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
                newParam.put("importList", saveAndUpdate.get(sysForm.getTableName()));
            } else {
                newParam.put("importList", Collections.EMPTY_LIST);
            }
            return this.sysFormExtApiService.invoke(formExtApi, requestParam, newParam);
        }
        return this.invokeService.formIncrementSave(newAppId, formId, params);
    }

    private void setIdAndTableNameColumnValue(String formId, Map<String, Object> params) {
        FormDesignResponse<FormCanvasSchema> formDesignResponse = this.canvasSchemaService.get(formId);
        if (HussarUtils.isEmpty((Object)formDesignResponse.getData())) {
            LOGGER.error("\u83b7\u53d6\u8868\u5355\u5b57\u6bb5 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            throw new BaseException("\u8868\u5355\u753b\u5e03\u4e0d\u5b58\u5728");
        }
        this.setIdAndTableNameColumnValue((FormCanvasSchema)((Object)formDesignResponse.getData()), params, null);
        this.parseSuggestValueToJsonString((FormCanvasSchema)((Object)formDesignResponse.getData()), params);
    }

    private void setIdAndTableNameColumnValue(String formId, List<Object> importList, Object type) {
        SysForm form = this.applicationService.getFormDetailById(Long.valueOf(formId));
        this.setIdAndTableNameColumnValue(form, importList, type);
    }

    private void setIdAndTableNameColumnValue(SysForm sysForm, List<Object> importList, Object type) {
        FormDesignResponse<FormCanvasSchema> formDesignResponse = this.canvasSchemaService.get(sysForm);
        if (HussarUtils.isEmpty((Object)formDesignResponse.getData())) {
            LOGGER.error("\u83b7\u53d6\u8868\u5355\u5b57\u6bb5 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)sysForm.getId());
            throw new BaseException("\u8868\u5355\u753b\u5e03\u4e0d\u5b58\u5728");
        }
        importList.forEach(params -> {
            this.setIdAndTableNameColumnValue((FormCanvasSchema)((Object)((Object)formDesignResponse.getData())), (Map)params, type);
            this.parseSuggestValueToJsonString((FormCanvasSchema)((Object)((Object)formDesignResponse.getData())), (Map)params);
        });
    }

    private void setIdAndTableNameColumnValue(FormCanvasSchema canvasSchema, Map<String, Object> params, Object type) {
        if (HussarUtils.isEmpty((Object)params.get("RECORD_ID"))) {
            params.put("RECORD_ID", EngineUtil.getId());
        } else {
            this.paddingSubTableColumn(canvasSchema, params, type);
        }
        params.put(canvasSchema.getName(), params.get("RECORD_ID"));
        canvasSchema.childTables().forEach(childTable -> this.setChildIdAndTableName((Widget)childTable, (List)params.get(childTable.getName()), params.get("RECORD_ID"), null));
    }

    private void setChildIdAndTableName(Widget widget, List<Map<String, Object>> childList, Object fid, Object gid) {
        if (HussarUtils.isNotEmpty(childList)) {
            childList.forEach(child -> {
                List<Widget> cs;
                if (ToolUtil.isEmpty(child.get("RECORD_ID"))) {
                    child.put("RECORD_ID", EngineUtil.getId());
                }
                child.put(widget.getName(), child.get("RECORD_ID"));
                child.put("F_RECORD_ID", fid);
                if (gid != null) {
                    child.put("G_RECORD_ID", gid);
                }
                if (CollUtil.isNotEmpty(cs = WidgetTool.flatButChildren(new ArrayList<Widget>(), widget.getChildren()))) {
                    cs.forEach(e -> this.setChildIdAndTableName((Widget)e, (List)child.get(e.getName()), child.get("RECORD_ID"), gid == null ? fid : gid));
                }
            });
        }
    }

    private void parseSuggestValueToJsonString(FormCanvasSchema canvasSchema, Map<String, Object> params) {
        canvasSchema.widgets().stream().filter(widget -> HussarUtils.equals((Object)widget.getType(), (Object)WidgetType.JXDN_SUGGESTION.getType())).forEach(widget -> {
            Object suggestValue = params.get(widget.getName());
            if (HussarUtils.isNotEmpty(suggestValue) && !(suggestValue instanceof String)) {
                params.put(widget.getName(), JSON.toJSONString(suggestValue));
            }
        });
    }

    private void paddingSubTableColumn(FormCanvasSchema canvasSchema, Map<String, Object> params, Object type) {
        if (HussarUtils.isNotEmpty((Object)type) && type.equals("appImport")) {
            return;
        }
        if (!HussarUtils.isEmpty((Object)params.get("RECORD_ID")) && HussarUtils.isNotEmpty(canvasSchema.childTables())) {
            String recordId = String.valueOf(params.get("RECORD_ID"));
            ResponseEntity<ApiResponse<Object>> formQuery = this.formQuery(canvasSchema.getId(), recordId, null, canvasSchema.getAppId(), Boolean.FALSE);
            if (formQuery.getStatusCode() == HttpStatus.OK && ((ApiResponse)formQuery.getBody()).isSuccess()) {
                canvasSchema.childTables().forEach(widget -> {
                    List childs = (List)params.get(widget.getName());
                    Optional.ofNullable(childs).ifPresent(o -> o.forEach(child -> {
                        if (HussarUtils.isNotEmpty(child.get("RECORD_ID"))) {
                            Set subTableKeys = child.keySet();
                            Map oldData = (Map)((ApiResponse)formQuery.getBody()).getData();
                            List oldChildData = (List)oldData.get(widget.getName());
                            if (!HussarUtils.isEmpty((Object)oldChildData)) {
                                Map<Object, Map> oldChildDataMap = oldChildData.stream().collect(Collectors.toMap(map -> map.get("RECORD_ID"), map -> map, (v1, v2) -> v1));
                                Map oldOneData = oldChildDataMap.get(child.get("RECORD_ID"));
                                Optional.ofNullable(oldOneData).ifPresent(ood -> ood.entrySet().forEach(feildValue -> {
                                    if (!subTableKeys.contains(feildValue.getKey())) {
                                        child.put(feildValue.getKey(), feildValue.getValue());
                                    }
                                }));
                            }
                        }
                    }));
                });
            }
        }
    }

    @DataOperateLog(moduleCode="flowFormSubmit", handleName="\u6d41\u7a0b\u8868\u5355\u6570\u636e\u63d0\u4ea4")
    public ResponseEntity<ApiResponse<Object>> flowFormSubmit(String formId, Map<String, Object> params) {
        SysForm form = (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
        String appId = String.valueOf(form.getAppId());
        this.flowFormSubmitHookParams(formId, form.getTableName(), appId, params);
        SysFormExtApi formExtApi = this.sysFormExtApiService.getSysFormExtApi(appId, formId, "flowFormSubmit", params);
        if (HussarUtils.isNotEmpty((Object)formExtApi)) {
            HashMap<String, String> requestParam = new HashMap<String, String>();
            requestParam.put("appId", appId);
            requestParam.put("formId", formId);
            ResponseEntity responseEntity = this.sysFormExtApiService.invoke(formExtApi, requestParam, params);
            this.flowFormSubmitHook(formId, form.getTableName(), appId, params, (ApiResponse<Object>)((ApiResponse)responseEntity.getBody()));
            return responseEntity;
        }
        this.setIdAndTableNameColumnValue(formId, (Map)params.get("formData"));
        ResponseEntity<ApiResponse<Object>> responseEntity = this.invokeService.flowFormSubmit(appId, formId, params);
        this.flowFormSubmitHook(formId, form.getTableName(), appId, params, (ApiResponse<Object>)((ApiResponse)responseEntity.getBody()));
        return responseEntity;
    }

    @DataOperateLog(moduleCode="flowFormSubmits", handleName="\u6d41\u7a0b\u8868\u5355\u6570\u636e\u63d0\u4ea4-\u6279\u91cf")
    public ResponseEntity<ApiResponse<Object>> flowFormSubmits(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        return this.invokeService.flowFormSubmits(appId, formId, params);
    }

    public void setIdAndTableName(String formId, Map<String, Object> params) {
        SysForm form = this.applicationService.getFormDetailById(Long.valueOf(Long.parseLong(formId)));
        params.put(TABLE_QUERY_FROM, form);
        List dataMapList = (List)params.get("dataList");
        ArrayList<Object> list = new ArrayList<Object>();
        if (HussarUtils.isNotEmpty((Object)dataMapList)) {
            for (Object data : dataMapList) {
                Map dataMap = (Map)data;
                Object object = dataMap.get("formData");
                if (!HussarUtils.isNotEmpty(object)) continue;
                list.add(object);
            }
            this.setIdAndTableNameColumnValue(form, list, null);
        }
    }

    private void flowFormSubmitHookParams(String formId, String tableName, String newAppId, Map<String, Object> params) {
        FlowFormSubmitHookDto formSubmitHookDto = new FlowFormSubmitHookDto();
        formSubmitHookDto.setFormId(Long.valueOf(formId));
        formSubmitHookDto.setAppId(Long.valueOf(newAppId));
        formSubmitHookDto.setParams(params);
        if (HussarUtils.isNotEmpty((Object)this.formOperateHookService)) {
            this.formOperateHookService.beforeFlowFormSubmit(formSubmitHookDto);
        }
        this.hookUtil.beforeFlowFormSubmit(formId, tableName, formSubmitHookDto);
    }

    private void flowFormSubmitHook(String formId, String tableName, String newAppId, Map<String, Object> params, ApiResponse<Object> flowFormSubmitResponse) {
        FlowFormSubmitHookDto formSubmitHookDto = new FlowFormSubmitHookDto();
        formSubmitHookDto.setFormId(Long.valueOf(formId));
        formSubmitHookDto.setAppId(Long.valueOf(newAppId));
        formSubmitHookDto.setParams(params);
        if (HussarUtils.isNotEmpty((Object)this.formOperateHookService)) {
            this.formOperateHookService.flowFormSubmitHook(formSubmitHookDto, flowFormSubmitResponse);
        }
        this.hookUtil.flowFormSubmitHook(formId, tableName, formSubmitHookDto, flowFormSubmitResponse);
    }

    @DataOperateLog(moduleCode="flowFormRecall", handleName="\u64a4\u56de")
    public ResponseEntity<ApiResponse<Object>> flowFormRecall(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        SysFormExtApi formExtApi = this.sysFormExtApiService.getSysFormExtApi(appId, formId, "flowFormRecall", params);
        if (HussarUtils.isNotEmpty((Object)formExtApi)) {
            HashMap<String, String> requestParam = new HashMap<String, String>();
            requestParam.put("appId", appId);
            requestParam.put("formId", formId);
            return this.sysFormExtApiService.invoke(formExtApi, requestParam, params);
        }
        return this.invokeService.flowFormRecall(appId, formId, params);
    }

    @DataOperateLog(moduleCode="initialNodeReject", handleName="\u9a73\u56de\u7533\u8bf7")
    public ResponseEntity<ApiResponse<Object>> initialNodeReject(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        SysFormExtApi formExtApi = this.sysFormExtApiService.getSysFormExtApi(appId, formId, "initialNodeReject", params);
        if (HussarUtils.isNotEmpty((Object)formExtApi)) {
            HashMap<String, String> requestParam = new HashMap<String, String>();
            requestParam.put("appId", appId);
            requestParam.put("formId", formId);
            return this.sysFormExtApiService.invoke(formExtApi, requestParam, params);
        }
        return this.invokeService.initialNodeReject(appId, formId, params);
    }

    @DataOperateLog(moduleCode="prevNodeReject", handleName="\u9a73\u56de")
    public ResponseEntity<ApiResponse<Object>> prevNodeReject(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        SysFormExtApi formExtApi = this.sysFormExtApiService.getSysFormExtApi(appId, formId, "prevNodeReject", params);
        if (HussarUtils.isNotEmpty((Object)formExtApi)) {
            HashMap<String, String> requestParam = new HashMap<String, String>();
            requestParam.put("appId", appId);
            requestParam.put("formId", formId);
            return this.sysFormExtApiService.invoke(formExtApi, requestParam, params);
        }
        return this.invokeService.prevNodeReject(appId, formId, params);
    }

    @DataOperateLog(moduleCode="anyNodeReject", handleName="\u4efb\u610f\u9a73\u56de")
    public ResponseEntity<ApiResponse<Object>> anyNodeReject(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        SysFormExtApi formExtApi = this.sysFormExtApiService.getSysFormExtApi(appId, formId, "anyNodeReject", params);
        if (HussarUtils.isNotEmpty((Object)formExtApi)) {
            HashMap<String, String> requestParam = new HashMap<String, String>();
            requestParam.put("appId", appId);
            requestParam.put("formId", formId);
            return this.sysFormExtApiService.invoke(formExtApi, requestParam, params);
        }
        return this.invokeService.anyNodeReject(appId, formId, params);
    }

    @DataOperateLog(moduleCode="flowFormRejectBatch", handleName="\u6d41\u7a0b\u6279\u91cf\u9a73\u56de")
    public ResponseEntity<ApiResponse<Object>> flowFormRejectBatch(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        SysForm formDetailById = this.applicationService.getFormDetailById(Long.valueOf(formId));
        Long idAppId = formDetailById.getAppId();
        return this.invokeService.flowFormRejectBatch(String.valueOf(idAppId), formId, params);
    }

    @DataOperateLog(moduleCode="flowFormSubmitBatch", handleName="\u6d41\u7a0b\u6279\u91cf\u5ba1\u6279")
    public ResponseEntity<ApiResponse<Object>> flowFormSubmitBatch(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        SysForm formDetailById = this.applicationService.getFormDetailById(Long.valueOf(formId));
        Long idAppId = formDetailById.getAppId();
        return this.invokeService.flowFormSubmitBatch(String.valueOf(idAppId), formId, params);
    }

    @DataOperateLog(moduleCode="taskEntrust", handleName="\u8f6c\u529e")
    public ResponseEntity<ApiResponse<Object>> taskEntrust(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        SysFormExtApi formExtApi = this.sysFormExtApiService.getSysFormExtApi(appId, formId, "taskEntrust", params);
        if (HussarUtils.isNotEmpty((Object)formExtApi)) {
            HashMap<String, String> requestParam = new HashMap<String, String>();
            requestParam.put("appId", appId);
            requestParam.put("formId", formId);
            return this.sysFormExtApiService.invoke(formExtApi, requestParam, params);
        }
        return this.invokeService.taskEntrust(appId, formId, params);
    }

    @DataOperateLog(moduleCode="endProcess", handleName="\u7ec8\u6b62")
    public ResponseEntity<ApiResponse<Object>> endProcess(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        SysFormExtApi formExtApi = this.sysFormExtApiService.getSysFormExtApi(appId, formId, "endProcess", params);
        if (HussarUtils.isNotEmpty((Object)formExtApi)) {
            HashMap<String, String> requestParam = new HashMap<String, String>();
            requestParam.put("appId", appId);
            requestParam.put("formId", formId);
            return this.sysFormExtApiService.invoke(formExtApi, requestParam, params);
        }
        return this.invokeService.endProcess(appId, formId, params);
    }

    public FormCanvasSchemaDTO getCanvas(String formId, String appId) {
        AppContextUtil.setAppId((String)appId);
        FormDesignResponse<FormCanvasSchema> canvasResponse = this.canvasService.get(formId);
        FormCanvasSchema canvas = (FormCanvasSchema)((Object)canvasResponse.getData());
        if (HussarUtils.isNotEmpty((Object)((Object)canvas))) {
            FormCanvasSchemaDTO canvasDto = new FormCanvasSchemaDTO();
            canvasDto = (FormCanvasSchemaDTO)HussarUtils.copyProperties((Object)((Object)canvas), FormCanvasSchemaDTO.class);
            return canvasDto;
        }
        return new FormCanvasSchemaDTO();
    }

    public FormCanvasSchemaDTO businessDataCanvas(String formId, String appId) {
        AppContextUtil.setAppId((String)appId);
        FormDesignResponse<FormCanvasSchema> canvasResponse = this.canvasSchemaService.get(formId);
        FormCanvasSchema canvas = (FormCanvasSchema)((Object)canvasResponse.getData());
        if (HussarUtils.isNotEmpty((Object)((Object)canvas))) {
            FormCanvasSchemaDTO canvasDto = new FormCanvasSchemaDTO();
            BeanUtils.copyProperties((Object)((Object)canvas), (Object)canvasDto);
            List<Widget> widgets = canvas.widgetsWithSys();
            widgets.addAll(canvas.childTables());
            ArrayList<WidgetDTO> widgetDTOS = new ArrayList<WidgetDTO>();
            WidgetTool.ofWidgetDTO(widgetDTOS, widgets, widget -> false);
            canvasDto.setWidgets(widgetDTOS);
            return canvasDto;
        }
        return new FormCanvasSchemaDTO();
    }

    public FormViewSchemaDTO getView(String formId, String appId) throws Exception {
        FormDesignResponse<FormViewSchema> viewResponse;
        FormViewSchema view;
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        if (HussarUtils.isNotEmpty((Object)(view = (FormViewSchema)(viewResponse = this.viewService.get(formId)).getData()))) {
            FormViewSchemaDTO viewDto = new FormViewSchemaDTO();
            BeanUtils.copyProperties((Object)view, (Object)viewDto);
            ISysApplicationExternalService iSysApplicationExternalService = (ISysApplicationExternalService)SpringUtil.getBean(ISysApplicationExternalService.class);
            SysForm formDetailById = iSysApplicationExternalService.getFormDetailById(Long.valueOf(Long.parseLong(formId)));
            if (HussarUtils.isEmpty((Object)formDetailById) || HussarUtils.isEmpty((Object)formDetailById.getFormStatus())) {
                ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u72b6\u6001\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
                return null;
            }
            viewDto.setFormStatus(formDetailById.getFormStatus());
            viewDto.setFormTitle(formDetailById.getFormName());
            return viewDto;
        }
        return null;
    }

    public FieldControlUnitSchema getFieldControl(String formId, String appId) throws IOException {
        FormDesignResponse<FieldControlUnitSchema> fieldControlResponse;
        FieldControlUnitSchema fieldControl;
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        if (HussarUtils.isNotEmpty((Object)(fieldControl = (FieldControlUnitSchema)(fieldControlResponse = this.settingService.getFieldControl(formId)).getData()))) {
            return fieldControl;
        }
        return null;
    }

    public SubmitSchema getSubmit(String formId, String appId) {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        FormDesignResponse<FormCanvasSchema> response = this.canvasSchemaService.get(formId);
        FormCanvasSchema canvasSchema = (FormCanvasSchema)((Object)response.getData());
        JSONObject submitSchema = null;
        if (HussarUtils.isNotEmpty((Object)((Object)canvasSchema)) && HussarUtils.isNotEmpty((Object)(submitSchema = (JSONObject)canvasSchema.getProps().get("submitSchema")))) {
            return (SubmitSchema)JSON.parseObject((String)submitSchema.toJSONString(), SubmitSchema.class);
        }
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.submit", SettingSchemaService.class);
        FormDesignResponse submitResponse = settingSchemaService.get(formId);
        return (SubmitSchema)submitResponse.getData();
    }

    public ApiResponse<Boolean> saveStaff(StaffScope staffScope) throws JsonProcessingException {
        return ApiResponse.success((Object)this.staffScopeService.saveStaff(staffScope).getData());
    }

    public ApiResponse<StaffScope> getStaffScope(String formId, String widgetName, String appId) {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        return ApiResponse.success((Object)this.staffScopeService.getStaffScope(formId, widgetName).getData());
    }

    public ApiResponse<Boolean> deleteStaff(String formId, String widgetName) throws JsonProcessingException {
        return ApiResponse.success((Object)this.staffScopeService.delete(formId, widgetName).getData());
    }

    public ApiResponse<List<FormDetailVO>> getShowForms(String formId, String appId) throws JsonProcessingException {
        FormDesignResponse<List<FormDetailVO>> showForms;
        List showFormsDate;
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        if (HussarUtils.isEmpty((Object)(showFormsDate = (List)(showForms = this.settingService.getShowForms(formId)).getData()))) {
            return ApiResponse.success(new ArrayList());
        }
        return ApiResponse.success((Object)showFormsDate);
    }

    public HideRuleSchema getHideRule(String formId) {
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.hideRule", SettingSchemaService.class);
        FormDesignResponse hideRuleSchemaResponse = settingSchemaService.get(formId);
        HideRuleSchema hideRule = (HideRuleSchema)hideRuleSchemaResponse.getData();
        if (HussarUtils.isNotEmpty((Object)hideRule)) {
            return hideRule;
        }
        return null;
    }

    public void exportMid(Long appId, String path, List<Long> formIds) throws JsonProcessingException {
        AppContextUtil.setAppId((String)String.valueOf(appId));
        String appIdStr = String.valueOf(appId);
        for (Long formId : formIds) {
            String formName = ((FormCanvasSchema)((Object)this.canvasService.get(String.valueOf(formId)).getData())).getName();
            String midFilePath = FileUtil.posixPath((String[])new String[]{path, appIdStr, formName});
            FormCanvasSchema canvasSchema = (FormCanvasSchema)((Object)this.canvasService.get(String.valueOf(formId)).getData());
            String canvasFin = formName + ".fd";
            String canvasPath = FileUtil.posixPath((String[])new String[]{midFilePath, "canvas", canvasFin});
            String canvasJson = JSON.toJSONStringWithDateFormat((Object)((Object)canvasSchema), (String)"yyyy-MM-dd hh:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
            this.filePublishService.writeStringToFile(canvasJson, canvasPath);
            SettingSchemaService bean = (SettingSchemaService)SpringUtil.getBean((String)"no.code.setting", SettingSchemaService.class);
            FormSettingSchema settingSchema = (FormSettingSchema)((Object)bean.get(String.valueOf(formId)).getData());
            String settingFin = formName + ".setting";
            String settingPath = FileUtil.posixPath((String[])new String[]{midFilePath, "setting", settingFin});
            String settingJson = JSON.toJSONStringWithDateFormat((Object)((Object)settingSchema), (String)"yyyy-MM-dd hh:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
            this.filePublishService.writeStringToFile(settingJson, settingPath);
            FormViewSchema viewSchema = (FormViewSchema)this.viewService.get(String.valueOf(formId)).getData();
            String viewFin = formName + ".vd";
            String viewPath = FileUtil.posixPath((String[])new String[]{midFilePath, "view", viewFin});
            String viewJson = JSON.toJSONStringWithDateFormat((Object)viewSchema, (String)"yyyy-MM-dd hh:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
            this.filePublishService.writeStringToFile(viewJson, viewPath);
            List staffScopes = (List)this.staffScopeScemaService.list(String.valueOf(formId)).getData();
            String staffFileName = formName + "history" + ".stf";
            String staffFilePath = FileUtil.posixPath((String[])new String[]{midFilePath, "staff", staffFileName});
            String staffJsonStr = JSON.toJSONStringWithDateFormat((Object)staffScopes, (String)"yyyy-MM-dd hh:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
            this.filePublishService.writeStringToFile(staffJsonStr, staffFilePath);
        }
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> convertForm(BaseForm baseForm, String appId) throws Exception {
        FormDesignResponse<List<DataView>> customViewAll;
        AppContextUtil.setAppId((String)appId);
        FormSchema formSchemaOld = (FormSchema)this.formOperateService.get(String.valueOf(baseForm.getId())).getData();
        FormCanvasSchema formCanvasSchema = formSchemaOld.getFormCanvas();
        String oldFormCanvasSchemaJson = JSON.toJSONString((Object)((Object)formCanvasSchema));
        FormCanvasSchema newFormCanvasSchema = (FormCanvasSchema)((Object)JSON.parseObject((String)oldFormCanvasSchemaJson, FormCanvasSchema.class));
        if (HussarUtils.isNotEmpty((Object)newFormCanvasSchema.getIdentity())) {
            baseForm.setIdentity(newFormCanvasSchema.getIdentity());
        }
        newFormCanvasSchema.setIdentity(baseForm.getIdentity());
        newFormCanvasSchema.setFormType(baseForm.getFormType());
        newFormCanvasSchema.setVersion(formCanvasSchema.getVersion() + 1);
        this.formOperate.delete(baseForm.getId());
        FormDesignResponse<FormViewSchema> viewSchemaData = this.viewService.get(baseForm.getId());
        LOGGER.info("convertForm\u83b7\u53d6\u5230\u7684\u89c6\u56fe\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(viewSchemaData));
        FormViewSchema viewSchema = (FormViewSchema)viewSchemaData.getData();
        ArrayList<DataView> views = new ArrayList<DataView>(4);
        DataView allDataView = viewSchema.getView(BASE_FORM.equals(viewSchema.getFormType()) ? ViewIdEnum.SYS_ORDINARY_ALL_DATA.getId() : ViewIdEnum.SYS_FLOW_ALL_DATA.getId());
        allDataView.setId(BASE_FORM.equals(baseForm.getFormType()) ? ViewIdEnum.SYS_ORDINARY_ALL_DATA.getId() : ViewIdEnum.SYS_FLOW_ALL_DATA.getId());
        allDataView.setTabType(BASE_FORM.equals(newFormCanvasSchema.getFormType()) ? "" : BASE_FORM);
        this.convertFormSetShowFields(baseForm, allDataView);
        this.convertFormSetOrderItem(baseForm, allDataView);
        this.convertFormSetDataFilter(baseForm, allDataView);
        views.add(allDataView);
        if (HussarUtils.equals((Object)FLOW_FORM, (Object)baseForm.getFormType())) {
            FormViewSchema initView = this.initView(newFormCanvasSchema);
            views.add(initView.getView(ViewIdEnum.SYS_FLOW_TASK.getId()));
            views.add(initView.getView(ViewIdEnum.SYS_FLOW_DONE.getId()));
            views.add(initView.getView(ViewIdEnum.SYS_FLOW_DRAFT.getId()));
            List processDefinitionVos = this.workflowService.queryFlowVersion(baseForm.getIdentity());
            if (HussarUtils.isEmpty((Object)processDefinitionVos)) {
                this.createDefaultProcess(baseForm, appId);
            }
        }
        if (HussarUtils.isNotEmpty((Object)(customViewAll = this.customViewService.getAll(baseForm.getId())).getData())) {
            List userDefineViews = (List)customViewAll.getData();
            userDefineViews.forEach(dataView -> {
                dataView.setTabType(BASE_FORM.equals(newFormCanvasSchema.getFormType()) ? "" : BASE_FORM);
                this.convertFormSetShowFields(baseForm, (DataView)dataView);
                this.convertFormSetOrderItem(baseForm, (DataView)dataView);
                this.convertFormSetDataFilter(baseForm, (DataView)dataView);
            });
            this.customViewService.updateBatch(baseForm.getId(), userDefineViews);
        }
        viewSchema.setViews(views);
        viewSchema.setFormType(baseForm.getFormType());
        List<String> viewOrder = viewSchema.getViewOrder();
        if (!HussarUtils.isNull(viewOrder)) {
            viewOrder = viewOrder.stream().distinct().collect(Collectors.toList());
            if (FLOW_FORM.equals(baseForm.getFormType())) {
                int allIndex = viewOrder.indexOf("\u5168\u90e8");
                if (!viewOrder.contains(ViewIdEnum.SYS_FLOW_TASK.getName())) {
                    viewOrder.add(allIndex + 1, ViewIdEnum.SYS_FLOW_TASK.getName());
                }
                if (!viewOrder.contains(ViewIdEnum.SYS_FLOW_DONE.getName())) {
                    viewOrder.add(allIndex + 2, ViewIdEnum.SYS_FLOW_DONE.getName());
                }
                if (!viewOrder.contains(ViewIdEnum.SYS_FLOW_DRAFT.getName())) {
                    viewOrder.add(allIndex + 3, ViewIdEnum.SYS_FLOW_DRAFT.getName());
                }
            } else {
                viewOrder.remove(ViewIdEnum.SYS_FLOW_TASK.getName());
                viewOrder.remove(ViewIdEnum.SYS_FLOW_DONE.getName());
                viewOrder.remove(ViewIdEnum.SYS_FLOW_DRAFT.getName());
            }
        }
        viewSchema.setViewOrder(viewOrder);
        this.customViewOrderService.convertForm(Long.valueOf(baseForm.getId()), baseForm.getFormType());
        this.canvasService.resetFieldControl(newFormCanvasSchema);
        this.canvasSchemaService.saveOrUpdate(newFormCanvasSchema);
        FormSchema formSchema = new FormSchema.Builder().formPage(newFormCanvasSchema).build();
        this.viewSchemaService.saveOrUpdate(viewSchema);
        this.canvasService.updateTableAndSync(EngineOperationType.ADD.getOperationType(), formSchema, formSchemaOld);
        return ApiResponse.success((Object)true);
    }

    private String labelSuffix(String name, String formId) throws JsonProcessingException {
        FormCanvasSchema canvasSchema = (FormCanvasSchema)((Object)this.canvasService.get(formId).getData());
        List<Widget> widgets = canvasSchema.widgets();
        widgets.addAll(canvasSchema.childTables());
        ArrayList<String> list = new ArrayList<String>();
        String suffix = "_label";
        Object[] widgetsType = new String[]{WidgetType.SELECT.getType(), WidgetType.SELECT.getType(), WidgetType.SELECT_MUL.getType(), WidgetType.RADIO_GROUP.getType(), WidgetType.CHECK_BOX_GROUP.getType()};
        for (Widget widget : widgets) {
            if (!HussarUtils.contains((Object[])widgetsType, (Object)widget.getType())) continue;
            list.add(widget.getName());
        }
        if (HussarUtils.contains((Object[])list.toArray(), (Object)name)) {
            return name + suffix;
        }
        return name;
    }

    private void convertFormSetShowFields(BaseForm baseForm, DataView allDataView) {
        if (FLOW_FORM.equals(baseForm.getFormType())) {
            Optional<ShowField> processStateOpt = allDataView.getShowFields().stream().filter(showField -> "PROCESS_STATE".equals(showField.getName())).findFirst();
            if (!processStateOpt.isPresent()) {
                ShowField processState = new ShowField();
                processState.setName("PROCESS_STATE");
                processState.setChecked(true);
                processState.setWidth(124);
                processState.setAlign("center");
                allDataView.getShowFields().add(1, processState);
            } else {
                allDataView.getShowFields().remove(processStateOpt.get());
                allDataView.getShowFields().add(1, processStateOpt.get());
            }
            Optional<ShowField> processNodeOpt = allDataView.getShowFields().stream().filter(showField -> "PROCESS_NODE".equals(showField.getName())).findFirst();
            if (processNodeOpt.isPresent()) {
                processNodeOpt.get().setIsMinWidth(false);
                allDataView.getShowFields().remove(processNodeOpt.get());
                allDataView.getShowFields().add(2, processNodeOpt.get());
            } else {
                ShowField processNode = new ShowField();
                processNode.setName("PROCESS_NODE");
                processNode.setChecked(true);
                processNode.setWidth(124);
                processNode.setAlign("center");
                allDataView.getShowFields().add(2, processNode);
            }
            Optional<ShowField> startTimeOpt = allDataView.getShowFields().stream().filter(showField -> "START_TIME".equals(showField.getName())).findFirst();
            if (!startTimeOpt.isPresent()) {
                ShowField processState = new ShowField();
                processState.setName("START_TIME");
                processState.setChecked(true);
                processState.setWidth(180);
                processState.setAlign("center");
                allDataView.getShowFields().add(3, processState);
            } else {
                allDataView.getShowFields().remove(startTimeOpt.get());
                allDataView.getShowFields().add(3, startTimeOpt.get());
            }
        }
    }

    private void convertFormSetOrderItem(BaseForm baseForm, DataView dataView) {
        if (BASE_FORM.equals(baseForm.getFormType())) {
            Iterator iterator = dataView.getOrderBy().iterator();
            while (iterator.hasNext()) {
                OrderItem next = (OrderItem)iterator.next();
                if (!FLOW_FORM_PECULIARLY_COLUMN.contains(next.getColumn())) continue;
                iterator.remove();
            }
            if (dataView.getOrderBy().size() == 0) {
                OrderItem orderItem = new OrderItem();
                orderItem.setColumn("createTime_date");
                orderItem.setAsc(false);
                dataView.getOrderBy().add(orderItem);
            }
        }
    }

    private void convertFormSetDataFilter(BaseForm baseForm, DataView dataView) {
        if (BASE_FORM.equals(baseForm.getFormType())) {
            Iterator iterator = dataView.getFilters().iterator();
            while (iterator.hasNext()) {
                Filter next = (Filter)iterator.next();
                if (!FLOW_FORM_PECULIARLY_COLUMN.contains(next.getField())) continue;
                iterator.remove();
            }
        }
    }

    private void createDefaultProcess(BaseForm baseForm, String appId) throws IOException, LcdpException {
        SaveInfoDto saveInfoDto = new SaveInfoDto();
        JSONObject data = PageBuilderFactory.getDefaultProcessBpmInternet();
        JSONObject props = (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)data.get((Object)"props")), JSONObject.class);
        JSONObject processBinding = (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)props.get((Object)"processBinding")), JSONObject.class);
        JSONObject slots = (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)data.get((Object)"slots")), JSONObject.class);
        List defaults = JSON.parseArray((String)JSON.toJSONString((Object)slots.get((Object)"default")), JSONObject.class);
        String formId = baseForm.getId();
        String formName = baseForm.getName();
        String identity = baseForm.getIdentity();
        String title = baseForm.getTitle();
        processBinding.put("mainTableName", (Object)formName);
        processBinding.put("taskTableName", (Object)("PROCESS_TASK_INFO_" + formName));
        processBinding.put("mainTableBusinessKey", (Object)"RECORD_ID");
        props.put("identity", (Object)identity);
        props.put("name", (Object)"\u672a\u547d\u540d\u6d41\u7a0b");
        props.put("processBinding", (Object)processBinding);
        data.put("props", (Object)props);
        JSONObject default0 = this.setProps((JSONObject)defaults.get(0), formId, title, "formAddress", "formDetailAddress");
        JSONObject default3 = this.setProps((JSONObject)defaults.get(3), formId, title, "formAddress", "formDetailAddress");
        JSONObject default1 = this.setProps((JSONObject)defaults.get(1), formId, title, "formAddress", "formDetailAddress", "ccFormAddress", "ccFormDetailAddress");
        JSONObject default2 = this.setProps((JSONObject)defaults.get(2), formId, title, "formAddress", "formDetailAddress", "ccFormAddress", "ccFormDetailAddress");
        ArrayList<JSONObject> newDefaults = new ArrayList<JSONObject>();
        newDefaults.add(default0);
        newDefaults.add(default1);
        newDefaults.add(default2);
        newDefaults.add(default3);
        slots.put("default", newDefaults);
        data.put("slots", (Object)slots);
        WorkflowInfo workflowInfo = new WorkflowInfo();
        workflowInfo.setAppId(appId);
        workflowInfo.setName("\u672a\u547d\u540d\u6d41\u7a0b");
        workflowInfo.setHasError(Boolean.valueOf(false));
        workflowInfo.seteName(identity);
        workflowInfo.setType("Workflow");
        workflowInfo.setWorkflowStyle("internet");
        workflowInfo.setId(ToolUtil.get32UUID());
        workflowInfo.setVersion(FLOW_FORM);
        workflowInfo.setIdentity(identity);
        workflowInfo.setData(JSON.toJSONString((Object)data));
        saveInfoDto.setSaveType(FLOW_FORM);
        saveInfoDto.setWorkflowInfo(workflowInfo);
        this.workflowService.checkAndSaveWorkFlowDataAndMeta(saveInfoDto);
    }

    private JSONObject setProps(JSONObject defaults, String formId, String formName, String ... paths) {
        for (int i = 0; i < paths.length; ++i) {
            JSONObject props = (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)defaults.get((Object)"props")), JSONObject.class);
            JSONObject formAddress = HussarUtils.isEmpty((Object)props.get((Object)paths[i])) ? new JSONObject() : (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)props.get((Object)paths[i])), JSONObject.class);
            JSONObject web = HussarUtils.isEmpty((Object)formAddress.get((Object)"web")) ? new JSONObject() : (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)formAddress.get((Object)"web")), JSONObject.class);
            web.put("id", (Object)formId);
            web.put("desc", (Object)formName);
            web.put("url", (Object)"");
            JSONObject mobile = HussarUtils.isEmpty((Object)formAddress.get((Object)"mobile")) ? new JSONObject() : (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)formAddress.get((Object)"mobile")), JSONObject.class);
            mobile.put("id", (Object)formId);
            mobile.put("desc", (Object)formName);
            mobile.put("url", (Object)"");
            formAddress.put("web", (Object)web);
            formAddress.put("mobile", (Object)mobile);
            props.put(paths[i], (Object)formAddress);
            defaults.put("props", (Object)props);
        }
        return defaults;
    }

    @DataOperateLog(moduleCode="flowEditAssignee", handleName="\u6d41\u7a0b\u52a0\u51cf\u7b7e")
    public ResponseEntity<ApiResponse<Object>> flowEditAssignee(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        SysFormExtApi formExtApi = this.sysFormExtApiService.getSysFormExtApi(appId, formId, "flowEditAssignee", params);
        if (HussarUtils.isNotEmpty((Object)formExtApi)) {
            HashMap<String, String> requestParam = new HashMap<String, String>();
            requestParam.put("appId", appId);
            requestParam.put("formId", formId);
            return this.sysFormExtApiService.invoke(formExtApi, requestParam, params);
        }
        return this.invokeService.flowEditAssignee(appId, formId, params);
    }

    @DataOperateLog(moduleCode="flowFreeJump", handleName="\u6d41\u7a0b\u81ea\u7531\u8df3\u8f6c")
    public ResponseEntity<ApiResponse<Object>> flowFreeJump(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        SysFormExtApi formExtApi = this.sysFormExtApiService.getSysFormExtApi(appId, formId, "flowFreeJump", params);
        if (HussarUtils.isNotEmpty((Object)formExtApi)) {
            HashMap<String, String> requestParam = new HashMap<String, String>();
            requestParam.put("appId", appId);
            requestParam.put("formId", formId);
            return this.sysFormExtApiService.invoke(formExtApi, requestParam, params);
        }
        return this.invokeService.flowFreeJump(appId, formId, params);
    }

    @DataOperateLog(moduleCode="createAssistTask", handleName="\u6d41\u7a0b\u65b0\u589e\u534f\u529e")
    public ResponseEntity<ApiResponse<Object>> createAssistTask(String formId, Map<String, Object> params) {
        String appId = params.get("appId").toString();
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = AppContextUtil.getAppId();
        }
        return this.invokeService.createAssistTask(appId, formId, params);
    }

    @DataOperateLog(moduleCode="completeAssistTask", handleName="\u6d41\u7a0b\u5b8c\u6210\u534f\u529e")
    public ResponseEntity<ApiResponse<Object>> completeAssistTask(String formId, Map<String, Object> params) {
        String appId = params.get("appId").toString();
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = AppContextUtil.getAppId();
        }
        return this.invokeService.completeAssistTask(appId, formId, params);
    }
}

