/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.vo.SearchOrganVo;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.UserStaffVo;
import com.jxdinfo.hussar.formdesign.application.print.model.SysFileInfoDashboard;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysFileInfoDashboardService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.InvokeService;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.region.service.IHussarBaseRegionBoService;
import com.jxdinfo.hussar.region.vo.RegionVo;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FieldInfoUtil {
    protected static final Logger logger = LoggerFactory.getLogger(FieldInfoUtil.class);
    protected static final String LABEL = "_label";
    protected static final String ID = "_id";
    protected static final String CODE = "_code";
    protected static final String REF_ID = "_ref_id";
    protected static final String REF_CHILD_ID = "_ref_child_id";
    protected static final String RECORD_ID = "RECORD_ID";
    protected static final String F_RECORD_ID = "F_RECORD_ID";
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private IHussarBaseUserBoService usersService;
    @Resource
    private IHussarBaseOrganizationBoService organService;
    @Resource
    private ISysFileInfoDashboardService infoDashboardService;
    @Resource
    private IHussarBaseRegionBoService regionService;
    @Resource
    private InvokeService invokeService;

    public List<String> getfieldInfo(String formId, String name) {
        FormCanvasSchema canvas = (FormCanvasSchema)((Object)this.canvasSchemaService.get(formId).getData());
        return WidgetTool.getAllFieldsByTypeAndName(canvas.getWidgets(), name);
    }

    public Map<String, Object> getFieldInfoById(String formId, String name, String id) {
        if (!(StringUtil.isNotEmpty((Object)formId) && StringUtil.isNotEmpty((Object)name) && StringUtil.isNotEmpty((Object)id))) {
            return new HashMap<String, Object>();
        }
        FormCanvasSchema canvas = (FormCanvasSchema)((Object)this.canvasSchemaService.get(formId).getData());
        return this.getFieldInfoByNameAndId(canvas.getWidgets(), name, id);
    }

    public Map<String, Object> getLinkFormFieldInfoById(String linkAppId, String linkFormId, String linkFormDataName, String name, String id, String tfModelId) {
        HashMap<String, Object> filedInfo = new HashMap<String, Object>();
        if (!(StringUtil.isNotEmpty((Object)linkFormId) && StringUtil.isNotEmpty((Object)name) && StringUtil.isNotEmpty((Object)id))) {
            return filedInfo;
        }
        List<String> idList = Arrays.asList(id.split(","));
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        queryParam.put("current", 1);
        queryParam.put("size", idList.size());
        ArrayList superQueryConditionDto = new ArrayList();
        superQueryConditionDto.add(new HashMap());
        ((Map)superQueryConditionDto.get(0)).put("field", RECORD_ID);
        ((Map)superQueryConditionDto.get(0)).put("match", "AND");
        ((Map)superQueryConditionDto.get(0)).put("rule", "_in");
        ((Map)superQueryConditionDto.get(0)).put("val", idList.toString());
        queryParam.put("superQueryConditionDto", superQueryConditionDto);
        queryParam.put("tfModelId", tfModelId);
        ApiResponse response = (ApiResponse)this.invokeService.tableQuery(linkAppId, linkFormId, null, queryParam).getBody();
        if (HussarUtils.isEmpty((Object)response)) {
            return filedInfo;
        }
        List linkFormInfos = ((PageVo)response.getData()).getData();
        StringBuilder linkFormLabels = new StringBuilder();
        StringBuilder refIds = new StringBuilder();
        StringBuilder childIds = new StringBuilder();
        for (Map formInfo : linkFormInfos) {
            if (linkFormLabels.length() > 0) {
                linkFormLabels.append(",");
                refIds.append(",");
                childIds.append(",");
            }
            linkFormLabels.append(formInfo.get(linkFormDataName));
            if (HussarUtils.isEmpty((Object)tfModelId)) {
                refIds.append(formInfo.get(RECORD_ID));
                continue;
            }
            refIds.append(formInfo.get(F_RECORD_ID));
            childIds.append(formInfo.get(RECORD_ID));
        }
        filedInfo.put(name, linkFormLabels.toString());
        filedInfo.put(name + REF_ID, refIds.toString());
        filedInfo.put(name + REF_CHILD_ID, childIds.toString());
        return filedInfo;
    }

    private Map<String, Object> getFieldInfoByNameAndId(List<Widget> widgets, String name, String id) {
        Map<String, Object> filedInfo = new HashMap<String, Object>();
        for (Widget widget : widgets) {
            if (!name.equals(widget.getName())) continue;
            switch (widget.getType()) {
                case "JXDNUser": 
                case "JXDNUserMulti": {
                    filedInfo = this.getUserFieldInfo(widget.getName(), id);
                    break;
                }
                case "JXDNFile": 
                case "JXDNImage": {
                    filedInfo = this.getFileFieldInfo(widget.getName(), id);
                    break;
                }
                case "JXDNOrg": 
                case "JXDNOrgMulti": {
                    filedInfo = this.getOrganFieldInfo(widget.getName(), id);
                    break;
                }
                case "JXDNAddress": {
                    filedInfo = this.getAddressFieldInfo(widget.getName(), id);
                    break;
                }
            }
        }
        return filedInfo;
    }

    private Map<String, Object> getUserFieldInfo(String name, String id) {
        HashMap<String, Object> userFiledInfo = new HashMap<String, Object>();
        List<String> idList = Arrays.asList(id.split(","));
        List users = this.usersService.getUserAndStaffList(idList.stream().map(Long::valueOf).collect(Collectors.toList()));
        if (HussarUtils.isEmpty((Object)users)) {
            return userFiledInfo;
        }
        StringBuilder userNames = new StringBuilder();
        StringBuilder userIds = new StringBuilder();
        JSONArray jsonUserArray = new JSONArray();
        for (UserStaffVo user : users) {
            if (userNames.length() > 0) {
                userNames.append(",");
                userIds.append(",");
            }
            userNames.append(user.getUserName());
            userIds.append(user.getUserId());
            JSONObject userJson = new JSONObject();
            userJson.put("label", (Object)user.getUserName());
            userJson.put("id", (Object)user.getUserId().toString());
            jsonUserArray.add((Object)userJson);
        }
        userFiledInfo.put(name, jsonUserArray.toJSONString());
        userFiledInfo.put(name + ID, userIds.toString());
        userFiledInfo.put(name + LABEL, userNames.toString());
        return userFiledInfo;
    }

    private Map<String, Object> getOrganFieldInfo(String name, String id) {
        HashMap<String, Object> organFiledInfo = new HashMap<String, Object>();
        List<String> idList = Arrays.asList(id.split(","));
        List organs = this.organService.getOrgansByStruIds(idList.stream().map(Long::valueOf).collect(Collectors.toList()));
        if (HussarUtils.isEmpty((Object)organs)) {
            return organFiledInfo;
        }
        StringBuilder organNames = new StringBuilder();
        StringBuilder organIds = new StringBuilder();
        JSONArray jsonOrganArray = new JSONArray();
        for (SearchOrganVo organ : organs) {
            if (organNames.length() > 0) {
                organNames.append(",");
                organIds.append(",");
            }
            organNames.append(organ.getLabel());
            organIds.append(organ.getId());
            JSONObject userJson = new JSONObject();
            userJson.put("label", (Object)organ.getLabel());
            userJson.put("id", (Object)organ.getId().toString());
            jsonOrganArray.add((Object)userJson);
        }
        organFiledInfo.put(name, jsonOrganArray.toJSONString());
        organFiledInfo.put(name + ID, organIds.toString());
        organFiledInfo.put(name + LABEL, organNames.toString());
        return organFiledInfo;
    }

    private Map<String, Object> getFileFieldInfo(String name, String id) {
        HashMap<String, Object> filedInfo = new HashMap<String, Object>();
        SysFileInfoDashboard fileInfoDashboard = (SysFileInfoDashboard)this.infoDashboardService.getById((Serializable)Long.valueOf(id));
        if (HussarUtils.isEmpty((Object)fileInfoDashboard)) {
            return filedInfo;
        }
        JSONArray jsonFileArray = new JSONArray();
        JSONObject fileJson = new JSONObject();
        fileJson.put("id", (Object)fileInfoDashboard.getId().toString());
        fileJson.put("name", (Object)fileInfoDashboard.getAttachmentName());
        fileJson.put("size", (Object)fileInfoDashboard.getAttachmentSize());
        fileJson.put("type", (Object)fileInfoDashboard.getAttachmentType());
        jsonFileArray.add((Object)fileJson);
        filedInfo.put(name, id);
        filedInfo.put(name + LABEL, jsonFileArray.toJSONString());
        return filedInfo;
    }

    private Map<String, Object> getAddressFieldInfo(String name, String id) {
        HashMap<String, Object> fieldInfo = new HashMap<String, Object>();
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(Long.valueOf(id));
        List fullPathRegion = this.regionService.getFullPathRegionInfoByIds(idList.stream().map(Long::valueOf).collect(Collectors.toList()));
        if (HussarUtils.isEmpty((Object)fullPathRegion)) {
            return fieldInfo;
        }
        StringBuilder addressLabel = new StringBuilder();
        for (RegionVo regionVo : fullPathRegion) {
            if (addressLabel.length() > 0) {
                addressLabel.append(" / ");
            }
            addressLabel.append(regionVo.getName());
        }
        fieldInfo.put(name + CODE, id);
        fieldInfo.put(name + LABEL, addressLabel.toString());
        return fieldInfo;
    }
}

