/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.tool;

import com.jxdinfo.hussar.datasource.util.DbUtil;
import com.jxdinfo.hussar.formdesign.application.form.constant.FormCreateTypeEnum;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.no.code.constant.DMSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.EngineOperationType;
import com.jxdinfo.hussar.formdesign.no.code.constant.EngineTypeStrategyEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.GAUSSSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.KingBaseSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.OSCARSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.OracleTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.engine.api.dto.ModelInfoDto;
import com.jxdinfo.hussar.support.engine.api.enums.ModelRelation;
import com.mysql.cj.MysqlType;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class EngineDataModelBuilder {
    public static final String TASK_PREFIX = "process_task_info_";
    public static final String TASK_PATH = "/task/process_task_info.json";
    public static final String ORACLE_TASK_PATH = "/task/process_task_info_oracle.json";
    public static final String ORACLE_PROCESS_INFO_PATH = "/task/process_info_oracle.json";
    public static final Map<String, String> fieldDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.INT.name());
            this.put("ORACLE", OracleTypeEnum.NUMBER.name());
            this.put("DM", DMSqlTypeEnum.INT.getTypeName());
            this.put(DbType.KINGBASE.name(), KingBaseSqlTypeEnum.INTEGER.getTypeName());
            this.put(DbType.OSCAR.name(), OSCARSqlTypeEnum.INT.getTypeName());
            this.put(DbType.GAUSS.name(), GAUSSSqlTypeEnum.INTEGER.getTypeName());
        }
    };
    public static final Map<String, String> textDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.TEXT.name());
            this.put("ORACLE", OracleTypeEnum.CLOB.name());
            this.put("DM", DMSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.KINGBASE.name(), KingBaseSqlTypeEnum.CLOB.getTypeName());
            this.put(DbType.OSCAR.name(), OSCARSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.GAUSS.name(), GAUSSSqlTypeEnum.TEXT.getTypeName());
        }
    };

    public abstract String strategy();

    public abstract void init(FormSchema var1);

    public ModelInfoDto direct(String operationType, FormSchema oldCanvas) throws Exception {
        ModelInfoDto modelInfoDto = new ModelInfoDto();
        modelInfoDto.setOperationType(operationType);
        return modelInfoDto;
    }

    public ModelInfoDto build() throws IOException {
        return new ModelInfoDto();
    }

    public ModelInfoDto buildBase(ModelInfoDto model, FormSchema newCanvas, FormSchema oldCanvas, String operationType) throws IOException {
        FormCanvasSchema formCanvas = newCanvas.getFormCanvas();
        model.setModelId(String.valueOf(formCanvas.getId()));
        DynamicDatasourceService bean = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);
        String jdbcUrl = bean.getCurrentDatasource().getUrl();
        String dbType = DbUtil.getDbType((String)jdbcUrl).toUpperCase();
        if (HussarUtils.equals((Object)DbType.KINGBASE.name(), (Object)dbType) || HussarUtils.equals((Object)com.baomidou.mybatisplus.annotation.DbType.KINGBASE_ES.name().replace("_", ""), (Object)dbType) || HussarUtils.equals((Object)DbType.POSTGRE_SQL.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.GAUSS.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.HIGHGO.name(), (Object)dbType)) {
            model.setModelName(formCanvas.getName().toLowerCase());
            model.setTableName(model.getModelName().toLowerCase());
        } else {
            model.setModelName(formCanvas.getName());
            model.setTableName(model.getModelName());
        }
        model.setModelDec(formCanvas.getTitle());
        String dataSourceName = DataModelUtil.currentDsName();
        model.setDatasourceId(DataModelUtil.getDataSourceConfigByName((String)dataSourceName).getId());
        model.setPollName(dataSourceName);
        model.setOperationType(this.getModelOperType(formCanvas, oldCanvas, operationType));
        if (FormCreateTypeEnum.FORM_TO_FORM.getType().equals(formCanvas.getCreateSource())) {
            model.setSourceModelId(String.valueOf(formCanvas.getSourceFormId()));
        }
        if (FormCreateTypeEnum.FORM_TO_FORM.getType().equals(formCanvas.getCreateSource()) && HussarUtils.isEmpty((Object)oldCanvas)) {
            ISysFormService formService = (ISysFormService)SpringUtil.getBean(ISysFormService.class);
            SysForm sysForm = (SysForm)formService.getById((Serializable)formCanvas.getSourceFormId());
            if (HussarUtils.isNotEmpty((Object)sysForm)) {
                if (!formCanvas.getFormType().equals(sysForm.getFormType())) {
                    model.setSyncToTable(true);
                } else {
                    model.setSyncToTable(false);
                }
            } else {
                model.setSyncToTable(false);
            }
        } else if (FormCreateTypeEnum.TABLE_TO_FORM.getType().equals(formCanvas.getCreateSource()) && HussarUtils.isEmpty((Object)oldCanvas)) {
            model.setSyncToTable(false);
        } else {
            model.setSyncToTable(true);
        }
        String formType = formCanvas.getFormType();
        String isDetail = formCanvas.getIsDetails();
        String strategy = formType + isDetail;
        model.setType(EngineTypeStrategyEnum.getStrategy(strategy));
        if (EngineTypeStrategyEnum.TASK_BASE.getType().equals(strategy) || EngineTypeStrategyEnum.TASK_MASTER_SLAVE.getType().equals(strategy)) {
            model.setRelation(ModelRelation.ONE_ONE);
            model.setType(EngineTypeStrategyEnum.TASK_MASTER_SLAVE.getTypeDesc());
        }
        return model;
    }

    private String getModelOperType(FormCanvasSchema formCanvas, FormSchema oldCanvas, String operationType) {
        if (HussarUtils.isEmpty((Object)oldCanvas)) {
            if (FormCreateTypeEnum.TABLE_TO_FORM.getType().equals(formCanvas.getCreateSource())) {
                return operationType;
            }
            if (FormCreateTypeEnum.FORM_TO_FORM.getType().equals(formCanvas.getCreateSource())) {
                ISysFormService formService = (ISysFormService)SpringUtil.getBean(ISysFormService.class);
                SysForm sysForm = (SysForm)formService.getById((Serializable)formCanvas.getSourceFormId());
                if (HussarUtils.isNotEmpty((Object)sysForm)) {
                    if (!formCanvas.getFormType().equals(sysForm.getFormType())) {
                        return EngineOperationType.UPDATE.getOperationType();
                    }
                    return operationType;
                }
                return operationType;
            }
            return operationType;
        }
        if (!formCanvas.getFormType().equals(oldCanvas.getFormCanvas().getFormType())) {
            return EngineOperationType.UPDATE.getOperationType();
        }
        return operationType;
    }
}

