/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.db;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.staff.StaffScope;
import com.jxdinfo.hussar.formdesign.no.code.business.service.SysMiddleFileStorageService;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.StaffScopeScemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.SysMiddleFileStorage;
import com.jxdinfo.hussar.formdesign.no.code.model.staff.StaffScopeHistory;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnDB;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={NoCodeConditionOnDB.class})
public class StaffScopeDBImpl
implements StaffScopeScemaService {
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private StorageService storage;
    @Resource
    private SysMiddleFileStorageService sysMiddleFileStorageService;

    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(StaffScope staffScope) throws JsonProcessingException {
        String formId = staffScope.getFormId();
        Wrapper wrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FORM_ID", (Object)Long.parseLong(formId))).eq((Object)"FILE_TYPE", (Object)"5")).eq((Object)"DEL_FLAG", (Object)"0");
        SysMiddleFileStorage sysMiddleFileStorage = (SysMiddleFileStorage)((Object)this.sysMiddleFileStorageService.getOne(wrapper));
        List<StaffScope> staffScopes = new ArrayList();
        if (sysMiddleFileStorage != null) {
            staffScopes = JSON.parseArray((String)sysMiddleFileStorage.getMiddleFileInfo(), StaffScope.class);
            staffScopes.add(staffScope);
            sysMiddleFileStorage.setMiddleFileInfo(JSON.toJSONString(staffScopes));
            this.sysMiddleFileStorageService.updateById((Object)sysMiddleFileStorage);
        } else {
            sysMiddleFileStorage = new SysMiddleFileStorage();
            staffScopes.add(staffScope);
            sysMiddleFileStorage.setAppId(Long.parseLong(staffScope.getAppId()));
            sysMiddleFileStorage.setFormId(Long.parseLong(formId));
            sysMiddleFileStorage.setFileType("5");
            sysMiddleFileStorage.setMiddleFileInfo(JSON.toJSONString(staffScopes));
            sysMiddleFileStorage.setDelFlag("0");
            this.sysMiddleFileStorageService.save((Object)sysMiddleFileStorage);
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<Boolean> saveOrUpdateBatch(List<StaffScope> staffScopes) throws JsonProcessingException {
        if (HussarUtils.isEmpty(staffScopes)) {
            return FormDesignResponse.fail((Object)false, (String)"\u63d0\u4ea4\u6570\u636e\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        for (StaffScope staffScope : staffScopes) {
            this.saveOrUpdate(staffScope);
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<StaffScope> getByName(String formId, String widgetName) {
        StaffScope staffScope = new StaffScope();
        Wrapper wrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FORM_ID", (Object)Long.parseLong(formId))).eq((Object)"FILE_TYPE", (Object)"5")).eq((Object)"DEL_FLAG", (Object)"0");
        SysMiddleFileStorage sysMiddleFileStorage = (SysMiddleFileStorage)((Object)this.sysMiddleFileStorageService.getOne(wrapper));
        if (HussarUtils.isNotEmpty((Object)((Object)sysMiddleFileStorage))) {
            List staffScopes = JSON.parseArray((String)sysMiddleFileStorage.getMiddleFileInfo(), StaffScope.class);
            for (StaffScope staffScopeName : staffScopes) {
                if (!staffScopeName.getWidgetName().equals(widgetName)) continue;
                staffScope = staffScopeName;
                return FormDesignResponse.success((Object)staffScope);
            }
        }
        return FormDesignResponse.success(null);
    }

    @Override
    public FormDesignResponse<List<StaffScope>> list(String formId) {
        List staffScopes = new ArrayList();
        Wrapper wrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FORM_ID", (Object)Long.parseLong(formId))).eq((Object)"FILE_TYPE", (Object)"5")).eq((Object)"DEL_FLAG", (Object)"0");
        SysMiddleFileStorage sysMiddleFileStorage = (SysMiddleFileStorage)((Object)this.sysMiddleFileStorageService.getOne(wrapper));
        if (!HussarUtils.isNotEmpty((Object)((Object)sysMiddleFileStorage))) {
            return FormDesignResponse.success(null);
        }
        staffScopes = JSON.parseArray((String)sysMiddleFileStorage.getMiddleFileInfo(), StaffScope.class);
        return FormDesignResponse.success(staffScopes);
    }

    @Override
    public FormDesignResponse<Boolean> delete(String formId, String widgetName) throws JsonProcessingException {
        List staffScopes = new ArrayList();
        Wrapper wrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FORM_ID", (Object)Long.parseLong(formId))).eq((Object)"FILE_TYPE", (Object)"5")).eq((Object)"DEL_FLAG", (Object)"0");
        SysMiddleFileStorage sysMiddleFileStorage = (SysMiddleFileStorage)((Object)this.sysMiddleFileStorageService.getOne(wrapper));
        if (HussarUtils.isNotEmpty((Object)((Object)sysMiddleFileStorage))) {
            staffScopes = JSON.parseArray((String)sysMiddleFileStorage.getMiddleFileInfo(), StaffScope.class);
            Iterator iterator = staffScopes.iterator();
            while (iterator.hasNext()) {
                StaffScope staffScope = (StaffScope)iterator.next();
                if (!staffScope.getWidgetName().equals(widgetName)) continue;
                iterator.remove();
            }
        } else {
            return FormDesignResponse.success((Object)true);
        }
        sysMiddleFileStorage.setMiddleFileInfo(JSON.toJSONString(staffScopes));
        this.sysMiddleFileStorageService.updateById((Object)sysMiddleFileStorage);
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<String> saveOrUpdateHistory(StaffScopeHistory staffScopeHistory) throws JsonProcessingException {
        String formId = String.valueOf(staffScopeHistory.getFormId());
        String cacheKey = String.format("%s:%s", "staffHistory", formId);
        ArrayList<StaffScopeHistory> cacheStaffScopeHistories = (ArrayList<StaffScopeHistory>)HussarCacheUtil.get((String)"vfg_no-code_schema", (Object)cacheKey, ArrayList.class);
        try {
            if (HussarUtils.isEmpty((Object)cacheStaffScopeHistories)) {
                cacheStaffScopeHistories = new ArrayList<StaffScopeHistory>();
            }
            cacheStaffScopeHistories.add(staffScopeHistory);
            HussarCacheUtil.put((String)"vfg_no-code_schema", (Object)cacheKey, cacheStaffScopeHistories, (long)3600L);
        }
        catch (Exception e) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u8868\u5355\u753b\u5e03 ==> Redis\u8fde\u63a5\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        return FormDesignResponse.success((Object)staffScopeHistory.getStepKey());
    }

    @Override
    public FormDesignResponse<List<StaffScopeHistory>> listHistory(String formId) {
        String cacheKey = String.format("%s:%s", "staffHistory", formId);
        List cacheStaffScopeHistories = (List)HussarCacheUtil.get((String)"vfg_no-code_schema", (Object)cacheKey, ArrayList.class);
        return FormDesignResponse.success((Object)cacheStaffScopeHistories);
    }

    @Override
    public FormDesignResponse<StaffScopeHistory> getHistoryByName(String formId, String widgetName, String stepKey) {
        String cacheKey = String.format("%s:%s", "staffHistory", formId);
        List cacheStaffScopeHistories = (List)HussarCacheUtil.get((String)"vfg_no-code_schema", (Object)cacheKey, ArrayList.class);
        if (HussarUtils.isNotEmpty((Object)cacheStaffScopeHistories)) {
            for (StaffScopeHistory staffScopeHistory : cacheStaffScopeHistories) {
                if (!staffScopeHistory.getStepKey().equals(stepKey) || !staffScopeHistory.getWidgetName().equals(widgetName)) continue;
                return FormDesignResponse.success((Object)staffScopeHistory);
            }
        }
        return FormDesignResponse.success(null);
    }

    @Override
    public FormDesignResponse<Boolean> deleteScopeHistory(String formId) throws JsonProcessingException {
        String cacheKey = String.format("%s:%s", "staffHistory", formId);
        HussarCacheUtil.evict((String)"vfg_no-code_schema", (Object)cacheKey);
        return FormDesignResponse.success((Object)true);
    }
}

