/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.formdesign.application.form.model.SysModelMethod;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysModelMethodService;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.DatasourceConfigDTO;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HeExternalApiUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.sql.AdditionalField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.sql.AdditionalFieldSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.sql.SqlConfigSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.sql.SqlField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.sql.SqlParameter;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CustomSqlViewService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CustomViewService;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.choreo.api.service.EngineBussnessdataInvokeService;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldRulesDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelInfoDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelSaveDto;
import com.jxdinfo.hussar.support.engine.api.service.ModelSaveService;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

@Service
public class CustomSqlViewServiceImpl
implements CustomSqlViewService {
    @Resource
    private ModelSaveService modelSaveService;
    @Resource
    private ISysModelMethodService modelMethodService;
    @Resource
    private CustomViewService customViewService;
    @Resource
    private EngineBussnessdataInvokeService engineBussnessdataInvokeService;
    @Resource
    private ISysDicTypeService sysDicTypeService;
    private final Logger log = LoggerFactory.getLogger(CustomSqlViewServiceImpl.class);

    @Override
    public ApiResponse<Map<String, Object>> getDataSourceInfo() throws IOException {
        HashMap<String, Object> dataSourceIfo = new HashMap<String, Object>();
        DynamicDatasourceService bean = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);
        ItemDataSource currentDatasource = bean.getCurrentDatasource();
        dataSourceIfo.put("dbType", currentDatasource.getDbType().getDb());
        String dataSourceKey = DataModelUtil.currentDsName();
        DatasourceConfigDTO dataSourceConfigByName = DataModelUtil.getDataSourceConfigByName((String)dataSourceKey);
        dataSourceIfo.put("dataSourceId", dataSourceConfigByName.getId());
        return ApiResponse.success(dataSourceIfo);
    }

    @Override
    public void publicSqlModel(List<DataView> customSqlViews) throws Exception {
        ModelSaveDto modelSaveDto = new ModelSaveDto();
        ArrayList<ModelInfoDto> saveModelList = new ArrayList<ModelInfoDto>();
        for (DataView customSqlView : customSqlViews) {
            ModelInfoDto modelInfoDto = new ModelInfoDto();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(SysModelMethod::getFormId, (Object)customSqlView.getFormId())).eq(SysModelMethod::getSceneId, (Object)Long.valueOf(customSqlView.getId()));
            SysModelMethod sysModelMethod = (SysModelMethod)this.modelMethodService.getOne((Wrapper)queryWrapper);
            if (HussarUtils.isEmpty((Object)sysModelMethod)) {
                modelInfoDto = this.parseSqlViewToModel(customSqlView, null);
                SysModelMethod modelMethod = new SysModelMethod();
                modelMethod.setFormId(customSqlView.getFormId());
                modelMethod.setTfModelId(modelInfoDto.getModelId());
                modelMethod.setSceneId(Long.valueOf(customSqlView.getId()));
                this.modelMethodService.save((Object)modelMethod);
            } else {
                modelInfoDto = this.parseSqlViewToModel(customSqlView, String.valueOf(sysModelMethod.getTfModelId()));
            }
            saveModelList.add(modelInfoDto);
        }
        modelSaveDto.setSaveModelList(saveModelList);
        this.modelSaveService.saveModel(modelSaveDto);
    }

    @Override
    public ApiResponse<List<DicType>> getDictTypeList() {
        List dicTypes = this.sysDicTypeService.selectListByParentId();
        return ApiResponse.success((Object)dicTypes);
    }

    @Override
    public ApiResponse<Object> sqlFormTableQuery(String appId, String formId, String viewId, Map<String, Object> params) {
        FormDesignResponse<DataView> dataViewById = this.customViewService.getById(Long.valueOf(viewId));
        if (HussarUtils.isNotEmpty((Object)dataViewById.getData())) {
            Object conditionDto;
            DataView viewData = (DataView)dataViewById.getData();
            UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
            String userId = "";
            String organId = "";
            String roleIds = "";
            if (HussarUtils.isNotEmpty((Object)userDetails)) {
                Object rolesListObj;
                Object deptIdObj;
                if (HussarUtils.isNotEmpty((Object)userDetails.getUserId())) {
                    userId = String.valueOf(userDetails.getUserId());
                }
                if (HussarUtils.isNotEmpty((Object)(deptIdObj = userDetails.getExtendUserMap("deptId")))) {
                    organId = JSON.toJSONString((Object)deptIdObj);
                }
                if (HussarUtils.isNotEmpty((Object)(rolesListObj = userDetails.getExtendUserMap("rolesList")))) {
                    List rolesList = JSON.parseArray((String)JSON.toJSONString((Object)rolesListObj), String.class);
                    roleIds = String.join((CharSequence)",", rolesList);
                }
            }
            if (HussarUtils.isNotEmpty((Object)viewData.getSqlConfig())) {
                List parameterValues = viewData.getSqlConfig().getParameterValues();
                for (SqlParameter parameterValue : parameterValues) {
                    if (HussarUtils.equals((Object)parameterValue.getCode(), (Object)"userId")) {
                        params.put(parameterValue.getCode(), userId);
                        continue;
                    }
                    if (HussarUtils.equals((Object)parameterValue.getCode(), (Object)"organId")) {
                        params.put(parameterValue.getCode(), organId);
                        continue;
                    }
                    if (HussarUtils.equals((Object)parameterValue.getCode(), (Object)"roleIds")) {
                        params.put(parameterValue.getCode(), roleIds);
                        continue;
                    }
                    if (HussarUtils.equals((Object)parameterValue.getType(), (Object)"arrayPrimary") && HussarUtils.isNotEmpty((Object)parameterValue.getValue())) {
                        String value = parameterValue.getValue();
                        List arrayList = Arrays.stream(value.split(",")).map(s -> s.trim().replace("\"", "").replace("'", "")).collect(Collectors.toList());
                        params.put(parameterValue.getCode(), arrayList);
                        continue;
                    }
                    params.put(parameterValue.getCode(), parameterValue.getValue());
                }
            }
            List viewOrderBy = viewData.getOrderBy();
            Object orderParam = params.get("orders");
            List queryOrderBy = HussarUtils.isEmpty((Object)orderParam) ? new ArrayList() : JSON.parseArray((String)JSON.toJSONString((Object)orderParam), OrderItem.class);
            queryOrderBy.addAll(viewOrderBy);
            params.put("orders", queryOrderBy);
            List viewFilters = viewData.getFilters();
            if (HussarUtils.isNotEmpty((Object)viewFilters)) {
                for (Filter filter : viewFilters) {
                    filter.setRule(HeExternalApiUtil.getOperatorType((String)filter.getRule()).getValue());
                }
            }
            List superQueryConditionDto = HussarUtils.isEmpty((Object)(conditionDto = params.get("superQueryConditionDto"))) ? new ArrayList() : JSON.parseArray((String)JSON.toJSONString((Object)conditionDto), Filter.class);
            superQueryConditionDto.addAll(viewFilters);
            params.put("superQueryConditionDto", superQueryConditionDto);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(SysModelMethod::getFormId, (Object)Long.valueOf(formId))).and(w -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.eq(SysModelMethod::getSceneId, (Object)Long.valueOf(viewId));
            });
            SysModelMethod modelMethod = (SysModelMethod)this.modelMethodService.getOne((Wrapper)queryWrapper);
            params.put("tfModelId", modelMethod.getTfModelId());
            String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "sqlModelCustomSql");
            return this.engineBussnessdataInvokeService.invoke(businessId, params);
        }
        this.log.error("\u81ea\u5b9a\u4e49SQL\u8868\u5355\u89c6\u56fe\u67e5\u8be2\u5931\u8d25\uff0cappId\uff1a{}\uff0cformId\uff1a{}\uff0cviewId\uff1a{}", new Object[]{appId, formId, viewId});
        return ApiResponse.fail((String)"\u81ea\u5b9a\u4e49SQL\u8868\u5355\u89c6\u56fe\u67e5\u8be2\u5931\u8d25");
    }

    private ModelInfoDto parseSqlViewToModel(DataView customSqlView, String modelId) throws Exception {
        ModelInfoDto modelInfoDto = new ModelInfoDto();
        SqlConfigSchema sqlConfigSchema = customSqlView.getSqlConfig();
        modelInfoDto.setModelId(HussarUtils.isNotEmpty((Object)modelId) ? modelId : String.valueOf(IdWorker.getId((Object)modelInfoDto)));
        modelInfoDto.setType("sql");
        modelInfoDto.setCustomSql(sqlConfigSchema.getSql());
        String dataSourceName = DataModelUtil.currentDsName();
        modelInfoDto.setDatasourceId(DataModelUtil.getDataSourceConfigByName((String)dataSourceName).getId());
        modelInfoDto.setPollName(dataSourceName);
        List sqlFieldList = sqlConfigSchema.getProjection();
        modelInfoDto.setFieldList(this.parserSqlFieldToModelField(sqlFieldList));
        return modelInfoDto;
    }

    private List<ModelFieldDto> parserSqlFieldToModelField(List<SqlField> sqlFieldList) {
        if (HussarUtils.isEmpty(sqlFieldList)) {
            return Collections.emptyList();
        }
        ArrayList<ModelFieldDto> modelFieldDtoList = new ArrayList<ModelFieldDto>();
        for (SqlField sqlField : sqlFieldList) {
            AdditionalFieldSchema additionalFieldSchema;
            ModelFieldDto modelFieldDto = new ModelFieldDto();
            modelFieldDto.setFieldId(sqlField.getFieldId());
            modelFieldDto.setFieldName(sqlField.getFieldName());
            modelFieldDto.setFieldAlias(HussarUtils.isEmpty((Object)sqlField.getFieldAlias()) ? sqlField.getFieldName() : sqlField.getFieldAlias());
            Optional engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)ComponentData.DataTypeEnum.STRING.getValue());
            if (engineColumnType.isPresent()) {
                modelFieldDto.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
                modelFieldDto.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
            }
            if (HussarUtils.isNotEmpty((Object)(additionalFieldSchema = sqlField.getAdditionalField()))) {
                ArrayList<ModelFieldRulesDto> modelFieldRulesDtoList = new ArrayList<ModelFieldRulesDto>();
                ModelFieldRulesDto modelFieldRulesDto = new ModelFieldRulesDto();
                if (HussarUtils.equals((Object)additionalFieldSchema.getTranslateType(), (Object)"dictTranslate")) {
                    AdditionalField additionalField = (AdditionalField)additionalFieldSchema.getTranslateFields().get(0);
                    modelFieldRulesDto.setRuleType("2");
                    HashMap<String, String> ruleContent = new HashMap<String, String>();
                    ruleContent.put("type", "field_trans");
                    ruleContent.put("namespace", "TranslateDict");
                    ruleContent.put("queryFields", "value,type");
                    ruleContent.put("ref", additionalField.getName() + "#label");
                    ruleContent.put("key", additionalFieldSchema.getSourceId());
                    modelFieldRulesDto.setRuleContent(JSON.toJSONString(ruleContent));
                    modelFieldRulesDtoList.add(modelFieldRulesDto);
                    modelFieldDto.setFieldRules(modelFieldRulesDtoList);
                }
            }
            modelFieldDtoList.add(modelFieldDto);
        }
        return modelFieldDtoList;
    }

    public String getBusinessId(String requestMethod, String appId, String formId, String invokeMethod) {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        String url = FileUtil.posixPath((String[])new String[]{appId, formId, invokeMethod});
        return String.format("%s /%s", requestMethod, url);
    }
}

