/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.controller;

import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.staff.StaffScope;
import com.jxdinfo.hussar.formdesign.no.code.business.service.StaffScopeService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.StaffScopeCopyDTO;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"formdesign/staff/scope"})
public class StaffScopeController {
    @Resource
    private StaffScopeService staffScopeService;

    @PostMapping
    public FormDesignResponse<String> saveStaffScope(@RequestBody StaffScope staffScope) throws Exception {
        return this.staffScopeService.saveStaffHistory(staffScope);
    }

    @PostMapping(value={"/delete"})
    public FormDesignResponse<Boolean> deleteStaff(@RequestParam String formId, @RequestParam String widgetName) throws Exception {
        return this.staffScopeService.delete(formId, widgetName);
    }

    @GetMapping
    public FormDesignResponse<StaffScope> getStaffScope(@RequestParam String formId, @RequestParam String widgetName, @RequestParam(required=false) String stepKey) throws Exception {
        if (HussarUtils.isEmpty((Object)stepKey)) {
            return this.staffScopeService.getStaffScope(formId, widgetName);
        }
        return this.staffScopeService.getStaffScopeHistory(formId, widgetName, stepKey);
    }

    @PostMapping(value={"/copy"})
    public FormDesignResponse<Boolean> copyBatch(@RequestBody StaffScopeCopyDTO staffScopeCopy) throws Exception {
        return this.staffScopeService.copyBatch(staffScopeCopy);
    }

    @GetMapping(value={"/delete_history"})
    public FormDesignResponse<Boolean> deleteScopeHistory(@RequestParam String formId) throws Exception {
        return this.staffScopeService.deleteHistory(formId);
    }
}

