/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.widget;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.no.code.constant.DMSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.GAUSSSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.HIGHGOSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.KingBaseSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.OSCARSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.OracleTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.PGSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.formdesign.no.code.widget.JXDNWidgetDefault;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldDto;
import com.mysql.cj.MysqlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;

@Component(value="JXDNRichText")
public class JXDNRichText
extends JXDNWidgetDefault {
    private Widget widget;
    private FormSchema form;
    private Map<String, String> fieldDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.TEXT.name());
            this.put("ORACLE", OracleTypeEnum.CLOB.getTypeName());
            this.put("HIGHGO", HIGHGOSqlTypeEnum.TEXT.getTypeName());
            this.put("DM", DMSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.KINGBASE.name(), KingBaseSqlTypeEnum.CLOB.getTypeName());
            this.put(DbType.OSCAR.name(), OSCARSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.POSTGRE_SQL.name(), PGSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.GAUSS.name(), GAUSSSqlTypeEnum.TEXT.getTypeName());
        }
    };

    @Override
    public void init(Widget widget, FormSchema form) {
        this.widget = widget;
        this.form = form;
    }

    @Override
    public List<DataModelFieldBase> withField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = WidgetTool.concatTitle(widget.getTitle());
        ArrayList<DataModelFieldBase> fields = new ArrayList<DataModelFieldBase>();
        fields.add(new DataModelFieldBase.Builder().withId(name).withName(name).withComment(title).withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).build());
        return fields;
    }

    @Override
    public List<ModelFieldDto> withEngineField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = WidgetTool.concatTitle(widget.getTitle());
        ArrayList<ModelFieldDto> fields = new ArrayList<ModelFieldDto>();
        ModelFieldDto fieldDto = new ModelFieldDto();
        fieldDto.setFieldName(name);
        fieldDto.setFieldComment(title);
        fieldDto.setDefaultValue(null);
        fieldDto.setDataType(this.fieldDbType.get(dbType));
        Optional engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)ComponentData.DataTypeEnum.STRING.getValue());
        fieldDto.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
        fieldDto.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        fieldDto.setNeedChangeIsRequired(false);
        fieldDto.setPurpose(widget.getUsage());
        fieldDto.setRequired("0");
        fields.add(fieldDto);
        return fields;
    }

    @Override
    public DataModelFieldBase getLabelField(String dbType, Widget widget) {
        return this.withField(dbType, widget).get(0);
    }

    public String parseFileId(String fieldName, Object data) {
        String patternKey = "?fileId=";
        if (HussarUtils.isEmpty((Object)data)) {
            return "";
        }
        String reg = "/attachment/fileDownload\\?fileId=([A-Za-z0-9_-]{18,36})";
        Pattern patten = Pattern.compile(reg);
        ArrayList<String> matchStr = new ArrayList<String>();
        JSONArray formData = JSON.parseArray((String)JSON.toJSONString((Object)data));
        for (Object formDatum : formData) {
            JSONObject form = JSON.parseObject((String)JSON.toJSONString(formDatum));
            Object val = form.get((Object)fieldName);
            if (HussarUtils.isEmpty((Object)val)) continue;
            Matcher matcher = patten.matcher(String.valueOf(val));
            while (matcher.find()) {
                String group = matcher.group();
                group = group.substring(group.indexOf(patternKey) + patternKey.length());
                matchStr.add(group);
            }
        }
        return String.join((CharSequence)",", matchStr);
    }
}

