/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.tool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.ModuleInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.util.FileUtil;
import com.jxdinfo.hussar.formdesign.no.code.model.builder.BuilderCtx;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;

public class ProjectStoreTool {
    private static final String PROJECT_STORE_TEMP = ".store-temp";

    public static String tempPath(String targetApp) {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringUtil.getBean(FormDesignProperties.class);
        return com.jxdinfo.hussar.formdesign.common.util.FileUtil.posixPath((String[])new String[]{formDesignProperties.getWorkspace(), formDesignProperties.getBackProjectPath(), PROJECT_STORE_TEMP, targetApp});
    }

    public static String write(BuilderCtx ctx, String targetApp) throws IOException, LcdpException {
        String path = ProjectStoreTool.tempPath(targetApp);
        Map<String, BaseFile> metaMap = ctx.getMetaMap();
        block11: for (String id : metaMap.keySet()) {
            BaseFile baseFile = metaMap.get(id);
            if (ToolUtil.isNotEmpty((Object)baseFile.getParentId()) && !"#".equals(baseFile.getParentId())) {
                Optional<String> pathOpt = ProjectStoreTool.relativePath(baseFile.getParentId(), path);
                BaseFile parentModule = metaMap.get(baseFile.getParentId());
                if (!pathOpt.isPresent() && "Module".equals(parentModule.getType())) {
                    ProjectStoreTool.createDirectory((ModuleInfo)parentModule, path);
                }
            }
            switch (baseFile.getType()) {
                case "Module": {
                    ProjectStoreTool.createDirectory((ModuleInfo)baseFile, path);
                    continue block11;
                }
                case "WebPage": 
                case "DataModel": 
                case "MobilePage": 
                case "Workflow": {
                    ProjectStoreTool.createFile(baseFile, path);
                    continue block11;
                }
            }
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684meta\u6587\u4ef6\u7c7b\u578b");
        }
        return "";
    }

    private static void createDirectory(ModuleInfo moduleInfo, String path) throws IOException {
        Optional<String> pathOpt;
        String parentPath = "";
        if (!ToolUtil.isEmpty((Object)moduleInfo.getParentId()) && !"#".equals(moduleInfo.getParentId()) && (pathOpt = ProjectStoreTool.relativePath(moduleInfo.getParentId(), path)).isPresent()) {
            parentPath = pathOpt.get();
        }
        File file = new File(com.jxdinfo.hussar.formdesign.common.util.FileUtil.posixPath((String[])new String[]{path, parentPath, moduleInfo.getName()}));
        File fileOfMeta = new File(ProjectStoreTool.addMeta(file.getAbsolutePath()));
        if (file.exists() && fileOfMeta.exists()) {
            return;
        }
        FileUtils.forceMkdir((File)file);
        FileUtils.writeStringToFile((File)fileOfMeta, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)moduleInfo), (String)"UTF-8", (boolean)false);
    }

    private static void createFile(BaseFile baseFile, String path) throws LcdpException, IOException {
        File file;
        Optional<String> pathOpt;
        String parentPath = "";
        if (!ToolUtil.isEmpty((Object)baseFile.getParentId()) && !"#".equals(baseFile.getParentId()) && (pathOpt = ProjectStoreTool.relativePath(baseFile.getParentId(), path)).isPresent()) {
            parentPath = pathOpt.get();
        }
        if ((file = new File(com.jxdinfo.hussar.formdesign.common.util.FileUtil.posixPath((String[])new String[]{path, parentPath, baseFile.getName() + FileUtil.transFileSuffix((String)baseFile.getType())}))).exists() && file.getPath().equals(file.getCanonicalPath())) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, file.getAbsolutePath());
        }
        File metaFile = new File(file.getAbsolutePath() + ".meta");
        if (metaFile.exists() && metaFile.getPath().equals(metaFile.getCanonicalPath())) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, metaFile.getAbsolutePath());
        }
        ProjectStoreTool.write(file, baseFile);
    }

    private static void write(File file, BaseFile baseFile) throws IOException {
        File fileOfMeta = new File(ProjectStoreTool.addMeta(file.getAbsolutePath()));
        Object jsonObject = JSONObject.parse((String)baseFile.getData());
        if (ToolUtil.isEmpty((Object)jsonObject)) {
            FileUtils.writeStringToFile((File)file, (String)"", (String)"UTF-8", (boolean)false);
        } else {
            FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject), (String)"UTF-8", (boolean)false);
        }
        baseFile.setData("");
        FileUtils.writeStringToFile((File)fileOfMeta, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)baseFile), (String)"UTF-8", (boolean)false);
    }

    private static String addMeta(String absolutePath) {
        String real = absolutePath.replace("/", File.separator).replace("\\", File.separator);
        return real + ".meta";
    }

    private static Optional<String> relativePath(String id, String path) {
        HashMap<String, String> fileMappingMap = new HashMap<String, String>();
        File file = new File(path);
        ProjectStoreTool.iteratorFile(file, fileMappingMap, file);
        if (HussarUtils.isEmpty(fileMappingMap.get(id))) {
            return Optional.empty();
        }
        return Optional.of(((String)fileMappingMap.get(id)).replace(".meta", ""));
    }

    private static void iteratorFile(File file, Map<String, String> fileMappingMap, File rootFile) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    for (File childFile : files) {
                        ProjectStoreTool.iteratorFile(childFile, fileMappingMap, rootFile);
                    }
                }
            } else if (file.getName().endsWith(".meta")) {
                String id = "";
                try {
                    BaseFile baseFile = (BaseFile)JSON.parseObject((String)FileUtils.readFileToString((File)file, (String)"UTF-8"), BaseFile.class);
                    id = baseFile.getId();
                }
                catch (Exception e) {
                    throw new RuntimeException("\u8bfb\u53d6meta\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6id\uff1a" + id);
                }
                if (ToolUtil.isNotEmpty((Object)id)) {
                    String relativePath = file.getAbsolutePath().replace(rootFile.getAbsolutePath(), "");
                    if (ToolUtil.isNotEmpty((Object)fileMappingMap.get(id))) {
                        throw new RuntimeException("\u5df2\u5b58\u5728\u76f8\u540cid\u6587\u4ef6\uff1a" + fileMappingMap.get(id));
                    }
                    fileMappingMap.put(id, com.jxdinfo.hussar.formdesign.common.util.FileUtil.posixPath((String[])new String[]{relativePath}));
                }
            }
        }
    }
}

