/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.storage;

import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.FormCleaner;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnOfflineStorage;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={NoCodeConditionOnOfflineStorage.class})
public class FormCleanerImpl
implements FormCleaner {
    @Resource
    private StorageService storage;
    @Resource
    private CanvasSchemaService canvasSchemaService;

    @Override
    public FormDesignResponse<Boolean> appClean() {
        if (HussarUtils.isEmpty((Object)AppContextUtil.getAppId())) {
            ToolUtil.getLogger(this.getClass()).error("\u5220\u9664\u5e94\u7528 ==> \u8bf7\u6c42\u5934\u7f3a\u5931appId\uff0c\u7981\u6b62\u5220\u9664 appId: {}", (Object)AppContextUtil.getAppId());
            return FormDesignResponse.fail((Object)false, (String)"\u5220\u9664\u5e94\u7528 ==> \u8bf7\u6c42\u5934\u7f3a\u5931appId\uff0c\u7981\u6b62\u5220\u9664");
        }
        StorageResult result = this.storage.deleteDirByPath("", false);
        if (((Boolean)result.getData()).booleanValue()) {
            return FormDesignResponse.success((Object)true);
        }
        ToolUtil.getLogger(this.getClass()).error("\u5220\u9664\u5e94\u7528 ==> {} appId: {}", (Object)result.getMsg(), (Object)AppContextUtil.getAppId());
        return FormDesignResponse.fail((Object)false, (String)("\u5220\u9664\u5e94\u7528 ==> {}" + result.getMsg()));
    }

    @Override
    public FormDesignResponse<Boolean> formClean(String formId) {
        if (HussarUtils.isEmpty((Object)AppContextUtil.getAppId())) {
            ToolUtil.getLogger(this.getClass()).error("\u5220\u9664\u8868\u5355 ==> \u8bf7\u6c42\u5934\u7f3a\u5931appId\uff0c\u7981\u6b62\u5220\u9664 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((Object)false, (String)"\u5220\u9664\u8868\u5355 ==> \u8bf7\u6c42\u5934\u7f3a\u5931appId\uff0c\u7981\u6b62\u5220\u9664");
        }
        FormDesignResponse<FormCanvasSchema> canvasRes = this.canvasSchemaService.get(formId);
        if (HussarUtils.isEmpty((Object)canvasRes.getData())) {
            ToolUtil.getLogger(this.getClass()).error("\u5220\u9664\u8868\u5355 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((Object)true, (String)"\u5220\u9664\u8868\u5355 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25");
        }
        StorageResult result = this.storage.deleteDirByPath(((FormCanvasSchema)((Object)canvasRes.getData())).getName(), false);
        if (((Boolean)result.getData()).booleanValue()) {
            this.evictCache(AppContextUtil.getAppId(), formId);
            return FormDesignResponse.success((Object)true);
        }
        ToolUtil.getLogger(this.getClass()).error("\u5220\u9664\u8868\u5355 ==> {} appId: {} formId: {}", new Object[]{result.getMsg(), AppContextUtil.getAppId(), formId});
        return FormDesignResponse.fail((Object)false, (String)("\u5220\u9664\u8868\u5355 ==> " + result.getMsg()));
    }

    private void evictCache(String appId, String formId) {
        String canvasCacheKey = String.format("%s:%s:%s", appId, "0", formId);
        String viewCacheKey = String.format("%s:%s:%s", appId, formId, "view");
        String settingCacheKey = String.format("%s:%s:%s", appId, formId, "setting");
        HussarCacheUtil.evict((String)"vfg_no-code_schema", (Object)canvasCacheKey);
        HussarCacheUtil.evict((String)"vfg_no-code_schema", (Object)viewCacheKey);
        HussarCacheUtil.evict((String)"vfg_no-code_schema", (Object)settingCacheKey);
    }
}

