/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.util;

import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.extension.api.dto.canvas.FormCanvasSchemaDto;
import com.jxdinfo.hussar.formdesign.extension.api.dto.form.ExcelVerifyHookDto;
import com.jxdinfo.hussar.formdesign.extension.api.dto.form.FlowFormSubmitHookDto;
import com.jxdinfo.hussar.formdesign.extension.api.dto.form.FormDataDeleteHookDto;
import com.jxdinfo.hussar.formdesign.extension.api.dto.form.FormDeleteHookDto;
import com.jxdinfo.hussar.formdesign.extension.api.dto.form.FormSaveHookDto;
import com.jxdinfo.hussar.formdesign.extension.api.dto.form.TableQueryHookDto;
import com.jxdinfo.hussar.formdesign.no.code.business.service.OperateHookStrategyService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HookUtil {
    @Autowired
    private OperateHookStrategyService operateHookStrategyService;

    public Boolean isFormOperateHookNotEmpty(String formId, String tableName) {
        return ToolUtil.isNotEmpty((Object)this.operateHookStrategyService.operateHookService(formId, tableName));
    }

    public Boolean isCanvasHookNtEmpty(String formId, String tableName) {
        return ToolUtil.isNotEmpty((Object)this.operateHookStrategyService.canvasHookService(formId, tableName));
    }

    public void beforeTableQuery(String formId, String tableName, TableQueryHookDto tableQueryHookDto) {
        if (Boolean.TRUE.equals(this.isFormOperateHookNotEmpty(formId, tableName))) {
            this.operateHookStrategyService.operateHookService(formId, tableName).beforeTableQuery(tableQueryHookDto);
        }
    }

    public void tableQueryHook(String formId, String tableName, TableQueryHookDto tableQueryHookDto, ApiResponse<Object> tableQueryResponse) {
        if (Boolean.TRUE.equals(this.isFormOperateHookNotEmpty(formId, tableName))) {
            this.operateHookStrategyService.operateHookService(formId, tableName).tableQueryHook(tableQueryHookDto, tableQueryResponse);
        }
    }

    public void beforeFormSave(String formId, String tableName, FormSaveHookDto formSaveHookDto) {
        if (Boolean.TRUE.equals(this.isFormOperateHookNotEmpty(formId, tableName))) {
            this.operateHookStrategyService.operateHookService(formId, tableName).beforeFormSave(formSaveHookDto);
        }
    }

    public void formSaveHook(String formId, String tableName, FormSaveHookDto formSaveHookDto, ApiResponse<Object> formSaveResponse) {
        if (Boolean.TRUE.equals(this.isFormOperateHookNotEmpty(formId, tableName))) {
            this.operateHookStrategyService.operateHookService(formId, tableName).formSaveHook(formSaveHookDto, formSaveResponse);
        }
    }

    public void beforeFlowFormSubmit(String formId, String tableName, FlowFormSubmitHookDto formSubmitHookDto) {
        if (Boolean.TRUE.equals(this.isFormOperateHookNotEmpty(formId, tableName))) {
            this.operateHookStrategyService.operateHookService(formId, tableName).beforeFlowFormSubmit(formSubmitHookDto);
        }
    }

    public void flowFormSubmitHook(String formId, String tableName, FlowFormSubmitHookDto formSubmitHookDto, ApiResponse<Object> flowFormSubmitResponse) {
        if (Boolean.TRUE.equals(this.isFormOperateHookNotEmpty(formId, tableName))) {
            this.operateHookStrategyService.operateHookService(formId, tableName).flowFormSubmitHook(formSubmitHookDto, flowFormSubmitResponse);
        }
    }

    public void beforeFormDelete(String formId, String tableName, FormDeleteHookDto formDeleteHookDto) {
        if (Boolean.TRUE.equals(this.isFormOperateHookNotEmpty(formId, tableName))) {
            this.operateHookStrategyService.operateHookService(formId, tableName).beforeFormDelete(formDeleteHookDto);
        }
    }

    public void formDeleteHook(String formId, String tableName, FormDeleteHookDto formDeleteHookDto) {
        if (Boolean.TRUE.equals(this.isFormOperateHookNotEmpty(formId, tableName))) {
            this.operateHookStrategyService.operateHookService(formId, tableName).formDeleteHook(formDeleteHookDto);
        }
    }

    public void formDataDeleteBatchHook(String formId, String tableName, FormDataDeleteHookDto formDataDeleteHookDto) {
        if (Boolean.TRUE.equals(this.isFormOperateHookNotEmpty(formId, tableName))) {
            this.operateHookStrategyService.operateHookService(formId, tableName).formDataDeleteBatchHook(formDataDeleteHookDto);
        }
    }

    public void beforeSaveCanvas(FormCanvasSchemaDto formCanvasSchemaDto) {
        String formId;
        if (formCanvasSchemaDto != null && Boolean.TRUE.equals(this.isCanvasHookNtEmpty(formId = String.valueOf(formCanvasSchemaDto.getId()), formCanvasSchemaDto.getName()))) {
            this.operateHookStrategyService.canvasHookService(formId, formCanvasSchemaDto.getName()).beforeSaveCanvas(formCanvasSchemaDto);
        }
    }

    public void afterSaveCanvas(FormCanvasSchemaDto formCanvasSchemaDto) {
        String formId;
        if (formCanvasSchemaDto != null && Boolean.TRUE.equals(this.isCanvasHookNtEmpty(formId = String.valueOf(formCanvasSchemaDto.getId()), formCanvasSchemaDto.getName()))) {
            this.operateHookStrategyService.canvasHookService(formId, formCanvasSchemaDto.getName()).afterSaveCanvas(formCanvasSchemaDto);
        }
    }

    public void excelImportDataVerifyHook(String tableName, ExcelVerifyHookDto excelVerifyHookDto) {
        if (Boolean.TRUE.equals(this.isFormOperateHookNotEmpty(excelVerifyHookDto.getFormId(), tableName))) {
            this.operateHookStrategyService.operateHookService(excelVerifyHookDto.getFormId(), tableName).excelImportDataVerifyHook(excelVerifyHookDto);
        }
    }
}

