/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.formdesign.no.code.business.service.DictDataSourceService;
import com.jxdinfo.hussar.formdesign.no.code.model.dict.DictFieldDto;
import com.jxdinfo.hussar.general.dict.dto.DicSingleDto;
import com.jxdinfo.hussar.general.dict.model.DicGroup;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicLevelTreeVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictDataSourceServiceImpl
implements DictDataSourceService {
    private static Logger logger = LoggerFactory.getLogger(DictDataSourceServiceImpl.class);
    @Resource
    private ISysDicRefService sysDicRefService;

    @Override
    public List<JSTreeModel> getDictTypeTree() {
        ApiResponse listApiResponse = this.sysDicRefService.dicTypeTreeData();
        return (List)listApiResponse.getData();
    }

    @Override
    public void addDictGroup(DicGroup dicGroup) {
        this.sysDicRefService.addGroup(dicGroup);
    }

    @Override
    @Transactional
    public boolean addDictAndField(DictFieldDto dictFieldDto) {
        DicType dicType = new DicType();
        dicType.setTypeName(dictFieldDto.getTypeName());
        dicType.setTypeDescription(dictFieldDto.getTypeDescription());
        dicType.setDescriptionLangKey(dictFieldDto.getDescriptionLangKey());
        dicType.setParentId(dictFieldDto.getParentId());
        this.sysDicRefService.add(dicType);
        DicType dicTypeDetail = this.sysDicRefService.getByTypeName(dictFieldDto.getTypeName());
        if (HussarUtils.isNotEmpty((Object)dicTypeDetail)) {
            Long typeId = dicTypeDetail.getId();
            for (DicSingleDto dicSingleDto : dictFieldDto.getDicSingleDtos()) {
                dicSingleDto.setTypeId(typeId);
                this.sysDicRefService.addSingle(dicSingleDto);
            }
            return true;
        }
        return false;
    }

    @Override
    public List<DicLevelTreeVo> queryDictOptions(Long typeId) {
        return this.sysDicRefService.getLevelDictByType(typeId);
    }
}

