/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.formdesign.application.util.NoCodeSecurityUtil;
import com.jxdinfo.hussar.formdesign.no.code.business.dao.CustomViewOrderMapper;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CustomViewOrderService;
import com.jxdinfo.hussar.formdesign.no.code.constant.ViewIdEnum;
import com.jxdinfo.hussar.formdesign.no.code.model.view.CustomViewOrder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class CustomViewOrderServiceImpl
extends HussarServiceImpl<CustomViewOrderMapper, CustomViewOrder>
implements CustomViewOrderService {
    @Resource
    private CustomViewOrderMapper customViewOrderMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomViewOrderServiceImpl.class);

    @Override
    public ApiResponse<CustomViewOrder> getOrderByUser(Long formId, Long userId) {
        CustomViewOrder viewOrder = this.customViewOrderMapper.getOrderByUser(formId, userId);
        return ApiResponse.success((Object)((Object)viewOrder));
    }

    @Override
    public ApiResponse<Boolean> insert(CustomViewOrder customViewOrder) {
        try {
            this.customViewOrderMapper.insert((Object)customViewOrder);
            return ApiResponse.success((Object)true);
        }
        catch (Exception e) {
            LOGGER.error("\u81ea\u5b9a\u4e49\u89c6\u56fe\u6392\u5e8f\u65b0\u589e\u5f02\u5e38\uff1a{}\uff0cformId\uff1a{}\uff0cuserId\uff1a{}", new Object[]{e.getMessage(), customViewOrder.getFormId(), customViewOrder.getUserId()});
            return ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)false, (String)"\u81ea\u5b9a\u4e49\u89c6\u56fe\u6392\u5e8f\u65b0\u589e\u5931\u8d25");
        }
    }

    @Override
    public ApiResponse<Boolean> update(CustomViewOrder customViewOrder) {
        try {
            this.customViewOrderMapper.updateById((Object)customViewOrder);
            return ApiResponse.success((Object)true);
        }
        catch (Exception e) {
            LOGGER.error("\u81ea\u5b9a\u4e49\u89c6\u56fe\u6392\u5e8f\u66f4\u65b0\u5f02\u5e38\uff1a{}\uff0cformId\uff1a{}\uff0cuserId\uff1a{}", new Object[]{e.getMessage(), customViewOrder.getFormId(), customViewOrder.getUserId()});
            return ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)false, (String)"\u81ea\u5b9a\u4e49\u89c6\u56fe\u6392\u5e8f\u66f4\u65b0\u5931\u8d25");
        }
    }

    @Override
    public void convertForm(Long formId, String formType) {
        LambdaQueryWrapper customViewOrderLambdaQueryWrapper = new LambdaQueryWrapper();
        customViewOrderLambdaQueryWrapper.eq(CustomViewOrder::getFormId, (Object)formId);
        List customViewOrders = this.list((Wrapper)customViewOrderLambdaQueryWrapper);
        if (HussarUtils.isEmpty((Object)customViewOrders)) {
            return;
        }
        customViewOrders.forEach(customViewOrder -> {
            String viewOrder = customViewOrder.getViewOrder();
            String viewHide = customViewOrder.getViewHide();
            if ("0".equals(formType)) {
                viewOrder = viewOrder.replace(ViewIdEnum.SYS_FLOW_ALL_DATA.getId(), ViewIdEnum.SYS_ORDINARY_ALL_DATA.getId());
                viewHide = viewHide.replace(ViewIdEnum.SYS_FLOW_ALL_DATA.getId(), ViewIdEnum.SYS_ORDINARY_ALL_DATA.getId());
                List viewOrderJson = JSON.parseArray((String)viewOrder, String.class);
                viewOrderJson.remove(ViewIdEnum.SYS_FLOW_TASK.getId());
                viewOrderJson.remove(ViewIdEnum.SYS_FLOW_DONE.getId());
                viewOrderJson.remove(ViewIdEnum.SYS_FLOW_DRAFT.getId());
                viewOrder = JSON.toJSONString((Object)viewOrderJson);
                JSONObject viewHideJsonObject = JSON.parseObject((String)viewHide);
                viewHideJsonObject.remove((Object)ViewIdEnum.SYS_FLOW_TASK.getId());
                viewHideJsonObject.remove((Object)ViewIdEnum.SYS_FLOW_DONE.getId());
                viewHideJsonObject.remove((Object)ViewIdEnum.SYS_FLOW_DRAFT.getId());
                viewHide = viewHideJsonObject.toJSONString();
            } else if ("1".equals(formType)) {
                viewOrder = viewOrder.replace(ViewIdEnum.SYS_ORDINARY_ALL_DATA.getId(), ViewIdEnum.SYS_FLOW_ALL_DATA.getId());
                viewHide = viewHide.replace(ViewIdEnum.SYS_ORDINARY_ALL_DATA.getId(), ViewIdEnum.SYS_FLOW_ALL_DATA.getId());
                List viewOrderJson = JSON.parseArray((String)viewOrder, String.class);
                viewOrderJson.add(ViewIdEnum.SYS_FLOW_TASK.getId());
                viewOrderJson.add(ViewIdEnum.SYS_FLOW_DONE.getId());
                viewOrderJson.add(ViewIdEnum.SYS_FLOW_DRAFT.getId());
                viewOrder = JSON.toJSONString((Object)viewOrderJson);
                JSONObject viewHideJsonObject = JSON.parseObject((String)viewHide);
                viewHideJsonObject.put(ViewIdEnum.SYS_FLOW_TASK.getId(), (Object)"true");
                viewHideJsonObject.put(ViewIdEnum.SYS_FLOW_DONE.getId(), (Object)"true");
                viewHideJsonObject.put(ViewIdEnum.SYS_FLOW_DRAFT.getId(), (Object)"true");
                viewHide = viewHideJsonObject.toJSONString();
            }
            customViewOrder.setViewOrder(viewOrder);
            customViewOrder.setViewHide(viewHide);
            customViewOrder.setLastEditor(NoCodeSecurityUtil.getUser().getUserId());
            customViewOrder.setLastTime(LocalDateTime.now());
        });
        this.saveOrUpdateBatch(customViewOrders);
    }
}

